/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.grpc.adapter.client.rs;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UpstreamEventBuffer<Elem> {
    private static Logger logger = LoggerFactory.getLogger(UpstreamEventBuffer.class);
    @Nullable
    private Elem bufferedElem;
    @Nullable
    private Optional<Throwable> completion;
    @Nonnull
    private final String logPrefix;

    UpstreamEventBuffer(@Nonnull String logPrefix) {
        this.logPrefix = logPrefix;
    }

    boolean onNext(@Nonnull Elem response) {
        if (this.bufferedElem != null) {
            this.onError(new IllegalStateException("gRPC upstream pushed 2 elements without demand."));
            return false;
        }
        logger.trace("{}Message {} was buffered.", (Object)this.logPrefix, (Object)response);
        this.bufferedElem = response;
        return true;
    }

    void onComplete() {
        if (this.completion != null) {
            if (this.completion.isPresent()) {
                Throwable bufferedError = this.completion.get();
                this.completion = Optional.of(new IllegalStateException("gRPC upstream signaled completion after error.", bufferedError));
            } else {
                this.completion = Optional.of(new IllegalStateException("gRPC upstream signaled completion twice."));
            }
        } else {
            logger.trace("{}Successful completion was buffered.", (Object)this.logPrefix);
            this.completion = Optional.empty();
        }
    }

    void onError(@Nonnull Throwable throwable2) {
        if (this.completion != null) {
            if (this.completion.isPresent()) {
                IllegalStateException moreThanOneError = new IllegalStateException("gRPC upstream signaled multiple errors.", this.completion.get());
                moreThanOneError.addSuppressed(throwable2);
                this.completion = Optional.of(moreThanOneError);
            } else {
                this.completion = Optional.of(new IllegalStateException("gRPC upstream signaled error after completion.", throwable2));
            }
        } else {
            logger.trace("{}Stream failure buffered", (Object)this.logPrefix, (Object)throwable2);
            this.completion = Optional.of(throwable2);
        }
    }

    void flushOnFirstRequest(@Nonnull Subscriber<? super Elem> subscriber) {
        this.flushBufferedElem(subscriber);
        this.flushCompletion(subscriber);
    }

    private void flushBufferedElem(@Nonnull Subscriber<? super Elem> subscriber) {
        if (this.bufferedElem != null) {
            logger.trace("{}Flushing buffered element {} to RS downstream.", (Object)this.logPrefix, (Object)this.bufferedElem);
            subscriber.onNext(this.bufferedElem);
            this.bufferedElem = null;
        }
    }

    private void flushCompletion(@Nonnull Subscriber subscriber) {
        if (this.completion != null) {
            logger.trace("{}Flushing completion to RS downstream.", (Object)this.logPrefix);
            if (this.completion.isPresent()) {
                subscriber.onError(this.completion.get());
            } else {
                subscriber.onComplete();
            }
            this.completion = null;
        }
    }

    boolean hasNoElement() {
        return this.bufferedElem == null;
    }
}

