/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.ledger.api.validation;

import com.digitalasset.api.util.TimestampConversion$;
import com.digitalasset.daml.lf.command.Commands;
import com.digitalasset.daml.lf.command.CreateAndExerciseCommand;
import com.digitalasset.daml.lf.command.CreateCommand;
import com.digitalasset.daml.lf.command.ExerciseByKeyCommand;
import com.digitalasset.daml.lf.command.ExerciseCommand;
import com.digitalasset.daml.lf.data.ImmArray;
import com.digitalasset.daml.lf.data.ImmArray$;
import com.digitalasset.daml.lf.data.Ref;
import com.digitalasset.daml.lf.data.Time;
import com.digitalasset.daml.lf.data.Time$Timestamp$;
import com.digitalasset.daml.lf.value.Value;
import com.digitalasset.ledger.api.domain;
import com.digitalasset.ledger.api.domain$;
import com.digitalasset.ledger.api.v1.commands.Command;
import com.digitalasset.ledger.api.v1.commands.Command$Command$Empty$;
import com.digitalasset.ledger.api.v1.value.Identifier;
import com.digitalasset.ledger.api.v1.value.Record;
import com.digitalasset.ledger.api.validation.ValueValidator$;
import com.digitalasset.platform.server.api.ApiException;
import com.digitalasset.platform.server.api.validation.ErrorFactories$;
import com.digitalasset.platform.server.api.validation.FieldValidations$;
import com.google.protobuf.timestamp.Timestamp;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.util.Either;
import scalaz.syntax.TagOps$;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001B\u0001\u0003\u00055\u0011\u0011cQ8n[\u0006tGm\u001d,bY&$\u0017\r^8s\u0015\t\u0019A!\u0001\u0006wC2LG-\u0019;j_:T!!\u0002\u0004\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\b\u0011\u00051A.\u001a3hKJT!!\u0003\u0006\u0002\u0019\u0011Lw-\u001b;bY\u0006\u001c8/\u001a;\u000b\u0003-\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0011!)\u0002A!A!\u0002\u00131\u0012\u0001\u00037fI\u001e,'/\u00133\u0011\u0005])cB\u0001\r$\u001d\tI\"E\u0004\u0002\u001bC9\u00111\u0004\t\b\u00039}i\u0011!\b\u0006\u0003=1\ta\u0001\u0010:p_Rt\u0014\"A\u0006\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002%\t\u00051Am\\7bS:L!AJ\u0014\u0003\u00111+GmZ3s\u0013\u0012T!\u0001\n\u0003\t\u000b%\u0002A\u0011\u0001\u0016\u0002\rqJg.\u001b;?)\tYS\u0006\u0005\u0002-\u00015\t!\u0001C\u0003\u0016Q\u0001\u0007a\u0003C\u00030\u0001\u0011\u0005\u0001'\u0001\twC2LG-\u0019;f\u0007>lW.\u00198egR\u0011\u0011g\u0012\t\u0005e]R$I\u0004\u00024k9\u0011A\u0004N\u0005\u0002#%\u0011a\u0007E\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0014H\u0001\u0004FSRDWM\u001d\u0006\u0003mA\u0001\"a\u000f!\u000e\u0003qR!!\u0010 \u0002\t\u001d\u0014\bo\u0019\u0006\u0002\u007f\u0005\u0011\u0011n\\\u0005\u0003\u0003r\u0012ac\u0015;biV\u001c(+\u001e8uS6,W\t_2faRLwN\u001c\t\u0003\u0007\u0016s!\u0001R\u0012\u000e\u0003\u0011I!AR\u0014\u0003\u0011\r{W.\\1oINDQ\u0001\u0013\u0018A\u0002%\u000b\u0001bY8n[\u0006tGm\u001d\t\u0003\u0015:k\u0011a\u0013\u0006\u0003\u00112S!!\u0014\u0003\u0002\u0005Y\f\u0014B\u0001$L\u0011\u0015\u0001\u0006\u0001\"\u0003R\u0003U1\u0018\r\\5eCR,\u0017J\u001c8fe\u000e{W.\\1oIN$2AU3k!\u0011\u0011tGO*\u0011\u0007QK6,D\u0001V\u0015\t1v+A\u0005j[6,H/\u00192mK*\u0011\u0001\fE\u0001\u000bG>dG.Z2uS>t\u0017B\u0001.V\u0005\r\u0019V-\u001d\t\u00039\u000el\u0011!\u0018\u0006\u0003=~\u000bqaY8n[\u0006tGM\u0003\u0002aC\u0006\u0011AN\u001a\u0006\u0003E\"\tA\u0001Z1nY&\u0011A-\u0018\u0002\b\u0007>lW.\u00198e\u0011\u0015Au\n1\u0001g!\r\u0011t\r[\u0005\u00035f\u0002\"AS5\n\u0005\u0011\\\u0005\"B6P\u0001\u0004a\u0017!C:vE6LG\u000f^3s!\ti7O\u0004\u0002oc6\tqN\u0003\u0002q?\u0006!A-\u0019;b\u0013\t\u0011x.A\u0002SK\u001aL!\u0001^;\u0003\u000bA\u000b'\u000f^=\u000b\u0005I|\u0007\"B<\u0001\t\u0013A\u0018\u0001\u0006<bY&$\u0017\r^3J]:,'oQ8n[\u0006tG\r\u0006\u0002zuB!!g\u000e\u001e\\\u0011\u0015qf\u000f1\u0001|!\taxP\u0004\u0002K{&\u0011apS\u0001\b\u0007>lW.\u00198e\u0013\r!\u0017\u0011\u0001\u0006\u0003}.\u0003")
public final class CommandsValidator {
    private final Object ledgerId;

    public Either<StatusRuntimeException, domain.Commands> validateCommands(com.digitalasset.ledger.api.v1.commands.Commands commands) {
        return FieldValidations$.MODULE$.requireLedgerString(commands.ledgerId(), "ledger_id").flatMap((Function1<String, Either> & Serializable & scala.Serializable)cmdLegerId -> FieldValidations$.MODULE$.matchLedgerId($this.ledgerId, domain$.MODULE$.LedgerId().apply(cmdLegerId)).flatMap((Function1<Object, Either> & Serializable & scala.Serializable)ledgerId -> (commands.workflowId().isEmpty() ? package$.MODULE$.Right().apply(None$.MODULE$) : FieldValidations$.MODULE$.requireLedgerString(commands.workflowId()).map((Function1<String, Some> & Serializable & scala.Serializable)x -> new Some<Object>(domain$.MODULE$.WorkflowId().apply(x)))).flatMap((Function1<Option, Either> & Serializable & scala.Serializable)workflowId -> FieldValidations$.MODULE$.requireLedgerString(commands.applicationId(), "application_id").map((Function1<String, Object> & Serializable & scala.Serializable)x$1 -> domain$.MODULE$.ApplicationId().apply(x$1)).flatMap((Function1<Object, Either> & Serializable & scala.Serializable)appId -> FieldValidations$.MODULE$.requireLedgerString(commands.commandId(), "command_id").map((Function1<String, Object> & Serializable & scala.Serializable)x$2 -> domain$.MODULE$.CommandId().apply(x$2)).flatMap((Function1<Object, Either> & Serializable & scala.Serializable)commandId -> FieldValidations$.MODULE$.requireParty(commands.party(), "party").flatMap((Function1<String, Either> & Serializable & scala.Serializable)submitter -> FieldValidations$.MODULE$.requirePresence(commands.ledgerEffectiveTime(), "ledger_effective_time").map((Function1<Timestamp, Tuple2> & Serializable & scala.Serializable)let -> {
            Instant ledgerEffectiveTime = TimestampConversion$.MODULE$.toInstant((Timestamp)let);
            return new Tuple2<Timestamp, Instant>((Timestamp)let, ledgerEffectiveTime);
        }).flatMap((Function1<Tuple2, Either> & Serializable & scala.Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Instant ledgerEffectiveTime = (Instant)tuple2._2();
            Either either2 = FieldValidations$.MODULE$.requirePresence(commands.maximumRecordTime(), "maximum_record_time").flatMap((Function1<Timestamp, Either> & Serializable & scala.Serializable)mrt -> FieldValidations$.MODULE$.requireNonEmpty(commands.commands(), "commands").flatMap((Function1<Seq, Either> & Serializable & scala.Serializable)commandz -> this.validateInnerCommands((Seq<Command>)commandz, (String)submitter).flatMap((Function1<scala.collection.immutable.Seq, Either> & Serializable & scala.Serializable)validatedCommands -> Time$Timestamp$.MODULE$.fromInstant(ledgerEffectiveTime).left().map((Function1<String, ApiException> & Serializable & scala.Serializable)x$3 -> ErrorFactories$.MODULE$.invalidField((String)x$3, "ledger_effective_time")).map((Function1<Time.Timestamp, domain.Commands> & Serializable & scala.Serializable)ledgerEffectiveTimestamp -> new domain.Commands(ledgerId, (Option<Object>)workflowId, appId, commandId, (String)submitter, ledgerEffectiveTime, TimestampConversion$.MODULE$.toInstant((Timestamp)mrt), new Commands((String)submitter, ImmArray$.MODULE$.apply(validatedCommands), (Time.Timestamp)ledgerEffectiveTimestamp, (String)workflowId.fold((Function0<String> & Serializable & scala.Serializable)() -> "", (Function1<Object, String> & Serializable & scala.Serializable)x$4 -> (String)TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(x$4)))))))));
            return either2;
        })))))));
    }

    private Either<StatusRuntimeException, scala.collection.immutable.Seq<com.digitalasset.daml.lf.command.Command>> validateInnerCommands(Seq<Command> commands, String submitter) {
        return commands.foldLeft(package$.MODULE$.Right().apply(package$.MODULE$.Vector().empty()), (Function2<Either, Command, Either> & Serializable & scala.Serializable)(commandz, command) -> commandz.flatMap((Function1<Vector, Either> & Serializable & scala.Serializable)validatedInnerCommands -> this.validateInnerCommand(command.command()).map((Function1<com.digitalasset.daml.lf.command.Command, Vector> & Serializable & scala.Serializable)validatedInnerCommand -> validatedInnerCommands.$colon$plus(validatedInnerCommand, Vector$.MODULE$.canBuildFrom()))));
    }

    private Either<StatusRuntimeException, com.digitalasset.daml.lf.command.Command> validateInnerCommand(Command.Command command) {
        Either<StatusRuntimeException, com.digitalasset.daml.lf.command.Command> either2;
        Command.Command command2 = command;
        if (command2 instanceof Command.Command.Create) {
            Command.Command.Create create = (Command.Command.Create)command2;
            either2 = FieldValidations$.MODULE$.requirePresence(create.value().templateId(), "template_id").flatMap((Function1<Identifier, Either> & Serializable & scala.Serializable)templateId -> FieldValidations$.MODULE$.validateIdentifier((Identifier)templateId).flatMap((Function1<Ref.Identifier, Either> & Serializable & scala.Serializable)validatedTemplateId -> FieldValidations$.MODULE$.requirePresence(create.value().createArguments(), "create_arguments").flatMap((Function1<Record, Either> & Serializable & scala.Serializable)createArguments -> ValueValidator$.MODULE$.validateOptionalIdentifier(createArguments.recordId()).flatMap((Function1<Option, Either> & Serializable & scala.Serializable)recordId -> ValueValidator$.MODULE$.validateRecordFields(createArguments.fields()).map((Function1<ImmArray, CreateCommand> & Serializable & scala.Serializable)validatedRecordField -> new CreateCommand((Ref.Identifier)validatedTemplateId, (Value<Value.AbsoluteContractId>)new Value.ValueRecord<Value.AbsoluteContractId>((Option<Ref.Identifier>)recordId, (ImmArray<Tuple2<Option<String>, Value<Value.AbsoluteContractId>>>)validatedRecordField)))))));
        } else if (command2 instanceof Command.Command.Exercise) {
            Command.Command.Exercise exercise = (Command.Command.Exercise)command2;
            either2 = FieldValidations$.MODULE$.requirePresence(exercise.value().templateId(), "template_id").flatMap((Function1<Identifier, Either> & Serializable & scala.Serializable)templateId -> FieldValidations$.MODULE$.validateIdentifier((Identifier)templateId).flatMap((Function1<Ref.Identifier, Either> & Serializable & scala.Serializable)validatedTemplateId -> FieldValidations$.MODULE$.requireLedgerString(exercise.value().contractId(), "contract_id").flatMap((Function1<String, Either> & Serializable & scala.Serializable)contractId -> FieldValidations$.MODULE$.requireName(exercise.value().choice(), "choice").flatMap((Function1<String, Either> & Serializable & scala.Serializable)choice2 -> FieldValidations$.MODULE$.requirePresence(exercise.value().choiceArgument(), "value").flatMap((Function1<com.digitalasset.ledger.api.v1.value.Value, Either> & Serializable & scala.Serializable)value -> ValueValidator$.MODULE$.validateValue((com.digitalasset.ledger.api.v1.value.Value)value).map((Function1<Value, ExerciseCommand> & Serializable & scala.Serializable)validatedValue -> new ExerciseCommand((Ref.Identifier)validatedTemplateId, (String)contractId, (String)choice2, (Value<Value.AbsoluteContractId>)validatedValue)))))));
        } else if (command2 instanceof Command.Command.ExerciseByKey) {
            Command.Command.ExerciseByKey exerciseByKey = (Command.Command.ExerciseByKey)command2;
            either2 = FieldValidations$.MODULE$.requirePresence(exerciseByKey.value().templateId(), "template_id").flatMap((Function1<Identifier, Either> & Serializable & scala.Serializable)templateId -> FieldValidations$.MODULE$.validateIdentifier((Identifier)templateId).flatMap((Function1<Ref.Identifier, Either> & Serializable & scala.Serializable)validatedTemplateId -> FieldValidations$.MODULE$.requirePresence(exerciseByKey.value().contractKey(), "contract_key").flatMap((Function1<com.digitalasset.ledger.api.v1.value.Value, Either> & Serializable & scala.Serializable)contractKey -> ValueValidator$.MODULE$.validateValue((com.digitalasset.ledger.api.v1.value.Value)contractKey).flatMap((Function1<Value, Either> & Serializable & scala.Serializable)validatedContractKey -> FieldValidations$.MODULE$.requireName(exerciseByKey.value().choice(), "choice").flatMap((Function1<String, Either> & Serializable & scala.Serializable)choice2 -> FieldValidations$.MODULE$.requirePresence(exerciseByKey.value().choiceArgument(), "value").flatMap((Function1<com.digitalasset.ledger.api.v1.value.Value, Either> & Serializable & scala.Serializable)value -> ValueValidator$.MODULE$.validateValue((com.digitalasset.ledger.api.v1.value.Value)value).map((Function1<Value, ExerciseByKeyCommand> & Serializable & scala.Serializable)validatedValue -> new ExerciseByKeyCommand((Ref.Identifier)validatedTemplateId, (Value<Value.AbsoluteContractId>)validatedContractKey, (String)choice2, (Value<Value.AbsoluteContractId>)validatedValue))))))));
        } else if (command2 instanceof Command.Command.CreateAndExercise) {
            Command.Command.CreateAndExercise createAndExercise = (Command.Command.CreateAndExercise)command2;
            either2 = FieldValidations$.MODULE$.requirePresence(createAndExercise.value().templateId(), "template_id").flatMap((Function1<Identifier, Either> & Serializable & scala.Serializable)templateId -> FieldValidations$.MODULE$.validateIdentifier((Identifier)templateId).flatMap((Function1<Ref.Identifier, Either> & Serializable & scala.Serializable)validatedTemplateId -> FieldValidations$.MODULE$.requirePresence(createAndExercise.value().createArguments(), "create_arguments").flatMap((Function1<Record, Either> & Serializable & scala.Serializable)createArguments -> ValueValidator$.MODULE$.validateOptionalIdentifier(createArguments.recordId()).flatMap((Function1<Option, Either> & Serializable & scala.Serializable)recordId -> ValueValidator$.MODULE$.validateRecordFields(createArguments.fields()).flatMap((Function1<ImmArray, Either> & Serializable & scala.Serializable)validatedRecordField -> FieldValidations$.MODULE$.requireName(createAndExercise.value().choice(), "choice").flatMap((Function1<String, Either> & Serializable & scala.Serializable)choice2 -> FieldValidations$.MODULE$.requirePresence(createAndExercise.value().choiceArgument(), "value").flatMap((Function1<com.digitalasset.ledger.api.v1.value.Value, Either> & Serializable & scala.Serializable)value -> ValueValidator$.MODULE$.validateValue((com.digitalasset.ledger.api.v1.value.Value)value).map((Function1<Value, CreateAndExerciseCommand> & Serializable & scala.Serializable)validatedChoiceArgument -> new CreateAndExerciseCommand((Ref.Identifier)validatedTemplateId, (Value<Value.AbsoluteContractId>)new Value.ValueRecord<Value.AbsoluteContractId>((Option<Ref.Identifier>)recordId, (ImmArray<Tuple2<Option<String>, Value<Value.AbsoluteContractId>>>)validatedRecordField), (String)choice2, (Value<Value.AbsoluteContractId>)validatedChoiceArgument)))))))));
        } else if (Command$Command$Empty$.MODULE$.equals(command2)) {
            either2 = package$.MODULE$.Left().apply(ErrorFactories$.MODULE$.missingField("command"));
        } else {
            throw new MatchError(command2);
        }
        return either2;
    }

    public CommandsValidator(Object ledgerId) {
        this.ledgerId = ledgerId;
    }
}

