/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.ledger.api.validation;

import com.digitalasset.daml.lf.data.BackStack;
import com.digitalasset.daml.lf.data.BackStack$;
import com.digitalasset.daml.lf.data.FrontStack;
import com.digitalasset.daml.lf.data.FrontStack$;
import com.digitalasset.daml.lf.data.ImmArray;
import com.digitalasset.daml.lf.data.Ref;
import com.digitalasset.daml.lf.data.Ref$;
import com.digitalasset.daml.lf.data.SortedLookupList;
import com.digitalasset.daml.lf.data.SortedLookupList$;
import com.digitalasset.daml.lf.data.Time$Date$;
import com.digitalasset.daml.lf.data.Time$Timestamp$;
import com.digitalasset.daml.lf.value.Value;
import com.digitalasset.daml.lf.value.Value$;
import com.digitalasset.daml.lf.value.Value$ValueBool$;
import com.digitalasset.daml.lf.value.Value$ValueDate$;
import com.digitalasset.daml.lf.value.Value$ValueNumeric$;
import com.digitalasset.daml.lf.value.Value$ValueParty$;
import com.digitalasset.daml.lf.value.Value$ValueTimestamp$;
import com.digitalasset.daml.lf.value.Value$ValueUnit$;
import com.digitalasset.ledger.api.v1.value.Enum;
import com.digitalasset.ledger.api.v1.value.GenMap;
import com.digitalasset.ledger.api.v1.value.Identifier;
import com.digitalasset.ledger.api.v1.value.List;
import com.digitalasset.ledger.api.v1.value.Map;
import com.digitalasset.ledger.api.v1.value.Optional;
import com.digitalasset.ledger.api.v1.value.Record;
import com.digitalasset.ledger.api.v1.value.RecordField;
import com.digitalasset.ledger.api.v1.value.Value;
import com.digitalasset.ledger.api.v1.value.Value$Sum$Empty$;
import com.digitalasset.ledger.api.v1.value.Variant;
import com.digitalasset.platform.server.api.validation.ErrorFactories$;
import com.digitalasset.platform.server.api.validation.FieldValidations$;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.regex.Pattern;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.util.Either;
import scala.util.Right;

public final class ValueValidator$ {
    public static ValueValidator$ MODULE$;
    private final Pattern validNumericString;

    static {
        new ValueValidator$();
    }

    public Either<StatusRuntimeException, ImmArray<Tuple2<Option<String>, Value<Value.AbsoluteContractId>>>> validateRecordFields(Seq<RecordField> recordFields) {
        return ((Either)recordFields.foldLeft(package$.MODULE$.Right().apply(BackStack$.MODULE$.empty()), (Function2<Either, RecordField, Either> & Serializable & scala.Serializable)(acc, rf) -> acc.flatMap((Function1<BackStack, Either> & Serializable & scala.Serializable)fields -> FieldValidations$.MODULE$.requirePresence(rf.value(), "value").flatMap((Function1<com.digitalasset.ledger.api.v1.value.Value, Either> & Serializable & scala.Serializable)v -> MODULE$.validateValue((com.digitalasset.ledger.api.v1.value.Value)v).flatMap((Function1<Value, Either> & Serializable & scala.Serializable)value -> (rf.label().isEmpty() ? package$.MODULE$.Right().apply(None$.MODULE$) : FieldValidations$.MODULE$.requireIdentifier(rf.label()).map((Function1<String, Some> & Serializable & scala.Serializable)x$1 -> new Some<String>((String)x$1))).map((Function1<Option, BackStack> & Serializable & scala.Serializable)label -> fields.$colon$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(label), value)))))))).map((Function1<BackStack, ImmArray> & Serializable & scala.Serializable)x$2 -> x$2.toImmArray());
    }

    public Either<StatusRuntimeException, Value.ValueRecord<Value.AbsoluteContractId>> validateRecord(Record rec) {
        return this.validateOptionalIdentifier(rec.recordId()).flatMap((Function1<Option, Either> & Serializable & scala.Serializable)recId -> MODULE$.validateRecordFields(rec.fields()).map((Function1<ImmArray, Value.ValueRecord> & Serializable & scala.Serializable)fields -> new Value.ValueRecord((Option<Ref.Identifier>)recId, fields)));
    }

    private Pattern validNumericString() {
        return this.validNumericString;
    }

    public Either<StatusRuntimeException, Value<Value.AbsoluteContractId>> validateValue(com.digitalasset.ledger.api.v1.value.Value v0) {
        Value.Sum.List list2;
        List list3;
        Value.Sum.Enum enum_;
        Enum enum_2;
        Value.Sum.Variant variant;
        Variant variant2;
        Either either2;
        Value.Sum sum = v0.sum();
        if (sum instanceof Value.Sum.ContractId) {
            Value.Sum.ContractId contractId = (Value.Sum.ContractId)sum;
            String cId = contractId.value();
            either2 = Ref$.MODULE$.ContractIdString().fromString(cId).left().map((Function1<String, StatusRuntimeException> & Serializable & scala.Serializable)errorMsg -> ErrorFactories$.MODULE$.invalidArgument((String)errorMsg)).map((Function1<String, Value.ValueContractId> & Serializable & scala.Serializable)coid -> new Value.ValueContractId<Value.AbsoluteContractId>(new Value.AbsoluteContractId((String)coid)));
        } else if (sum instanceof Value.Sum.Numeric) {
            Value.Sum.Numeric numeric = (Value.Sum.Numeric)sum;
            String value = numeric.value();
            either2 = this.validNumericString().matcher(value).matches() ? com.digitalasset.daml.lf.data.package$.MODULE$.Numeric().fromUnscaledBigDecimal(new BigDecimal(value)).left().map((Function1<String, StatusRuntimeException> & Serializable & scala.Serializable)x$3 -> ValueValidator$.err$1(value)).map(Value$ValueNumeric$.MODULE$) : package$.MODULE$.Left().apply(ValueValidator$.err$1(value));
        } else if (sum instanceof Value.Sum.Party) {
            Value.Sum.Party party = (Value.Sum.Party)sum;
            String party2 = party.value();
            either2 = Ref$.MODULE$.Party().fromString(party2).left().map((Function1<String, StatusRuntimeException> & Serializable & scala.Serializable)errorMsg -> ErrorFactories$.MODULE$.invalidArgument((String)errorMsg)).map(Value$ValueParty$.MODULE$);
        } else if (sum instanceof Value.Sum.Bool) {
            Value.Sum.Bool bool = (Value.Sum.Bool)sum;
            boolean b = bool.value();
            either2 = package$.MODULE$.Right().apply(Value$ValueBool$.MODULE$.apply(b));
        } else if (sum instanceof Value.Sum.Timestamp) {
            Value.Sum.Timestamp timestamp = (Value.Sum.Timestamp)sum;
            long micros = timestamp.value();
            either2 = Time$Timestamp$.MODULE$.fromLong(micros).left().map((Function1<String, StatusRuntimeException> & Serializable & scala.Serializable)errorMsg -> ErrorFactories$.MODULE$.invalidArgument((String)errorMsg)).map(Value$ValueTimestamp$.MODULE$);
        } else if (sum instanceof Value.Sum.Date) {
            Value.Sum.Date date = (Value.Sum.Date)sum;
            int days = date.value();
            either2 = Time$Date$.MODULE$.fromDaysSinceEpoch(days).left().map((Function1<String, StatusRuntimeException> & Serializable & scala.Serializable)errorMsg -> ErrorFactories$.MODULE$.invalidArgument((String)errorMsg)).map(Value$ValueDate$.MODULE$);
        } else if (sum instanceof Value.Sum.Text) {
            Value.Sum.Text text = (Value.Sum.Text)sum;
            String text2 = text.value();
            either2 = package$.MODULE$.Right().apply(new Value.ValueText(text2));
        } else if (sum instanceof Value.Sum.Int64) {
            Value.Sum.Int64 int64 = (Value.Sum.Int64)sum;
            long value = int64.value();
            either2 = package$.MODULE$.Right().apply(new Value.ValueInt64(value));
        } else if (sum instanceof Value.Sum.Record) {
            Value.Sum.Record record2 = (Value.Sum.Record)sum;
            Record rec = record2.value();
            either2 = this.validateRecord(rec);
        } else if (sum instanceof Value.Sum.Variant && (variant2 = (variant = (Value.Sum.Variant)sum).value()) != null) {
            Option<Identifier> variantId = variant2.variantId();
            String constructor = variant2.constructor();
            Option<com.digitalasset.ledger.api.v1.value.Value> value = variant2.value();
            either2 = this.validateOptionalIdentifier(variantId).flatMap((Function1<Option, Either> & Serializable & scala.Serializable)validatedVariantId -> FieldValidations$.MODULE$.requireName(constructor, "constructor").flatMap((Function1<String, Either> & Serializable & scala.Serializable)validatedConstructor -> FieldValidations$.MODULE$.requirePresence(value, "value").flatMap((Function1<com.digitalasset.ledger.api.v1.value.Value, Either> & Serializable & scala.Serializable)v -> MODULE$.validateValue((com.digitalasset.ledger.api.v1.value.Value)v).map((Function1<Value, Value.ValueVariant> & Serializable & scala.Serializable)validatedValue -> new Value.ValueVariant((Option<Ref.Identifier>)validatedVariantId, (String)validatedConstructor, validatedValue)))));
        } else if (sum instanceof Value.Sum.Enum && (enum_2 = (enum_ = (Value.Sum.Enum)sum).value()) != null) {
            Option<Identifier> enumId = enum_2.enumId();
            String value = enum_2.constructor();
            either2 = this.validateOptionalIdentifier(enumId).flatMap((Function1<Option, Either> & Serializable & scala.Serializable)validatedEnumId -> FieldValidations$.MODULE$.requireName(value, "value").map((Function1<String, Value.ValueEnum> & Serializable & scala.Serializable)validatedValue -> new Value.ValueEnum((Option<Ref.Identifier>)validatedEnumId, (String)validatedValue)));
        } else if (sum instanceof Value.Sum.List && (list3 = (list2 = (Value.Sum.List)sum).value()) != null) {
            Seq<com.digitalasset.ledger.api.v1.value.Value> elems = list3.elements();
            either2 = ((Either)elems.foldLeft(package$.MODULE$.Right().apply(BackStack$.MODULE$.empty()), (Function2<Either, com.digitalasset.ledger.api.v1.value.Value, Either> & Serializable & scala.Serializable)(valuesE, v) -> valuesE.flatMap((Function1<BackStack, Either> & Serializable & scala.Serializable)values -> MODULE$.validateValue((com.digitalasset.ledger.api.v1.value.Value)v).map((Function1<Value, BackStack> & Serializable & scala.Serializable)validatedValue -> values.$colon$plus(validatedValue))))).map((Function1<BackStack, Value.ValueList> & Serializable & scala.Serializable)elements -> new Value.ValueList(FrontStack$.MODULE$.apply(elements.toImmArray())));
        } else if (sum instanceof Value.Sum.Unit) {
            either2 = package$.MODULE$.Right().apply(Value$ValueUnit$.MODULE$);
        } else if (sum instanceof Value.Sum.Optional) {
            Value.Sum.Optional optional = (Value.Sum.Optional)sum;
            Optional o = optional.value();
            either2 = (Either)o.value().fold((Function0<Right> & Serializable & scala.Serializable)() -> package$.MODULE$.Right().apply(Value$.MODULE$.ValueNone()), (Function1<com.digitalasset.ledger.api.v1.value.Value, Either> & Serializable & scala.Serializable)x$4 -> MODULE$.validateValue((com.digitalasset.ledger.api.v1.value.Value)x$4).map((Function1<Value, Value.ValueOptional> & Serializable & scala.Serializable)v -> new Value.ValueOptional(new Some(v))));
        } else if (sum instanceof Value.Sum.Map) {
            Value.Sum.Map map2 = (Value.Sum.Map)sum;
            Map map0 = map2.value();
            Either map3 = map0.entries().foldLeft(package$.MODULE$.Right().apply(FrontStack$.MODULE$.empty()), (Function2<Either, Map.Entry, Either> & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Map.Entry entry;
                Either acc;
                block3: {
                    Tuple2<Either, Map.Entry> tuple2;
                    block2: {
                        tuple2 = new Tuple2<Either, Map.Entry>((Either)x0$1, (Map.Entry)x1$1);
                        if (tuple2 == null) break block2;
                        acc = tuple2._1();
                        entry = tuple2._2();
                        if (entry != null) break block3;
                    }
                    throw new MatchError(tuple2);
                }
                String key = entry.key();
                Option<com.digitalasset.ledger.api.v1.value.Value> value0 = entry.value();
                Either either2 = acc.flatMap((Function1<FrontStack, Either> & Serializable & scala.Serializable)tail -> FieldValidations$.MODULE$.requirePresence(value0, "value").flatMap((Function1<com.digitalasset.ledger.api.v1.value.Value, Either> & Serializable & scala.Serializable)v -> MODULE$.validateValue((com.digitalasset.ledger.api.v1.value.Value)v).map((Function1<Value, FrontStack> & Serializable & scala.Serializable)validatedValue -> {
                    Tuple2<String, Value> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), validatedValue);
                    return tail.$plus$colon(tuple2);
                })));
                return either2;
            });
            either2 = map3.flatMap((Function1<FrontStack, Either> & Serializable & scala.Serializable)entries -> SortedLookupList$.MODULE$.fromImmArray(entries.toImmArray()).left().map((Function1<String, StatusRuntimeException> & Serializable & scala.Serializable)errorMsg -> ErrorFactories$.MODULE$.invalidArgument((String)errorMsg)).map((Function1<SortedLookupList, Value.ValueTextMap> & Serializable & scala.Serializable)map2 -> new Value.ValueTextMap(map2)));
        } else if (sum instanceof Value.Sum.GenMap) {
            Value.Sum.GenMap genMap = (Value.Sum.GenMap)sum;
            GenMap genMap0 = genMap.value();
            Either genMap2 = genMap0.entries().foldLeft(package$.MODULE$.Right().apply(BackStack$.MODULE$.empty()), (Function2<Either, GenMap.Entry, Either> & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                GenMap.Entry entry;
                Either acc;
                block3: {
                    Tuple2<Either, GenMap.Entry> tuple2;
                    block2: {
                        tuple2 = new Tuple2<Either, GenMap.Entry>((Either)x0$2, (GenMap.Entry)x1$2);
                        if (tuple2 == null) break block2;
                        acc = tuple2._1();
                        entry = tuple2._2();
                        if (entry != null) break block3;
                    }
                    throw new MatchError(tuple2);
                }
                Option<com.digitalasset.ledger.api.v1.value.Value> key0 = entry.key();
                Option<com.digitalasset.ledger.api.v1.value.Value> value0 = entry.value();
                Either either2 = acc.flatMap((Function1<BackStack, Either> & Serializable & scala.Serializable)stack -> FieldValidations$.MODULE$.requirePresence(key0, "key").flatMap((Function1<com.digitalasset.ledger.api.v1.value.Value, Either> & Serializable & scala.Serializable)key -> FieldValidations$.MODULE$.requirePresence(value0, "value").flatMap((Function1<com.digitalasset.ledger.api.v1.value.Value, Either> & Serializable & scala.Serializable)value -> MODULE$.validateValue((com.digitalasset.ledger.api.v1.value.Value)key).flatMap((Function1<Value, Either> & Serializable & scala.Serializable)validatedKey -> MODULE$.validateValue((com.digitalasset.ledger.api.v1.value.Value)value).map((Function1<Value, BackStack> & Serializable & scala.Serializable)validatedValue -> stack.$colon$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(validatedKey), validatedValue)))))));
                return either2;
            });
            either2 = genMap2.map((Function1<BackStack, Value.ValueGenMap> & Serializable & scala.Serializable)entries -> new Value.ValueGenMap(entries.toImmArray()));
        } else if (Value$Sum$Empty$.MODULE$.equals(sum)) {
            either2 = package$.MODULE$.Left().apply(ErrorFactories$.MODULE$.missingField("value"));
        } else {
            throw new MatchError(sum);
        }
        return either2;
    }

    public Either<StatusRuntimeException, Option<Ref.Identifier>> validateOptionalIdentifier(Option<Identifier> variantIdO) {
        return (Either)variantIdO.map((Function1<Identifier, Either> & Serializable & scala.Serializable)x$6 -> FieldValidations$.MODULE$.validateIdentifier((Identifier)x$6).map((Function1<Ref.Identifier, Some> & Serializable & scala.Serializable)value -> new Some<Ref.Identifier>((Ref.Identifier)value))).getOrElse((Function0<Right> & Serializable & scala.Serializable)() -> package$.MODULE$.Right().apply(None$.MODULE$));
    }

    private static final StatusRuntimeException err$1(String value$1) {
        return ErrorFactories$.MODULE$.invalidArgument(new StringBuilder(32).append("Could not read Numeric string \"").append(value$1).append("\"").toString());
    }

    private ValueValidator$() {
        MODULE$ = this;
        this.validNumericString = new StringOps(Predef$.MODULE$.augmentString("[+-]?\\d{1,38}(\\.\\d{0,37})?")).r().pattern();
    }
}

