/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.platform.server.api.services.grpc;

import akka.NotUsed;
import akka.stream.Materializer;
import akka.stream.SharedKillSwitch;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.digitalasset.api.util.TimestampConversion$;
import com.digitalasset.dec.DirectExecutionContext$;
import com.digitalasset.grpc.adapter.ExecutionSequencerFactory;
import com.digitalasset.ledger.api.domain;
import com.digitalasset.ledger.api.messages.command.completion.CompletionEndRequest;
import com.digitalasset.ledger.api.v1.command_completion_service.Checkpoint;
import com.digitalasset.ledger.api.v1.command_completion_service.CommandCompletionServiceAkkaGrpc;
import com.digitalasset.ledger.api.v1.command_completion_service.CommandCompletionServiceGrpc;
import com.digitalasset.ledger.api.v1.command_completion_service.CommandCompletionServiceGrpc$CommandCompletionService$;
import com.digitalasset.ledger.api.v1.command_completion_service.CompletionEndResponse;
import com.digitalasset.ledger.api.v1.command_completion_service.CompletionStreamRequest;
import com.digitalasset.ledger.api.v1.command_completion_service.CompletionStreamResponse;
import com.digitalasset.ledger.api.v1.command_completion_service.CompletionStreamResponse$;
import com.digitalasset.ledger.api.v1.completion.Completion;
import com.digitalasset.ledger.api.v1.completion.Completion$;
import com.digitalasset.ledger.api.v1.ledger_offset.LedgerOffset;
import com.digitalasset.ledger.api.validation.CompletionServiceRequestValidator;
import com.digitalasset.ledger.api.validation.PartyNameChecker;
import com.digitalasset.platform.server.api.services.domain.CommandCompletionService;
import com.digitalasset.platform.server.api.services.grpc.GrpcCommandCompletionService$;
import com.google.protobuf.timestamp.Timestamp;
import com.google.rpc.status.Status;
import com.google.rpc.status.Status$;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scalaz.syntax.TagOps$;
import scalaz.syntax.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dv!B\u0001\u0003\u0011\u0003\t\u0012\u0001H$sa\u000e\u001cu.\\7b]\u0012\u001cu.\u001c9mKRLwN\\*feZL7-\u001a\u0006\u0003\u0007\u0011\tAa\u001a:qG*\u0011QAB\u0001\tg\u0016\u0014h/[2fg*\u0011q\u0001C\u0001\u0004CBL'BA\u0005\u000b\u0003\u0019\u0019XM\u001d<fe*\u00111\u0002D\u0001\ta2\fGOZ8s[*\u0011QBD\u0001\rI&<\u0017\u000e^1mCN\u001cX\r\u001e\u0006\u0002\u001f\u0005\u00191m\\7\u0004\u0001A\u0011!cE\u0007\u0002\u0005\u0019)AC\u0001E\u0001+\tarI\u001d9d\u0007>lW.\u00198e\u0007>l\u0007\u000f\\3uS>t7+\u001a:wS\u000e,7CA\n\u0017!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005\u0019\te.\u001f*fM\")Qd\u0005C\u0001=\u00051A(\u001b8jiz\"\u0012!\u0005\u0005\u0007AM\u0001\u000b\u0011B\u0011\u0002;\r|W\u000e\u001d7fi&|gn\u0015;sK\u0006lG)\u001a4bk2$xJ\u001a4tKR\u00042a\u0006\u0012%\u0013\t\u0019\u0003D\u0001\u0003T_6,gBA\u00131\u001d\t1SF\u0004\u0002(W5\t\u0001F\u0003\u0002\bS)\u0011!\u0006D\u0001\u0007Y\u0016$w-\u001a:\n\u00051B\u0013A\u00023p[\u0006Lg.\u0003\u0002/_\u0005aA*\u001a3hKJ|eMZ:fi*\u0011A\u0006K\u0005\u0003cI\n\u0011\u0002T3eO\u0016\u0014XI\u001c3\u000b\u00059z\u0003\"\u0002\u001b\u0014\t\u0013)\u0014A\u00054jY2LenV5uQ\u0012+g-Y;miN$\"A\u000e!\u0011\u0005]rT\"\u0001\u001d\u000b\u0005eR\u0014AC2p[BdW\r^5p]*\u00111\bP\u0001\bG>lW.\u00198e\u0015\ti\u0004&\u0001\u0005nKN\u001c\u0018mZ3t\u0013\ty\u0004HA\fD_6\u0004H.\u001a;j_:\u001cFO]3b[J+\u0017/^3ti\")\u0011i\ra\u0001m\u00059!/Z9vKN$h\u0001\u0002\u000b\u0003\u0001\r\u001b2A\u0011\fE!\t)%*D\u0001G\u0015\t9\u0005*\u0001\u000ed_6l\u0017M\u001c3`G>l\u0007\u000f\\3uS>twl]3sm&\u001cWM\u0003\u0002JQ\u0005\u0011a/M\u0005\u0003\u0017\u001a\u0013\u0001eQ8n[\u0006tGmQ8na2,G/[8o'\u0016\u0014h/[2f\u0003.\\\u0017m\u0012:qG\"AQJ\u0011B\u0001B\u0003%a*\u0001\u0005mK\u0012<WM]%e!\ty5L\u0004\u0002QW9\u0011\u0011K\u0017\b\u0003%fs!a\u0015-\u000f\u0005Q;V\"A+\u000b\u0005Y\u0003\u0012A\u0002\u001fs_>$h(C\u0001\u0010\u0013\tia\"\u0003\u0002+\u0019%\u0011q!K\u0005\u00039>\u0012\u0001\u0002T3eO\u0016\u0014\u0018\n\u001a\u0005\t=\n\u0013\t\u0011)A\u0005?\u000691/\u001a:wS\u000e,\u0007C\u00011c\u001b\u0005\t'B\u0001\u0017\u0005\u0013\t\u0019\u0017M\u0001\rD_6l\u0017M\u001c3D_6\u0004H.\u001a;j_:\u001cVM\u001d<jG\u0016D\u0001\"\u001a\"\u0003\u0002\u0003\u0006IAZ\u0001\u0011a\u0006\u0014H/\u001f(b[\u0016\u001c\u0005.Z2lKJ\u0004\"a\u001a6\u000e\u0003!T!!\u001b\u0015\u0002\u0015Y\fG.\u001b3bi&|g.\u0003\u0002lQ\n\u0001\u0002+\u0019:us:\u000bW.Z\"iK\u000e\\WM\u001d\u0005\t[\n\u0013)\u0019!C\n]\u0006\u0019Qm\u001d4\u0016\u0003=\u0004\"\u0001\u001d;\u000e\u0003ET!A]:\u0002\u000f\u0005$\u0017\r\u001d;fe*\u00111\u0001D\u0005\u0003kF\u0014\u0011$\u0012=fGV$\u0018n\u001c8TKF,XM\\2fe\u001a\u000b7\r^8ss\"AqO\u0011B\u0001B\u0003%q.\u0001\u0003fg\u001a\u0004\u0003\u0002C=C\u0005\u000b\u0007I1\u0003>\u0002\u00075\fG/F\u0001|!\ra\u00181A\u0007\u0002{*\u0011ap`\u0001\u0007gR\u0014X-Y7\u000b\u0005\u0005\u0005\u0011\u0001B1lW\u0006L1!!\u0002~\u00051i\u0015\r^3sS\u0006d\u0017N_3s\u0011%\tIA\u0011B\u0001B\u0003%10\u0001\u0003nCR\u0004\u0003BB\u000fC\t\u0003\ti\u0001\u0006\u0005\u0002\u0010\u0005]\u0011\u0011DA\u000e)\u0019\t\t\"a\u0005\u0002\u0016A\u0011!C\u0011\u0005\u0007[\u0006-\u00019A8\t\re\fY\u0001q\u0001|\u0011\u0019i\u00151\u0002a\u0001\u001d\"1a,a\u0003A\u0002}Ca!ZA\u0006\u0001\u00041\u0007\"CA\u0010\u0005\n\u0007I\u0011BA\u0011\u0003%1\u0018\r\\5eCR|'/\u0006\u0002\u0002$A\u0019q-!\n\n\u0007\u0005\u001d\u0002NA\u0011D_6\u0004H.\u001a;j_:\u001cVM\u001d<jG\u0016\u0014V-];fgR4\u0016\r\\5eCR|'\u000f\u0003\u0005\u0002,\t\u0003\u000b\u0011BA\u0012\u0003)1\u0018\r\\5eCR|'\u000f\t\u0005\b\u0003_\u0011E\u0011IA\u0019\u0003Y\u0019w.\u001c9mKRLwN\\*ue\u0016\fWnU8ve\u000e,G\u0003BA\u001a\u0003\u001b\u0002\u0002\"!\u000e\u0002<\u0005}\u0012QI\u0007\u0003\u0003oQ1!!\u000f~\u0003!\u00198-\u00197bINd\u0017\u0002BA\u001f\u0003o\u0011aaU8ve\u000e,\u0007cA#\u0002B%\u0019\u00111\t$\u00031\r{W\u000e\u001d7fi&|gn\u0015;sK\u0006l'+Z:q_:\u001cX\r\u0005\u0003\u0002H\u0005%S\"A@\n\u0007\u0005-sPA\u0004O_R,6/\u001a3\t\u000f\u0005\u000bi\u00031\u0001\u0002PA\u0019Q)!\u0015\n\u0005}2\u0005bBA+\u0005\u0012\u0005\u0013qK\u0001\u000eG>l\u0007\u000f\\3uS>tWI\u001c3\u0015\t\u0005e\u00131\u000e\t\u0007\u00037\n\t'!\u001a\u000e\u0005\u0005u#bAA01\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005\r\u0014Q\f\u0002\u0007\rV$XO]3\u0011\u0007\u0015\u000b9'C\u0002\u0002j\u0019\u0013QcQ8na2,G/[8o\u000b:$'+Z:q_:\u001cX\rC\u0004B\u0003'\u0002\r!!\u001c\u0011\u0007\u0015\u000by'C\u0002\u0002r\u0019\u0013AcQ8na2,G/[8o\u000b:$'+Z9vKN$\bbBA;\u0005\u0012%\u0011qO\u0001\u0010i>\f\u0005/[\"p[BdW\r^5p]R!\u0011qHA=\u0011!\tY(a\u001dA\u0002\u0005u\u0014AA2f!\r1\u0013qP\u0005\u0004\u0003\u0003{#aD\"p[BdW\r^5p]\u00163XM\u001c;\t\u000f\u0005\u0015%\t\"\u0003\u0002\b\u0006)\"/\u001a6fGRLwN\u001c+p\u0007>l\u0007\u000f\\3uS>tGCBAE\u0003'\u000bi\n\u0005\u0003\u0002\f\u0006=UBAAG\u0015\tI\u0004*\u0003\u0003\u0002\u0012\u00065%AC\"p[BdW\r^5p]\"A\u0011QSAB\u0001\u0004\t9*A\u0005d_6l\u0017M\u001c3JIB\u0019q*!'\n\u0007\u0005muFA\u0005D_6l\u0017M\u001c3JI\"A\u0011qTAB\u0001\u0004\t\t+A\u0003feJ|'\u000fE\u0002P\u0003GK1!!*0\u0005=\u0011VM[3di&|gNU3bg>t\u0007")
public class GrpcCommandCompletionService
implements CommandCompletionServiceAkkaGrpc {
    private final CommandCompletionService service;
    private final ExecutionSequencerFactory esf;
    private final Materializer mat;
    private final CompletionServiceRequestValidator validator;
    private final SharedKillSwitch killSwitch;
    private final AtomicBoolean closed;

    @Override
    public StatusRuntimeException closingError() {
        return CommandCompletionServiceAkkaGrpc.closingError$(this);
    }

    @Override
    public void close() {
        CommandCompletionServiceAkkaGrpc.close$(this);
    }

    @Override
    public void completionStream(CompletionStreamRequest request, StreamObserver<CompletionStreamResponse> responseObserver) {
        CommandCompletionServiceAkkaGrpc.completionStream$(this, request, responseObserver);
    }

    @Override
    public CommandCompletionServiceGrpc$CommandCompletionService$ serviceCompanion() {
        return CommandCompletionServiceGrpc.CommandCompletionService.serviceCompanion$(this);
    }

    @Override
    public SharedKillSwitch killSwitch() {
        return this.killSwitch;
    }

    @Override
    public AtomicBoolean closed() {
        return this.closed;
    }

    @Override
    public void com$digitalasset$ledger$api$v1$command_completion_service$CommandCompletionServiceAkkaGrpc$_setter_$killSwitch_$eq(SharedKillSwitch x$1) {
        this.killSwitch = x$1;
    }

    @Override
    public void com$digitalasset$ledger$api$v1$command_completion_service$CommandCompletionServiceAkkaGrpc$_setter_$closed_$eq(AtomicBoolean x$1) {
        this.closed = x$1;
    }

    @Override
    public ExecutionSequencerFactory esf() {
        return this.esf;
    }

    @Override
    public Materializer mat() {
        return this.mat;
    }

    private CompletionServiceRequestValidator validator() {
        return this.validator;
    }

    @Override
    public Source<CompletionStreamResponse, NotUsed> completionStreamSource(CompletionStreamRequest request) {
        return (Source)this.validator().validateCompletionStreamRequest(request).fold((Function1<Throwable, Source> & Serializable & scala.Serializable)cause -> Source$.MODULE$.failed((Throwable)cause), (Function1<com.digitalasset.ledger.api.messages.command.completion.CompletionStreamRequest, Source> & Serializable & scala.Serializable)validatedRequest -> (Source)$this.service.completionStreamSource(GrpcCommandCompletionService$.MODULE$.com$digitalasset$platform$server$api$services$grpc$GrpcCommandCompletionService$$fillInWithDefaults((com.digitalasset.ledger.api.messages.command.completion.CompletionStreamRequest)validatedRequest)).map((Function1<domain.CompletionEvent, CompletionStreamResponse> & Serializable & scala.Serializable)ce -> this.toApiCompletion((domain.CompletionEvent)ce)));
    }

    @Override
    public Future<CompletionEndResponse> completionEnd(com.digitalasset.ledger.api.v1.command_completion_service.CompletionEndRequest request) {
        return (Future)this.validator().validateCompletionEndRequest(request).fold((Function1<Throwable, Future> & Serializable & scala.Serializable)exception -> Future$.MODULE$.failed((Throwable)exception), (Function1<CompletionEndRequest, Future> & Serializable & scala.Serializable)req -> $this.service.getLedgerEnd(req.ledgerId()).map((Function1<domain.LedgerOffset.Absolute, CompletionEndResponse> & Serializable & scala.Serializable)abs -> new CompletionEndResponse(new Some<LedgerOffset>(new LedgerOffset(new LedgerOffset.Value.Absolute(abs.value())))), DirectExecutionContext$.MODULE$));
    }

    private CompletionStreamResponse toApiCompletion(domain.CompletionEvent ce) {
        CompletionStreamResponse completionStreamResponse;
        Some<Checkpoint> checkpoint = new Some<Checkpoint>(new Checkpoint(new Some<Timestamp>(TimestampConversion$.MODULE$.fromInstant(ce.recordTime())), new Some<LedgerOffset>(new LedgerOffset(new LedgerOffset.Value.Absolute(ce.offset().value())))));
        domain.CompletionEvent completionEvent = ce;
        if (completionEvent instanceof domain.CompletionEvent.CommandAccepted) {
            domain.CompletionEvent.CommandAccepted commandAccepted = (domain.CompletionEvent.CommandAccepted)completionEvent;
            Object commandId = commandAccepted.commandId();
            Object transactionId = commandAccepted.transactionId();
            completionStreamResponse = new CompletionStreamResponse(checkpoint, (Seq<Completion>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Completion[]{new Completion((String)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(commandId)), new Some<Status>(new Status(Status$.MODULE$.apply$default$1(), Status$.MODULE$.apply$default$2(), Status$.MODULE$.apply$default$3())), (String)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(transactionId)), Completion$.MODULE$.apply$default$4())})));
        } else if (completionEvent instanceof domain.CompletionEvent.CommandRejected) {
            domain.CompletionEvent.CommandRejected commandRejected = (domain.CompletionEvent.CommandRejected)completionEvent;
            Object commandId = commandRejected.commandId();
            domain.RejectionReason reason = commandRejected.reason();
            completionStreamResponse = new CompletionStreamResponse(checkpoint, (Seq<Completion>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Completion[]{this.rejectionToCompletion(commandId, reason)})));
        } else if (completionEvent instanceof domain.CompletionEvent.Checkpoint) {
            completionStreamResponse = new CompletionStreamResponse(checkpoint, CompletionStreamResponse$.MODULE$.apply$default$2());
        } else {
            throw new MatchError(completionEvent);
        }
        return completionStreamResponse;
    }

    private Completion rejectionToCompletion(Object commandId, domain.RejectionReason error) {
        Status.Code code;
        domain.RejectionReason rejectionReason = error;
        if (rejectionReason instanceof domain.RejectionReason.Inconsistent) {
            code = Status.Code.INVALID_ARGUMENT;
        } else if (rejectionReason instanceof domain.RejectionReason.OutOfQuota) {
            code = Status.Code.ABORTED;
        } else if (rejectionReason instanceof domain.RejectionReason.TimedOut) {
            code = Status.Code.ABORTED;
        } else if (rejectionReason instanceof domain.RejectionReason.Disputed) {
            code = Status.Code.INVALID_ARGUMENT;
        } else if (rejectionReason instanceof domain.RejectionReason.PartyNotKnownOnLedger) {
            code = Status.Code.INVALID_ARGUMENT;
        } else if (rejectionReason instanceof domain.RejectionReason.SubmitterCannotActViaParticipant) {
            code = Status.Code.PERMISSION_DENIED;
        } else {
            throw new MatchError(rejectionReason);
        }
        Status.Code code2 = code;
        String x$5 = (String)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(commandId));
        Some<Status> x$6 = new Some<Status>(new Status(code2.value(), error.description(), Status$.MODULE$.apply$default$3()));
        None$ x$7 = None$.MODULE$;
        String x$8 = Completion$.MODULE$.apply$default$3();
        return new Completion(x$5, x$6, x$8, x$7);
    }

    public GrpcCommandCompletionService(Object ledgerId, CommandCompletionService service, PartyNameChecker partyNameChecker, ExecutionSequencerFactory esf, Materializer mat) {
        this.service = service;
        this.esf = esf;
        this.mat = mat;
        CommandCompletionServiceGrpc.CommandCompletionService.$init$(this);
        CommandCompletionServiceAkkaGrpc.$init$(this);
        this.validator = new CompletionServiceRequestValidator(ledgerId, partyNameChecker);
    }
}

