/*
 * Decompiled with CFR 0.152.
 */
package com.digitalasset.platform.server.api.services.grpc;

import akka.NotUsed;
import akka.stream.Materializer;
import akka.stream.SharedKillSwitch;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.digitalasset.api.util.TimestampConversion$;
import com.digitalasset.daml.lf.data.Ref;
import com.digitalasset.daml.lf.value.Value;
import com.digitalasset.dec.DirectExecutionContext$;
import com.digitalasset.grpc.adapter.ExecutionSequencerFactory;
import com.digitalasset.ledger.api.domain;
import com.digitalasset.ledger.api.messages.transaction.GetLedgerEndRequest;
import com.digitalasset.ledger.api.messages.transaction.GetTransactionByEventIdRequest;
import com.digitalasset.ledger.api.messages.transaction.GetTransactionTreesRequest;
import com.digitalasset.ledger.api.messages.transaction.GetTransactionsRequest;
import com.digitalasset.ledger.api.v1.event.ArchivedEvent;
import com.digitalasset.ledger.api.v1.event.CreatedEvent;
import com.digitalasset.ledger.api.v1.event.Event;
import com.digitalasset.ledger.api.v1.event.ExercisedEvent;
import com.digitalasset.ledger.api.v1.ledger_offset.LedgerOffset;
import com.digitalasset.ledger.api.v1.transaction.Transaction;
import com.digitalasset.ledger.api.v1.transaction.Transaction$;
import com.digitalasset.ledger.api.v1.transaction.TransactionTree;
import com.digitalasset.ledger.api.v1.transaction.TransactionTree$;
import com.digitalasset.ledger.api.v1.transaction.TreeEvent;
import com.digitalasset.ledger.api.v1.transaction_service.GetFlatTransactionResponse;
import com.digitalasset.ledger.api.v1.transaction_service.GetLedgerEndResponse;
import com.digitalasset.ledger.api.v1.transaction_service.GetTransactionByIdRequest;
import com.digitalasset.ledger.api.v1.transaction_service.GetTransactionResponse;
import com.digitalasset.ledger.api.v1.transaction_service.GetTransactionTreesResponse;
import com.digitalasset.ledger.api.v1.transaction_service.GetTransactionsResponse;
import com.digitalasset.ledger.api.v1.transaction_service.TransactionServiceAkkaGrpc;
import com.digitalasset.ledger.api.v1.transaction_service.TransactionServiceGrpc;
import com.digitalasset.ledger.api.v1.transaction_service.TransactionServiceGrpc$;
import com.digitalasset.ledger.api.v1.transaction_service.TransactionServiceGrpc$TransactionService$;
import com.digitalasset.ledger.api.v1.value.Identifier;
import com.digitalasset.ledger.api.v1.value.Record;
import com.digitalasset.ledger.api.validation.PartyNameChecker;
import com.digitalasset.ledger.api.validation.TransactionServiceRequestValidator;
import com.digitalasset.platform.api.grpc.GrpcApiService;
import com.digitalasset.platform.participant.util.LfEngineToApi$;
import com.digitalasset.platform.server.api.ApiException;
import com.digitalasset.platform.server.api.services.domain.TransactionService;
import com.digitalasset.platform.server.api.validation.ErrorFactories;
import com.digitalasset.platform.server.api.validation.FieldValidations;
import com.google.protobuf.timestamp.Timestamp;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Seq$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.util.Either;
import scalaz.Tag$;
import scalaz.syntax.TagOps$;
import scalaz.syntax.package$;

@ScalaSignature(bytes="\u0006\u0001\t\rh\u0001B\u0001\u0003\u0001E\u0011ac\u0012:qGR\u0013\u0018M\\:bGRLwN\\*feZL7-\u001a\u0006\u0003\u0007\u0011\tAa\u001a:qG*\u0011QAB\u0001\tg\u0016\u0014h/[2fg*\u0011q\u0001C\u0001\u0004CBL'BA\u0005\u000b\u0003\u0019\u0019XM\u001d<fe*\u00111\u0002D\u0001\ta2\fGOZ8s[*\u0011QBD\u0001\rI&<\u0017\u000e^1mCN\u001cX\r\u001e\u0006\u0002\u001f\u0005\u00191m\\7\u0004\u0001M1\u0001A\u0005\r$S=\u0002\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007CA\r\"\u001b\u0005Q\"BA\u000e\u001d\u0003M!(/\u00198tC\u000e$\u0018n\u001c8`g\u0016\u0014h/[2f\u0015\tib$\u0001\u0002wc)\u0011qa\b\u0006\u0003A1\ta\u0001\\3eO\u0016\u0014\u0018B\u0001\u0012\u001b\u0005i!&/\u00198tC\u000e$\u0018n\u001c8TKJ4\u0018nY3BW.\fwI\u001d9d!\t!s%D\u0001&\u0015\t\u0019aE\u0003\u0002\b\u0015%\u0011\u0001&\n\u0002\u000f\u000fJ\u00048-\u00119j'\u0016\u0014h/[2f!\tQS&D\u0001,\u0015\tac!\u0001\u0006wC2LG-\u0019;j_:L!AL\u0016\u0003\u001d\u0015\u0013(o\u001c:GC\u000e$xN]5fgB\u0011!\u0006M\u0005\u0003c-\u0012\u0001CR5fY\u00124\u0016\r\\5eCRLwN\\:\t\u0011M\u0002!Q1A\u0005\u0012Q\nqa]3sm&\u001cW-F\u00016!\t1\u0014(D\u00018\u0015\tAD!\u0001\u0004e_6\f\u0017N\\\u0005\u0003u]\u0012!\u0003\u0016:b]N\f7\r^5p]N+'O^5dK\"AA\b\u0001B\u0001B\u0003%Q'\u0001\u0005tKJ4\u0018nY3!\u0011!q\u0004A!b\u0001\n\u0003y\u0014\u0001\u00037fI\u001e,'/\u00133\u0016\u0003\u0001\u0003\"!\u0011(\u000f\u0005\tkeBA\"M\u001d\t!5J\u0004\u0002F\u0015:\u0011a)S\u0007\u0002\u000f*\u0011\u0001\nE\u0001\u0007yI|w\u000e\u001e \n\u0003=I!!\u0004\b\n\u0005\u0001b\u0011BA\u0004 \u0013\tAd$\u0003\u0002P!\nAA*\u001a3hKJLEM\u0003\u00029=!A!\u000b\u0001B\u0001B\u0003%\u0001)A\u0005mK\u0012<WM]%eA!AA\u000b\u0001B\u0001B\u0003%Q+\u0001\tqCJ$\u0018PT1nK\u000eCWmY6feB\u0011a\u000bW\u0007\u0002/*\u0011AFH\u0005\u00033^\u0013\u0001\u0003U1sift\u0015-\\3DQ\u0016\u001c7.\u001a:\t\u0011m\u0003!Q1A\u0005\u0014q\u000b1!Z:g+\u0005i\u0006C\u00010c\u001b\u0005y&B\u00011b\u0003\u001d\tG-\u00199uKJT!a\u0001\u0007\n\u0005\r|&!G#yK\u000e,H/[8o'\u0016\fX/\u001a8dKJ4\u0015m\u0019;pefD\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006I!X\u0001\u0005KN4\u0007\u0005\u0003\u0005h\u0001\t\u0015\r\u0011b\u0005i\u0003\ri\u0017\r^\u000b\u0002SB\u0011!n\\\u0007\u0002W*\u0011A.\\\u0001\u0007gR\u0014X-Y7\u000b\u00039\fA!Y6lC&\u0011\u0001o\u001b\u0002\r\u001b\u0006$XM]5bY&TXM\u001d\u0005\te\u0002\u0011\t\u0011)A\u0005S\u0006!Q.\u0019;!\u0011\u0015!\b\u0001\"\u0001v\u0003\u0019a\u0014N\\5u}Q!ao\u001f?~)\r9\u0018P\u001f\t\u0003q\u0002i\u0011A\u0001\u0005\u00067N\u0004\u001d!\u0018\u0005\u0006ON\u0004\u001d!\u001b\u0005\u0006gM\u0004\r!\u000e\u0005\u0006}M\u0004\r\u0001\u0011\u0005\u0006)N\u0004\r!\u0016\u0005\t\u007f\u0002\u0011\r\u0011\"\u0005\u0002\u0002\u00051An\\4hKJ,\"!a\u0001\u0011\t\u0005\u0015\u0011qB\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005)1\u000f\u001c45U*\u0011\u0011QB\u0001\u0004_J<\u0017\u0002BA\t\u0003\u000f\u0011a\u0001T8hO\u0016\u0014\b\u0002CA\u000b\u0001\u0001\u0006I!a\u0001\u0002\u000f1|wmZ3sA\u00151\u0011\u0011\u0004\u0001\u0005\u00037\u0011A\"T1q'R\u0014\u0018N\\4TKR,B!!\b\u0002>AA\u0011qDA\u0014\u0003[\t\u0019D\u0004\u0003\u0002\"\u0005\r\u0002C\u0001$\u0015\u0013\r\t)\u0003F\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00121\u0006\u0002\u0004\u001b\u0006\u0004(bAA\u0013)A!\u0011qDA\u0018\u0013\u0011\t\t$a\u000b\u0003\rM#(/\u001b8h!\u0019\ty\"!\u000e\u0002:%!\u0011qGA\u0016\u0005\r\u0019V\r\u001e\t\u0005\u0003w\ti\u0004\u0004\u0001\u0005\u0011\u0005}\u0012q\u0003b\u0001\u0003\u0003\u0012\u0011\u0001V\t\u0005\u0003\u0007\nI\u0005E\u0002\u0014\u0003\u000bJ1!a\u0012\u0015\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aEA&\u0013\r\ti\u0005\u0006\u0002\u0004\u0003:L\b\"CA)\u0001\t\u0007I\u0011BA*\u0003%1\u0018\r\\5eCR|'/\u0006\u0002\u0002VA\u0019a+a\u0016\n\u0007\u0005esK\u0001\u0012Ue\u0006t7/Y2uS>t7+\u001a:wS\u000e,'+Z9vKN$h+\u00197jI\u0006$xN\u001d\u0005\t\u0003;\u0002\u0001\u0015!\u0003\u0002V\u0005Qa/\u00197jI\u0006$xN\u001d\u0011\t\u000f\u0005\u0005\u0004\u0001\"\u0015\u0002d\u0005)r-\u001a;Ue\u0006t7/Y2uS>t7oU8ve\u000e,G\u0003BA3\u0003\u007f\u0002\u0002\"a\u001a\u0002n\u0005E\u0014qO\u0007\u0003\u0003SR1!a\u001bl\u0003!\u00198-\u00197bINd\u0017\u0002BA8\u0003S\u0012aaU8ve\u000e,\u0007cA\r\u0002t%\u0019\u0011Q\u000f\u000e\u0003/\u001d+G\u000f\u0016:b]N\f7\r^5p]N\u0014Vm\u001d9p]N,\u0007\u0003BA=\u0003wj\u0011!\\\u0005\u0004\u0003{j'a\u0002(piV\u001bX\r\u001a\u0005\t\u0003\u0003\u000by\u00061\u0001\u0002\u0004\u00069!/Z9vKN$\bcA\r\u0002\u0006&\u0019\u0011q\u0011\u000e\u0003-\u001d+G\u000f\u0016:b]N\f7\r^5p]N\u0014V-];fgRDq!a#\u0001\t#\ni)A\rhKR$&/\u00198tC\u000e$\u0018n\u001c8Ue\u0016,7oU8ve\u000e,G\u0003BAH\u0003/\u0003\u0002\"a\u001a\u0002n\u0005E\u0015q\u000f\t\u00043\u0005M\u0015bAAK5\tYr)\u001a;Ue\u0006t7/Y2uS>tGK]3fgJ+7\u000f]8og\u0016D\u0001\"!!\u0002\n\u0002\u0007\u00111\u0011\u0005\b\u00037\u0003A\u0011BAO\u0003Q9W\r^*j]\u001edW\r\u0016:b]N\f7\r^5p]VQ\u0011qTA]\u00037\fI/a,\u0015\u0015\u0005\u0005\u00161WA_\u0003?\fi\u000f\u0005\u0004\u0002$\u0006%\u0016QV\u0007\u0003\u0003KS1!a*\u0015\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003W\u000b)K\u0001\u0004GkR,(/\u001a\t\u0005\u0003w\ty\u000b\u0002\u0005\u00022\u0006e%\u0019AA!\u0005!\u0011Vm\u001d9p]N,\u0007\u0002CA[\u00033\u0003\r!a.\u0002\u0007I,\u0017\u000f\u0005\u0003\u0002<\u0005eF\u0001CA^\u00033\u0013\r!!\u0011\u0003\u000fI+\u0017/^3ti\"A\u0011qXAM\u0001\u0004\t\t-\u0001\u0005wC2LG-\u0019;f!\u001d\u0019\u00121YA\\\u0003\u000fL1!!2\u0015\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0004\u0002J\u0006M\u0017\u0011\u001c\b\u0005\u0003\u0017\fyMD\u0002C\u0003\u001bL!\u0001\f\u0010\n\u0007\u0005Ew+\u0001\u0012Ue\u0006t7/Y2uS>t7+\u001a:wS\u000e,'+Z9vKN$h+\u00197jI\u0006$xN]\u0005\u0005\u0003+\f9N\u0001\u0004SKN,H\u000e\u001e\u0006\u0004\u0003#<\u0006\u0003BA\u001e\u00037$\u0001\"!8\u0002\u001a\n\u0007\u0011\u0011\t\u0002\u000e\t>l\u0017-\u001b8SKF,Xm\u001d;\t\u0011\u0005\u0005\u0018\u0011\u0014a\u0001\u0003G\fQAZ3uG\"\u0004raEAb\u00033\f)\u000f\u0005\u0004\u0002$\u0006%\u0016q\u001d\t\u0005\u0003w\tI\u000f\u0002\u0005\u0002l\u0006e%\u0019AA!\u0005!!u.\\1j]RC\b\u0002CAx\u00033\u0003\r!!=\u0002\u000bQ|\u0017\t]5\u0011\u000fM\t\u0019-a:\u0002.\"9\u0011Q\u001f\u0001\u0005B\u0005]\u0018aF4fiR\u0013\u0018M\\:bGRLwN\u001c\"z\u000bZ,g\u000e^%e)\u0011\tIP!\u0001\u0011\r\u0005\r\u0016\u0011VA~!\rI\u0012Q`\u0005\u0004\u0003\u007fT\"AF$fiR\u0013\u0018M\\:bGRLwN\u001c*fgB|gn]3\t\u0011\u0005\u0005\u00151\u001fa\u0001\u0005\u0007\u00012!\u0007B\u0003\u0013\r\u00119A\u0007\u0002\u001f\u000f\u0016$HK]1og\u0006\u001cG/[8o\u0005f,e/\u001a8u\u0013\u0012\u0014V-];fgRDqAa\u0003\u0001\t\u0003\u0012i!\u0001\nhKR$&/\u00198tC\u000e$\u0018n\u001c8Cs&#G\u0003BA}\u0005\u001fA\u0001\"!!\u0003\n\u0001\u0007!\u0011\u0003\t\u00043\tM\u0011b\u0001B\u000b5\tIr)\u001a;Ue\u0006t7/Y2uS>t')_%e%\u0016\fX/Z:u\u0011\u001d\u0011I\u0002\u0001C!\u00057\t1dZ3u\r2\fG\u000f\u0016:b]N\f7\r^5p]\nKXI^3oi&#G\u0003\u0002B\u000f\u0005K\u0001b!a)\u0002*\n}\u0001cA\r\u0003\"%\u0019!1\u0005\u000e\u00035\u001d+GO\u00127biR\u0013\u0018M\\:bGRLwN\u001c*fgB|gn]3\t\u0011\u0005\u0005%q\u0003a\u0001\u0005\u0007AqA!\u000b\u0001\t\u0003\u0012Y#\u0001\fhKR4E.\u0019;Ue\u0006t7/Y2uS>t')_%e)\u0011\u0011iB!\f\t\u0011\u0005\u0005%q\u0005a\u0001\u0005#AqA!\r\u0001\t\u0003\u0012\u0019$\u0001\u0007hKRdU\rZ4fe\u0016sG\r\u0006\u0003\u00036\tu\u0002CBAR\u0003S\u00139\u0004E\u0002\u001a\u0005sI1Aa\u000f\u001b\u0005Q9U\r\u001e'fI\u001e,'/\u00128e%\u0016\u001c\bo\u001c8tK\"A\u0011\u0011\u0011B\u0018\u0001\u0004\u0011y\u0004E\u0002\u001a\u0005\u0003J1Aa\u0011\u001b\u0005M9U\r\u001e'fI\u001e,'/\u00128e%\u0016\fX/Z:u\u0011\u001d\u00119\u0005\u0001C!\u0005\u0013\n1BY5oIN+'O^5dKR\u0011!1\n\t\u0005\u0005\u001b\u0012)&\u0004\u0002\u0003P)\u00191A!\u0015\u000b\u0005\tM\u0013AA5p\u0013\u0011\u00119Fa\u0014\u0003/M+'O^3s'\u0016\u0014h/[2f\t\u00164\u0017N\\5uS>t\u0007b\u0002B.\u0001\u0011\u0005!QL\u0001\u0012I>l\u0017-\u001b8UqR{\u0017\t]5GY\u0006$HC\u0002B0\u0005W\u00129\b\u0005\u0003\u0003b\t\u001dTB\u0001B2\u0015\r\u0011)\u0007H\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u0003j\t\r$a\u0003+sC:\u001c\u0018m\u0019;j_:D\u0001B!\u001c\u0003Z\u0001\u0007!qN\u0001\u0003ib\u0004BA!\u001d\u0003v9\u0019!1O'\u000e\u0003yI1A!\u001bQ\u0011!\u0011IH!\u0017A\u0002\tm\u0014a\u0002<fe\n|7/\u001a\t\u0004'\tu\u0014b\u0001B@)\t9!i\\8mK\u0006t\u0007b\u0002BB\u0001\u0011\u0005!QQ\u0001\u0012I>l\u0017-\u001b8UqR{\u0017\t]5Ue\u0016,GC\u0002BD\u0005\u001b\u0013\u0019\n\u0005\u0003\u0003b\t%\u0015\u0002\u0002BF\u0005G\u0012q\u0002\u0016:b]N\f7\r^5p]R\u0013X-\u001a\u0005\t\u0005[\u0012\t\t1\u0001\u0003\u0010B!!\u0011\u000fBI\u0013\r\u0011Y\t\u0015\u0005\t\u0005s\u0012\t\t1\u0001\u0003|!9!q\u0013\u0001\u0005\n\te\u0015!\u00053p[\u0006Lg\u000eV8Ba&\u001c%/Z1uKR1!1\u0014BT\u0005o\u0003BA!(\u0003$6\u0011!q\u0014\u0006\u0004\u0005Cc\u0012!B3wK:$\u0018\u0002\u0002BS\u0005?\u0013Ab\u0011:fCR,G-\u0012<f]RD\u0001B!+\u0003\u0016\u0002\u0007!1V\u0001\u0007GJ,\u0017\r^3\u0011\t\t5&1\u0017\b\u0005\u0005c\u0012y+C\u0002\u00032B\u000bQ!\u0012<f]RLAA!*\u00036*\u0019!\u0011\u0017)\t\u0011\te$Q\u0013a\u0001\u0005wBqAa/\u0001\t\u0013\u0011i,A\ne_6\f\u0017N\u001c+p\u0003BLW\t_3sG&\u001cX\r\u0006\u0004\u0003@\n\u0015'Q\u001a\t\u0005\u0005;\u0013\t-\u0003\u0003\u0003D\n}%AD#yKJ\u001c\u0017n]3e\u000bZ,g\u000e\u001e\u0005\t\u0005\u000f\u0014I\f1\u0001\u0003J\u0006AQ\r_3sG&\u001cX\r\u0005\u0003\u0003.\n-\u0017\u0002\u0002Bb\u0005kC\u0001B!\u001f\u0003:\u0002\u0007!1\u0010\u0005\b\u0005#\u0004A\u0011\u0002Bj\u0003I!w.\\1j]R{\u0017\t]5Be\u000eD\u0017N^3\u0015\t\tU'1\u001c\t\u0005\u0005;\u00139.\u0003\u0003\u0003Z\n}%!D!sG\"Lg/\u001a3Fm\u0016tG\u000f\u0003\u0005\u0003^\n=\u0007\u0019\u0001Bp\u0003\u001d\t'o\u00195jm\u0016\u0004BA!,\u0003b&!!\u0011\u001cB[\u0001")
public class GrpcTransactionService
implements TransactionServiceAkkaGrpc,
GrpcApiService,
ErrorFactories,
FieldValidations {
    private final TransactionService service;
    private final Object ledgerId;
    private final ExecutionSequencerFactory esf;
    private final Materializer mat;
    private final Logger logger;
    private final TransactionServiceRequestValidator validator;
    private final SharedKillSwitch killSwitch;
    private final AtomicBoolean closed;

    @Override
    public Either<StatusRuntimeException, Object> matchLedgerId(Object ledgerId, Object received) {
        return FieldValidations.matchLedgerId$(this, ledgerId, received);
    }

    @Override
    public Either<StatusRuntimeException, String> requireNonEmptyString(String s2, String fieldName) {
        return FieldValidations.requireNonEmptyString$(this, s2, fieldName);
    }

    @Override
    public Either<StatusRuntimeException, String> requireIdentifier(String s2) {
        return FieldValidations.requireIdentifier$(this, s2);
    }

    @Override
    public Either<StatusRuntimeException, String> requireName(String s2, String fieldName) {
        return FieldValidations.requireName$(this, s2, fieldName);
    }

    @Override
    public Either<StatusRuntimeException, Object> requireNumber(String s2, String fieldName) {
        return FieldValidations.requireNumber$(this, s2, fieldName);
    }

    @Override
    public Either<StatusRuntimeException, String> requirePackageId(String s2, String fieldName) {
        return FieldValidations.requirePackageId$(this, s2, fieldName);
    }

    @Override
    public Either<StatusRuntimeException, String> requirePackageId(String s2) {
        return FieldValidations.requirePackageId$(this, s2);
    }

    @Override
    public Either<StatusRuntimeException, String> requireParty(String s2, String fieldName) {
        return FieldValidations.requireParty$(this, s2, fieldName);
    }

    @Override
    public Either<StatusRuntimeException, String> requireParty(String s2) {
        return FieldValidations.requireParty$(this, s2);
    }

    @Override
    public Either<StatusRuntimeException, String> requireLedgerString(String s2, String fieldName) {
        return FieldValidations.requireLedgerString$(this, s2, fieldName);
    }

    @Override
    public Either<StatusRuntimeException, String> requireLedgerString(String s2) {
        return FieldValidations.requireLedgerString$(this, s2);
    }

    @Override
    public Either<StatusRuntimeException, Ref.DottedName> requireDottedName(String s2, String fieldName) {
        return FieldValidations.requireDottedName$(this, s2, fieldName);
    }

    @Override
    public <M extends Iterable<?>, T> Either<StatusRuntimeException, M> requireNonEmpty(M s2, String fieldName) {
        return FieldValidations.requireNonEmpty$(this, s2, fieldName);
    }

    @Override
    public <T> Either<StatusRuntimeException, T> requirePresence(Option<T> option2, String fieldName) {
        return FieldValidations.requirePresence$(this, option2, fieldName);
    }

    @Override
    public Either<StatusRuntimeException, Ref.Identifier> validateIdentifier(Identifier identifier) {
        return FieldValidations.validateIdentifier$(this, identifier);
    }

    @Override
    public StatusRuntimeException ledgerIdMismatch(Object expected, Object received) {
        return ErrorFactories.ledgerIdMismatch$(this, expected, received);
    }

    @Override
    public StatusRuntimeException missingField(String fieldName) {
        return ErrorFactories.missingField$(this, fieldName);
    }

    @Override
    public StatusRuntimeException invalidArgument(String errorMsg) {
        return ErrorFactories.invalidArgument$(this, errorMsg);
    }

    @Override
    public ApiException invalidField(String fieldName, String message) {
        return ErrorFactories.invalidField$(this, fieldName, message);
    }

    @Override
    public StatusRuntimeException notFound(String target) {
        return ErrorFactories.notFound$(this, target);
    }

    @Override
    public StatusRuntimeException internal(String description) {
        return ErrorFactories.internal$(this, description);
    }

    @Override
    public StatusRuntimeException aborted(String description) {
        return ErrorFactories.aborted$(this, description);
    }

    @Override
    public StatusRuntimeException unimplemented(String description) {
        return ErrorFactories.unimplemented$(this, description);
    }

    @Override
    public StatusRuntimeException permissionDenied(String description) {
        return ErrorFactories.permissionDenied$(this, description);
    }

    @Override
    public StatusRuntimeException resourceExhausted(String description) {
        return ErrorFactories.resourceExhausted$(this, description);
    }

    @Override
    public ApiException grpcError(Status status) {
        return ErrorFactories.grpcError$(this, status);
    }

    @Override
    public StatusRuntimeException closingError() {
        return TransactionServiceAkkaGrpc.closingError$(this);
    }

    @Override
    public void close() {
        TransactionServiceAkkaGrpc.close$(this);
    }

    @Override
    public void getTransactions(com.digitalasset.ledger.api.v1.transaction_service.GetTransactionsRequest request, StreamObserver<GetTransactionsResponse> responseObserver) {
        TransactionServiceAkkaGrpc.getTransactions$(this, request, responseObserver);
    }

    @Override
    public void getTransactionTrees(com.digitalasset.ledger.api.v1.transaction_service.GetTransactionsRequest request, StreamObserver<GetTransactionTreesResponse> responseObserver) {
        TransactionServiceAkkaGrpc.getTransactionTrees$(this, request, responseObserver);
    }

    @Override
    public TransactionServiceGrpc$TransactionService$ serviceCompanion() {
        return TransactionServiceGrpc.TransactionService.serviceCompanion$(this);
    }

    @Override
    public SharedKillSwitch killSwitch() {
        return this.killSwitch;
    }

    @Override
    public AtomicBoolean closed() {
        return this.closed;
    }

    @Override
    public void com$digitalasset$ledger$api$v1$transaction_service$TransactionServiceAkkaGrpc$_setter_$killSwitch_$eq(SharedKillSwitch x$1) {
        this.killSwitch = x$1;
    }

    @Override
    public void com$digitalasset$ledger$api$v1$transaction_service$TransactionServiceAkkaGrpc$_setter_$closed_$eq(AtomicBoolean x$1) {
        this.closed = x$1;
    }

    public TransactionService service() {
        return this.service;
    }

    public Object ledgerId() {
        return this.ledgerId;
    }

    @Override
    public ExecutionSequencerFactory esf() {
        return this.esf;
    }

    @Override
    public Materializer mat() {
        return this.mat;
    }

    public Logger logger() {
        return this.logger;
    }

    private TransactionServiceRequestValidator validator() {
        return this.validator;
    }

    @Override
    public Source<GetTransactionsResponse, NotUsed> getTransactionsSource(com.digitalasset.ledger.api.v1.transaction_service.GetTransactionsRequest request) {
        this.logger().debug("Received new transaction request {}", new Object[]{request});
        return (Source)Source$.MODULE$.future(this.service().getLedgerEnd(request.ledgerId())).flatMapConcat((Function1<domain.LedgerOffset.Absolute, Source> & Serializable & scala.Serializable)ledgerEnd -> {
            Either<StatusRuntimeException, GetTransactionsRequest> validation = this.validator().validate(request, (domain.LedgerOffset.Absolute)ledgerEnd, this.service().offsetOrdering());
            return (Source)validation.fold((Function1<StatusRuntimeException, Source> & Serializable & scala.Serializable)t -> {
                this.logger().debug("Request validation failed for {}. Message: {}", (Object)request, (Object)t.getMessage());
                return Source$.MODULE$.failed((Throwable)t);
            }, (Function1<GetTransactionsRequest, Source> & Serializable & scala.Serializable)req -> req.filter().filtersByParty().isEmpty() ? Source$.MODULE$.empty() : (Source)this.service().getTransactions((GetTransactionsRequest)req).map((Function1<domain.Transaction, GetTransactionsResponse> & Serializable & scala.Serializable)tx -> new GetTransactionsResponse((Seq<Transaction>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Transaction[]{this.domainTxToApiFlat((domain.Transaction)tx, request.verbose())})))));
        });
    }

    @Override
    public Source<GetTransactionTreesResponse, NotUsed> getTransactionTreesSource(com.digitalasset.ledger.api.v1.transaction_service.GetTransactionsRequest request) {
        this.logger().debug("Received new transaction tree request {}", new Object[]{request});
        return (Source)Source$.MODULE$.future(this.service().getLedgerEnd(request.ledgerId())).flatMapConcat((Function1<domain.LedgerOffset.Absolute, Source> & Serializable & scala.Serializable)ledgerEnd -> {
            Either<StatusRuntimeException, GetTransactionTreesRequest> validation = this.validator().validateTree(request, (domain.LedgerOffset.Absolute)ledgerEnd, this.service().offsetOrdering());
            return (Source)validation.fold((Function1<StatusRuntimeException, Source> & Serializable & scala.Serializable)t -> {
                this.logger().debug("Request validation failed for {}. Message: {}", (Object)request, (Object)t.getMessage());
                return Source$.MODULE$.failed((Throwable)t);
            }, (Function1<GetTransactionTreesRequest, Source> & Serializable & scala.Serializable)req -> req.parties().isEmpty() ? Source$.MODULE$.empty() : (Source)this.service().getTransactionTrees((GetTransactionTreesRequest)req).map((Function1<domain.TransactionTree, GetTransactionTreesResponse> & Serializable & scala.Serializable)tx -> new GetTransactionTreesResponse((Seq<TransactionTree>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new TransactionTree[]{this.domainTxToApiTree((domain.TransactionTree)tx, request.verbose())})))));
        });
    }

    private <Request, DomainRequest, DomainTx, Response> Future<Response> getSingleTransaction(Request req, Function1<Request, Either<StatusRuntimeException, DomainRequest>> validate, Function1<DomainRequest, Future<DomainTx>> fetch, Function1<DomainTx, Response> toApi) {
        Either<StatusRuntimeException, DomainRequest> validation = validate.apply(req);
        return (Future)validation.fold((Function1<Throwable, Future> & Serializable & scala.Serializable)exception -> Future$.MODULE$.failed((Throwable)exception), (Function1<Object, Future> & Serializable & scala.Serializable)x$1 -> ((Future)fetch.apply(x$1)).map((Function1<Object, Object> & Serializable & scala.Serializable)x$2 -> toApi.apply(x$2), DirectExecutionContext$.MODULE$));
    }

    @Override
    public Future<GetTransactionResponse> getTransactionByEventId(com.digitalasset.ledger.api.v1.transaction_service.GetTransactionByEventIdRequest request) {
        return this.getSingleTransaction(request, (Function1<com.digitalasset.ledger.api.v1.transaction_service.GetTransactionByEventIdRequest, Either> & Serializable & scala.Serializable)req -> this.validator().validateTransactionByEventId((com.digitalasset.ledger.api.v1.transaction_service.GetTransactionByEventIdRequest)req), (Function1<GetTransactionByEventIdRequest, Future> & Serializable & scala.Serializable)req -> this.service().getTransactionByEventId((GetTransactionByEventIdRequest)req), (Function1<domain.TransactionTree, GetTransactionResponse> & Serializable & scala.Serializable)tree -> new GetTransactionResponse(new Some<TransactionTree>(this.domainTxToApiTree((domain.TransactionTree)tree, true))));
    }

    @Override
    public Future<GetTransactionResponse> getTransactionById(GetTransactionByIdRequest request) {
        return this.getSingleTransaction(request, (Function1<GetTransactionByIdRequest, Either> & Serializable & scala.Serializable)req -> this.validator().validateTransactionById((GetTransactionByIdRequest)req), (Function1<com.digitalasset.ledger.api.messages.transaction.GetTransactionByIdRequest, Future> & Serializable & scala.Serializable)req -> this.service().getTransactionById((com.digitalasset.ledger.api.messages.transaction.GetTransactionByIdRequest)req), (Function1<domain.TransactionTree, GetTransactionResponse> & Serializable & scala.Serializable)tree -> new GetTransactionResponse(new Some<TransactionTree>(this.domainTxToApiTree((domain.TransactionTree)tree, true))));
    }

    @Override
    public Future<GetFlatTransactionResponse> getFlatTransactionByEventId(com.digitalasset.ledger.api.v1.transaction_service.GetTransactionByEventIdRequest request) {
        return this.getSingleTransaction(request, (Function1<com.digitalasset.ledger.api.v1.transaction_service.GetTransactionByEventIdRequest, Either> & Serializable & scala.Serializable)req -> this.validator().validateTransactionByEventId((com.digitalasset.ledger.api.v1.transaction_service.GetTransactionByEventIdRequest)req), (Function1<GetTransactionByEventIdRequest, Future> & Serializable & scala.Serializable)req -> this.service().getFlatTransactionByEventId((GetTransactionByEventIdRequest)req), (Function1<domain.Transaction, GetFlatTransactionResponse> & Serializable & scala.Serializable)flat -> new GetFlatTransactionResponse(new Some<Transaction>(this.domainTxToApiFlat((domain.Transaction)flat, true))));
    }

    @Override
    public Future<GetFlatTransactionResponse> getFlatTransactionById(GetTransactionByIdRequest request) {
        return this.getSingleTransaction(request, (Function1<GetTransactionByIdRequest, Either> & Serializable & scala.Serializable)req -> this.validator().validateTransactionById((GetTransactionByIdRequest)req), (Function1<com.digitalasset.ledger.api.messages.transaction.GetTransactionByIdRequest, Future> & Serializable & scala.Serializable)req -> this.service().getFlatTransactionById((com.digitalasset.ledger.api.messages.transaction.GetTransactionByIdRequest)req), (Function1<domain.Transaction, GetFlatTransactionResponse> & Serializable & scala.Serializable)flat -> new GetFlatTransactionResponse(new Some<Transaction>(this.domainTxToApiFlat((domain.Transaction)flat, true))));
    }

    @Override
    public Future<GetLedgerEndResponse> getLedgerEnd(com.digitalasset.ledger.api.v1.transaction_service.GetLedgerEndRequest request) {
        Either<StatusRuntimeException, GetLedgerEndRequest> validation = this.validator().validateLedgerEnd(request);
        return (Future)validation.fold((Function1<Throwable, Future> & Serializable & scala.Serializable)exception -> Future$.MODULE$.failed((Throwable)exception), (Function1<GetLedgerEndRequest, Future> & Serializable & scala.Serializable)v -> this.service().getLedgerEnd(request.ledgerId()).map((Function1<domain.LedgerOffset.Absolute, GetLedgerEndResponse> & Serializable & scala.Serializable)abs -> new GetLedgerEndResponse(new Some<LedgerOffset>(new LedgerOffset(new LedgerOffset.Value.Absolute(abs.value())))), DirectExecutionContext$.MODULE$));
    }

    @Override
    public ServerServiceDefinition bindService() {
        return TransactionServiceGrpc$.MODULE$.bindService(this, DirectExecutionContext$.MODULE$);
    }

    public Transaction domainTxToApiFlat(domain.Transaction tx, boolean verbose) {
        return new Transaction((String)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(tx.transactionId())), (String)Tag$.MODULE$.unsubst(tx.commandId()).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> ""), (String)Tag$.MODULE$.unsubst(tx.workflowId()).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> ""), new Some<Timestamp>(TimestampConversion$.MODULE$.fromInstant(tx.effectiveAt())), tx.events().map((Function1<domain.Event.CreateOrArchiveEvent, Event> & Serializable & scala.Serializable)x0$1 -> {
            Event event;
            domain.Event.CreateOrArchiveEvent createOrArchiveEvent = x0$1;
            if (createOrArchiveEvent instanceof domain.Event.CreatedEvent) {
                domain.Event.CreatedEvent createdEvent = (domain.Event.CreatedEvent)createOrArchiveEvent;
                event = new Event(new Event.Event.Created(this.domainToApiCreate(createdEvent, verbose)));
            } else if (createOrArchiveEvent instanceof domain.Event.ArchivedEvent) {
                domain.Event.ArchivedEvent archivedEvent = (domain.Event.ArchivedEvent)createOrArchiveEvent;
                event = new Event(new Event.Event.Archived(this.domainToApiArchive(archivedEvent)));
            } else {
                throw new MatchError(createOrArchiveEvent);
            }
            return event;
        }, Seq$.MODULE$.canBuildFrom()), tx.offset().value(), Transaction$.MODULE$.apply$default$7());
    }

    public TransactionTree domainTxToApiTree(domain.TransactionTree tx, boolean verbose) {
        return new TransactionTree((String)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(tx.transactionId())), (String)Tag$.MODULE$.unsubst(tx.commandId()).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> ""), (String)Tag$.MODULE$.unsubst(tx.workflowId()).getOrElse((Function0<String> & Serializable & scala.Serializable)() -> ""), new Some<Timestamp>(TimestampConversion$.MODULE$.fromInstant(tx.effectiveAt())), tx.offset().value(), tx.eventsById().map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                Object eventId = tuple2._1();
                domain.Event.CreateOrExerciseEvent create = (domain.Event.CreateOrExerciseEvent)tuple2._2();
                if (create instanceof domain.Event.CreatedEvent) {
                    domain.Event.CreatedEvent createdEvent = (domain.Event.CreatedEvent)create;
                    return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(eventId))), new TreeEvent(new TreeEvent.Kind.Created(this.domainToApiCreate(createdEvent, verbose))));
                }
            }
            if (tuple2 == null) throw new MatchError(tuple2);
            Object eventId = tuple2._1();
            domain.Event.CreateOrExerciseEvent exercise = (domain.Event.CreateOrExerciseEvent)tuple2._2();
            if (!(exercise instanceof domain.Event.ExercisedEvent)) throw new MatchError(tuple2);
            domain.Event.ExercisedEvent exercisedEvent = (domain.Event.ExercisedEvent)exercise;
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(eventId))), new TreeEvent(new TreeEvent.Kind.Exercised(this.domainToApiExercise(exercisedEvent, verbose))));
        }, Map$.MODULE$.canBuildFrom()), tx.rootEventIds().map((Function1<Object, String> & Serializable & scala.Serializable)x$3 -> (String)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(x$3)), Seq$.MODULE$.canBuildFrom()), TransactionTree$.MODULE$.apply$default$8());
    }

    private CreatedEvent domainToApiCreate(domain.Event.CreatedEvent create, boolean verbose) {
        return new CreatedEvent((String)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(create.eventId())), (String)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(create.contractId())), new Some<Identifier>(LfEngineToApi$.MODULE$.toApiIdentifier(create.templateId())), create.contractKey().map((Function1<Value, com.digitalasset.ledger.api.v1.value.Value> & Serializable & scala.Serializable)ck -> LfEngineToApi$.MODULE$.assertOrRuntimeEx("translating the contract key", LfEngineToApi$.MODULE$.lfValueToApiValue(verbose, (Value<Value.AbsoluteContractId>)ck))), new Some<Record>((Record)LfEngineToApi$.MODULE$.lfValueToApiRecord(verbose, create.createArguments()).fold((Function1<String, Nothing$> & Serializable & scala.Serializable)x$4 -> {
            throw new RuntimeException("Expected value to be a record.");
        }, (Function1<Record, Record> & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x))), create.witnessParties().toSeq(), create.signatories().toSeq(), create.observers().toSeq(), new Some<String>(create.agreementText()));
    }

    private ExercisedEvent domainToApiExercise(domain.Event.ExercisedEvent exercise, boolean verbose) {
        return new ExercisedEvent((String)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(exercise.eventId())), (String)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(exercise.contractId())), new Some<Identifier>(LfEngineToApi$.MODULE$.toApiIdentifier(exercise.templateId())), exercise.choice(), new Some<com.digitalasset.ledger.api.v1.value.Value>((com.digitalasset.ledger.api.v1.value.Value)LfEngineToApi$.MODULE$.lfValueToApiValue(verbose, exercise.choiceArgument()).fold((Function1<String, Nothing$> & Serializable & scala.Serializable)x$5 -> {
            throw new RuntimeException("Error converting choice argument");
        }, (Function1<com.digitalasset.ledger.api.v1.value.Value, com.digitalasset.ledger.api.v1.value.Value> & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x))), exercise.actingParties().toSeq(), exercise.consuming(), exercise.witnessParties().toSeq(), exercise.children().map((Function1<Object, String> & Serializable & scala.Serializable)x$6 -> (String)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(x$6)), List$.MODULE$.canBuildFrom()), exercise.exerciseResult().map((Function1<Value, com.digitalasset.ledger.api.v1.value.Value> & Serializable & scala.Serializable)x$7 -> (com.digitalasset.ledger.api.v1.value.Value)LfEngineToApi$.MODULE$.lfValueToApiValue(verbose, (Value<Value.AbsoluteContractId>)x$7).fold((Function1<String, Nothing$> & Serializable & scala.Serializable)x$8 -> {
            throw new RuntimeException("Error converting exercise result");
        }, (Function1<com.digitalasset.ledger.api.v1.value.Value, com.digitalasset.ledger.api.v1.value.Value> & Serializable & scala.Serializable)x -> Predef$.MODULE$.identity(x))));
    }

    private ArchivedEvent domainToApiArchive(domain.Event.ArchivedEvent archive) {
        return new ArchivedEvent((String)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(archive.eventId())), (String)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(archive.contractId())), new Some<Identifier>(LfEngineToApi$.MODULE$.toApiIdentifier(archive.templateId())), archive.witnessParties().toSeq());
    }

    public GrpcTransactionService(TransactionService service, Object ledgerId, PartyNameChecker partyNameChecker, ExecutionSequencerFactory esf, Materializer mat) {
        this.service = service;
        this.ledgerId = ledgerId;
        this.esf = esf;
        this.mat = mat;
        TransactionServiceGrpc.TransactionService.$init$(this);
        TransactionServiceAkkaGrpc.$init$(this);
        ErrorFactories.$init$(this);
        FieldValidations.$init$(this);
        this.logger = LoggerFactory.getLogger(TransactionServiceGrpc$TransactionService$.MODULE$.getClass());
        this.validator = new TransactionServiceRequestValidator(ledgerId, partyNameChecker);
    }
}

