/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.sslconfig.ssl;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Key;
import java.security.KeyFactory;
import java.security.interfaces.DSAKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAKey;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHKey;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.GenSet;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class Algorithms$ {
    public static Algorithms$ MODULE$;

    static {
        new Algorithms$();
    }

    public String disabledSignatureAlgorithms() {
        return "MD2, MD4, MD5";
    }

    public String disabledKeyAlgorithms() {
        return "RSA keySize < 2048, DSA keySize < 2048, EC keySize < 224";
    }

    public Option<Object> keySize(Key key) {
        Option option2;
        block8: {
            Option option3;
            Key key2;
            while (true) {
                Key translatedKey;
                if ((key2 = key) instanceof SecretKey) {
                    SecretKey secretKey = (SecretKey)key2;
                    String string2 = secretKey.getFormat();
                    String string3 = "RAW";
                    option2 = !(string2 != null ? !string2.equals(string3) : string3 != null) && secretKey.getEncoded() != null ? new Some<Integer>(BoxesRunTime.boxToInteger(secretKey.getEncoded().length * 8)) : None$.MODULE$;
                    break block8;
                }
                if (key2 instanceof RSAKey) {
                    Key key3 = key2;
                    option2 = new Some<Integer>(BoxesRunTime.boxToInteger(((RSAKey)((Object)key3)).getModulus().bitLength()));
                    break block8;
                }
                if (key2 instanceof ECKey) {
                    Key key4 = key2;
                    option2 = new Some<Integer>(BoxesRunTime.boxToInteger(((ECKey)((Object)key4)).getParams().getOrder().bitLength()));
                    break block8;
                }
                if (key2 instanceof DSAKey) {
                    Key key5 = key2;
                    option2 = new Some<Integer>(BoxesRunTime.boxToInteger(((DSAKey)((Object)key5)).getParams().getP().bitLength()));
                    break block8;
                }
                if (key2 instanceof DHKey) {
                    Key key6 = key2;
                    option2 = new Some<Integer>(BoxesRunTime.boxToInteger(((DHKey)((Object)key6)).getParams().getP().bitLength()));
                    break block8;
                }
                if (key2 == null) break;
                Key key7 = key2;
                key = translatedKey = this.translateKey(key7);
            }
            try {
                Method lengthMethod = key2.getClass().getMethod("length", new Class[0]);
                Integer l = (Integer)lengthMethod.invoke((Object)key2, new Object[0]);
                option3 = Predef$.MODULE$.Integer2int(l) >= 0 ? new Some<Integer>(BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(l))) : None$.MODULE$;
            }
            catch (Throwable throwable2) {
                throw new IllegalStateException(new StringBuilder(12).append("unknown key ").append(key.getClass().getName()).toString());
            }
            option2 = option3;
        }
        return option2;
    }

    /*
     * WARNING - void declaration
     */
    public String getKeyAlgorithmName(Key pubk) {
        void var2_2;
        String name;
        String string2 = name = pubk.getAlgorithm();
        String string3 = "DH";
        return !(string2 != null ? !string2.equals(string3) : string3 != null) ? "DiffieHellman" : var2_2;
    }

    public Key translateKey(Key pubk) {
        String keyAlgName = this.getKeyAlgorithmName(pubk);
        KeyFactory keyFactory = KeyFactory.getInstance(keyAlgName);
        return keyFactory.translateKey(pubk);
    }

    public Key translateECKey(Key pubk) {
        Key key;
        Class<?> keyFactory = Thread.currentThread().getContextClassLoader().loadClass("sun.security.ec.ECKeyFactory");
        Method method = keyFactory.getMethod("toECKey", Key.class);
        Object object = method.invoke(null, pubk);
        if (object instanceof ECPublicKey) {
            ECPublicKey eCPublicKey;
            key = eCPublicKey = (ECPublicKey)object;
        } else if (object instanceof ECPrivateKey) {
            ECPrivateKey eCPrivateKey = (ECPrivateKey)object;
            key = eCPrivateKey;
        } else {
            throw new MatchError(object);
        }
        return key;
    }

    public Set<String> decomposes(String algorithm) {
        if (algorithm == null || algorithm.length() == 0) {
            throw new IllegalArgumentException("Null or blank algorithm found!");
        }
        Regex withAndPattern = new Regex("(?i)with|and", Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        String[] tokens = new StringOps(Predef$.MODULE$.augmentString("/")).r().split(algorithm);
        GenSet elements = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])tokens)).flatMap((Function1<String, Object> & Serializable & scala.Serializable)t -> new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])withAndPattern.split(t))).map((Function1<String, String> & Serializable & scala.Serializable)name -> name, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSet();
        return elements.contains("SHA1") && !elements.contains("SHA-1") ? (Set)elements.$plus("SHA-1") : (elements.contains("SHA-1") && !elements.contains("SHA1") ? (Set)elements.$plus("SHA1") : elements);
    }

    private Algorithms$() {
        MODULE$ = this;
    }
}

