/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.tags;

import io.opencensus.tags.Tag;
import java.util.HashMap;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class TagContext {
    protected abstract Iterator<Tag> getIterator();

    public String toString() {
        return "TagContext";
    }

    public boolean equals(@Nullable Object other) {
        Tag tag2;
        if (!(other instanceof TagContext)) {
            return false;
        }
        TagContext otherTags = (TagContext)other;
        Iterator<Tag> iter1 = this.getIterator();
        Iterator<Tag> iter2 = otherTags.getIterator();
        HashMap<Tag, Integer> tags = new HashMap<Tag, Integer>();
        while (iter1 != null && iter1.hasNext()) {
            tag2 = iter1.next();
            if (tags.containsKey(tag2)) {
                tags.put(tag2, (Integer)tags.get(tag2) + 1);
                continue;
            }
            tags.put(tag2, 1);
        }
        while (iter2 != null && iter2.hasNext()) {
            tag2 = iter2.next();
            if (!tags.containsKey(tag2)) {
                return false;
            }
            int count = (Integer)tags.get(tag2);
            if (count > 1) {
                tags.put(tag2, count - 1);
                continue;
            }
            tags.remove(tag2);
        }
        return tags.isEmpty();
    }

    public final int hashCode() {
        int hashCode = 0;
        Iterator<Tag> i = this.getIterator();
        if (i == null) {
            return hashCode;
        }
        while (i.hasNext()) {
            Tag tag2 = i.next();
            if (tag2 == null) continue;
            hashCode += tag2.hashCode();
        }
        return hashCode;
    }
}

