/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.util.NoSuchElementException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.RedBlackTree;
import scala.collection.immutable.RedBlackTree$BlackTree$;
import scala.collection.immutable.RedBlackTree$NList$;
import scala.collection.immutable.RedBlackTree$RedTree$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class RedBlackTree$ {
    public static RedBlackTree$ MODULE$;

    static {
        new RedBlackTree$();
    }

    public boolean isEmpty(RedBlackTree.Tree<?, ?> tree) {
        return tree == null;
    }

    public <A> boolean contains(RedBlackTree.Tree<A, ?> tree, A x, Ordering<A> evidence$1) {
        return this.lookup(tree, x, evidence$1) != null;
    }

    public <A, B> Option<B> get(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> evidence$2) {
        RedBlackTree.Tree<A, B> tree2 = this.lookup(tree, x, evidence$2);
        Option option2 = tree2 == null ? None$.MODULE$ : new Some<B>(tree2.value());
        return option2;
    }

    public <A, B> RedBlackTree.Tree<A, B> lookup(RedBlackTree.Tree<A, B> tree, A x, Ordering<A> ordering2) {
        while (true) {
            if (tree == null) {
                return null;
            }
            int cmp = ordering2.compare(x, tree.key());
            if (cmp < 0) {
                tree = tree.left();
                continue;
            }
            if (cmp <= 0) break;
            tree = tree.right();
        }
        return tree;
    }

    public int count(RedBlackTree.Tree<?, ?> tree) {
        if (tree == null) {
            return 0;
        }
        return tree.count();
    }

    public <A> int countInRange(RedBlackTree.Tree<A, ?> tree, Option<A> from, Option<A> to, Ordering<A> ordering2) {
        int n;
        block5: {
            while (true) {
                Option<A> option2;
                if (tree == null) {
                    return 0;
                }
                Option<A> option3 = from;
                Option<A> option4 = to;
                if (None$.MODULE$.equals(option3) && None$.MODULE$.equals(option4)) {
                    n = tree.count();
                    break block5;
                }
                Option<A> option5 = from;
                if (option5 instanceof Some) {
                    Object lb = ((Some)option5).value();
                    if (ordering2.lt(tree.key(), lb)) {
                        tree = tree.right();
                        continue;
                    }
                }
                if (!((option2 = to) instanceof Some)) break;
                Object ub = ((Some)option2).value();
                if (!ordering2.gteq(tree.key(), ub)) break;
                tree = tree.left();
            }
            n = 1 + this.countInRange(tree.left(), from, None$.MODULE$, ordering2) + this.countInRange(tree.right(), None$.MODULE$, to, ordering2);
        }
        return n;
    }

    public <A, B, B1> RedBlackTree.Tree<A, B1> update(RedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> evidence$3) {
        return this.blacken(this.upd(tree, k, v, overwrite, evidence$3));
    }

    public <A, B> RedBlackTree.Tree<A, B> delete(RedBlackTree.Tree<A, B> tree, A k, Ordering<A> evidence$4) {
        return this.blacken(this.del(tree, k, evidence$4));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <A, B> RedBlackTree.Tree<A, B> rangeImpl(RedBlackTree.Tree<A, B> tree, Option<A> from, Option<A> until, Ordering<A> evidence$5) {
        Tuple2<Option<A>, Option<A>> tuple2 = new Tuple2<Option<A>, Option<A>>(from, until);
        Option<A> option2 = from;
        Option<A> option3 = until;
        if (option2 instanceof Some) {
            Object from2 = ((Some)option2).value();
            if (option3 instanceof Some) {
                Object until2 = ((Some)option3).value();
                return this.range(tree, from2, until2, evidence$5);
            }
        }
        Option<A> option4 = from;
        Option<A> option5 = until;
        if (option4 instanceof Some) {
            Object from3 = ((Some)option4).value();
            if (None$.MODULE$.equals(option5)) {
                return this.from(tree, from3, evidence$5);
            }
        }
        Option<A> option6 = from;
        Option<A> option7 = until;
        if (None$.MODULE$.equals(option6) && option7 instanceof Some) {
            Object until3 = ((Some)option7).value();
            return this.until(tree, until3, evidence$5);
        }
        Option<A> option8 = from;
        Option<A> option9 = until;
        if (!None$.MODULE$.equals(option8)) throw new MatchError(tuple2);
        if (!None$.MODULE$.equals(option9)) throw new MatchError(tuple2);
        return tree;
    }

    public <A, B> RedBlackTree.Tree<A, B> range(RedBlackTree.Tree<A, B> tree, A from, A until, Ordering<A> evidence$6) {
        return this.blacken(this.doRange(tree, from, until, evidence$6));
    }

    public <A, B> RedBlackTree.Tree<A, B> from(RedBlackTree.Tree<A, B> tree, A from, Ordering<A> evidence$7) {
        return this.blacken(this.doFrom(tree, from, evidence$7));
    }

    public <A, B> RedBlackTree.Tree<A, B> to(RedBlackTree.Tree<A, B> tree, A to, Ordering<A> evidence$8) {
        return this.blacken(this.doTo(tree, to, evidence$8));
    }

    public <A, B> RedBlackTree.Tree<A, B> until(RedBlackTree.Tree<A, B> tree, A key, Ordering<A> evidence$9) {
        return this.blacken(this.doUntil(tree, key, evidence$9));
    }

    public <A, B> RedBlackTree.Tree<A, B> drop(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$10) {
        return this.blacken(this.doDrop(tree, n));
    }

    public <A, B> RedBlackTree.Tree<A, B> take(RedBlackTree.Tree<A, B> tree, int n, Ordering<A> evidence$11) {
        return this.blacken(this.doTake(tree, n));
    }

    public <A, B> RedBlackTree.Tree<A, B> slice(RedBlackTree.Tree<A, B> tree, int from, int until, Ordering<A> evidence$12) {
        return this.blacken(this.doSlice(tree, from, until));
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> smallest(RedBlackTree.Tree<A, B> tree) {
        void var2_2;
        if (tree == null) {
            throw new NoSuchElementException("empty map");
        }
        RedBlackTree.Tree<A, B> result2 = tree;
        while (result2.left() != null) {
            result2 = result2.left();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public <A, B> RedBlackTree.Tree<A, B> greatest(RedBlackTree.Tree<A, B> tree) {
        void var2_2;
        if (tree == null) {
            throw new NoSuchElementException("empty map");
        }
        RedBlackTree.Tree<A, B> result2 = tree;
        while (result2.right() != null) {
            result2 = result2.right();
        }
        return var2_2;
    }

    public <A, B, U> void foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        if (tree != null) {
            this._foreach(tree, f);
        }
    }

    private <A, B, U> void _foreach(RedBlackTree.Tree<A, B> tree, Function1<Tuple2<A, B>, U> f) {
        while (true) {
            if (tree.left() != null) {
                this._foreach(tree.left(), f);
            }
            f.apply(new Tuple2<A, B>(tree.key(), tree.value()));
            if (tree.right() == null) break;
            tree = tree.right();
        }
    }

    public <A, U> void foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        if (tree != null) {
            this._foreachKey(tree, f);
        }
    }

    private <A, U> void _foreachKey(RedBlackTree.Tree<A, ?> tree, Function1<A, U> f) {
        while (true) {
            if (tree.left() != null) {
                this._foreachKey(tree.left(), f);
            }
            f.apply(tree.key());
            if (tree.right() == null) break;
            tree = tree.right();
        }
    }

    public <A, B> Iterator<Tuple2<A, B>> iterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$13) {
        return new RedBlackTree.EntriesIterator<A, B>(tree, start, evidence$13);
    }

    public <A, B> None$ iterator$default$2() {
        return None$.MODULE$;
    }

    public <A> Iterator<A> keysIterator(RedBlackTree.Tree<A, ?> tree, Option<A> start, Ordering<A> evidence$14) {
        return new RedBlackTree.KeysIterator(tree, start, evidence$14);
    }

    public <A> None$ keysIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> Iterator<B> valuesIterator(RedBlackTree.Tree<A, B> tree, Option<A> start, Ordering<A> evidence$15) {
        return new RedBlackTree.ValuesIterator<A, B>(tree, start, evidence$15);
    }

    public <A, B> None$ valuesIterator$default$2() {
        return None$.MODULE$;
    }

    public <A, B> RedBlackTree.Tree<A, B> nth(RedBlackTree.Tree<A, B> tree, int n) {
        while (true) {
            int count;
            if (n < (count = this.count(tree.left()))) {
                tree = tree.left();
                continue;
            }
            if (n <= count) break;
            n = n - count - 1;
            tree = tree.right();
        }
        return tree;
    }

    public boolean isBlack(RedBlackTree.Tree<?, ?> tree) {
        return tree == null || this.isBlackTree(tree);
    }

    private boolean isRedTree(RedBlackTree.Tree<?, ?> tree) {
        return tree instanceof RedBlackTree.RedTree;
    }

    private boolean isBlackTree(RedBlackTree.Tree<?, ?> tree) {
        return tree instanceof RedBlackTree.BlackTree;
    }

    private <A, B> RedBlackTree.Tree<A, B> blacken(RedBlackTree.Tree<A, B> t) {
        if (t == null) {
            return null;
        }
        return t.black();
    }

    private <A, B> RedBlackTree.Tree<A, B> mkTree(boolean isBlack, A k, B v, RedBlackTree.Tree<A, B> l, RedBlackTree.Tree<A, B> r) {
        if (isBlack) {
            if (RedBlackTree$BlackTree$.MODULE$ == null) {
                throw null;
            }
            return new RedBlackTree.BlackTree<A, B>(k, v, l, r);
        }
        if (RedBlackTree$RedTree$.MODULE$ == null) {
            throw null;
        }
        return new RedBlackTree.RedTree<A, B>(k, v, l, r);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B, B1> RedBlackTree.Tree<A, B1> balanceLeft(boolean isBlack, A z, B zv, RedBlackTree.Tree<A, B1> l, RedBlackTree.Tree<A, B1> d) {
        if (this.isRedTree(l) && this.isRedTree(l.left())) {
            void apply_value;
            void apply_key;
            void apply_left;
            void apply_right;
            void apply_left2;
            void apply_value2;
            void apply_key2;
            RedBlackTree.Tree<A, B1> tree = l.left().right();
            RedBlackTree.Tree<A, B1> tree2 = l.left().left();
            B1 B1 = l.left().value();
            A a = l.left().key();
            if (RedBlackTree$BlackTree$.MODULE$ == null) {
                throw null;
            }
            RedBlackTree.BlackTree<void, void> blackTree = new RedBlackTree.BlackTree<void, void>(apply_key2, apply_value2, (RedBlackTree.Tree<void, void>)apply_left2, (RedBlackTree.Tree<void, void>)apply_right);
            RedBlackTree.Tree<A, B1> tree3 = l.right();
            if (RedBlackTree$BlackTree$.MODULE$ == null) {
                throw null;
            }
            RedBlackTree.BlackTree<A, B> blackTree2 = new RedBlackTree.BlackTree<A, B>(z, zv, apply_left, d);
            B1 B12 = l.value();
            A a2 = l.key();
            if (RedBlackTree$RedTree$.MODULE$ == null) {
                throw null;
            }
            return new RedBlackTree.RedTree<void, void>(apply_key, apply_value, blackTree, blackTree2);
        }
        if (this.isRedTree(l) && this.isRedTree(l.right())) {
            void apply_value;
            void apply_key;
            void apply_left;
            void apply_right;
            void apply_left3;
            void apply_value3;
            void apply_key3;
            RedBlackTree.Tree<A, B1> tree = l.right().left();
            RedBlackTree.Tree<A, B1> tree4 = l.left();
            B1 B1 = l.value();
            A a = l.key();
            if (RedBlackTree$BlackTree$.MODULE$ == null) {
                throw null;
            }
            RedBlackTree.BlackTree<void, void> blackTree = new RedBlackTree.BlackTree<void, void>(apply_key3, apply_value3, (RedBlackTree.Tree<void, void>)apply_left3, (RedBlackTree.Tree<void, void>)apply_right);
            RedBlackTree.Tree<A, B1> tree5 = l.right().right();
            if (RedBlackTree$BlackTree$.MODULE$ == null) {
                throw null;
            }
            RedBlackTree.BlackTree<A, B> blackTree3 = new RedBlackTree.BlackTree<A, B>(z, zv, apply_left, d);
            B1 B13 = l.right().value();
            A a3 = l.right().key();
            if (RedBlackTree$RedTree$.MODULE$ == null) {
                throw null;
            }
            return new RedBlackTree.RedTree<void, void>(apply_key, apply_value, blackTree, blackTree3);
        }
        return this.mkTree(isBlack, z, zv, l, d);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B, B1> RedBlackTree.Tree<A, B1> balanceRight(boolean isBlack, A x, B xv, RedBlackTree.Tree<A, B1> a, RedBlackTree.Tree<A, B1> r) {
        if (this.isRedTree(r) && this.isRedTree(r.left())) {
            void apply_value;
            void apply_key;
            void apply_right;
            void apply_left;
            void apply_value2;
            void apply_key2;
            void apply_right2;
            RedBlackTree.Tree<A, B1> tree = r.left().left();
            if (RedBlackTree$BlackTree$.MODULE$ == null) {
                throw null;
            }
            RedBlackTree.BlackTree<A, B> blackTree = new RedBlackTree.BlackTree<A, B>(x, xv, a, apply_right2);
            RedBlackTree.Tree<A, B1> tree2 = r.right();
            RedBlackTree.Tree<A, B1> tree3 = r.left().right();
            B1 B1 = r.value();
            A a2 = r.key();
            if (RedBlackTree$BlackTree$.MODULE$ == null) {
                throw null;
            }
            RedBlackTree.BlackTree<void, void> blackTree2 = new RedBlackTree.BlackTree<void, void>(apply_key2, apply_value2, (RedBlackTree.Tree<void, void>)apply_left, (RedBlackTree.Tree<void, void>)apply_right);
            B1 B12 = r.left().value();
            A a3 = r.left().key();
            if (RedBlackTree$RedTree$.MODULE$ == null) {
                throw null;
            }
            return new RedBlackTree.RedTree<void, void>(apply_key, apply_value, blackTree, blackTree2);
        }
        if (this.isRedTree(r) && this.isRedTree(r.right())) {
            void apply_value;
            void apply_key;
            void apply_right;
            void apply_left;
            void apply_value3;
            void apply_key3;
            void apply_right3;
            RedBlackTree.Tree<A, B1> tree = r.left();
            if (RedBlackTree$BlackTree$.MODULE$ == null) {
                throw null;
            }
            RedBlackTree.BlackTree<A, B> blackTree = new RedBlackTree.BlackTree<A, B>(x, xv, a, apply_right3);
            RedBlackTree.Tree<A, B1> tree4 = r.right().right();
            RedBlackTree.Tree<A, B1> tree5 = r.right().left();
            B1 B1 = r.right().value();
            A a4 = r.right().key();
            if (RedBlackTree$BlackTree$.MODULE$ == null) {
                throw null;
            }
            RedBlackTree.BlackTree<void, void> blackTree3 = new RedBlackTree.BlackTree<void, void>(apply_key3, apply_value3, (RedBlackTree.Tree<void, void>)apply_left, (RedBlackTree.Tree<void, void>)apply_right);
            B1 B13 = r.value();
            A a5 = r.key();
            if (RedBlackTree$RedTree$.MODULE$ == null) {
                throw null;
            }
            return new RedBlackTree.RedTree<void, void>(apply_key, apply_value, blackTree, blackTree3);
        }
        return this.mkTree(isBlack, x, xv, a, r);
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> upd(RedBlackTree.Tree<A, B> tree, A k, B1 v, boolean overwrite, Ordering<A> ordering2) {
        if (tree == null) {
            if (RedBlackTree$RedTree$.MODULE$ == null) {
                throw null;
            }
            return new RedBlackTree.RedTree<A, B1>(k, v, null, null);
        }
        int cmp = ordering2.compare(k, tree.key());
        if (cmp < 0) {
            return this.balanceLeft(this.isBlackTree(tree), tree.key(), tree.value(), this.upd(tree.left(), k, v, overwrite, ordering2), tree.right());
        }
        if (cmp > 0) {
            return this.balanceRight(this.isBlackTree(tree), tree.key(), tree.value(), tree.left(), this.upd(tree.right(), k, v, overwrite, ordering2));
        }
        if (overwrite || !BoxesRunTime.equals(k, tree.key())) {
            return this.mkTree(this.isBlackTree(tree), k, v, tree.left(), tree.right());
        }
        return tree;
    }

    private <A, B, B1> RedBlackTree.Tree<A, B1> updNth(RedBlackTree.Tree<A, B> tree, int idx, A k, B1 v, boolean overwrite) {
        if (tree == null) {
            if (RedBlackTree$RedTree$.MODULE$ == null) {
                throw null;
            }
            return new RedBlackTree.RedTree<A, B1>(k, v, null, null);
        }
        int rank = this.count(tree.left()) + 1;
        if (idx < rank) {
            return this.balanceLeft(this.isBlackTree(tree), tree.key(), tree.value(), this.updNth(tree.left(), idx, k, v, overwrite), tree.right());
        }
        if (idx > rank) {
            return this.balanceRight(this.isBlackTree(tree), tree.key(), tree.value(), tree.left(), this.updNth(tree.right(), idx - rank, k, v, overwrite));
        }
        if (overwrite) {
            return this.mkTree(this.isBlackTree(tree), k, v, tree.left(), tree.right());
        }
        return tree;
    }

    private <A, B> RedBlackTree.Tree<A, B> del(RedBlackTree.Tree<A, B> tree, A k, Ordering<A> ordering2) {
        if (tree == null) {
            return null;
        }
        int cmp = ordering2.compare(k, tree.key());
        if (cmp < 0) {
            return this.delLeft$1(tree, k, ordering2);
        }
        if (cmp > 0) {
            return this.delRight$1(tree, k, ordering2);
        }
        return this.append$1(tree.left(), tree.right());
    }

    private <A, B> RedBlackTree.Tree<A, B> doFrom(RedBlackTree.Tree<A, B> tree, A from, Ordering<A> ordering2) {
        if (tree == null) {
            return null;
        }
        if (ordering2.lt(tree.key(), from)) {
            return this.doFrom(tree.right(), from, ordering2);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doFrom(tree.left(), from, ordering2);
        if (newLeft == tree.left()) {
            return tree;
        }
        if (newLeft == null) {
            return this.upd(tree.right(), tree.key(), tree.value(), false, ordering2);
        }
        return this.rebalance(tree, newLeft, tree.right());
    }

    private <A, B> RedBlackTree.Tree<A, B> doTo(RedBlackTree.Tree<A, B> tree, A to, Ordering<A> ordering2) {
        if (tree == null) {
            return null;
        }
        if (ordering2.lt(to, tree.key())) {
            return this.doTo(tree.left(), to, ordering2);
        }
        RedBlackTree.Tree<A, B> newRight = this.doTo(tree.right(), to, ordering2);
        if (newRight == tree.right()) {
            return tree;
        }
        if (newRight == null) {
            return this.upd(tree.left(), tree.key(), tree.value(), false, ordering2);
        }
        return this.rebalance(tree, tree.left(), newRight);
    }

    private <A, B> RedBlackTree.Tree<A, B> doUntil(RedBlackTree.Tree<A, B> tree, A until, Ordering<A> ordering2) {
        if (tree == null) {
            return null;
        }
        if (ordering2.lteq(until, tree.key())) {
            return this.doUntil(tree.left(), until, ordering2);
        }
        RedBlackTree.Tree<A, B> newRight = this.doUntil(tree.right(), until, ordering2);
        if (newRight == tree.right()) {
            return tree;
        }
        if (newRight == null) {
            return this.upd(tree.left(), tree.key(), tree.value(), false, ordering2);
        }
        return this.rebalance(tree, tree.left(), newRight);
    }

    private <A, B> RedBlackTree.Tree<A, B> doRange(RedBlackTree.Tree<A, B> tree, A from, A until, Ordering<A> ordering2) {
        if (tree == null) {
            return null;
        }
        if (ordering2.lt(tree.key(), from)) {
            return this.doRange(tree.right(), from, until, ordering2);
        }
        if (ordering2.lteq(until, tree.key())) {
            return this.doRange(tree.left(), from, until, ordering2);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doFrom(tree.left(), from, ordering2);
        RedBlackTree.Tree<A, B> newRight = this.doUntil(tree.right(), until, ordering2);
        if (newLeft == tree.left() && newRight == tree.right()) {
            return tree;
        }
        if (newLeft == null) {
            return this.upd(newRight, tree.key(), tree.value(), false, ordering2);
        }
        if (newRight == null) {
            return this.upd(newLeft, tree.key(), tree.value(), false, ordering2);
        }
        return this.rebalance(tree, newLeft, newRight);
    }

    private <A, B> RedBlackTree.Tree<A, B> doDrop(RedBlackTree.Tree<A, B> tree, int n) {
        if (n <= 0) {
            return tree;
        }
        if (n >= this.count(tree)) {
            return null;
        }
        int count = this.count(tree.left());
        if (n > count) {
            return this.doDrop(tree.right(), n - count - 1);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doDrop(tree.left(), n);
        if (newLeft == tree.left()) {
            return tree;
        }
        if (newLeft == null) {
            return this.updNth(tree.right(), n - count - 1, tree.key(), tree.value(), false);
        }
        return this.rebalance(tree, newLeft, tree.right());
    }

    private <A, B> RedBlackTree.Tree<A, B> doTake(RedBlackTree.Tree<A, B> tree, int n) {
        if (n <= 0) {
            return null;
        }
        if (n >= this.count(tree)) {
            return tree;
        }
        int count = this.count(tree.left());
        if (n <= count) {
            return this.doTake(tree.left(), n);
        }
        RedBlackTree.Tree<A, B> newRight = this.doTake(tree.right(), n - count - 1);
        if (newRight == tree.right()) {
            return tree;
        }
        if (newRight == null) {
            return this.updNth(tree.left(), n, tree.key(), tree.value(), false);
        }
        return this.rebalance(tree, tree.left(), newRight);
    }

    private <A, B> RedBlackTree.Tree<A, B> doSlice(RedBlackTree.Tree<A, B> tree, int from, int until) {
        if (tree == null) {
            return null;
        }
        int count = this.count(tree.left());
        if (from > count) {
            return this.doSlice(tree.right(), from - count - 1, until - count - 1);
        }
        if (until <= count) {
            return this.doSlice(tree.left(), from, until);
        }
        RedBlackTree.Tree<A, B> newLeft = this.doDrop(tree.left(), from);
        RedBlackTree.Tree<A, B> newRight = this.doTake(tree.right(), until - count - 1);
        if (newLeft == tree.left() && newRight == tree.right()) {
            return tree;
        }
        if (newLeft == null) {
            return this.updNth(newRight, from - count - 1, tree.key(), tree.value(), false);
        }
        if (newRight == null) {
            return this.updNth(newLeft, until, tree.key(), tree.value(), false);
        }
        return this.rebalance(tree, newLeft, newRight);
    }

    private <A, B> Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Object, Object, Object> compareDepth(RedBlackTree.Tree<A, B> left, RedBlackTree.Tree<A, B> right) {
        return this.unzipBoth$1(left, right, null, null, 0);
    }

    /*
     * WARNING - void declaration
     */
    private <A, B> RedBlackTree.Tree<A, B> rebalance(RedBlackTree.Tree<A, B> tree, RedBlackTree.Tree<A, B> newLeft, RedBlackTree.Tree<A, B> newRight) {
        void var22_22;
        RedBlackTree.RedTree<void, void> redTree;
        void var9_9;
        void var10_10;
        void var7_7;
        void var8_8;
        RedBlackTree.Tree<A, B> blkNewRight;
        RedBlackTree.Tree<A, B> blkNewLeft = this.blacken(newLeft);
        Tuple4<RedBlackTree.NList<RedBlackTree.Tree<A, B>>, Object, Object, Object> tuple4 = this.compareDepth(blkNewLeft, blkNewRight = this.blacken(newRight));
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        RedBlackTree.NList<RedBlackTree.Tree<A, B>> zipper2 = tuple4._1();
        boolean levelled = BoxesRunTime.unboxToBoolean(tuple4._2());
        boolean leftMost = BoxesRunTime.unboxToBoolean(tuple4._3());
        int smallerDepth = BoxesRunTime.unboxToInt(tuple4._4());
        if (var8_8 != false) {
            void apply_value;
            void apply_key;
            B b = tree.value();
            A a = tree.key();
            if (RedBlackTree$BlackTree$.MODULE$ == null) {
                throw null;
            }
            return new RedBlackTree.BlackTree<void, void>(apply_key, apply_value, blkNewLeft, blkNewRight);
        }
        RedBlackTree.NList zipFrom = this.findDepth$1((RedBlackTree.NList)var7_7, (int)var10_10);
        if (var9_9 != false) {
            void apply_right;
            void apply_value;
            void apply_key;
            RedBlackTree.Tree tree2 = (RedBlackTree.Tree)zipFrom.head();
            B b = tree.value();
            A a = tree.key();
            if (RedBlackTree$RedTree$.MODULE$ == null) {
                throw null;
            }
            redTree = new RedBlackTree.RedTree<void, void>(apply_key, apply_value, (RedBlackTree.Tree<void, void>)blkNewLeft, (RedBlackTree.Tree<void, void>)apply_right);
        } else {
            void apply_left;
            void apply_value;
            void apply_key;
            RedBlackTree.Tree tree3 = (RedBlackTree.Tree)zipFrom.head();
            B b = tree.value();
            A a = tree.key();
            if (RedBlackTree$RedTree$.MODULE$ == null) {
                throw null;
            }
            redTree = new RedBlackTree.RedTree<void, void>(apply_key, apply_value, (RedBlackTree.Tree<void, void>)apply_left, (RedBlackTree.Tree<void, void>)blkNewRight);
        }
        RedBlackTree.RedTree<void, void> union2 = redTree;
        RedBlackTree.NList nList = zipFrom.tail();
        if (RedBlackTree$NList$.MODULE$ == null) {
            throw null;
        }
        RedBlackTree.Tree foldLeft_acc = union2;
        for (RedBlackTree.NList foldLeft_these = foldLeft_xs; foldLeft_these != null; foldLeft_these = foldLeft_these.tail()) {
            RedBlackTree.Tree tree4 = (RedBlackTree.Tree)foldLeft_these.head();
            RedBlackTree.Tree tree5 = foldLeft_acc;
            foldLeft_acc = RedBlackTree$.$anonfun$rebalance$1((boolean)var9_9, tree5, tree4);
        }
        return (RedBlackTree.Tree)var22_22;
    }

    /*
     * WARNING - void declaration
     */
    private final RedBlackTree.Tree balance$1(Object x, Object xv, RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        if (this.isRedTree(tl)) {
            if (this.isRedTree(tr)) {
                void apply_right;
                void apply_left;
                RedBlackTree.Tree tree = tr.black();
                RedBlackTree.Tree tree2 = tl.black();
                if (RedBlackTree$RedTree$.MODULE$ == null) {
                    throw null;
                }
                return new RedBlackTree.RedTree<Object, Object>(x, xv, (RedBlackTree.Tree<Object, Object>)apply_left, (RedBlackTree.Tree<Object, Object>)apply_right);
            }
            if (this.isRedTree(tl.left())) {
                void apply_left;
                void apply_value;
                void apply_key;
                void apply_left2;
                RedBlackTree.Tree tree = tl.right();
                if (RedBlackTree$BlackTree$.MODULE$ == null) {
                    throw null;
                }
                RedBlackTree.BlackTree<Object, Object> blackTree = new RedBlackTree.BlackTree<Object, Object>(x, xv, (RedBlackTree.Tree<Object, Object>)apply_left2, tr);
                RedBlackTree.Tree tree3 = tl.left().black();
                Object b = tl.value();
                Object a = tl.key();
                if (RedBlackTree$RedTree$.MODULE$ == null) {
                    throw null;
                }
                return new RedBlackTree.RedTree<Object, Object>(apply_key, apply_value, (RedBlackTree.Tree<Object, Object>)apply_left, (RedBlackTree.Tree<Object, Object>)blackTree);
            }
            if (this.isRedTree(tl.right())) {
                void apply_value;
                void apply_key;
                void apply_left;
                void apply_right;
                void apply_left3;
                void apply_value2;
                void apply_key2;
                RedBlackTree.Tree tree = tl.right().left();
                RedBlackTree.Tree tree4 = tl.left();
                Object b = tl.value();
                Object a = tl.key();
                if (RedBlackTree$BlackTree$.MODULE$ == null) {
                    throw null;
                }
                RedBlackTree.BlackTree<void, void> blackTree = new RedBlackTree.BlackTree<void, void>(apply_key2, apply_value2, (RedBlackTree.Tree<void, void>)apply_left3, (RedBlackTree.Tree<void, void>)apply_right);
                RedBlackTree.Tree tree5 = tl.right().right();
                if (RedBlackTree$BlackTree$.MODULE$ == null) {
                    throw null;
                }
                RedBlackTree.BlackTree<Object, Object> blackTree2 = new RedBlackTree.BlackTree<Object, Object>(x, xv, (RedBlackTree.Tree<Object, Object>)apply_left, tr);
                Object b2 = tl.right().value();
                Object a2 = tl.right().key();
                if (RedBlackTree$RedTree$.MODULE$ == null) {
                    throw null;
                }
                return new RedBlackTree.RedTree<Object, Object>(apply_key, apply_value, blackTree, blackTree2);
            }
            if (RedBlackTree$BlackTree$.MODULE$ == null) {
                throw null;
            }
            return new RedBlackTree.BlackTree<Object, Object>(x, xv, tl, tr);
        }
        if (this.isRedTree(tr)) {
            if (this.isRedTree(tr.right())) {
                void apply_right;
                void apply_value;
                void apply_key;
                void apply_right2;
                RedBlackTree.Tree tree = tr.left();
                if (RedBlackTree$BlackTree$.MODULE$ == null) {
                    throw null;
                }
                RedBlackTree.BlackTree<Object, Object> blackTree = new RedBlackTree.BlackTree<Object, Object>(x, xv, tl, (RedBlackTree.Tree<Object, Object>)apply_right2);
                RedBlackTree.Tree tree6 = tr.right().black();
                Object b = tr.value();
                Object a = tr.key();
                if (RedBlackTree$RedTree$.MODULE$ == null) {
                    throw null;
                }
                return new RedBlackTree.RedTree<Object, Object>(apply_key, apply_value, (RedBlackTree.Tree<Object, Object>)blackTree, (RedBlackTree.Tree<Object, Object>)apply_right);
            }
            if (this.isRedTree(tr.left())) {
                void apply_value;
                void apply_key;
                void apply_right;
                void apply_left;
                void apply_value3;
                void apply_key3;
                void apply_right3;
                RedBlackTree.Tree tree = tr.left().left();
                if (RedBlackTree$BlackTree$.MODULE$ == null) {
                    throw null;
                }
                RedBlackTree.BlackTree<Object, Object> blackTree = new RedBlackTree.BlackTree<Object, Object>(x, xv, tl, (RedBlackTree.Tree<Object, Object>)apply_right3);
                RedBlackTree.Tree tree7 = tr.right();
                RedBlackTree.Tree tree8 = tr.left().right();
                Object b = tr.value();
                Object a = tr.key();
                if (RedBlackTree$BlackTree$.MODULE$ == null) {
                    throw null;
                }
                RedBlackTree.BlackTree<void, void> blackTree3 = new RedBlackTree.BlackTree<void, void>(apply_key3, apply_value3, (RedBlackTree.Tree<void, void>)apply_left, (RedBlackTree.Tree<void, void>)apply_right);
                Object b3 = tr.left().value();
                Object a3 = tr.left().key();
                if (RedBlackTree$RedTree$.MODULE$ == null) {
                    throw null;
                }
                return new RedBlackTree.RedTree<void, void>(apply_key, apply_value, blackTree, blackTree3);
            }
            if (RedBlackTree$BlackTree$.MODULE$ == null) {
                throw null;
            }
            return new RedBlackTree.BlackTree<Object, Object>(x, xv, tl, tr);
        }
        if (RedBlackTree$BlackTree$.MODULE$ == null) {
            throw null;
        }
        return new RedBlackTree.BlackTree<Object, Object>(x, xv, tl, tr);
    }

    private static final RedBlackTree.Tree subl$1(RedBlackTree.Tree t) {
        if (t instanceof RedBlackTree.BlackTree) {
            return t.red();
        }
        throw package$.MODULE$.error(new StringBuilder(50).append("Defect: invariance violation; expected black, got ").append(t).toString());
    }

    /*
     * WARNING - void declaration
     */
    private final RedBlackTree.Tree balLeft$1(Object x, Object xv, RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        if (this.isRedTree(tl)) {
            void apply_left;
            RedBlackTree.Tree tree = tl.black();
            if (RedBlackTree$RedTree$.MODULE$ == null) {
                throw null;
            }
            return new RedBlackTree.RedTree<Object, Object>(x, xv, (RedBlackTree.Tree<Object, Object>)apply_left, tr);
        }
        if (this.isBlackTree(tr)) {
            return this.balance$1(x, xv, tl, tr.red());
        }
        if (this.isRedTree(tr) && this.isBlackTree(tr.left())) {
            void apply_right;
            void apply_value;
            void apply_key;
            void apply_right2;
            RedBlackTree.Tree tree = tr.left().left();
            if (RedBlackTree$BlackTree$.MODULE$ == null) {
                throw null;
            }
            RedBlackTree.BlackTree<Object, Object> blackTree = new RedBlackTree.BlackTree<Object, Object>(x, xv, tl, (RedBlackTree.Tree<Object, Object>)apply_right2);
            RedBlackTree.Tree tree2 = this.balance$1(tr.key(), tr.value(), tr.left().right(), RedBlackTree$.subl$1(tr.right()));
            Object b = tr.left().value();
            Object a = tr.left().key();
            if (RedBlackTree$RedTree$.MODULE$ == null) {
                throw null;
            }
            return new RedBlackTree.RedTree<Object, Object>(apply_key, apply_value, (RedBlackTree.Tree<Object, Object>)blackTree, (RedBlackTree.Tree<Object, Object>)apply_right);
        }
        throw package$.MODULE$.error("Defect: invariance violation");
    }

    /*
     * WARNING - void declaration
     */
    private final RedBlackTree.Tree balRight$1(Object x, Object xv, RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        if (this.isRedTree(tr)) {
            void apply_right;
            RedBlackTree.Tree tree = tr.black();
            if (RedBlackTree$RedTree$.MODULE$ == null) {
                throw null;
            }
            return new RedBlackTree.RedTree<Object, Object>(x, xv, tl, (RedBlackTree.Tree<Object, Object>)apply_right);
        }
        if (this.isBlackTree(tl)) {
            return this.balance$1(x, xv, tl.red(), tr);
        }
        if (this.isRedTree(tl) && this.isBlackTree(tl.right())) {
            void apply_left;
            void apply_value;
            void apply_key;
            void apply_left2;
            RedBlackTree.Tree tree = tl.right().right();
            if (RedBlackTree$BlackTree$.MODULE$ == null) {
                throw null;
            }
            RedBlackTree.BlackTree<Object, Object> blackTree = new RedBlackTree.BlackTree<Object, Object>(x, xv, (RedBlackTree.Tree<Object, Object>)apply_left2, tr);
            RedBlackTree.Tree tree2 = this.balance$1(tl.key(), tl.value(), RedBlackTree$.subl$1(tl.left()), tl.right().left());
            Object b = tl.right().value();
            Object a = tl.right().key();
            if (RedBlackTree$RedTree$.MODULE$ == null) {
                throw null;
            }
            return new RedBlackTree.RedTree<Object, Object>(apply_key, apply_value, (RedBlackTree.Tree<Object, Object>)apply_left, (RedBlackTree.Tree<Object, Object>)blackTree);
        }
        throw package$.MODULE$.error("Defect: invariance violation");
    }

    /*
     * WARNING - void declaration
     */
    private final RedBlackTree.Tree delLeft$1(RedBlackTree.Tree tree$1, Object k$1, Ordering ordering$1) {
        void apply_right;
        void apply_left;
        void apply_value;
        void apply_key;
        if (this.isBlackTree(tree$1.left())) {
            return this.balLeft$1(tree$1.key(), tree$1.value(), this.del(tree$1.left(), k$1, ordering$1), tree$1.right());
        }
        RedBlackTree.Tree tree = tree$1.right();
        RedBlackTree.Tree tree2 = this.del(tree$1.left(), k$1, ordering$1);
        Object b = tree$1.value();
        Object a = tree$1.key();
        if (RedBlackTree$RedTree$.MODULE$ == null) {
            throw null;
        }
        return new RedBlackTree.RedTree<void, void>(apply_key, apply_value, (RedBlackTree.Tree<void, void>)apply_left, (RedBlackTree.Tree<void, void>)apply_right);
    }

    /*
     * WARNING - void declaration
     */
    private final RedBlackTree.Tree delRight$1(RedBlackTree.Tree tree$1, Object k$1, Ordering ordering$1) {
        void apply_right;
        void apply_left;
        void apply_value;
        void apply_key;
        if (this.isBlackTree(tree$1.right())) {
            return this.balRight$1(tree$1.key(), tree$1.value(), tree$1.left(), this.del(tree$1.right(), k$1, ordering$1));
        }
        RedBlackTree.Tree tree = this.del(tree$1.right(), k$1, ordering$1);
        RedBlackTree.Tree tree2 = tree$1.left();
        Object b = tree$1.value();
        Object a = tree$1.key();
        if (RedBlackTree$RedTree$.MODULE$ == null) {
            throw null;
        }
        return new RedBlackTree.RedTree<void, void>(apply_key, apply_value, (RedBlackTree.Tree<void, void>)apply_left, (RedBlackTree.Tree<void, void>)apply_right);
    }

    /*
     * WARNING - void declaration
     */
    private final RedBlackTree.Tree append$1(RedBlackTree.Tree tl, RedBlackTree.Tree tr) {
        if (tl == null) {
            return tr;
        }
        if (tr == null) {
            return tl;
        }
        if (this.isRedTree(tl) && this.isRedTree(tr)) {
            void apply_left;
            void apply_value;
            void apply_key;
            void apply_right;
            void apply_value2;
            void apply_key2;
            RedBlackTree.Tree bc = this.append$1(tl.right(), tr.left());
            if (this.isRedTree(bc)) {
                void apply_value3;
                void apply_key3;
                void apply_right2;
                void apply_left2;
                void apply_value4;
                void apply_key4;
                void apply_right3;
                void apply_left3;
                void apply_value5;
                void apply_key5;
                RedBlackTree.Tree tree = bc.left();
                RedBlackTree.Tree tree2 = tl.left();
                Object b = tl.value();
                Object a = tl.key();
                if (RedBlackTree$RedTree$.MODULE$ == null) {
                    throw null;
                }
                RedBlackTree.RedTree<void, void> redTree = new RedBlackTree.RedTree<void, void>(apply_key5, apply_value5, (RedBlackTree.Tree<void, void>)apply_left3, (RedBlackTree.Tree<void, void>)apply_right3);
                RedBlackTree.Tree tree3 = tr.right();
                RedBlackTree.Tree tree4 = bc.right();
                Object b2 = tr.value();
                Object a2 = tr.key();
                if (RedBlackTree$RedTree$.MODULE$ == null) {
                    throw null;
                }
                RedBlackTree.RedTree<void, void> redTree2 = new RedBlackTree.RedTree<void, void>(apply_key4, apply_value4, (RedBlackTree.Tree<void, void>)apply_left2, (RedBlackTree.Tree<void, void>)apply_right2);
                Object b3 = bc.value();
                Object a3 = bc.key();
                if (RedBlackTree$RedTree$.MODULE$ == null) {
                    throw null;
                }
                return new RedBlackTree.RedTree<void, void>(apply_key3, apply_value3, redTree, redTree2);
            }
            RedBlackTree.Tree tree = tr.right();
            Object b = tr.value();
            Object a = tr.key();
            if (RedBlackTree$RedTree$.MODULE$ == null) {
                throw null;
            }
            RedBlackTree.RedTree<void, void> redTree = new RedBlackTree.RedTree<void, void>(apply_key2, apply_value2, bc, (RedBlackTree.Tree<void, void>)apply_right);
            RedBlackTree.Tree tree5 = tl.left();
            Object b4 = tl.value();
            Object a4 = tl.key();
            if (RedBlackTree$RedTree$.MODULE$ == null) {
                throw null;
            }
            return new RedBlackTree.RedTree<void, void>(apply_key, apply_value, (RedBlackTree.Tree<void, void>)apply_left, (RedBlackTree.Tree<void, void>)redTree);
        }
        if (this.isBlackTree(tl) && this.isBlackTree(tr)) {
            void apply_right;
            void apply_value;
            void apply_key;
            RedBlackTree.Tree bc = this.append$1(tl.right(), tr.left());
            if (this.isRedTree(bc)) {
                void apply_value6;
                void apply_key6;
                void apply_right4;
                void apply_left;
                void apply_value7;
                void apply_key7;
                void apply_right5;
                void apply_left4;
                void apply_value8;
                void apply_key8;
                RedBlackTree.Tree tree = bc.left();
                RedBlackTree.Tree tree6 = tl.left();
                Object b = tl.value();
                Object a = tl.key();
                if (RedBlackTree$BlackTree$.MODULE$ == null) {
                    throw null;
                }
                RedBlackTree.BlackTree<void, void> blackTree = new RedBlackTree.BlackTree<void, void>(apply_key8, apply_value8, (RedBlackTree.Tree<void, void>)apply_left4, (RedBlackTree.Tree<void, void>)apply_right5);
                RedBlackTree.Tree tree7 = tr.right();
                RedBlackTree.Tree tree8 = bc.right();
                Object b5 = tr.value();
                Object a5 = tr.key();
                if (RedBlackTree$BlackTree$.MODULE$ == null) {
                    throw null;
                }
                RedBlackTree.BlackTree<void, void> blackTree2 = new RedBlackTree.BlackTree<void, void>(apply_key7, apply_value7, (RedBlackTree.Tree<void, void>)apply_left, (RedBlackTree.Tree<void, void>)apply_right4);
                Object b6 = bc.value();
                Object a6 = bc.key();
                if (RedBlackTree$RedTree$.MODULE$ == null) {
                    throw null;
                }
                return new RedBlackTree.RedTree<void, void>(apply_key6, apply_value6, blackTree, blackTree2);
            }
            RedBlackTree.Tree tree = tr.right();
            Object b = tr.value();
            Object a = tr.key();
            if (RedBlackTree$BlackTree$.MODULE$ == null) {
                throw null;
            }
            return this.balLeft$1(tl.key(), tl.value(), tl.left(), new RedBlackTree.BlackTree<void, void>(apply_key, apply_value, bc, (RedBlackTree.Tree<void, void>)apply_right));
        }
        if (this.isRedTree(tr)) {
            void apply_right;
            void apply_left;
            void apply_value;
            void apply_key;
            RedBlackTree.Tree tree = tr.right();
            RedBlackTree.Tree tree9 = this.append$1(tl, tr.left());
            Object b = tr.value();
            Object a = tr.key();
            if (RedBlackTree$RedTree$.MODULE$ == null) {
                throw null;
            }
            return new RedBlackTree.RedTree<void, void>(apply_key, apply_value, (RedBlackTree.Tree<void, void>)apply_left, (RedBlackTree.Tree<void, void>)apply_right);
        }
        if (this.isRedTree(tl)) {
            void apply_right;
            void apply_left;
            void apply_value;
            void apply_key;
            RedBlackTree.Tree tree = this.append$1(tl.right(), tr);
            RedBlackTree.Tree tree10 = tl.left();
            Object b = tl.value();
            Object a = tl.key();
            if (RedBlackTree$RedTree$.MODULE$ == null) {
                throw null;
            }
            return new RedBlackTree.RedTree<void, void>(apply_key, apply_value, (RedBlackTree.Tree<void, void>)apply_left, (RedBlackTree.Tree<void, void>)apply_right);
        }
        throw package$.MODULE$.error(new StringBuilder(28).append("unmatched tree on append: ").append(tl).append(", ").append(tr).toString());
    }

    private final RedBlackTree.NList unzip$1(RedBlackTree.NList zipper2, boolean leftMost) {
        while (true) {
            RedBlackTree.Tree next;
            RedBlackTree.Tree tree = next = leftMost ? ((RedBlackTree.Tree)zipper2.head()).left() : ((RedBlackTree.Tree)zipper2.head()).right();
            if (next == null) {
                return zipper2;
            }
            zipper2 = RedBlackTree$NList$.MODULE$.cons(next, zipper2);
        }
    }

    private final Tuple4 unzipBoth$1(RedBlackTree.Tree left, RedBlackTree.Tree right, RedBlackTree.NList leftZipper, RedBlackTree.NList rightZipper, int smallerDepth) {
        while (true) {
            if (this.isBlackTree(left) && this.isBlackTree(right)) {
                ++smallerDepth;
                rightZipper = RedBlackTree$NList$.MODULE$.cons(right, rightZipper);
                leftZipper = RedBlackTree$NList$.MODULE$.cons(left, leftZipper);
                right = right.left();
                left = left.right();
                continue;
            }
            if (this.isRedTree(left) && this.isRedTree(right)) {
                rightZipper = RedBlackTree$NList$.MODULE$.cons(right, rightZipper);
                leftZipper = RedBlackTree$NList$.MODULE$.cons(left, leftZipper);
                right = right.left();
                left = left.right();
                continue;
            }
            if (this.isRedTree(right)) {
                rightZipper = RedBlackTree$NList$.MODULE$.cons(right, rightZipper);
                right = right.left();
                continue;
            }
            if (!this.isRedTree(left)) break;
            leftZipper = RedBlackTree$NList$.MODULE$.cons(left, leftZipper);
            left = left.right();
        }
        if (left == null && right == null) {
            return new Tuple4<Object, Boolean, Boolean, Integer>(null, BoxesRunTime.boxToBoolean(true), BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToInteger(smallerDepth));
        }
        if (left == null && this.isBlackTree(right)) {
            boolean leftMost = true;
            return new Tuple4<RedBlackTree.NList, Boolean, Boolean, Integer>(this.unzip$1(RedBlackTree$NList$.MODULE$.cons(right, rightZipper), leftMost), BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToBoolean(leftMost), BoxesRunTime.boxToInteger(smallerDepth));
        }
        if (this.isBlackTree(left) && right == null) {
            boolean leftMost = false;
            return new Tuple4<RedBlackTree.NList, Boolean, Boolean, Integer>(this.unzip$1(RedBlackTree$NList$.MODULE$.cons(left, leftZipper), leftMost), BoxesRunTime.boxToBoolean(false), BoxesRunTime.boxToBoolean(leftMost), BoxesRunTime.boxToInteger(smallerDepth));
        }
        throw package$.MODULE$.error(new StringBuilder(28).append("unmatched trees in unzip: ").append(left).append(", ").append(right).toString());
    }

    private final RedBlackTree.NList findDepth$1(RedBlackTree.NList zipper2, int depth) {
        while (true) {
            if (zipper2 == null) {
                throw package$.MODULE$.error("Defect: unexpected empty zipper while computing range");
            }
            if (this.isBlackTree((RedBlackTree.Tree)zipper2.head())) {
                if (depth == 1) {
                    return zipper2;
                }
                --depth;
                zipper2 = zipper2.tail();
                continue;
            }
            zipper2 = zipper2.tail();
        }
    }

    public static final /* synthetic */ RedBlackTree.Tree $anonfun$rebalance$1(boolean leftMost$1, RedBlackTree.Tree tree, RedBlackTree.Tree node) {
        if (leftMost$1) {
            return MODULE$.balanceLeft(MODULE$.isBlackTree(node), node.key(), node.value(), tree, node.right());
        }
        return MODULE$.balanceRight(MODULE$.isBlackTree(node), node.key(), node.value(), node.left(), tree);
    }

    private RedBlackTree$() {
        MODULE$ = this;
    }
}

