/*
 * Decompiled with CFR 0.152.
 */
package scalapb.textformat;

import com.google.protobuf.descriptor.FieldDescriptorProto;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_BOOL$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_BYTES$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_DOUBLE$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_ENUM$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_FIXED32$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_FIXED64$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_FLOAT$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_GROUP$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_INT32$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_INT64$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_SFIXED32$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_SFIXED64$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_SINT32$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_SINT64$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_STRING$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_UINT32$;
import com.google.protobuf.descriptor.FieldDescriptorProto$Type$TYPE_UINT64$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.BigInt;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Try$;
import scalapb.GeneratedMessage;
import scalapb.GeneratedMessageCompanion;
import scalapb.Message;
import scalapb.TextFormatError;
import scalapb.descriptors.EnumDescriptor;
import scalapb.descriptors.EnumValueDescriptor;
import scalapb.descriptors.FieldDescriptor;
import scalapb.descriptors.PBoolean;
import scalapb.descriptors.PByteString$;
import scalapb.descriptors.PDouble;
import scalapb.descriptors.PEnum$;
import scalapb.descriptors.PFloat;
import scalapb.descriptors.PInt;
import scalapb.descriptors.PLong;
import scalapb.descriptors.PMessage;
import scalapb.descriptors.PRepeated;
import scalapb.descriptors.PRepeated$;
import scalapb.descriptors.PString$;
import scalapb.descriptors.PValue;
import scalapb.textformat.AstUtils;
import scalapb.textformat.TArray;
import scalapb.textformat.TBytes;
import scalapb.textformat.TField;
import scalapb.textformat.TIntLiteral;
import scalapb.textformat.TLiteral;
import scalapb.textformat.TMessage;
import scalapb.textformat.TPrimitive;
import scalapb.textformat.TValue;
import scalapb.textformat.TextFormatUtils$;

public final class AstUtils$ {
    public static AstUtils$ MODULE$;

    static {
        new AstUtils$();
    }

    private <T> Either<AstUtils.AstError, Vector<T>> flatten(Seq<Either<AstUtils.AstError, T>> s) {
        Either either2;
        Some some;
        Either either3;
        Option option2 = s.find((Function1<Either, Object> & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.isLeft()));
        if (option2 instanceof Some && (either3 = (Either)(some = (Some)option2).value()) instanceof Left) {
            Left left = (Left)either3;
            AstUtils.AstError e = (AstUtils.AstError)left.value();
            either2 = package$.MODULE$.Left().apply(e);
        } else {
            either2 = package$.MODULE$.Right().apply(((TraversableOnce)s.view().map((Function1<Either, Object> & java.io.Serializable & Serializable)x$2 -> x$2.right().get(), SeqView$.MODULE$.canBuildFrom())).toVector());
        }
        return either2;
    }

    public <T extends GeneratedMessage & Message<T>> Either<AstUtils.AstError, T> parseMessage(GeneratedMessageCompanion<T> v, TMessage ast) {
        return this.parseUnsafe(v, ast).right().map(v.messageReads().read());
    }

    public Either<AstUtils.AstError, BigInt> checkBigInt(TPrimitive p, boolean isSigned, boolean isLong) {
        Either either2;
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TIntLiteral) {
            int maxBits;
            boolean negative;
            TIntLiteral tIntLiteral = (TIntLiteral)tPrimitive;
            int index = tIntLiteral.index();
            BigInt v = tIntLiteral.value();
            boolean bl = negative = v.signum() == -1;
            int n = isLong ? (isSigned ? 63 : 64) : (maxBits = isSigned ? 31 : 32);
            either2 = !isSigned && negative ? package$.MODULE$.Left().apply(new AstUtils.AstError(index, new StringBuilder(25).append("Number must be positive: ").append(v).toString())) : (v.bitLength() > maxBits ? package$.MODULE$.Left().apply(new AstUtils.AstError(index, new StringBuilder(39).append("Number out of range for ").append(isLong ? BoxesRunTime.boxToInteger(64) : BoxesRunTime.boxToInteger(32)).append("-bit ").append((Object)(isSigned ? "signed" : "unsigned")).append(" integer: ").append(v).toString())) : package$.MODULE$.Right().apply(v));
        } else {
            either2 = package$.MODULE$.Left().apply(new AstUtils.AstError(tPrimitive.index(), new StringBuilder(16).append("Invalid input '").append(tPrimitive.asString()).append("'").toString()));
        }
        return either2;
    }

    public boolean checkBigInt$default$2() {
        return true;
    }

    public Either<AstUtils.AstError, PInt> parseInt32(TPrimitive p) {
        return this.checkBigInt(p, true, false).right().map((Function1<BigInt, Object> & java.io.Serializable & Serializable)t -> new PInt(t.intValue()));
    }

    public Either<AstUtils.AstError, PInt> parseUint32(TPrimitive p) {
        return this.checkBigInt(p, false, false).right().map((Function1<BigInt, Object> & java.io.Serializable & Serializable)t -> new PInt(t.intValue()));
    }

    public Either<AstUtils.AstError, PLong> parseInt64(TPrimitive p) {
        return this.checkBigInt(p, true, true).right().map((Function1<BigInt, Object> & java.io.Serializable & Serializable)t -> new PLong(t.longValue()));
    }

    public Either<AstUtils.AstError, PLong> parseUint64(TPrimitive p) {
        return this.checkBigInt(p, false, true).right().map((Function1<BigInt, Object> & java.io.Serializable & Serializable)t -> new PLong(t.longValue()));
    }

    private Either<AstUtils.AstError, Map<FieldDescriptor, PValue>> parseUnsafe(GeneratedMessageCompanion<?> v, TMessage ast) {
        Either either2;
        Map fieldMap = ((TraversableOnce)v.scalaDescriptor().fields().map((Function1<FieldDescriptor, Tuple2> & java.io.Serializable & Serializable)f -> new Tuple2<String, FieldDescriptor>(f.name(), (FieldDescriptor)f), Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map fields = ast.fields().groupBy((Function1<TField, String> & java.io.Serializable & Serializable)x$7 -> x$7.name());
        Option option2 = ast.fields().find((Function1<TField, Object> & java.io.Serializable & Serializable)f -> BoxesRunTime.boxToBoolean(AstUtils$.$anonfun$parseUnsafe$20(fieldMap, f)));
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            TField f2 = (TField)some.value();
            either2 = package$.MODULE$.Left().apply(new AstUtils.AstError(f2.index(), new StringBuilder(21).append("Unknown field name '").append(f2.name()).append("'").toString()));
        } else if (None$.MODULE$.equals(option2)) {
            either2 = this.flatten(((TraversableOnce)fields.map(((Function2<String, Seq, Either> & java.io.Serializable & Serializable)(Function2<String, Seq, Either> & java.io.Serializable & Serializable)(name, group) -> this.fieldGroupToValue$1((String)name, (Seq)group, fieldMap, v)).tupled(), Iterable$.MODULE$.canBuildFrom())).toVector());
        } else {
            throw new MatchError(option2);
        }
        Either maybeMap = either2;
        return maybeMap.right().map((Function1<Vector, Object> & java.io.Serializable & Serializable)t -> new PMessage(t.toMap(Predef$.MODULE$.$conforms())));
    }

    public static final /* synthetic */ double $anonfun$parseUnsafe$1(String value$1) {
        return new StringOps(Predef$.MODULE$.augmentString(value$1)).toDouble();
    }

    private static final Either parseDouble$1(TPrimitive p) {
        Either either2;
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TLiteral) {
            Either either3;
            TLiteral tLiteral = (TLiteral)tPrimitive;
            String value = tLiteral.value();
            String low = value.toLowerCase();
            String string2 = low;
            boolean bl = "inf".equals(string2) ? true : "infinity".equals(string2);
            if (bl) {
                either3 = package$.MODULE$.Right().apply(new PDouble(Double.POSITIVE_INFINITY));
            } else {
                boolean bl2 = "-inf".equals(string2) ? true : "-infinity".equals(string2);
                either3 = bl2 ? package$.MODULE$.Right().apply(new PDouble(Double.NEGATIVE_INFINITY)) : ("nan".equals(string2) ? package$.MODULE$.Right().apply(new PDouble(Double.NaN)) : Try$.MODULE$.apply((Function0<Object> & java.io.Serializable & Serializable)() -> new PDouble(AstUtils$.$anonfun$parseUnsafe$1(value))).toOption().toRight((Function0<AstUtils.AstError> & java.io.Serializable & Serializable)() -> new AstUtils.AstError(p.index(), new StringBuilder(28).append("Invalid value for double: '").append(value).append("'").toString())));
            }
            either2 = either3;
        } else if (tPrimitive instanceof TIntLiteral) {
            TIntLiteral tIntLiteral = (TIntLiteral)tPrimitive;
            BigInt value = tIntLiteral.value();
            either2 = package$.MODULE$.Right().apply(new PDouble(value.toDouble()));
        } else {
            either2 = package$.MODULE$.Left().apply(new AstUtils.AstError(tPrimitive.index(), new StringBuilder(32).append("Invalid input '").append(tPrimitive.asString()).append("', expected float").toString()));
        }
        return either2;
    }

    public static final /* synthetic */ float $anonfun$parseUnsafe$3(String value$2) {
        return new StringOps(Predef$.MODULE$.augmentString(value$2)).toFloat();
    }

    private static final Either parseFloat$1(TPrimitive p) {
        Either either2;
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TLiteral) {
            Either either3;
            TLiteral tLiteral = (TLiteral)tPrimitive;
            String value = tLiteral.value();
            String low = value.toLowerCase();
            String string2 = low;
            boolean bl = "inf".equals(string2) ? true : ("inff".equals(string2) ? true : ("infinity".equals(string2) ? true : "infinityf".equals(string2)));
            if (bl) {
                either3 = package$.MODULE$.Right().apply(new PFloat(Float.POSITIVE_INFINITY));
            } else {
                boolean bl2 = "-inf".equals(string2) ? true : ("-inff".equals(string2) ? true : ("-infinity".equals(string2) ? true : "-infinityf".equals(string2)));
                if (bl2) {
                    either3 = package$.MODULE$.Right().apply(new PFloat(Float.NEGATIVE_INFINITY));
                } else {
                    boolean bl3 = "nan".equals(string2) ? true : "nanf".equals(string2);
                    either3 = bl3 ? package$.MODULE$.Right().apply(new PFloat(Float.NaN)) : Try$.MODULE$.apply((Function0<Object> & java.io.Serializable & Serializable)() -> new PFloat(AstUtils$.$anonfun$parseUnsafe$3(value))).toOption().toRight((Function0<AstUtils.AstError> & java.io.Serializable & Serializable)() -> new AstUtils.AstError(p.index(), new StringBuilder(27).append("Invalid value for float: '").append(value).append("'").toString()));
                }
            }
            either2 = either3;
        } else if (tPrimitive instanceof TIntLiteral) {
            TIntLiteral tIntLiteral = (TIntLiteral)tPrimitive;
            BigInt value = tIntLiteral.value();
            either2 = package$.MODULE$.Right().apply(new PFloat(value.toFloat()));
        } else {
            either2 = package$.MODULE$.Left().apply(new AstUtils.AstError(tPrimitive.index(), new StringBuilder(32).append("Invalid input '").append(tPrimitive.asString()).append("', expected float").toString()));
        }
        return either2;
    }

    private static final String invalidInput$1(String v) {
        return new StringBuilder(44).append("Invalid input '").append(v).append("', expected 'true' or 'false'").toString();
    }

    private static final Either parseBoolean$1(TPrimitive p) {
        Either either2;
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TIntLiteral) {
            TIntLiteral tIntLiteral = (TIntLiteral)tPrimitive;
            int index = tIntLiteral.index();
            BigInt v = tIntLiteral.value();
            either2 = BoxesRunTime.equalsNumObject(v, BoxesRunTime.boxToInteger(0)) ? package$.MODULE$.Right().apply(new PBoolean(false)) : (BoxesRunTime.equalsNumObject(v, BoxesRunTime.boxToInteger(1)) ? package$.MODULE$.Right().apply(new PBoolean(true)) : package$.MODULE$.Left().apply(new AstUtils.AstError(index, AstUtils$.invalidInput$1(v.toString()))));
        } else if (tPrimitive instanceof TLiteral) {
            Either either3;
            TLiteral tLiteral = (TLiteral)tPrimitive;
            int index = tLiteral.index();
            String v = tLiteral.value();
            String string2 = v.toLowerCase();
            boolean bl = "t".equals(string2) ? true : "true".equals(string2);
            if (bl) {
                either3 = package$.MODULE$.Right().apply(new PBoolean(true));
            } else {
                boolean bl2 = "f".equals(string2) ? true : "false".equals(string2);
                either3 = bl2 ? package$.MODULE$.Right().apply(new PBoolean(false)) : package$.MODULE$.Left().apply(new AstUtils.AstError(index, AstUtils$.invalidInput$1(v.toString())));
            }
            either2 = either3;
        } else if (tPrimitive instanceof TBytes) {
            TBytes tBytes = (TBytes)tPrimitive;
            String v = tBytes.value();
            either2 = package$.MODULE$.Left().apply(new AstUtils.AstError(p.index(), AstUtils$.invalidInput$1(v)));
        } else {
            throw new MatchError(tPrimitive);
        }
        return either2;
    }

    private static final Either parseString$1(TPrimitive p) {
        Either either2;
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TBytes) {
            TBytes tBytes = (TBytes)tPrimitive;
            String value = tBytes.value();
            either2 = TextFormatUtils$.MODULE$.unescapeText(value).right().map(PString$.MODULE$).left().map((Function1<TextFormatError, AstUtils.AstError> & java.io.Serializable & Serializable)error -> new AstUtils.AstError(p.index(), error.msg()));
        } else {
            either2 = package$.MODULE$.Left().apply(new AstUtils.AstError(tPrimitive.index(), new StringBuilder(33).append("Invalid input '").append(tPrimitive.asString()).append("', expected string").toString()));
        }
        return either2;
    }

    private static final Either parseBytes$1(TPrimitive p) {
        Either either2;
        TPrimitive tPrimitive = p;
        if (tPrimitive instanceof TBytes) {
            TBytes tBytes = (TBytes)tPrimitive;
            String value = tBytes.value();
            either2 = TextFormatUtils$.MODULE$.unescapeBytes(value).right().map(PByteString$.MODULE$).left().map((Function1<TextFormatError, AstUtils.AstError> & java.io.Serializable & Serializable)error -> new AstUtils.AstError(p.index(), error.msg()));
        } else {
            either2 = package$.MODULE$.Left().apply(new AstUtils.AstError(p.index(), "Unexpected input"));
        }
        return either2;
    }

    public static final /* synthetic */ boolean $anonfun$parseUnsafe$7(BigInt num$1, EnumValueDescriptor x$3) {
        return x$3.number() == num$1.toInt();
    }

    public static final /* synthetic */ boolean $anonfun$parseUnsafe$9(String name$1, EnumValueDescriptor x$4) {
        String string2 = x$4.name();
        String string3 = name$1;
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    private final Either parsePrimitive$1(FieldDescriptor field2, TPrimitive p, GeneratedMessageCompanion v$1) {
        Either<AstUtils.AstError, Object> either2;
        FieldDescriptorProto.Type type = field2.protoType();
        if (FieldDescriptorProto$Type$TYPE_DOUBLE$.MODULE$.equals(type)) {
            either2 = AstUtils$.parseDouble$1(p);
        } else if (FieldDescriptorProto$Type$TYPE_FLOAT$.MODULE$.equals(type)) {
            either2 = AstUtils$.parseFloat$1(p);
        } else if (FieldDescriptorProto$Type$TYPE_INT64$.MODULE$.equals(type)) {
            either2 = this.parseInt64(p);
        } else if (FieldDescriptorProto$Type$TYPE_UINT64$.MODULE$.equals(type)) {
            either2 = this.parseUint64(p);
        } else if (FieldDescriptorProto$Type$TYPE_INT32$.MODULE$.equals(type)) {
            either2 = this.parseInt32(p);
        } else if (FieldDescriptorProto$Type$TYPE_FIXED64$.MODULE$.equals(type)) {
            either2 = this.parseUint64(p);
        } else if (FieldDescriptorProto$Type$TYPE_FIXED32$.MODULE$.equals(type)) {
            either2 = this.parseUint32(p);
        } else if (FieldDescriptorProto$Type$TYPE_BOOL$.MODULE$.equals(type)) {
            either2 = AstUtils$.parseBoolean$1(p);
        } else if (FieldDescriptorProto$Type$TYPE_STRING$.MODULE$.equals(type)) {
            either2 = AstUtils$.parseString$1(p);
        } else if (FieldDescriptorProto$Type$TYPE_BYTES$.MODULE$.equals(type)) {
            either2 = AstUtils$.parseBytes$1(p);
        } else if (FieldDescriptorProto$Type$TYPE_UINT32$.MODULE$.equals(type)) {
            either2 = this.parseUint32(p);
        } else if (FieldDescriptorProto$Type$TYPE_SFIXED32$.MODULE$.equals(type)) {
            either2 = this.parseInt32(p);
        } else if (FieldDescriptorProto$Type$TYPE_SFIXED64$.MODULE$.equals(type)) {
            either2 = this.parseInt64(p);
        } else if (FieldDescriptorProto$Type$TYPE_SINT32$.MODULE$.equals(type)) {
            either2 = this.parseInt32(p);
        } else if (FieldDescriptorProto$Type$TYPE_SINT64$.MODULE$.equals(type)) {
            either2 = this.parseInt64(p);
        } else if (FieldDescriptorProto$Type$TYPE_GROUP$.MODULE$.equals(type)) {
            either2 = package$.MODULE$.Left().apply(new AstUtils.AstError(p.index(), "groups are not supported"));
        } else if (FieldDescriptorProto$Type$TYPE_ENUM$.MODULE$.equals(type)) {
            Either either3;
            EnumDescriptor enumDesc = v$1.enumCompanionForFieldNumber(field2.number()).scalaDescriptor();
            TPrimitive tPrimitive = p;
            if (tPrimitive instanceof TIntLiteral) {
                TIntLiteral tIntLiteral = (TIntLiteral)tPrimitive;
                int index = tIntLiteral.index();
                BigInt num = tIntLiteral.value();
                either3 = enumDesc.values().find((Function1<EnumValueDescriptor, Object> & java.io.Serializable & Serializable)x$3 -> BoxesRunTime.boxToBoolean(AstUtils$.$anonfun$parseUnsafe$7(num, x$3))).map(PEnum$.MODULE$).toRight((Function0<AstUtils.AstError> & java.io.Serializable & Serializable)() -> new AstUtils.AstError(index, new StringBuilder(47).append("Expected Enum type \"").append(enumDesc.asProto().getName()).append("\" has no value with number ").append(num.toString()).toString()));
            } else if (tPrimitive instanceof TLiteral) {
                TLiteral tLiteral = (TLiteral)tPrimitive;
                int index = tLiteral.index();
                String name = tLiteral.value();
                either3 = enumDesc.values().find((Function1<EnumValueDescriptor, Object> & java.io.Serializable & Serializable)x$4 -> BoxesRunTime.boxToBoolean(AstUtils$.$anonfun$parseUnsafe$9(name, x$4))).map(PEnum$.MODULE$).toRight((Function0<AstUtils.AstError> & java.io.Serializable & Serializable)() -> new AstUtils.AstError(index, new StringBuilder(43).append("Expected Enum type \"").append(enumDesc.asProto().getName()).append("\" has no value named \"").append(name).append("\"").toString()));
            } else {
                either3 = package$.MODULE$.Left().apply(new AstUtils.AstError(tPrimitive.index(), new StringBuilder(38).append("Invalid value '").append(tPrimitive.asString()).append(", expected Enum type \"").append(enumDesc.asProto().getName()).append("\"").toString()));
            }
            either2 = either3;
        } else {
            either2 = package$.MODULE$.Left().apply(new AstUtils.AstError(p.index(), "This should not happen."));
        }
        return either2;
    }

    public static final /* synthetic */ boolean $anonfun$parseUnsafe$11(TValue x$5) {
        return !(x$5 instanceof TMessage);
    }

    public static final /* synthetic */ boolean $anonfun$parseUnsafe$13(TValue x$6) {
        return !(x$6 instanceof TPrimitive);
    }

    private final Either pfieldToValue$1(FieldDescriptor fd, TField pfield, GeneratedMessageCompanion v$1) {
        Either either2;
        TValue tValue = pfield.value();
        if (tValue instanceof TArray) {
            int idx;
            int idx2;
            TArray tArray = (TArray)tValue;
            Either either3 = !fd.isRepeated() ? package$.MODULE$.Left().apply(new AstUtils.AstError(tArray.index(), new StringBuilder(28).append("Invalid input '[', expected ").append(fd.protoType().toString().toLowerCase()).toString())) : (fd.protoType().isTypeMessage() ? ((idx2 = tArray.values().indexWhere((Function1<TValue, Object> & java.io.Serializable & Serializable)x$5 -> BoxesRunTime.boxToBoolean(AstUtils$.$anonfun$parseUnsafe$11(x$5)))) != -1 ? package$.MODULE$.Left().apply(new AstUtils.AstError(tArray.index(), new StringBuilder(43).append("Array contain a non-message value at index ").append(idx2).toString())) : this.flatten(((TraversableOnce)tArray.values().map((Function1<TValue, Either> & java.io.Serializable & Serializable)t -> MODULE$.parseUnsafe(v$1.messageCompanionForFieldNumber(fd.number()), (TMessage)t), Seq$.MODULE$.canBuildFrom())).toVector()).right().map(PRepeated$.MODULE$)) : ((idx = tArray.values().indexWhere((Function1<TValue, Object> & java.io.Serializable & Serializable)x$6 -> BoxesRunTime.boxToBoolean(AstUtils$.$anonfun$parseUnsafe$13(x$6)))) != -1 ? package$.MODULE$.Left().apply(new AstUtils.AstError(tArray.index(), new StringBuilder(26).append("Unexpected value at index ").append(idx).toString())) : this.flatten(((TraversableOnce)tArray.values().map((Function1<TValue, Either> & java.io.Serializable & Serializable)t -> this.parsePrimitive$1(fd, (TPrimitive)t, v$1), Seq$.MODULE$.canBuildFrom())).toVector()).right().map(PRepeated$.MODULE$)));
            either2 = either3;
        } else if (tValue instanceof TPrimitive) {
            TPrimitive tPrimitive = (TPrimitive)tValue;
            either2 = fd.protoType().isTypeMessage() ? package$.MODULE$.Left().apply(new AstUtils.AstError(tPrimitive.index(), "invalid value for message")) : this.parsePrimitive$1(fd, tPrimitive, v$1);
        } else if (tValue instanceof TMessage) {
            TMessage tMessage = (TMessage)tValue;
            either2 = !fd.protoType().isTypeMessage() ? package$.MODULE$.Left().apply(new AstUtils.AstError(tMessage.index(), "invalid value for message")) : this.parseUnsafe(v$1.messageCompanionForFieldNumber(fd.number()), tMessage);
        } else {
            throw new MatchError(tValue);
        }
        return either2;
    }

    private final Either fieldGroupToValue$1(String name, Seq group, Map fieldMap$1, GeneratedMessageCompanion v$1) {
        FieldDescriptor fd = (FieldDescriptor)fieldMap$1.apply(name);
        Either values = this.flatten(group.map((Function1<TField, Either> & java.io.Serializable & Serializable)x$8 -> this.pfieldToValue$1(fd, (TField)x$8, v$1), Seq$.MODULE$.canBuildFrom()));
        return values.right().map((Function1<Seq, Tuple2> & java.io.Serializable & Serializable)t -> !fd.isRepeated() ? Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(fd), t.last()) : Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(fd), new PRepeated((Vector)t.foldLeft(package$.MODULE$.Vector().apply(Nil$.MODULE$), (Function2<Vector, PValue, Vector> & java.io.Serializable & Serializable)(x0$1, x1$1) -> {
            Tuple2<Vector, PValue> tuple2 = new Tuple2<Vector, PValue>((Vector)x0$1, (PValue)x1$1);
            if (tuple2 != null) {
                Vector xs = tuple2._1();
                PValue pValue = tuple2._2();
                if (pValue instanceof PRepeated) {
                    Vector<PValue> vector2;
                    Vector<PValue> ys = vector2 = pValue == null ? null : ((PRepeated)pValue).value();
                    return xs.$plus$plus(ys, Vector$.MODULE$.canBuildFrom());
                }
            }
            if (tuple2 == null) throw new MatchError(tuple2);
            Vector xs = tuple2._1();
            PValue t = tuple2._2();
            if (!(t instanceof PValue)) throw new MatchError(tuple2);
            PValue pValue = t;
            return xs.$colon$plus(pValue, Vector$.MODULE$.canBuildFrom());
        }))));
    }

    public static final /* synthetic */ boolean $anonfun$parseUnsafe$20(Map fieldMap$1, TField f) {
        return !fieldMap$1.contains(f.name());
    }

    private AstUtils$() {
        MODULE$ = this;
    }
}

