/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal;

import java.nio.ByteBuffer;
import java.util.List;
import zipkin.DependencyLink;
import zipkin.internal.Buffer;
import zipkin.internal.ThriftCodec;
import zipkin.internal.Util;

@Deprecated
public final class Dependencies {
    public final long startTs;
    public final long endTs;
    public final List<DependencyLink> links;
    @Deprecated
    static final ThriftCodec.ThriftAdapter<Dependencies> THRIFT_ADAPTER = new ThriftCodec.ThriftAdapter<Dependencies>(){
        final ThriftCodec.Field START_TS = new ThriftCodec.Field(10, 1);
        final ThriftCodec.Field END_TS = new ThriftCodec.Field(10, 2);
        final ThriftCodec.Field LINKS = new ThriftCodec.Field(15, 3);

        @Override
        public Dependencies read(ByteBuffer bytes) {
            long startTs = 0L;
            long endTs = 0L;
            List<DependencyLink> links = null;
            while (true) {
                ThriftCodec.Field field2 = ThriftCodec.Field.read(bytes);
                if (field2.type == 0) break;
                if (field2.isEqualTo(this.START_TS)) {
                    startTs = bytes.getLong();
                    continue;
                }
                if (field2.isEqualTo(this.END_TS)) {
                    endTs = bytes.getLong();
                    continue;
                }
                if (field2.isEqualTo(this.LINKS)) {
                    links = ThriftCodec.readList(ThriftCodec.DEPENDENCY_LINK_ADAPTER, bytes);
                    continue;
                }
                ThriftCodec.skip(bytes, field2.type);
            }
            return Dependencies.create(startTs, endTs, links);
        }

        @Override
        public int sizeInBytes(Dependencies value) {
            int sizeInBytes = 0;
            sizeInBytes += 11;
            sizeInBytes += 11;
            sizeInBytes += 3 + ThriftCodec.listSizeInBytes(ThriftCodec.DEPENDENCY_LINK_ADAPTER, value.links);
            return ++sizeInBytes;
        }

        @Override
        public void write(Dependencies value, Buffer buffer) {
            this.START_TS.write(buffer);
            buffer.writeLong(value.startTs);
            this.END_TS.write(buffer);
            buffer.writeLong(value.endTs);
            this.LINKS.write(buffer);
            ThriftCodec.writeList(ThriftCodec.DEPENDENCY_LINK_ADAPTER, value.links, buffer);
            buffer.writeByte(0);
        }

        public String toString() {
            return "Dependencies";
        }
    };

    public static Dependencies fromThrift(ByteBuffer bytes) {
        return ThriftCodec.read(THRIFT_ADAPTER, bytes);
    }

    public ByteBuffer toThrift() {
        return ByteBuffer.wrap(ThriftCodec.write(THRIFT_ADAPTER, this));
    }

    public static Dependencies create(long startTs, long endTs, List<DependencyLink> links) {
        return new Dependencies(startTs, endTs, links);
    }

    Dependencies(long startTs, long endTs, List<DependencyLink> links) {
        this.startTs = startTs;
        this.endTs = endTs;
        this.links = Util.checkNotNull(links, "links");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Dependencies) {
            Dependencies that = (Dependencies)o;
            return this.startTs == that.startTs && this.endTs == that.endTs && this.links.equals(that.links);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= (int)((long)h2 ^ (this.startTs >>> 32 ^ this.startTs));
        h2 *= 1000003;
        h2 ^= (int)((long)h2 ^ (this.endTs >>> 32 ^ this.endTs));
        h2 *= 1000003;
        return h2 ^= this.links.hashCode();
    }
}

