/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal.v2;

import zipkin.internal.v2.DependencyLink;

final class AutoValue_DependencyLink
extends DependencyLink {
    private final String parent;
    private final String child;
    private final long callCount;
    private final long errorCount;
    private static final long serialVersionUID = 0L;

    private AutoValue_DependencyLink(String parent, String child, long callCount, long errorCount) {
        this.parent = parent;
        this.child = child;
        this.callCount = callCount;
        this.errorCount = errorCount;
    }

    @Override
    public String parent() {
        return this.parent;
    }

    @Override
    public String child() {
        return this.child;
    }

    @Override
    public long callCount() {
        return this.callCount;
    }

    @Override
    public long errorCount() {
        return this.errorCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DependencyLink) {
            DependencyLink that = (DependencyLink)o;
            return this.parent.equals(that.parent()) && this.child.equals(that.child()) && this.callCount == that.callCount() && this.errorCount == that.errorCount();
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= this.parent.hashCode();
        h2 *= 1000003;
        h2 ^= this.child.hashCode();
        h2 *= 1000003;
        h2 ^= (int)(this.callCount >>> 32 ^ this.callCount);
        h2 *= 1000003;
        return h2 ^= (int)(this.errorCount >>> 32 ^ this.errorCount);
    }

    @Override
    public DependencyLink.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends DependencyLink.Builder {
        private String parent;
        private String child;
        private Long callCount;
        private Long errorCount;

        Builder() {
        }

        private Builder(DependencyLink source) {
            this.parent = source.parent();
            this.child = source.child();
            this.callCount = source.callCount();
            this.errorCount = source.errorCount();
        }

        @Override
        public DependencyLink.Builder parent(String parent) {
            if (parent == null) {
                throw new NullPointerException("Null parent");
            }
            this.parent = parent;
            return this;
        }

        @Override
        String parent() {
            if (this.parent == null) {
                throw new IllegalStateException("Property \"parent\" has not been set");
            }
            return this.parent;
        }

        @Override
        public DependencyLink.Builder child(String child) {
            if (child == null) {
                throw new NullPointerException("Null child");
            }
            this.child = child;
            return this;
        }

        @Override
        String child() {
            if (this.child == null) {
                throw new IllegalStateException("Property \"child\" has not been set");
            }
            return this.child;
        }

        @Override
        public DependencyLink.Builder callCount(long callCount) {
            this.callCount = callCount;
            return this;
        }

        @Override
        public DependencyLink.Builder errorCount(long errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        @Override
        DependencyLink autoBuild() {
            String missing = "";
            if (this.parent == null) {
                missing = missing + " parent";
            }
            if (this.child == null) {
                missing = missing + " child";
            }
            if (this.callCount == null) {
                missing = missing + " callCount";
            }
            if (this.errorCount == null) {
                missing = missing + " errorCount";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_DependencyLink(this.parent, this.child, this.callCount, this.errorCount);
        }
    }
}

