/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal.v2;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import zipkin.internal.v2.Annotation;
import zipkin.internal.v2.AutoValue_Span;
import zipkin.internal.v2.Endpoint;
import zipkin.internal.v2.codec.SpanBytesEncoder;

@AutoValue
@Immutable
public abstract class Span
implements Serializable {
    static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final long serialVersionUID = 0L;

    public abstract String traceId();

    @Nullable
    public abstract String parentId();

    public abstract String id();

    @Nullable
    public abstract Kind kind();

    @Nullable
    public abstract String name();

    @Nullable
    public abstract Long timestamp();

    @Nullable
    public abstract Long duration();

    @Nullable
    public abstract Endpoint localEndpoint();

    @Nullable
    public abstract Endpoint remoteEndpoint();

    public abstract List<Annotation> annotations();

    public abstract Map<String, String> tags();

    @Nullable
    public abstract Boolean debug();

    @Nullable
    public abstract Boolean shared();

    @Nullable
    public String localServiceName() {
        Endpoint localEndpoint = this.localEndpoint();
        return localEndpoint != null ? localEndpoint.serviceName() : null;
    }

    @Nullable
    public String remoteServiceName() {
        Endpoint remoteEndpoint = this.remoteEndpoint();
        return remoteEndpoint != null ? remoteEndpoint.serviceName() : null;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return new String(SpanBytesEncoder.JSON_V2.encode(this), UTF_8);
    }

    public static String normalizeTraceId(String traceId) {
        if (traceId == null) {
            throw new NullPointerException("traceId == null");
        }
        int length = traceId.length();
        if (length > 32) {
            throw new IllegalArgumentException("traceId.length > 32");
        }
        Span.validateHex(traceId);
        if (length == 32 || length == 16) {
            return traceId;
        }
        if (length < 16) {
            return Span.padLeft(traceId, 16);
        }
        return Span.padLeft(traceId, 32);
    }

    static String padLeft(String id2, int desiredLength) {
        StringBuilder builder = new StringBuilder(desiredLength);
        int offset = desiredLength - id2.length();
        for (int i = 0; i < offset; ++i) {
            builder.append('0');
        }
        builder.append(id2);
        return builder.toString();
    }

    static void validateHex(String id2) {
        int length = id2.length();
        for (int i = 0; i < length; ++i) {
            char c = id2.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') continue;
            throw new IllegalArgumentException(id2 + " should be lower-hex encoded with no prefix");
        }
    }

    static <T extends Comparable<? super T>> List<T> sortedList(@Nullable List<T> in) {
        if (in == null || in.isEmpty()) {
            return Collections.emptyList();
        }
        if (in.size() == 1) {
            return Collections.singletonList((Comparable)in.get(0));
        }
        Object[] array = in.toArray();
        Arrays.sort(array);
        List<Object> result2 = Arrays.asList(array);
        return Collections.unmodifiableList(result2);
    }

    public static final class Builder {
        String traceId;
        String parentId;
        String id;
        Kind kind;
        String name;
        Long timestamp;
        Long duration;
        Endpoint localEndpoint;
        Endpoint remoteEndpoint;
        ArrayList<Annotation> annotations;
        TreeMap<String, String> tags;
        Boolean debug;
        Boolean shared;

        public Builder clear() {
            this.traceId = null;
            this.parentId = null;
            this.id = null;
            this.kind = null;
            this.name = null;
            this.timestamp = null;
            this.duration = null;
            this.localEndpoint = null;
            this.remoteEndpoint = null;
            if (this.annotations != null) {
                this.annotations.clear();
            }
            if (this.tags != null) {
                this.tags.clear();
            }
            this.debug = null;
            this.shared = null;
            return this;
        }

        public Builder clone() {
            Builder result2 = new Builder();
            result2.traceId = this.traceId;
            result2.parentId = this.parentId;
            result2.id = this.id;
            result2.kind = this.kind;
            result2.name = this.name;
            result2.timestamp = this.timestamp;
            result2.duration = this.duration;
            result2.localEndpoint = this.localEndpoint;
            result2.remoteEndpoint = this.remoteEndpoint;
            if (this.annotations != null) {
                result2.annotations = (ArrayList)this.annotations.clone();
            }
            if (this.tags != null) {
                result2.tags = (TreeMap)this.tags.clone();
            }
            result2.debug = this.debug;
            result2.shared = this.shared;
            return result2;
        }

        Builder(Span source) {
            this.traceId = source.traceId();
            this.parentId = source.parentId();
            this.id = source.id();
            this.kind = source.kind();
            this.name = source.name();
            this.timestamp = source.timestamp();
            this.duration = source.duration();
            this.localEndpoint = source.localEndpoint();
            this.remoteEndpoint = source.remoteEndpoint();
            if (!source.annotations().isEmpty()) {
                this.annotations = new ArrayList(source.annotations().size());
                this.annotations.addAll(source.annotations());
            }
            if (!source.tags().isEmpty()) {
                this.tags = new TreeMap();
                this.tags.putAll(source.tags());
            }
            this.debug = source.debug();
            this.shared = source.shared();
        }

        @Nullable
        public Kind kind() {
            return this.kind;
        }

        @Nullable
        public Endpoint localEndpoint() {
            return this.localEndpoint;
        }

        public Builder traceId(String traceId) {
            this.traceId = Span.normalizeTraceId(traceId);
            return this;
        }

        public Builder parentId(@Nullable String parentId) {
            if (parentId != null) {
                int length = parentId.length();
                if (length > 16) {
                    throw new IllegalArgumentException("parentId.length > 16");
                }
                Span.validateHex(parentId);
                this.parentId = length < 16 ? Span.padLeft(parentId, 16) : parentId;
            }
            return this;
        }

        public Builder id(String id2) {
            if (id2 == null) {
                throw new NullPointerException("id == null");
            }
            int length = id2.length();
            if (length > 16) {
                throw new IllegalArgumentException("id.length > 16");
            }
            Span.validateHex(id2);
            this.id = length < 16 ? Span.padLeft(id2, 16) : id2;
            return this;
        }

        public Builder kind(@Nullable Kind kind) {
            this.kind = kind;
            return this;
        }

        public Builder name(@Nullable String name) {
            this.name = name == null || name.isEmpty() ? null : name.toLowerCase(Locale.ROOT);
            return this;
        }

        public Builder timestamp(@Nullable Long timestamp) {
            if (timestamp != null && timestamp == 0L) {
                timestamp = null;
            }
            this.timestamp = timestamp;
            return this;
        }

        public Builder duration(@Nullable Long duration) {
            if (duration != null && duration == 0L) {
                duration = null;
            }
            this.duration = duration;
            return this;
        }

        public Builder localEndpoint(@Nullable Endpoint localEndpoint) {
            this.localEndpoint = localEndpoint;
            return this;
        }

        public Builder remoteEndpoint(@Nullable Endpoint remoteEndpoint) {
            this.remoteEndpoint = remoteEndpoint;
            return this;
        }

        public Builder addAnnotation(long timestamp, String value) {
            if (this.annotations == null) {
                this.annotations = new ArrayList(2);
            }
            this.annotations.add(Annotation.create(timestamp, value));
            return this;
        }

        public Builder putTag(String key, String value) {
            if (this.tags == null) {
                this.tags = new TreeMap();
            }
            if (key == null) {
                throw new NullPointerException("key == null");
            }
            if (value == null) {
                throw new NullPointerException("value of " + key + " == null");
            }
            this.tags.put(key, value);
            return this;
        }

        public Builder debug(@Nullable Boolean debug) {
            this.debug = debug;
            return this;
        }

        public Builder shared(@Nullable Boolean shared) {
            this.shared = shared;
            return this;
        }

        public Span build() {
            return new AutoValue_Span(this.traceId, this.parentId, this.id, this.kind, this.name, this.timestamp, this.duration, this.localEndpoint, this.remoteEndpoint, Span.sortedList(this.annotations), this.tags == null ? Collections.emptyMap() : new LinkedHashMap<String, String>(this.tags), this.debug, this.shared);
        }

        Builder() {
        }
    }

    public static enum Kind {
        CLIENT,
        SERVER,
        PRODUCER,
        CONSUMER;

    }
}

