/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal.v2.codec;

import java.io.IOException;
import java.util.List;
import zipkin.internal.gson.stream.JsonReader;
import zipkin.internal.v2.DependencyLink;
import zipkin.internal.v2.codec.BytesDecoder;
import zipkin.internal.v2.codec.BytesEncoder;
import zipkin.internal.v2.codec.Encoding;
import zipkin.internal.v2.internal.Buffer;
import zipkin.internal.v2.internal.JsonCodec;
import zipkin.internal.v2.internal.JsonEscaper;

public enum DependencyLinkBytesCodec implements BytesEncoder<DependencyLink>,
BytesDecoder<DependencyLink>
{
    JSON{

        @Override
        public Encoding encoding() {
            return Encoding.JSON;
        }

        @Override
        public int sizeInBytes(DependencyLink input) {
            return WRITER.sizeInBytes(input);
        }

        @Override
        public byte[] encode(DependencyLink link) {
            return JsonCodec.write(WRITER, link);
        }

        @Override
        public DependencyLink decode(byte[] link) {
            return (DependencyLink)JsonCodec.read(READER, link);
        }

        @Override
        public byte[] encodeList(List<DependencyLink> links) {
            return JsonCodec.writeList(WRITER, links);
        }

        @Override
        public List<DependencyLink> decodeList(byte[] links) {
            return JsonCodec.readList(READER, links);
        }
    };

    static final JsonCodec.JsonReaderAdapter<DependencyLink> READER;
    static final Buffer.Writer<DependencyLink> WRITER;

    static {
        READER = new JsonCodec.JsonReaderAdapter<DependencyLink>(){

            @Override
            public DependencyLink fromJson(JsonReader reader) throws IOException {
                DependencyLink.Builder result2 = DependencyLink.newBuilder();
                reader.beginObject();
                while (reader.hasNext()) {
                    String nextName = reader.nextName();
                    if (nextName.equals("parent")) {
                        result2.parent(reader.nextString());
                        continue;
                    }
                    if (nextName.equals("child")) {
                        result2.child(reader.nextString());
                        continue;
                    }
                    if (nextName.equals("callCount")) {
                        result2.callCount(reader.nextLong());
                        continue;
                    }
                    if (nextName.equals("errorCount")) {
                        result2.errorCount(reader.nextLong());
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                return result2.build();
            }

            public String toString() {
                return "DependencyLink";
            }
        };
        WRITER = new Buffer.Writer<DependencyLink>(){

            @Override
            public int sizeInBytes(DependencyLink value) {
                int sizeInBytes = 37;
                sizeInBytes += JsonEscaper.jsonEscapedSizeInBytes(value.parent());
                sizeInBytes += JsonEscaper.jsonEscapedSizeInBytes(value.child());
                sizeInBytes += Buffer.asciiSizeInBytes(value.callCount());
                if (value.errorCount() > 0L) {
                    sizeInBytes += 14;
                    sizeInBytes += Buffer.asciiSizeInBytes(value.errorCount());
                }
                return sizeInBytes;
            }

            @Override
            public void write(DependencyLink value, Buffer b) {
                b.writeAscii("{\"parent\":\"").writeUtf8(JsonEscaper.jsonEscape(value.parent()));
                b.writeAscii("\",\"child\":\"").writeUtf8(JsonEscaper.jsonEscape(value.child()));
                b.writeAscii("\",\"callCount\":").writeAscii(value.callCount());
                if (value.errorCount() > 0L) {
                    b.writeAscii(",\"errorCount\":").writeAscii(value.errorCount());
                }
                b.writeByte(125);
            }

            public String toString() {
                return "DependencyLink";
            }
        };
    }
}

