/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal.v2.internal;

import java.nio.charset.Charset;

public final class Buffer {
    static final Charset UTF_8 = Charset.forName("UTF-8");
    private final byte[] buf;
    int pos;
    static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    public Buffer(int size) {
        this.buf = new byte[size];
    }

    public Buffer writeByte(int v) {
        this.buf[this.pos++] = (byte)v;
        return this;
    }

    public Buffer write(byte[] v) {
        System.arraycopy(v, 0, this.buf, this.pos, v.length);
        this.pos += v.length;
        return this;
    }

    static int utf8SizeInBytes(String string2) {
        int sizeInBytes = 0;
        int len = string2.length();
        for (int i = 0; i < len; ++i) {
            char low;
            char ch = string2.charAt(i);
            if (ch < '\u0080') {
                ++sizeInBytes;
                continue;
            }
            if (ch < '\u0800') {
                sizeInBytes += 2;
                continue;
            }
            if (ch < '\ud800' || ch > '\udfff') {
                sizeInBytes += 3;
                continue;
            }
            char c = low = i + 1 < len ? string2.charAt(i + 1) : (char)'\u0000';
            if (ch > '\udbff' || low < '\udc00' || low > '\udfff') {
                ++sizeInBytes;
                continue;
            }
            sizeInBytes += 4;
            ++i;
        }
        return sizeInBytes;
    }

    public Buffer writeAscii(String v) {
        int length = v.length();
        for (int i = 0; i < length; ++i) {
            this.buf[this.pos++] = (byte)v.charAt(i);
        }
        return this;
    }

    static boolean isAscii(String v) {
        int length = v.length();
        for (int i = 0; i < length; ++i) {
            if (v.charAt(i) < '\u0080') continue;
            return false;
        }
        return true;
    }

    public Buffer writeUtf8(String v) {
        if (Buffer.isAscii(v)) {
            return this.writeAscii(v);
        }
        byte[] temp = v.getBytes(UTF_8);
        this.write(temp);
        return this;
    }

    public static int asciiSizeInBytes(long v) {
        if (v == 0L) {
            return 1;
        }
        if (v == Long.MIN_VALUE) {
            return 20;
        }
        boolean negative = false;
        if (v < 0L) {
            v = -v;
            negative = true;
        }
        int width = v < 100000000L ? (v < 10000L ? (v < 100L ? (v < 10L ? 1 : 2) : (v < 1000L ? 3 : 4)) : (v < 1000000L ? (v < 100000L ? 5 : 6) : (v < 10000000L ? 7 : 8))) : (v < 1000000000000L ? (v < 10000000000L ? (v < 1000000000L ? 9 : 10) : (v < 100000000000L ? 11 : 12)) : (v < 1000000000000000L ? (v < 10000000000000L ? 13 : (v < 100000000000000L ? 14 : 15)) : (v < 100000000000000000L ? (v < 10000000000000000L ? 16 : 17) : (v < 1000000000000000000L ? 18 : 19))));
        return negative ? width + 1 : width;
    }

    public Buffer writeAscii(long v) {
        if (v == 0L) {
            return this.writeByte(48);
        }
        if (v == Long.MIN_VALUE) {
            return this.writeAscii("-9223372036854775808");
        }
        int width = Buffer.asciiSizeInBytes(v);
        int pos = this.pos += width;
        boolean negative = false;
        if (v < 0L) {
            negative = true;
            v = -v;
        }
        while (v != 0L) {
            int digit = (int)(v % 10L);
            this.buf[--pos] = DIGITS[digit];
            v /= 10L;
        }
        if (negative) {
            this.buf[--pos] = 45;
        }
        return this;
    }

    public byte[] toByteArray() {
        return this.buf;
    }

    public static interface Writer<T> {
        public int sizeInBytes(T var1);

        public void write(T var1, Buffer var2);
    }
}

