/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal.v2.internal;

import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import zipkin.internal.v2.DependencyLink;
import zipkin.internal.v2.Span;
import zipkin.internal.v2.internal.AutoValue_DependencyLinker_Pair;
import zipkin.internal.v2.internal.Node;

public final class DependencyLinker {
    private final Logger logger;
    private final Map<Pair, Long> callCounts = new LinkedHashMap<Pair, Long>();
    private final Map<Pair, Long> errorCounts = new LinkedHashMap<Pair, Long>();
    static final Node.MergeFunction<Span> MERGE_RPC = new MergeRpc();

    public DependencyLinker() {
        this(Logger.getLogger(DependencyLinker.class.getName()));
    }

    DependencyLinker(Logger logger) {
        this.logger = logger;
    }

    public DependencyLinker putTrace(Iterator<Span> spans) {
        if (!spans.hasNext()) {
            return this;
        }
        Span first2 = spans.next();
        Node.TreeBuilder<Span> builder = new Node.TreeBuilder<Span>(this.logger, MERGE_RPC, first2.traceId());
        builder.addNode(first2.parentId(), first2.id(), first2);
        while (spans.hasNext()) {
            Span next = spans.next();
            builder.addNode(next.parentId(), next.id(), next);
        }
        Node<Span> tree = builder.build();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("traversing trace tree, breadth-first");
        }
        Iterator<Node<Span>> i = tree.traverse();
        block5: while (i.hasNext()) {
            String rpcAncestorName;
            Span rpcAncestor;
            String parent;
            String child;
            Node<Span> current = i.next();
            Span currentSpan = current.value();
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("processing " + currentSpan);
            }
            if (current.isSyntheticRootForPartialTree()) {
                this.logger.fine("skipping synthetic node for broken span tree");
                continue;
            }
            Span.Kind kind = currentSpan.kind();
            if (Span.Kind.CLIENT.equals((Object)kind) && !current.children().isEmpty()) {
                this.logger.fine("deferring link to rpc child span");
                continue;
            }
            String serviceName = currentSpan.localServiceName();
            String remoteServiceName = currentSpan.remoteServiceName();
            if (kind == null) {
                if (serviceName != null && remoteServiceName != null) {
                    kind = Span.Kind.CLIENT;
                } else {
                    this.logger.fine("non-rpc span; skipping");
                    continue;
                }
            }
            switch (kind) {
                case SERVER: 
                case CONSUMER: {
                    child = serviceName;
                    parent = remoteServiceName;
                    if (current != tree || parent != null) break;
                    this.logger.fine("root's peer is unknown; skipping");
                    continue block5;
                }
                case CLIENT: 
                case PRODUCER: {
                    parent = serviceName;
                    child = remoteServiceName;
                    break;
                }
                default: {
                    this.logger.fine("unknown kind; skipping");
                    continue block5;
                }
            }
            boolean isError = currentSpan.tags().containsKey("error");
            if (kind == Span.Kind.PRODUCER || kind == Span.Kind.CONSUMER) {
                if (parent == null || child == null) {
                    this.logger.fine("cannot link messaging span to its broker; skipping");
                    continue;
                }
                this.addLink(parent, child, isError);
                continue;
            }
            if (this.logger.isLoggable(Level.FINE) && parent == null) {
                this.logger.fine("cannot determine parent, looking for first server ancestor");
            }
            if ((rpcAncestor = this.findRpcAncestor(current)) != null && (rpcAncestorName = rpcAncestor.localServiceName()) != null) {
                if (kind == Span.Kind.CLIENT && serviceName != null && !rpcAncestorName.equals(serviceName)) {
                    this.logger.fine("detected missing link to client span");
                    this.addLink(rpcAncestorName, serviceName, false);
                }
                if (parent == null) {
                    parent = rpcAncestorName;
                }
                if (!isError && Span.Kind.CLIENT.equals((Object)rpcAncestor.kind()) && currentSpan.parentId() != null && currentSpan.parentId().equals(rpcAncestor.id())) {
                    isError = rpcAncestor.tags().containsKey("error");
                }
            }
            if (parent == null || child == null) {
                this.logger.fine("cannot find server ancestor; skipping");
                continue;
            }
            this.addLink(parent, child, isError);
        }
        return this;
    }

    Span findRpcAncestor(Node<Span> current) {
        for (Node<Span> ancestor = current.parent(); ancestor != null; ancestor = ancestor.parent()) {
            Span maybeRemote;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("processing ancestor " + ancestor.value());
            }
            if (ancestor.isSyntheticRootForPartialTree() || (maybeRemote = ancestor.value()).kind() == null) continue;
            return maybeRemote;
        }
        return null;
    }

    void addLink(String parent, String child, boolean isError) {
        Pair key;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("incrementing " + (isError ? "error " : "") + "link " + parent + " -> " + child);
        }
        if (this.callCounts.containsKey(key = Pair.of(parent, child))) {
            this.callCounts.put(key, this.callCounts.get(key) + 1L);
        } else {
            this.callCounts.put(key, 1L);
        }
        if (!isError) {
            return;
        }
        if (this.errorCounts.containsKey(key)) {
            this.errorCounts.put(key, this.errorCounts.get(key) + 1L);
        } else {
            this.errorCounts.put(key, 1L);
        }
    }

    public List<DependencyLink> link() {
        return DependencyLinker.link(this.callCounts, this.errorCounts);
    }

    public static List<DependencyLink> merge(Iterable<DependencyLink> in) {
        LinkedHashMap<Pair, Long> callCounts = new LinkedHashMap<Pair, Long>();
        LinkedHashMap<Pair, Long> errorCounts = new LinkedHashMap<Pair, Long>();
        for (DependencyLink link : in) {
            Pair parentChild = Pair.of(link.parent(), link.child());
            long callCount = callCounts.containsKey(parentChild) ? (Long)callCounts.get(parentChild) : 0L;
            callCounts.put(parentChild, callCount += link.callCount());
            long errorCount = errorCounts.containsKey(parentChild) ? (Long)errorCounts.get(parentChild) : 0L;
            errorCounts.put(parentChild, errorCount += link.errorCount());
        }
        return DependencyLinker.link(callCounts, errorCounts);
    }

    static List<DependencyLink> link(Map<Pair, Long> callCounts, Map<Pair, Long> errorCounts) {
        ArrayList<DependencyLink> result2 = new ArrayList<DependencyLink>(callCounts.size());
        for (Map.Entry<Pair, Long> entry : callCounts.entrySet()) {
            Pair parentChild = entry.getKey();
            result2.add(DependencyLink.newBuilder().parent(parentChild.left()).child(parentChild.right()).callCount(entry.getValue()).errorCount(errorCounts.containsKey(parentChild) ? errorCounts.get(parentChild) : 0L).build());
        }
        return result2;
    }

    @AutoValue
    static abstract class Pair {
        Pair() {
        }

        static Pair of(String left, String right) {
            return new AutoValue_DependencyLinker_Pair(left, right);
        }

        abstract String left();

        abstract String right();
    }

    static final class MergeRpc
    implements Node.MergeFunction<Span> {
        MergeRpc() {
        }

        @Override
        public Span merge(@Nullable Span left, @Nullable Span right) {
            Span client;
            if (left == null) {
                return right;
            }
            if (right == null) {
                return left;
            }
            if (left.kind() == null) {
                return MergeRpc.copyError(left, right);
            }
            if (right.kind() == null) {
                return MergeRpc.copyError(right, left);
            }
            Span server = left.kind() == Span.Kind.SERVER ? left : right;
            Span span = client = left == server ? right : left;
            if (server.remoteServiceName() != null) {
                return MergeRpc.copyError(client, server);
            }
            return MergeRpc.copyError(client, server).toBuilder().remoteEndpoint(client.localEndpoint()).build();
        }

        static Span copyError(Span maybeError, Span result2) {
            String error = maybeError.tags().get("error");
            if (error != null) {
                return result2.toBuilder().putTag("error", error).build();
            }
            return result2;
        }
    }
}

