/*
 * Decompiled with CFR 0.152.
 */
package zipkin.internal.v2.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import zipkin.internal.gson.stream.JsonReader;
import zipkin.internal.v2.internal.Buffer;
import zipkin.internal.v2.internal.Platform;

public final class JsonCodec {
    static final Charset UTF_8 = Charset.forName("UTF-8");

    public static <T> T read(JsonReaderAdapter<T> adapter, byte[] bytes) {
        if (bytes.length == 0) {
            throw new IllegalArgumentException("Empty input reading " + adapter);
        }
        try {
            return adapter.fromJson(JsonCodec.jsonReader(bytes));
        }
        catch (Exception e) {
            throw JsonCodec.exceptionReading(adapter.toString(), bytes, e);
        }
    }

    public static <T> List<T> readList(JsonReaderAdapter<T> adapter, byte[] bytes) {
        if (bytes.length == 0) {
            throw new IllegalArgumentException("Empty input reading List<" + adapter + ">");
        }
        JsonReader reader = JsonCodec.jsonReader(bytes);
        try {
            LinkedList<T> result2;
            reader.beginArray();
            LinkedList<T> linkedList = result2 = reader.hasNext() ? new LinkedList<T>() : Collections.emptyList();
            while (reader.hasNext()) {
                result2.add(adapter.fromJson(reader));
            }
            reader.endArray();
            return result2;
        }
        catch (Exception e) {
            throw JsonCodec.exceptionReading("List<" + adapter + ">", bytes, e);
        }
    }

    static JsonReader jsonReader(byte[] bytes) {
        return new JsonReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), UTF_8));
    }

    static <T> int sizeInBytes(Buffer.Writer<T> writer, List<T> value) {
        int length = value.size();
        int sizeInBytes = 2;
        if (length > 1) {
            sizeInBytes += length - 1;
        }
        for (int i = 0; i < length; ++i) {
            sizeInBytes += writer.sizeInBytes(value.get(i));
        }
        return sizeInBytes;
    }

    public static <T> byte[] write(Buffer.Writer<T> writer, T value) {
        Buffer b = new Buffer(writer.sizeInBytes(value));
        try {
            writer.write(value, b);
        }
        catch (RuntimeException e) {
            byte[] bytesWritten;
            byte[] bytes = b.toByteArray();
            int lengthWritten = bytes.length;
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] != 0) continue;
                lengthWritten = i;
                break;
            }
            if (lengthWritten == bytes.length) {
                bytesWritten = bytes;
            } else {
                bytesWritten = new byte[lengthWritten];
                System.arraycopy(bytes, 0, bytesWritten, 0, lengthWritten);
            }
            String written = new String(bytesWritten, UTF_8);
            String message = String.format("Bug found using %s to write %s as json. Wrote %s/%s bytes: %s", writer.getClass().getSimpleName().replace("AutoValue_", ""), value.getClass().getSimpleName(), lengthWritten, bytes.length, written);
            throw Platform.get().assertionError(message, e);
        }
        return b.toByteArray();
    }

    public static <T> byte[] writeList(Buffer.Writer<T> writer, List<T> value) {
        if (value.isEmpty()) {
            return new byte[]{91, 93};
        }
        Buffer result2 = new Buffer(JsonCodec.sizeInBytes(writer, value));
        JsonCodec.writeList(writer, value, result2);
        return result2.toByteArray();
    }

    public static <T> void writeList(Buffer.Writer<T> writer, List<T> value, Buffer b) {
        b.writeByte(91);
        int i = 0;
        int length = value.size();
        while (i < length) {
            writer.write(value.get(i++), b);
            if (i >= length) continue;
            b.writeByte(44);
        }
        b.writeByte(93);
    }

    public static <T> byte[] writeNestedList(Buffer.Writer<T> writer, List<List<T>> traces) {
        int length = traces.size();
        int sizeInBytes = 2;
        if (length > 1) {
            sizeInBytes += length - 1;
        }
        for (int i = 0; i < length; ++i) {
            List<T> spans = traces.get(i);
            int jLength = spans.size();
            sizeInBytes += 2;
            if (jLength > 1) {
                sizeInBytes += jLength - 1;
            }
            for (int j = 0; j < jLength; ++j) {
                sizeInBytes += writer.sizeInBytes(spans.get(j));
            }
        }
        Buffer out = new Buffer(sizeInBytes);
        out.writeByte(91);
        for (int i = 0; i < length; ++i) {
            JsonCodec.writeList(writer, traces.get(i), out);
            if (i + 1 >= length) continue;
            out.writeByte(44);
        }
        out.writeByte(93);
        return out.toByteArray();
    }

    static IllegalArgumentException exceptionReading(String type, byte[] bytes, Exception e) {
        String cause;
        String string2 = cause = e.getMessage() == null ? "Error" : e.getMessage();
        if (cause.indexOf("malformed") != -1) {
            cause = "Malformed";
        }
        String message = String.format("%s reading %s from json: %s", cause, type, new String(bytes, UTF_8));
        throw new IllegalArgumentException(message, e);
    }

    public static interface JsonReaderAdapter<T> {
        public T fromJson(JsonReader var1) throws IOException;
    }
}

