/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver;

import com.daml.ledger.resources.ResourceContext;
import com.daml.ledger.resources.ResourceOwner$;
import com.daml.metrics.Metrics;
import com.daml.platform.apiserver.GrpcServer;
import com.daml.platform.apiserver.MetricsInterceptor;
import com.daml.platform.apiserver.RateLimitingInterceptor$;
import com.daml.platform.apiserver.TruncatedStatusInterceptor;
import com.daml.platform.apiserver.configuration.RateLimitingConfig;
import com.daml.platform.apiserver.error.ErrorInterceptor;
import com.daml.resources.AbstractResourceOwner;
import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.netty.NettyServerBuilder;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Failure;

public final class GrpcServer$ {
    public static final GrpcServer$ MODULE$ = new GrpcServer$();
    private static final int MaximumStatusDescriptionLength = 4096;

    private int MaximumStatusDescriptionLength() {
        return MaximumStatusDescriptionLength;
    }

    public AbstractResourceOwner<ResourceContext, Server> owner(Option<String> address, int desiredPort, int maxInboundMessageSize, Option<SslContext> sslContext, List<ServerInterceptor> interceptors, Metrics metrics, Executor servicesExecutor, Iterable<BindableService> services, Option<RateLimitingConfig> rateLimitingConfig) {
        InetAddress host = (InetAddress)address.map((Function1 & Serializable)x$1 -> InetAddress.getByName(x$1)).getOrElse((Function0 & Serializable)() -> InetAddress.getLoopbackAddress());
        NettyServerBuilder builder = NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(host, desiredPort));
        builder.sslContext((SslContext)sslContext.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        builder.permitKeepAliveTime(10L, TimeUnit.SECONDS);
        builder.permitKeepAliveWithoutCalls(true);
        builder.executor(servicesExecutor);
        builder.maxInboundMessageSize(maxInboundMessageSize);
        interceptors.foreach((Function1 & Serializable)x$1 -> (NettyServerBuilder)builder.intercept(x$1));
        builder.intercept((ServerInterceptor)new MetricsInterceptor(metrics));
        builder.intercept((ServerInterceptor)new TruncatedStatusInterceptor(this.MaximumStatusDescriptionLength()));
        builder.intercept((ServerInterceptor)new ErrorInterceptor());
        rateLimitingConfig.foreach((Function1 & Serializable)c -> (NettyServerBuilder)builder.intercept((ServerInterceptor)RateLimitingInterceptor$.MODULE$.apply(metrics, (RateLimitingConfig)c)));
        services.foreach((Function1 & Serializable)service -> {
            GrpcServer$.$anonfun$owner$5(builder, service);
            return BoxedUnit.UNIT;
        });
        return ResourceOwner$.MODULE$.forServer((ServerBuilder)builder, new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second()).transform((Function1 & Serializable)x$1 -> x$1.recoverWith((PartialFunction)new Serializable(desiredPort){
            private static final long serialVersionUID = 0L;
            private final int desiredPort$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                IOException iOException;
                A1 A1 = x1;
                Object object = A1 instanceof IOException && (iOException = (IOException)A1).getCause() != null && iOException.getCause() instanceof BindException ? new Failure((Throwable)new GrpcServer.UnableToBind(this.desiredPort$1, iOException.getCause())) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                IOException iOException;
                Throwable throwable = x1;
                boolean bl = throwable instanceof IOException && (iOException = (IOException)throwable).getCause() != null && iOException.getCause() instanceof BindException;
                return bl;
            }
            {
                this.desiredPort$1 = desiredPort$1;
            }
        }));
    }

    public Option<SslContext> owner$default$4() {
        return None$.MODULE$;
    }

    public List<ServerInterceptor> owner$default$5() {
        return package$.MODULE$.List().empty();
    }

    private Option<ServerServiceDefinition> toLegacyService(BindableService service) {
        None$ none$;
        String com$u002Edaml = "com.daml";
        String com$u002Edigitalasset = "com.digitalasset";
        ServerServiceDefinition damlDef = service.bindService();
        ServiceDescriptor damlDesc = damlDef.getServiceDescriptor();
        if (damlDesc.getName().contains(com$u002Edaml)) {
            String digitalassetName = damlDesc.getName().replace(com$u002Edaml, com$u002Edigitalasset);
            ServerServiceDefinition.Builder digitalassetDef = ServerServiceDefinition.builder((String)digitalassetName);
            damlDef.getMethods().forEach(methodDef -> {
                MethodDescriptor damlMethodDesc = methodDef.getMethodDescriptor();
                String digitalassetMethodName = damlMethodDesc.getFullMethodName().replace(com$u002Edaml, com$u002Edigitalasset);
                MethodDescriptor digitalassetMethodDesc = damlMethodDesc.toBuilder().setFullMethodName(digitalassetMethodName).build();
                ServerServiceDefinition.Builder builder = digitalassetDef.addMethod(digitalassetMethodDesc, methodDef.getServerCallHandler());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            });
            none$ = Option$.MODULE$.apply((Object)digitalassetDef.build());
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static final /* synthetic */ void $anonfun$owner$5(NettyServerBuilder builder$1, BindableService service) {
        builder$1.addService(service);
        MODULE$.toLegacyService(service).foreach((Function1 & Serializable)x$1 -> (NettyServerBuilder)builder$1.addService(x$1));
    }

    private GrpcServer$() {
    }
}

