/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver;

import com.daml.ledger.api.tls.TlsConfiguration;
import com.daml.ledger.resources.ResourceContext;
import com.daml.ledger.resources.package$;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.metrics.Metrics;
import com.daml.platform.apiserver.ApiServer;
import com.daml.platform.apiserver.ApiServices;
import com.daml.platform.apiserver.GrpcServer$;
import com.daml.platform.apiserver.LedgerApiServer$;
import com.daml.platform.apiserver.configuration.RateLimitingConfig;
import com.daml.ports.Port$;
import com.daml.resources.AbstractResourceOwner;
import com.daml.resources.HasExecutionContext;
import com.daml.resources.Resource;
import io.grpc.Server;
import io.grpc.ServerInterceptor;
import io.netty.handler.ssl.SslContext;
import java.io.Serializable;
import java.util.concurrent.Executor;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple3;
import scala.collection.immutable.List;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005Me!\u0002\u000b\u0016\u0005ei\u0002\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\t\u0011y\u0002!\u0011!Q\u0001\n}B\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"A\u0001\f\u0001B\u0001B\u0003%\u0011\f\u0003\u0005c\u0001\t\u0005\t\u0015!\u0003d\u0011!\u0019\bA!A!\u0002\u0013!\b\u0002\u0003@\u0001\u0005\u0003\u0005\u000b\u0011B@\t\u0015\u0005%\u0001A!A!\u0002\u0013\tY\u0001\u0003\u0006\u0002\u001a\u0001\u0011\t\u0011)A\u0006\u00037Aq!a\n\u0001\t\u0003\tI\u0003C\u0005\u0002D\u0001\u0011\r\u0011\"\u0003\u0002F!A\u0011Q\n\u0001!\u0002\u0013\t9\u0005C\u0004\u0002P\u0001!\t%!\u0015\b\u0015\u0005\u001dT#!A\t\u0002e\tIGB\u0005\u0015+\u0005\u0005\t\u0012A\r\u0002l!9\u0011q\u0005\t\u0005\u0002\u0005M\u0004\"CA;!E\u0005I\u0011AA<\u0011%\ti\tEI\u0001\n\u0003\tyIA\bMK\u0012<WM]!qSN+'O^3s\u0015\t1r#A\u0005ba&\u001cXM\u001d<fe*\u0011\u0001$G\u0001\ta2\fGOZ8s[*\u0011!dG\u0001\u0005I\u0006lGNC\u0001\u001d\u0003\r\u0019w.\\\n\u0003\u0001y\u00012a\b\u001a6\u001d\t\u0001sF\u0004\u0002\"Y9\u0011!E\u000b\b\u0003G%r!\u0001\n\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\rq\u0012xn\u001c;?\u0007\u0001I\u0011\u0001H\u0005\u00035mI!aK\r\u0002\r1,GmZ3s\u0013\tic&A\u0005sKN|WO]2fg*\u00111&G\u0005\u0003aE\nq\u0001]1dW\u0006<WM\u0003\u0002.]%\u00111\u0007\u000e\u0002\u000e%\u0016\u001cx.\u001e:dK>;h.\u001a:\u000b\u0005A\n\u0004C\u0001\u001c8\u001b\u0005)\u0012B\u0001\u001d\u0016\u0005%\t\u0005/[*feZ,'/\u0001\tba&\u001cVM\u001d<jG\u0016\u001cxj\u001e8feB\u0019qDM\u001e\u0011\u0005Yb\u0014BA\u001f\u0016\u0005-\t\u0005/[*feZL7-Z:\u0002\u0017\u0011,7/\u001b:fIB{'\u000f\u001e\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005f\tQ\u0001]8siNL!\u0001R!\u0003\tA{'\u000f^\u0001\u0016[\u0006D\u0018J\u001c2pk:$W*Z:tC\u001e,7+\u001b>f!\t9%*D\u0001I\u0015\u0005I\u0015!B:dC2\f\u0017BA&I\u0005\rIe\u000e^\u0001\bC\u0012$'/Z:t!\r9e\nU\u0005\u0003\u001f\"\u0013aa\u00149uS>t\u0007CA)V\u001d\t\u00116\u000b\u0005\u0002%\u0011&\u0011A\u000bS\u0001\u0007!J,G-\u001a4\n\u0005Y;&AB*ue&twM\u0003\u0002U\u0011\u0006\u0001B\u000f\\:D_:4\u0017nZ;sCRLwN\u001c\t\u0004\u000f:S\u0006CA.a\u001b\u0005a&BA/_\u0003\r!Hn\u001d\u0006\u0003?:\n1!\u00199j\u0013\t\tGL\u0001\tUYN\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u0006a\u0011N\u001c;fe\u000e,\u0007\u000f^8sgB\u0019A\r[6\u000f\u0005\u0015<gB\u0001\u0013g\u0013\u0005I\u0015B\u0001\u0019I\u0013\tI'N\u0001\u0003MSN$(B\u0001\u0019I!\ta\u0017/D\u0001n\u0015\tqw.\u0001\u0003heB\u001c'\"\u00019\u0002\u0005%|\u0017B\u0001:n\u0005E\u0019VM\u001d<fe&sG/\u001a:dKB$xN]\u0001\u0011g\u0016\u0014h/[2fg\u0016CXmY;u_J\u0004\"!\u001e?\u000e\u0003YT!a\u001e=\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002zu\u0006!Q\u000f^5m\u0015\u0005Y\u0018\u0001\u00026bm\u0006L!! <\u0003\u0011\u0015CXmY;u_J\fq!\\3ue&\u001c7\u000f\u0005\u0003\u0002\u0002\u0005\u0015QBAA\u0002\u0015\tq\u0018$\u0003\u0003\u0002\b\u0005\r!aB'fiJL7m]\u0001\u0013e\u0006$X\rT5nSRLgnZ\"p]\u001aLw\r\u0005\u0003H\u001d\u00065\u0001\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005MQ#A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0005\u0003/\t\tB\u0001\nSCR,G*[7ji&twmQ8oM&<\u0017A\u00047pO\u001eLgnZ\"p]R,\u0007\u0010\u001e\t\u0005\u0003;\t\u0019#\u0004\u0002\u0002 )\u0019\u0011\u0011E\r\u0002\u000f1|wmZ5oO&!\u0011QEA\u0010\u00059aunZ4j]\u001e\u001cuN\u001c;fqR\fa\u0001P5oSRtD\u0003FA\u0016\u0003c\t\u0019$!\u000e\u00028\u0005e\u00121HA\u001f\u0003\u007f\t\t\u0005\u0006\u0003\u0002.\u0005=\u0002C\u0001\u001c\u0001\u0011\u001d\tIb\u0003a\u0002\u00037AQ!O\u0006A\u0002iBQAP\u0006A\u0002}BQ!R\u0006A\u0002\u0019CQ\u0001T\u0006A\u00025Cq\u0001W\u0006\u0011\u0002\u0003\u0007\u0011\fC\u0004c\u0017A\u0005\t\u0019A2\t\u000bM\\\u0001\u0019\u0001;\t\u000by\\\u0001\u0019A@\t\u000f\u0005%1\u00021\u0001\u0002\f\u00051An\\4hKJ,\"!a\u0012\u0011\t\u0005u\u0011\u0011J\u0005\u0005\u0003\u0017\nyB\u0001\u000bD_:$X\r\u001f;vC2L'0\u001a3M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003\u001d\t7-];je\u0016$\"!a\u0015\u0015\t\u0005U\u00131\f\t\u0005?\u0005]S'C\u0002\u0002ZQ\u0012\u0001BU3t_V\u00148-\u001a\u0005\b\u0003;r\u00019AA0\u0003\u001d\u0019wN\u001c;fqR\u0004B!!\u0019\u0002d5\t\u0011'C\u0002\u0002fE\u0012qBU3t_V\u00148-Z\"p]R,\u0007\u0010^\u0001\u0010\u0019\u0016$w-\u001a:Ba&\u001cVM\u001d<feB\u0011a\u0007E\n\u0004!\u00055\u0004cA$\u0002p%\u0019\u0011\u0011\u000f%\u0003\r\u0005s\u0017PU3g)\t\tI'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0003sR3!WA>W\t\ti\b\u0005\u0003\u0002\u0000\u0005%UBAAA\u0015\u0011\t\u0019)!\"\u0002\u0013Ut7\r[3dW\u0016$'bAAD\u0011\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0015\u0011\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'\u0006\u0002\u0002\u0012*\u001a1-a\u001f")
public final class LedgerApiServer
extends AbstractResourceOwner<ResourceContext, ApiServer> {
    private final AbstractResourceOwner<ResourceContext, ApiServices> apiServicesOwner;
    private final int desiredPort;
    private final int maxInboundMessageSize;
    private final Option<String> address;
    private final Option<TlsConfiguration> tlsConfiguration;
    private final List<ServerInterceptor> interceptors;
    private final Executor servicesExecutor;
    private final Metrics metrics;
    private final Option<RateLimitingConfig> rateLimitingConfig;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;

    public static List<ServerInterceptor> $lessinit$greater$default$6() {
        return LedgerApiServer$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<TlsConfiguration> $lessinit$greater$default$5() {
        return LedgerApiServer$.MODULE$.$lessinit$greater$default$5();
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    public Resource<ResourceContext, ApiServer> acquire(ResourceContext context) {
        Promise servicesClosedPromise = Promise$.MODULE$.apply();
        Resource apiServicesResource = this.apiServicesOwner.acquire((Object)context);
        Resource resource = apiServicesResource.map((Function1 & Serializable)apiServices -> {
            Option sslContext = $this.tlsConfiguration.flatMap((Function1 & Serializable)x$1 -> x$1.server());
            Option x$5 = $this.tlsConfiguration.map((Function1 & Serializable)x$2 -> {
                x$2.setJvmTlsProperties();
                return BoxedUnit.UNIT;
            });
            return new Tuple3(apiServices, (Object)sslContext, (Object)x$5);
        }, (Object)context);
        Resource resource2 = resource.flatMap((Function1 & Serializable)x$7 -> {
            Tuple3 tuple3 = x$7;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            ApiServices apiServices = (ApiServices)tuple3._1();
            Option sslContext = (Option)tuple3._2();
            Resource resource = GrpcServer$.MODULE$.owner($this.address, $this.desiredPort, $this.maxInboundMessageSize, (Option<SslContext>)sslContext, $this.interceptors, $this.metrics, $this.servicesExecutor, apiServices.services(), $this.rateLimitingConfig).acquire((Object)context);
            Resource resource2 = resource.flatMap((Function1 & Serializable)server -> package$.MODULE$.Resource().apply(Future$.MODULE$.unit(), (Function1 & Serializable)x$3 -> apiServicesResource.release().map((Function1 & Serializable)x$4 -> {
                servicesClosedPromise.success((Object)BoxedUnit.UNIT);
                return BoxedUnit.UNIT;
            }, this.executionContext(context)), (Object)context).map((Function1 & Serializable)x$6 -> {
                BoxedUnit boxedUnit = x$6;
                String host = (String)$this.address.getOrElse((Function0 & Serializable)() -> "localhost");
                int actualPort = server.getPort();
                String transportMedium = sslContext.isDefined() ? "TLS" : "plain text";
                this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(21).append("Listening on ").append(host).append(":").append(actualPort).append(" over ").append(transportMedium).append(".").toString(), $this.loggingContext);
                ApiServer apiServer = new ApiServer(null, (Server)server, servicesClosedPromise){
                    private final int port;
                    private final Promise servicesClosedPromise$1;

                    public int port() {
                        return this.port;
                    }

                    public Future<BoxedUnit> servicesClosed() {
                        return this.servicesClosedPromise$1.future();
                    }
                    {
                        this.servicesClosedPromise$1 = servicesClosedPromise$1;
                        this.port = Port$.MODULE$.apply(server$1.getPort());
                    }
                };
                return apiServer;
            }, (Object)context), (Object)context);
            return resource2;
        }, (Object)context);
        return resource2.transformWith((Function1 & Serializable)x0$1 -> {
            Resource resource;
            Try try_ = x0$1;
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                this.logger().error().apply((Function0 & Serializable)() -> "Failed to create LedgerApiServer", ex, $this.loggingContext);
                resource = package$.MODULE$.Resource().failed(ex);
            } else if (try_ instanceof Success) {
                Success success = (Success)try_;
                ApiServer s = (ApiServer)success.value();
                resource = package$.MODULE$.Resource().successful((Object)s);
            } else {
                throw new MatchError((Object)try_);
            }
            return resource;
        }, (Object)context);
    }

    public LedgerApiServer(AbstractResourceOwner<ResourceContext, ApiServices> apiServicesOwner, int desiredPort, int maxInboundMessageSize, Option<String> address, Option<TlsConfiguration> tlsConfiguration, List<ServerInterceptor> interceptors, Executor servicesExecutor, Metrics metrics, Option<RateLimitingConfig> rateLimitingConfig, LoggingContext loggingContext) {
        this.apiServicesOwner = apiServicesOwner;
        this.desiredPort = desiredPort;
        this.maxInboundMessageSize = maxInboundMessageSize;
        this.address = address;
        this.tlsConfiguration = tlsConfiguration;
        this.interceptors = interceptors;
        this.servicesExecutor = servicesExecutor;
        this.metrics = metrics;
        this.rateLimitingConfig = rateLimitingConfig;
        this.loggingContext = loggingContext;
        super((HasExecutionContext)ResourceContext.Context$u0020has$u0020ExecutionContext$.MODULE$);
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
    }
}

