/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver;

import com.codahale.metrics.Timer;
import com.daml.metrics.MetricName$;
import com.daml.metrics.Metrics;
import com.daml.platform.apiserver.MetricsNaming$;
import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.io.Serializable;
import scala.Function0;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005-c!B\u0006\r\u00051!\u0002\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u000b1\u0002A\u0011A\u0017\t\u000fE\u0002!\u0019!C\u0005e!1q\n\u0001Q\u0001\nMBQ\u0001\u0015\u0001\u0005BE3A\u0001\u001f\u0001\u0007s\"Q\u0011Q\u0003\u0004\u0003\u0002\u0003\u0006I!a\u0006\t\u0015\u0005eaA!A!\u0002\u0013\tY\u0002\u0003\u0004-\r\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003g1A\u0011IA\u001b\u0005IiU\r\u001e:jGNLe\u000e^3sG\u0016\u0004Ho\u001c:\u000b\u00055q\u0011!C1qSN,'O^3s\u0015\ty\u0001#\u0001\u0005qY\u0006$hm\u001c:n\u0015\t\t\"#\u0001\u0003eC6d'\"A\n\u0002\u0007\r|WnE\u0002\u0001+u\u0001\"AF\u000e\u000e\u0003]Q!\u0001G\r\u0002\t1\fgn\u001a\u0006\u00025\u0005!!.\u0019<b\u0013\tarC\u0001\u0004PE*,7\r\u001e\t\u0003=\rj\u0011a\b\u0006\u0003A\u0005\nAa\u001a:qG*\t!%\u0001\u0002j_&\u0011Ae\b\u0002\u0012'\u0016\u0014h/\u001a:J]R,'oY3qi>\u0014\u0018aB7fiJL7m]\u0002\u0001!\tA#&D\u0001*\u0015\t)\u0003#\u0003\u0002,S\t9Q*\u001a;sS\u000e\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0002/aA\u0011q\u0006A\u0007\u0002\u0019!)QE\u0001a\u0001O\u0005ab-\u001e7m'\u0016\u0014h/[2f)>lU\r\u001e:jG:\u000bW.Z\"bG\",W#A\u001a\u0011\tQZT\bS\u0007\u0002k)\u0011agN\u0001\u000bG>t7-\u001e:sK:$(B\u0001\u001d:\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000e\u0002\b)JLW-T1q!\tqTI\u0004\u0002@\u0007B\u0011\u0001)O\u0007\u0002\u0003*\u0011!IJ\u0001\u0007yI|w\u000e\u001e \n\u0005\u0011K\u0014A\u0002)sK\u0012,g-\u0003\u0002G\u000f\n11\u000b\u001e:j]\u001eT!\u0001R\u001d\u0011\u0005%kU\"\u0001&\u000b\u0005\u0015Z%B\u0001'\u0013\u0003!\u0019w\u000eZ1iC2,\u0017B\u0001(K\u0005\u0015!\u0016.\\3s\u0003u1W\u000f\u001c7TKJ4\u0018nY3U_6+GO]5d\u001d\u0006lWmQ1dQ\u0016\u0004\u0013!D5oi\u0016\u00148-\u001a9u\u0007\u0006dG.F\u0002S92$Ba\u00154ogB\u0019Ak\u0016.\u000f\u0005y)\u0016B\u0001, \u0003)\u0019VM\u001d<fe\u000e\u000bG\u000e\\\u0005\u00031f\u0013\u0001\u0002T5ti\u0016tWM\u001d\u0006\u0003-~\u0001\"a\u0017/\r\u0001\u0011)Q,\u0002b\u0001=\n!!+Z9U#\ty6\r\u0005\u0002aC6\t\u0011(\u0003\u0002cs\t9aj\u001c;iS:<\u0007C\u00011e\u0013\t)\u0017HA\u0002B]fDQaZ\u0003A\u0002!\fAaY1mYB!a$\u001b.l\u0013\tQwD\u0001\u0006TKJ4XM]\"bY2\u0004\"a\u00177\u0005\u000b5,!\u0019\u00010\u0003\u000bI+7\u000f\u001d+\t\u000b=,\u0001\u0019\u00019\u0002\u000f!,\u0017\rZ3sgB\u0011a$]\u0005\u0003e~\u0011\u0001\"T3uC\u0012\fG/\u0019\u0005\u0006i\u0016\u0001\r!^\u0001\u0005]\u0016DH\u000f\u0005\u0003\u001fmj[\u0017BA< \u0005E\u0019VM\u001d<fe\u000e\u000bG\u000e\u001c%b]\u0012dWM\u001d\u0002\u0010)&lW\rZ*feZ,'oQ1mYV)!0a\u0004\u0002\u0014M\u0011aa\u001f\t\by\u0006\u001d\u0011QBA\t\u001d\ri\u00181\u0001\b\u0004}\u0006\u0005aB\u0001!\u0000\u0013\u0005\u0011\u0013B\u0001\u0011\"\u0013\r\t)aH\u0001\u0015\r>\u0014x/\u0019:eS:<7+\u001a:wKJ\u001c\u0015\r\u001c7\n\t\u0005%\u00111\u0002\u0002\u001b'&l\u0007\u000f\\3G_J<\u0018M\u001d3j]\u001e\u001cVM\u001d<fe\u000e\u000bG\u000e\u001c\u0006\u0004\u0003\u000by\u0002cA.\u0002\u0010\u0011)QL\u0002b\u0001=B\u00191,a\u0005\u0005\u000b54!\u0019\u00010\u0002\u0011\u0011,G.Z4bi\u0016\u0004bAH5\u0002\u000e\u0005E\u0011!\u0002;j[\u0016\u0014\b\u0003BA\u000f\u0003Gq1!SA\u0010\u0013\r\t\tCS\u0001\u0006)&lWM]\u0005\u0005\u0003K\t9CA\u0004D_:$X\r\u001f;\u000b\u0007\u0005\u0005\"\n\u0006\u0004\u0002,\u0005=\u0012\u0011\u0007\t\b\u0003[1\u0011QBA\t\u001b\u0005\u0001\u0001bBA\u000b\u0013\u0001\u0007\u0011q\u0003\u0005\b\u00033I\u0001\u0019AA\u000e\u0003\u0015\u0019Gn\\:f)\u0019\t9$!\u0010\u0002HA\u0019\u0001-!\u000f\n\u0007\u0005m\u0012H\u0001\u0003V]&$\bbBA \u0015\u0001\u0007\u0011\u0011I\u0001\u0007gR\fG/^:\u0011\u0007y\t\u0019%C\u0002\u0002F}\u0011aa\u0015;biV\u001c\bBBA%\u0015\u0001\u0007\u0001/\u0001\u0005ue\u0006LG.\u001a:t\u0001")
public final class MetricsInterceptor
implements ServerInterceptor {
    private final Metrics metrics;
    private final TrieMap<String, Timer> fullServiceToMetricNameCache;

    private TrieMap<String, Timer> fullServiceToMetricNameCache() {
        return this.fullServiceToMetricNameCache;
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        String fullMethodName = call.getMethodDescriptor().getFullMethodName();
        Timer timer = (Timer)this.fullServiceToMetricNameCache().getOrElseUpdate((Object)fullMethodName, (Function0 & Serializable)() -> $this.metrics.daml().lapi().forMethod(MetricName$.MODULE$.metricNameToString(MetricsNaming$.MODULE$.nameFor(fullMethodName))));
        Timer.Context timerCtx = timer.time();
        return next.startCall(new TimedServerCall<ReqT, RespT>(this, call, timerCtx), headers);
    }

    public MetricsInterceptor(Metrics metrics) {
        this.metrics = metrics;
        this.fullServiceToMetricNameCache = TrieMap$.MODULE$.empty();
    }

    private final class TimedServerCall<ReqT, RespT>
    extends ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT> {
        private final ServerCall<ReqT, RespT> delegate;
        private final Timer.Context timer;

        public void close(Status status, Metadata trailers) {
            this.delegate.close(status, trailers);
            this.timer.stop();
        }

        public TimedServerCall(MetricsInterceptor $outer, ServerCall<ReqT, RespT> delegate, Timer.Context timer) {
            this.delegate = delegate;
            this.timer = timer;
            super(delegate);
        }
    }
}

