/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver;

import com.daml.lf.crypto.Hash$;
import com.daml.platform.apiserver.SeedService;
import com.daml.platform.apiserver.SeedService$Seeding$Static$;
import com.daml.platform.apiserver.SeedService$Seeding$Strong$;
import com.daml.platform.apiserver.SeedService$Seeding$Weak$;
import java.security.SecureRandom;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.MatchError;

public final class SeedService$ {
    public static final SeedService$ MODULE$ = new SeedService$();
    private static SeedService StrongRandom;
    private static SeedService WeakRandom;
    private static volatile byte bitmap$0;

    public SeedService apply(SeedService.Seeding seeding) {
        SeedService seedService;
        SeedService.Seeding seeding2 = seeding;
        if (SeedService$Seeding$Strong$.MODULE$.equals(seeding2)) {
            seedService = this.StrongRandom();
        } else if (SeedService$Seeding$Weak$.MODULE$.equals(seeding2)) {
            seedService = this.WeakRandom();
        } else if (SeedService$Seeding$Static$.MODULE$.equals(seeding2)) {
            seedService = this.staticRandom("static random seed service");
        } else {
            throw new MatchError((Object)seeding2);
        }
        return seedService;
    }

    private SeedService StrongRandom$lzycompute() {
        SeedService$ seedService$ = this;
        synchronized (seedService$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                Logger logger = LoggerFactory.getLogger(this.getClass());
                Timer timer = new Timer();
                TimerTask task = new TimerTask(logger){
                    private final Logger logger$1;

                    public void run() {
                        this.logger$1.warn("Trying to gather entropy from the underlying operating system to initialize the contract ID seeding, but the entropy pool seems empty.");
                        this.logger$1.warn(new StringBuilder(128).append("In CI environments environment consider using the \"").append(SeedService$Seeding$Weak$.MODULE$.name()).append("\" mode, that may produce insecure contract IDs but does not block on startup.").toString());
                    }
                    {
                        this.logger$1 = logger$1;
                    }
                };
                timer.schedule(task, TimeUnit.SECONDS.toMillis(5L));
                byte[] seed = SecureRandom.getInstanceStrong().generateSeed(Hash$.MODULE$.underlyingHashLength());
                timer.cancel();
                StrongRandom = new SeedService(Hash$.MODULE$.assertFromByteArray(seed));
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return StrongRandom;
    }

    public SeedService StrongRandom() {
        return (byte)(bitmap$0 & 1) == 0 ? this.StrongRandom$lzycompute() : StrongRandom;
    }

    private SeedService WeakRandom$lzycompute() {
        SeedService$ seedService$ = this;
        synchronized (seedService$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                byte[] seed = new byte[Hash$.MODULE$.underlyingHashLength()];
                new SecureRandom().nextBytes(seed);
                WeakRandom = new SeedService(Hash$.MODULE$.assertFromByteArray(seed));
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return WeakRandom;
    }

    public SeedService WeakRandom() {
        return (byte)(bitmap$0 & 2) == 0 ? this.WeakRandom$lzycompute() : WeakRandom;
    }

    public SeedService staticRandom(String seed) {
        return new SeedService(Hash$.MODULE$.hashPrivateKey(seed));
    }

    private SeedService$() {
    }
}

