/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver.configuration;

import akka.actor.Cancellable;
import akka.actor.Scheduler;
import com.daml.api.util.TimeProvider;
import com.daml.ledger.api.SubmissionIdGenerator;
import com.daml.ledger.configuration.Configuration;
import com.daml.ledger.participant.state.v2.SubmissionResult;
import com.daml.ledger.participant.state.v2.WriteConfigService;
import com.daml.ledger.resources.ResourceContext;
import com.daml.ledger.resources.ResourceOwner$;
import com.daml.lf.data.Time;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.logging.LoggingContext$;
import com.daml.logging.entries.LoggingValue$;
import com.daml.logging.entries.ToLoggingValue$;
import com.daml.platform.apiserver.configuration.LedgerConfigurationSubscription;
import com.daml.platform.configuration.InitialLedgerConfiguration;
import com.daml.resources.AbstractResourceOwner;
import com.daml.telemetry.DefaultTelemetry$;
import com.daml.telemetry.SpanKind$;
import com.daml.telemetry.SpanName$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration$;
import scala.jdk.FutureConverters;
import scala.jdk.FutureConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001B\u0006\r\u0005]A\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tG\u0001\u0011\t\u0011)A\u0005I!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0011!y\u0004A!A!\u0002\u0013\u0001\u0005\"\u0002%\u0001\t\u0003I\u0005b\u0002)\u0001\u0005\u0004%I!\u0015\u0005\u00071\u0002\u0001\u000b\u0011\u0002*\t\u000be\u0003A\u0011\u0001.\t\u000f\u0005=\u0001\u0001\"\u0003\u0002\u0012\tqB*\u001a3hKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]B\u0013xN^5tS>tWM\u001d\u0006\u0003\u001b9\tQbY8oM&<WO]1uS>t'BA\b\u0011\u0003%\t\u0007/[:feZ,'O\u0003\u0002\u0012%\u0005A\u0001\u000f\\1uM>\u0014XN\u0003\u0002\u0014)\u0005!A-Y7m\u0015\u0005)\u0012aA2p[\u000e\u00011C\u0001\u0001\u0019!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fM\u0006yB.\u001a3hKJ\u001cuN\u001c4jOV\u0014\u0018\r^5p]N+(m]2sSB$\u0018n\u001c8\u0011\u0005\u0001\nS\"\u0001\u0007\n\u0005\tb!a\b'fI\u001e,'oQ8oM&<WO]1uS>t7+\u001e2tGJL\u0007\u000f^5p]\u0006aqO]5uKN+'O^5dKB\u0011QEL\u0007\u0002M)\u0011q\u0005K\u0001\u0003mJR!!\u000b\u0016\u0002\u000bM$\u0018\r^3\u000b\u0005-b\u0013a\u00039beRL7-\u001b9b]RT!!\f\n\u0002\r1,GmZ3s\u0013\tycE\u0001\nXe&$XmQ8oM&<7+\u001a:wS\u000e,\u0017\u0001\u0004;j[\u0016\u0004&o\u001c<jI\u0016\u0014\bC\u0001\u001a8\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0011)H/\u001b7\u000b\u0005Y\u0012\u0012aA1qS&\u0011\u0001h\r\u0002\r)&lW\r\u0015:pm&$WM]\u0001\u0016gV\u0014W.[:tS>t\u0017\nZ$f]\u0016\u0014\u0018\r^8s!\tYT(D\u0001=\u0015\t1D&\u0003\u0002?y\t)2+\u001e2nSN\u001c\u0018n\u001c8JI\u001e+g.\u001a:bi>\u0014\u0018!C:dQ\u0016$W\u000f\\3s!\t\te)D\u0001C\u0015\t\u0019E)A\u0003bGR|'OC\u0001F\u0003\u0011\t7n[1\n\u0005\u001d\u0013%!C*dQ\u0016$W\u000f\\3s\u0003\u0019a\u0014N\\5u}Q1!j\u0013'N\u001d>\u0003\"\u0001\t\u0001\t\u000by1\u0001\u0019A\u0010\t\u000b\r2\u0001\u0019\u0001\u0013\t\u000bA2\u0001\u0019A\u0019\t\u000be2\u0001\u0019\u0001\u001e\t\u000b}2\u0001\u0019\u0001!\u0002\r1|wmZ3s+\u0005\u0011\u0006CA*W\u001b\u0005!&BA+\u0013\u0003\u001dawnZ4j]\u001eL!a\u0016+\u0003)\r{g\u000e^3yiV\fG.\u001b>fI2{wmZ3s\u0003\u001dawnZ4fe\u0002\naa];c[&$HcA.\u0002\u0002Q\u0019Al]>\u0011\u0007uk\u0007O\u0004\u0002_U:\u0011q\f\u001b\b\u0003A\u001et!!\u00194\u000f\u0005\t,W\"A2\u000b\u0005\u00114\u0012A\u0002\u001fs_>$h(C\u0001\u0016\u0013\t\u0019B#\u0003\u0002.%%\u0011\u0011\u000eL\u0001\ne\u0016\u001cx.\u001e:dKNL!a\u001b7\u0002\u000fA\f7m[1hK*\u0011\u0011\u000eL\u0005\u0003]>\u0014QBU3t_V\u00148-Z(x]\u0016\u0014(BA6m!\tI\u0012/\u0003\u0002s5\t!QK\\5u\u0011\u0015!\u0018\u0002q\u0001v\u0003A)\u00070Z2vi&|gnQ8oi\u0016DH\u000f\u0005\u0002ws6\tqO\u0003\u0002y5\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005i<(\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u0015a\u0018\u0002q\u0001~\u00039awnZ4j]\u001e\u001cuN\u001c;fqR\u0004\"a\u0015@\n\u0005}$&A\u0004'pO\u001eLgnZ\"p]R,\u0007\u0010\u001e\u0005\b\u0003\u0007I\u0001\u0019AA\u0003\u0003iIg.\u001b;jC2dU\rZ4fe\u000e{gNZ5hkJ\fG/[8o!\u0011\t9!a\u0003\u000e\u0005\u0005%!BA\u0007\u0011\u0013\u0011\ti!!\u0003\u00035%s\u0017\u000e^5bY2+GmZ3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002#M,(-\\5u\u00136lW\rZ5bi\u0016d\u0017\u0010\u0006\u0003\u0002\u0014\u0005eA#\u00029\u0002\u0016\u0005]\u0001\"\u0002;\u000b\u0001\b)\b\"\u0002?\u000b\u0001\bi\bbBA\u000e\u0015\u0001\u0007\u0011QD\u0001\u0015S:LG/[1m\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\t\u0005}\u00111E\u0007\u0003\u0003CQ!!\u0004\u0017\n\t\u0005\u0015\u0012\u0011\u0005\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8")
public final class LedgerConfigurationProvisioner {
    private final LedgerConfigurationSubscription ledgerConfigurationSubscription;
    private final WriteConfigService writeService;
    private final TimeProvider timeProvider;
    private final SubmissionIdGenerator submissionIdGenerator;
    private final Scheduler scheduler;
    private final ContextualizedLogger logger;

    private ContextualizedLogger logger() {
        return this.logger;
    }

    public AbstractResourceOwner<ResourceContext, BoxedUnit> submit(InitialLedgerConfiguration initialLedgerConfiguration, ExecutionContext executionContext, LoggingContext loggingContext) {
        return ResourceOwner$.MODULE$.forCancellable((Function0 & Serializable)() -> $this.scheduler.scheduleOnce(Duration$.MODULE$.fromNanos(initialLedgerConfiguration.delayBeforeSubmitting().toNanos()), new Runnable(this, initialLedgerConfiguration, executionContext, loggingContext){
            private final /* synthetic */ LedgerConfigurationProvisioner $outer;
            private final InitialLedgerConfiguration initialLedgerConfiguration$1;
            private final ExecutionContext executionContext$1;
            private final LoggingContext loggingContext$1;

            public void run() {
                this.$outer.com$daml$platform$apiserver$configuration$LedgerConfigurationProvisioner$$submitImmediately(this.initialLedgerConfiguration$1.toConfiguration(), this.executionContext$1, this.loggingContext$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.initialLedgerConfiguration$1 = initialLedgerConfiguration$1;
                this.executionContext$1 = executionContext$1;
                this.loggingContext$1 = loggingContext$1;
            }
        }, executionContext)).map((Function1 & Serializable)x$1 -> {
            LedgerConfigurationProvisioner.$anonfun$submit$2(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void com$daml$platform$apiserver$configuration$LedgerConfigurationProvisioner$$submitImmediately(Configuration initialConfiguration, ExecutionContext executionContext, LoggingContext loggingContext2) {
        block0: {
            if (!this.ledgerConfigurationSubscription.latestConfiguration().isEmpty()) break block0;
            String submissionId = this.submissionIdGenerator.generate();
            LoggingContext$.MODULE$.withEnrichedLoggingContext(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"submissionId"), (Object)LoggingValue$.MODULE$.from((Object)submissionId, ToLoggingValue$.MODULE$.String$u0020to$u0020LoggingValue())), (Seq)Nil$.MODULE$, (Function1 & Serializable)loggingContext -> {
                LedgerConfigurationProvisioner.$anonfun$submitImmediately$1(this, submissionId, initialConfiguration, executionContext, loggingContext);
                return BoxedUnit.UNIT;
            }, loggingContext2);
        }
    }

    public static final /* synthetic */ void $anonfun$submit$2(Cancellable x$1) {
    }

    public static final /* synthetic */ void $anonfun$submitImmediately$6(LedgerConfigurationProvisioner $this, LoggingContext loggingContext) {
        $this.logger().warn().apply((Function0 & Serializable)() -> "Initial configuration submission failed.", loggingContext);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$submitImmediately$4(LedgerConfigurationProvisioner $this, LoggingContext loggingContext$2, Try x0$1) {
        SubmissionResult result;
        boolean bl = false;
        Success success = null;
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            SubmissionResult submissionResult = (SubmissionResult)success.value();
            if (SubmissionResult.Acknowledged$.MODULE$.equals(submissionResult)) {
                $this.logger().info().apply((Function0 & Serializable)() -> "Initial configuration submission was successful.", loggingContext$2);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && (result = (SubmissionResult)success.value()) instanceof SubmissionResult.SynchronousError) {
            SubmissionResult.SynchronousError synchronousError = (SubmissionResult.SynchronousError)result;
            BoxedUnit boxedUnit = (BoxedUnit)LoggingContext$.MODULE$.withEnrichedLoggingContext(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)LoggingValue$.MODULE$.from((Object)synchronousError, SubmissionResult.SynchronousError$.MODULE$.SynchronousError$u0020to$u0020LoggingValue())), (Seq)Nil$.MODULE$, (Function1 & Serializable)loggingContext -> {
                LedgerConfigurationProvisioner.$anonfun$submitImmediately$6($this, loggingContext);
                return BoxedUnit.UNIT;
            }, loggingContext$2);
            return;
        }
        if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
        Failure failure = (Failure)try_;
        Throwable exception = failure.exception();
        $this.logger().error().apply((Function0 & Serializable)() -> "Initial configuration submission failed.", exception, loggingContext$2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$submitImmediately$1(LedgerConfigurationProvisioner $this, String submissionId$1, Configuration initialConfiguration$1, ExecutionContext executionContext$2, LoggingContext loggingContext) {
        $this.logger().info().apply((Function0 & Serializable)() -> "No ledger configuration found, submitting an initial configuration.", loggingContext);
        DefaultTelemetry$.MODULE$.runFutureInSpan(SpanName$.MODULE$.LedgerConfigProviderInitialConfig(), SpanKind$.MODULE$.Internal(), (Seq)Nil$.MODULE$, (Function1 & Serializable)telemetryContext -> {
            Time.Timestamp maxRecordTime = Time.Timestamp$.MODULE$.assertFromInstant($this.timeProvider.getCurrentTime().plusSeconds(60L));
            return FutureConverters.CompletionStageOps$.MODULE$.asScala$extension(FutureConverters$.MODULE$.CompletionStageOps($this.writeService.submitConfiguration(maxRecordTime, submissionId$1, initialConfiguration$1, loggingContext, telemetryContext)));
        }).onComplete((Function1 & Serializable)x0$1 -> {
            LedgerConfigurationProvisioner.$anonfun$submitImmediately$4($this, loggingContext, x0$1);
            return BoxedUnit.UNIT;
        }, executionContext$2);
    }

    public LedgerConfigurationProvisioner(LedgerConfigurationSubscription ledgerConfigurationSubscription, WriteConfigService writeService, TimeProvider timeProvider, SubmissionIdGenerator submissionIdGenerator, Scheduler scheduler) {
        this.ledgerConfigurationSubscription = ledgerConfigurationSubscription;
        this.writeService = writeService;
        this.timeProvider = timeProvider;
        this.submissionIdGenerator = submissionIdGenerator;
        this.scheduler = scheduler;
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
    }
}

