/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver.error;

import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.definitions.LedgerApiErrors;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.logging.LoggingContext$;
import com.daml.platform.apiserver.error.LogOnUnhandledFailureInClose$;
import io.grpc.ForwardingServerCallListener;
import io.grpc.ServerCall;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005i3A!\u0003\u0006\u0001+!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u001d1\u0005A1A\u0005\n\u001dCaA\u0014\u0001!\u0002\u0013A\u0005bB(\u0001\u0005\u0004%I\u0001\u0015\u0005\u0007)\u0002\u0001\u000b\u0011B)\t\u000bU\u0003A\u0011\t,\u0003\u001b\u0015\u0013(o\u001c:MSN$XM\\3s\u0015\tYA\"A\u0003feJ|'O\u0003\u0002\u000e\u001d\u0005I\u0011\r]5tKJ4XM\u001d\u0006\u0003\u001fA\t\u0001\u0002\u001d7bi\u001a|'/\u001c\u0006\u0003#I\tA\u0001Z1nY*\t1#A\u0002d_6\u001c\u0001!F\u0002\u0017Ky\u001a\"\u0001A\f\u0011\u0007a\u00013E\u0004\u0002\u001a=5\t!D\u0003\u0002\u001c9\u0005!qM\u001d9d\u0015\u0005i\u0012AA5p\u0013\ty\"$\u0001\u000fG_J<\u0018M\u001d3j]\u001e\u001cVM\u001d<fe\u000e\u000bG\u000e\u001c'jgR,g.\u001a:\n\u0005\u0005\u0012#AI*j[BdWMR8so\u0006\u0014H-\u001b8h'\u0016\u0014h/\u001a:DC2dG*[:uK:,'O\u0003\u0002 5A\u0011A%\n\u0007\u0001\t\u00151\u0003A1\u0001(\u0005\u0011\u0011V-\u001d+\u0012\u0005!r\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#a\u0002(pi\"Lgn\u001a\t\u0003S=J!\u0001\r\u0016\u0003\u0007\u0005s\u00170\u0001\u0005eK2,w-\u0019;f!\r\u0019dg\t\b\u00033QJ!!\u000e\u000e\u0002\u0015M+'O^3s\u0007\u0006dG.\u0003\u00028q\tAA*[:uK:,'O\u0003\u000265\u0005!1-\u00197m!\u0011I2hI\u001f\n\u0005qR\"AC*feZ,'oQ1mYB\u0011AE\u0010\u0003\u0006\u007f\u0001\u0011\ra\n\u0002\u0006%\u0016\u001c\b\u000fV\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\t#U\t\u0005\u0003D\u0001\rjT\"\u0001\u0006\t\u000bE\u001a\u0001\u0019\u0001\u001a\t\u000be\u001a\u0001\u0019\u0001\u001e\u0002\r1|wmZ3s+\u0005A\u0005CA%M\u001b\u0005Q%BA&\u0011\u0003\u001dawnZ4j]\u001eL!!\u0014&\u0003)\r{g\u000e^3yiV\fG.\u001b>fI2{wmZ3s\u0003\u001dawnZ4fe\u0002\n1#Z7qifdunZ4j]\u001e\u001cuN\u001c;fqR,\u0012!\u0015\t\u0003\u0013JK!a\u0015&\u0003\u001d1{wmZ5oO\u000e{g\u000e^3yi\u0006!R-\u001c9us2{wmZ5oO\u000e{g\u000e^3yi\u0002\n1b\u001c8IC247\t\\8tKR\tq\u000b\u0005\u0002*1&\u0011\u0011L\u000b\u0002\u0005+:LG\u000f")
public class ErrorListener<ReqT, RespT>
extends ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT> {
    private final ServerCall<ReqT, RespT> call;
    private final ContextualizedLogger logger;
    private final LoggingContext emptyLoggingContext;

    private ContextualizedLogger logger() {
        return this.logger;
    }

    private LoggingContext emptyLoggingContext() {
        return this.emptyLoggingContext;
    }

    public void onHalfClose() {
        try {
            super.onHalfClose();
        }
        catch (StatusException t) {
            LogOnUnhandledFailureInClose$.MODULE$.apply((JFunction0.mcV.sp & Serializable)() -> $this.call.close(t.getStatus(), t.getTrailers()));
        }
        catch (StatusRuntimeException t) {
            LogOnUnhandledFailureInClose$.MODULE$.apply((JFunction0.mcV.sp & Serializable)() -> $this.call.close(t.getStatus(), t.getTrailers()));
        }
        catch (Throwable t) {
            StatusRuntimeException e = new LedgerApiErrors.InternalError$.UnexpectedOrUnknownException(t, (ContextualizedErrorLogger)new DamlContextualizedErrorLogger(this.logger(), this.emptyLoggingContext(), (Option)None$.MODULE$)).asGrpcError();
            LogOnUnhandledFailureInClose$.MODULE$.apply((JFunction0.mcV.sp & Serializable)() -> $this.call.close(e.getStatus(), e.getTrailers()));
        }
    }

    public ErrorListener(ServerCall.Listener<ReqT> delegate, ServerCall<ReqT, RespT> call) {
        this.call = call;
        super(delegate);
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.emptyLoggingContext = (LoggingContext)LoggingContext$.MODULE$.newLoggingContext((Function1 & Serializable)x -> (LoggingContext)Predef$.MODULE$.identity(x));
    }
}

