/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver.execution;

import com.daml.daml_lf_dev.DamlLf;
import com.daml.error.definitions.ErrorCause;
import com.daml.ledger.api.domain;
import com.daml.ledger.configuration.Configuration;
import com.daml.ledger.participant.state.index.v2.ContractStore;
import com.daml.ledger.participant.state.index.v2.IndexPackagesService;
import com.daml.ledger.participant.state.v2.SubmitterInfo;
import com.daml.ledger.participant.state.v2.TransactionMeta;
import com.daml.lf.crypto.Hash;
import com.daml.lf.data.ImmArray$;
import com.daml.lf.engine.Engine;
import com.daml.lf.engine.Error;
import com.daml.lf.engine.Result;
import com.daml.lf.engine.ResultDone;
import com.daml.lf.engine.ResultError;
import com.daml.lf.engine.ResultNeedContract;
import com.daml.lf.engine.ResultNeedKey;
import com.daml.lf.engine.ResultNeedPackage;
import com.daml.lf.transaction.GlobalKey;
import com.daml.lf.transaction.GlobalKeyWithMaintainers;
import com.daml.lf.transaction.Node;
import com.daml.lf.transaction.NodeId;
import com.daml.lf.transaction.Transaction;
import com.daml.lf.transaction.VersionedTransaction;
import com.daml.lf.value.Value;
import com.daml.logging.LoggingContext;
import com.daml.metrics.Metrics;
import com.daml.metrics.Timed$;
import com.daml.platform.apiserver.execution.CommandExecutionResult;
import com.daml.platform.apiserver.execution.CommandExecutor;
import com.daml.platform.packages.DeduplicatingPackageLoader;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Try;
import scalaz.syntax.TagOps$;

@ScalaSignature(bytes="\u0006\u0005\t\rc!\u0002\b\u0010\u0005EI\u0002\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0014\t\u00115\u0002!\u0011!Q\u0001\n9B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"A!\n\u0001B\u0001B\u0003%1\n\u0003\u0005Q\u0001\t\u0005\t\u0015a\u0003R\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u0019\t\u0007\u0001)A\u0005E\")\u0001\u000e\u0001C!S\"9\u0011\u0011\r\u0001\u0005\n\u0005\r\u0004bBAS\u0001\u0011%\u0011q\u0015\u0005\b\u0003/\u0004A\u0011BAm\u0011\u001d\u00119\u0003\u0001C\u0005\u0005S\u0011!d\u0015;pe\u0016\u0014\u0015mY6fI\u000e{W.\\1oI\u0016CXmY;u_JT!\u0001E\t\u0002\u0013\u0015DXmY;uS>t'B\u0001\n\u0014\u0003%\t\u0007/[:feZ,'O\u0003\u0002\u0015+\u0005A\u0001\u000f\\1uM>\u0014XN\u0003\u0002\u0017/\u0005!A-Y7m\u0015\u0005A\u0012aA2p[N\u0019\u0001A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g!\t\t#%D\u0001\u0010\u0013\t\u0019sBA\bD_6l\u0017M\u001c3Fq\u0016\u001cW\u000f^8s\u0003\u0019)gnZ5oK\u000e\u0001\u0001CA\u0014,\u001b\u0005A#B\u0001\u0013*\u0015\tQS#\u0001\u0002mM&\u0011A\u0006\u000b\u0002\u0007\u000b:<\u0017N\\3\u0002\u0017A\f'\u000f^5dSB\fg\u000e\u001e\t\u0003_Ur!\u0001M\u001a\u000e\u0003ER!AM\u0015\u0002\t\u0011\fG/Y\u0005\u0003iE\n1AU3g\u0013\t1tGA\u0007QCJ$\u0018nY5qC:$\u0018\n\u001a\u0006\u0003iE\nq\u0002]1dW\u0006<Wm]*feZL7-\u001a\t\u0003u\u0011k\u0011a\u000f\u0006\u0003yu\n!A\u001e\u001a\u000b\u0005yz\u0014!B5oI\u0016D(B\u0001!B\u0003\u0015\u0019H/\u0019;f\u0015\ti#I\u0003\u0002D+\u00051A.\u001a3hKJL!!R\u001e\u0003)%sG-\u001a=QC\u000e\\\u0017mZ3t'\u0016\u0014h/[2f\u00035\u0019wN\u001c;sC\u000e$8\u000b^8sKB\u0011!\bS\u0005\u0003\u0013n\u0012QbQ8oiJ\f7\r^*u_J,\u0017aB7fiJL7m\u001d\t\u0003\u0019:k\u0011!\u0014\u0006\u0003\u0015VI!aT'\u0003\u000f5+GO]5dg\u0006\u0011Qm\u0019\t\u0003%Vk\u0011a\u0015\u0006\u0003)r\t!bY8oGV\u0014(/\u001a8u\u0013\t16K\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"b!\u0017/^=~\u0003GC\u0001.\\!\t\t\u0003\u0001C\u0003Q\u000f\u0001\u000f\u0011\u000bC\u0003%\u000f\u0001\u0007a\u0005C\u0003.\u000f\u0001\u0007a\u0006C\u00039\u000f\u0001\u0007\u0011\bC\u0003G\u000f\u0001\u0007q\tC\u0003K\u000f\u0001\u00071*A\u0007qC\u000e\\\u0017mZ3M_\u0006$WM\u001d\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003KN\t\u0001\u0002]1dW\u0006<Wm]\u0005\u0003O\u0012\u0014!\u0004R3ekBd\u0017nY1uS:<\u0007+Y2lC\u001e,Gj\\1eKJ\fq!\u001a=fGV$X\rF\u0004k\u00037\t\t%!\u0015\u0015\u0007-\fY\u0001E\u0002SY:L!!\\*\u0003\r\u0019+H/\u001e:f!\u0015ywO_A\u0003\u001d\t\u0001XO\u0004\u0002ri6\t!O\u0003\u0002tK\u00051AH]8pizJ\u0011!H\u0005\u0003mr\tq\u0001]1dW\u0006<W-\u0003\u0002ys\n1Q)\u001b;iKJT!A\u001e\u000f\u0011\u0007m\f\t!D\u0001}\u0015\tih0A\u0006eK\u001aLg.\u001b;j_:\u001c(BA@\u0016\u0003\u0015)'O]8s\u0013\r\t\u0019\u0001 \u0002\u000b\u000bJ\u0014xN]\"bkN,\u0007cA\u0011\u0002\b%\u0019\u0011\u0011B\b\u0003-\r{W.\\1oI\u0016CXmY;uS>t'+Z:vYRDq!!\u0004\n\u0001\b\ty!\u0001\bm_\u001e<\u0017N\\4D_:$X\r\u001f;\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006\u0016\u0003\u001dawnZ4j]\u001eLA!!\u0007\u0002\u0014\tqAj\\4hS:<7i\u001c8uKb$\bbBA\u000f\u0013\u0001\u0007\u0011qD\u0001\tG>lW.\u00198egB!\u0011\u0011EA\u001e\u001d\u0011\t\u0019#!\u000e\u000f\t\u0005\u0015\u0012\u0011\u0007\b\u0005\u0003O\tyC\u0004\u0003\u0002*\u00055bbA9\u0002,%\t\u0001$\u0003\u0002\u0017/%\u00111)F\u0005\u0004\u0003g\u0011\u0015aA1qS&!\u0011qGA\u001d\u0003\u0019!w.\\1j]*\u0019\u00111\u0007\"\n\t\u0005u\u0012q\b\u0002\t\u0007>lW.\u00198eg*!\u0011qGA\u001d\u0011\u001d\t\u0019%\u0003a\u0001\u0003\u000b\nab];c[&\u001c8/[8o'\u0016,G\r\u0005\u0003\u0002H\u00055SBAA%\u0015\r\tY%K\u0001\u0007GJL\b\u000f^8\n\t\u0005=\u0013\u0011\n\u0002\u0005\u0011\u0006\u001c\b\u000eC\u0004\u0002T%\u0001\r!!\u0016\u0002'1,GmZ3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0011\t\u0005]\u0013QL\u0007\u0003\u00033R1!a\u0017C\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&!\u0011qLA-\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u000612m\\7nC:$W\t_3dkRLwN\u001c*fgVdG\u000f\u0006\b\u0002\u0006\u0005\u0015\u0014qMA5\u0003W\n9)a'\t\u000f\u0005u!\u00021\u0001\u0002 !9\u00111\t\u0006A\u0002\u0005\u0015\u0003bBA*\u0015\u0001\u0007\u0011Q\u000b\u0005\b\u0003[R\u0001\u0019AA8\u0003!)\b\u000fZ1uKRC\b\u0003BA9\u0003\u0003sA!a\u001d\u0002~9!\u0011QOA=\u001d\u0011\t9#a\u001e\n\u0005)*\u0012bAA>S\u0005YAO]1og\u0006\u001cG/[8o\u0013\r1\u0018q\u0010\u0006\u0004\u0003wJ\u0013\u0002BAB\u0003\u000b\u0013AcU;c[&$H/\u001a3Ue\u0006t7/Y2uS>t'b\u0001<\u0002\u0000!9\u0011\u0011\u0012\u0006A\u0002\u0005-\u0015\u0001B7fi\u0006\u0004B!!$\u0002\u0016:!\u0011qRAI\u001b\t\ty(\u0003\u0003\u0002\u0014\u0006}\u0014a\u0003+sC:\u001c\u0018m\u0019;j_:LA!a&\u0002\u001a\nAQ*\u001a;bI\u0006$\u0018M\u0003\u0003\u0002\u0014\u0006}\u0004bBAO\u0015\u0001\u0007\u0011qT\u0001\u0018S:$XM\u001d9sKR\fG/[8o)&lWMT1o_N\u00042aGAQ\u0013\r\t\u0019\u000b\b\u0002\u0005\u0019>tw-\u0001\btk\nl\u0017\u000e\u001e+p\u000b:<\u0017N\\3\u0015\u0011\u0005%\u00161XA_\u0003\u007f#B!a+\u0002:B!!\u000b\\AW!\u00159\u0013qVAZ\u0013\r\t\t\f\u000b\u0002\u0007%\u0016\u001cX\u000f\u001c;\u0011\u000fm\t),a\u001c\u0002\f&\u0019\u0011q\u0017\u000f\u0003\rQ+\b\u000f\\33\u0011\u001d\tia\u0003a\u0002\u0003\u001fAq!!\b\f\u0001\u0004\ty\u0002C\u0004\u0002D-\u0001\r!!\u0012\t\u000f\u0005u5\u00021\u0001\u0002BB!\u00111YAj\u001b\t\t)M\u0003\u0003\u0002H\u0006%\u0017AB1u_6L7MC\u0002U\u0003\u0017TA!!4\u0002P\u0006!Q\u000f^5m\u0015\t\t\t.\u0001\u0003kCZ\f\u0017\u0002BAk\u0003\u000b\u0014!\"\u0011;p[&\u001cGj\u001c8h\u0003\u001d\u0019wN\\:v[\u0016,B!a7\u0002nRQ\u0011Q\u001cB\u0001\u00057\u0011yB!\n\u0015\t\u0005}\u0017q \t\u0005%2\f\t\u000f\u0005\u0004po\u0006\r\u0018\u0011\u001e\t\u0004O\u0005\u0015\u0018bAAtQ\t)QI\u001d:peB!\u00111^Aw\u0019\u0001!q!a<\r\u0005\u0004\t\tPA\u0001B#\u0011\t\u00190!?\u0011\u0007m\t)0C\u0002\u0002xr\u0011qAT8uQ&tw\rE\u0002\u001c\u0003wL1!!@\u001d\u0005\r\te.\u001f\u0005\b\u0003\u001ba\u00019AA\b\u0011\u001d\u0011\u0019\u0001\u0004a\u0001\u0005\u000b\tQ!Y2u\u0003N\u0004bAa\u0002\u0003\u0010\tUa\u0002\u0002B\u0005\u0005\u0017\u0001\"!\u001d\u000f\n\u0007\t5A$\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005#\u0011\u0019BA\u0002TKRT1A!\u0004\u001d!\ry#qC\u0005\u0004\u000539$!\u0002)beRL\bb\u0002B\u000f\u0019\u0001\u0007!QA\u0001\u0007e\u0016\fG-Q:\t\u000f\t\u0005B\u00021\u0001\u0003$\u00051!/Z:vYR\u0004RaJAX\u0003SDq!!(\r\u0001\u0004\t\t-\u0001\nue\u0006\u001c7nU=oG\u0016CXmY;uS>tW\u0003\u0002B\u0016\u0005c!BA!\f\u0003@Q!!q\u0006B\u001b!\u0011\tYO!\r\u0005\u000f\tMRB1\u0001\u0002r\n\tA\u000b\u0003\u0005\u000385!\t\u0019\u0001B\u001d\u0003-\u0019w.\u001c9vi\u0006$\u0018n\u001c8\u0011\u000bm\u0011YDa\f\n\u0007\tuBD\u0001\u0005=Eft\u0017-\\3?\u0011\u001d\u0011\t%\u0004a\u0001\u0003\u0003\f!\"\u0019;p[&\u001cg*\u00198p\u0001")
public final class StoreBackedCommandExecutor
implements CommandExecutor {
    private final Engine engine;
    private final String participant;
    private final IndexPackagesService packagesService;
    private final ContractStore contractStore;
    public final Metrics com$daml$platform$apiserver$execution$StoreBackedCommandExecutor$$metrics;
    private final ExecutionContext ec;
    private final DeduplicatingPackageLoader packageLoader;

    @Override
    public Future<Either<ErrorCause, CommandExecutionResult>> execute(domain.Commands commands, Hash submissionSeed, Configuration ledgerConfiguration2, LoggingContext loggingContext) {
        AtomicLong interpretationTimeNanos = new AtomicLong(0L);
        long start2 = System.nanoTime();
        return this.submitToEngine(commands, submissionSeed, interpretationTimeNanos, loggingContext).flatMap((Function1 & Serializable)submissionResult -> this.consume((Set<String>)commands.actAs(), (Set<String>)commands.readAs(), (Result)submissionResult, interpretationTimeNanos, loggingContext).map((Function1 & Serializable)submission -> submission.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            VersionedTransaction updateTx = (VersionedTransaction)tuple2._1();
            Transaction.Metadata meta = (Transaction.Metadata)tuple2._2();
            long interpretationTimeNanos = System.nanoTime() - start2;
            CommandExecutionResult commandExecutionResult2 = this.commandExecutionResult(commands, submissionSeed, ledgerConfiguration2, updateTx, meta, interpretationTimeNanos);
            return commandExecutionResult2;
        }).left().map((Function1)ErrorCause.DamlLf$.MODULE$), $this.ec), this.ec);
    }

    private CommandExecutionResult commandExecutionResult(domain.Commands commands, Hash submissionSeed, Configuration ledgerConfiguration2, VersionedTransaction updateTx, Transaction.Metadata meta, long interpretationTimeNanos) {
        return new CommandExecutionResult(new SubmitterInfo(commands.actAs().toList(), commands.readAs().toList(), commands.applicationId(), (String)TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(commands.commandId())), commands.deduplicationPeriod(), commands.submissionId().map((Function1 & Serializable)x$1 -> (String)TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(x$1))), ledgerConfiguration2), new TransactionMeta(commands.commands().ledgerEffectiveTime(), commands.workflowId().map((Function1 & Serializable)x$2 -> (String)TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(x$2))), meta.submissionTime(), submissionSeed, (Option)new Some((Object)meta.usedPackages()), (Option)new Some((Object)meta.nodeSeeds()), (Option)new Some(((IterableOnceOps)updateTx.nodes().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<NodeId, Node>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    Node.Action action;
                    NodeId nodeId = (NodeId)A1._1();
                    Node node = (Node)A1._2();
                    if (node instanceof Node.Action && (action = (Node.Action)node).byKey()) {
                        object = nodeId;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<NodeId, Node> x1) {
                Node.Action action;
                Node node;
                Tuple2<NodeId, Node> tuple2 = x1;
                boolean bl = tuple2 != null && (node = (Node)tuple2._2()) instanceof Node.Action && (action = (Node.Action)node).byKey();
                return bl;
            }
        })).to(IterableFactory$.MODULE$.toFactory((IterableFactory)ImmArray$.MODULE$)))), updateTx, meta.dependsOnTime(), interpretationTimeNanos, (Map<GlobalKey, Option<Value.ContractId>>)meta.globalKeyMapping());
    }

    private Future<Result<Tuple2<VersionedTransaction, Transaction.Metadata>>> submitToEngine(domain.Commands commands, Hash submissionSeed, AtomicLong interpretationTimeNanos, LoggingContext loggingContext) {
        return Timed$.MODULE$.trackedFuture(this.com$daml$platform$apiserver$execution$StoreBackedCommandExecutor$$metrics.daml().execution().engineRunning(), (Function0 & Serializable)() -> Future$.MODULE$.apply((Function0 & Serializable)() -> (Result)this.trackSyncExecution(interpretationTimeNanos, (Function0 & Serializable)() -> {
            Set commitAuthorizers = commands.actAs();
            return $this.engine.submit(commitAuthorizers, commands.readAs(), commands.commands(), ImmArray$.MODULE$.empty(), $this.participant, submissionSeed, loggingContext);
        }), $this.ec));
    }

    private <A> Future<Either<Error, A>> consume(Set<String> actAs, Set<String> readAs, Result<A> result, AtomicLong interpretationTimeNanos, LoggingContext loggingContext) {
        Set readers = (Set)actAs.$plus$plus(readAs);
        AtomicLong lookupActiveContractTime = new AtomicLong(0L);
        AtomicLong lookupActiveContractCount = new AtomicLong(0L);
        AtomicLong lookupContractKeyTime = new AtomicLong(0L);
        AtomicLong lookupContractKeyCount = new AtomicLong(0L);
        return this.resolveStep$1(result, readers, loggingContext, lookupActiveContractTime, lookupActiveContractCount, interpretationTimeNanos, lookupContractKeyTime, lookupContractKeyCount).andThen((PartialFunction)new Serializable(this, lookupActiveContractTime, lookupActiveContractCount, lookupContractKeyTime, lookupContractKeyCount, interpretationTimeNanos){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ StoreBackedCommandExecutor $outer;
            private final AtomicLong lookupActiveContractTime$1;
            private final AtomicLong lookupActiveContractCount$1;
            private final AtomicLong lookupContractKeyTime$1;
            private final AtomicLong lookupContractKeyCount$1;
            private final AtomicLong interpretationTimeNanos$3;

            public final <A1 extends Try<Either<Error, A>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.$outer.com$daml$platform$apiserver$execution$StoreBackedCommandExecutor$$metrics.daml().execution().lookupActiveContractPerExecution().update(this.lookupActiveContractTime$1.get(), TimeUnit.NANOSECONDS);
                this.$outer.com$daml$platform$apiserver$execution$StoreBackedCommandExecutor$$metrics.daml().execution().lookupActiveContractCountPerExecution().update(this.lookupActiveContractCount$1.get());
                this.$outer.com$daml$platform$apiserver$execution$StoreBackedCommandExecutor$$metrics.daml().execution().lookupContractKeyPerExecution().update(this.lookupContractKeyTime$1.get(), TimeUnit.NANOSECONDS);
                this.$outer.com$daml$platform$apiserver$execution$StoreBackedCommandExecutor$$metrics.daml().execution().lookupContractKeyCountPerExecution().update(this.lookupContractKeyCount$1.get());
                this.$outer.com$daml$platform$apiserver$execution$StoreBackedCommandExecutor$$metrics.daml().execution().engine().update(this.interpretationTimeNanos$3.get(), TimeUnit.NANOSECONDS);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (B1)boxedUnit;
            }

            public final boolean isDefinedAt(Try<Either<Error, A>> x1) {
                Try<Either<Error, A>> try_ = x1;
                boolean bl = true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.lookupActiveContractTime$1 = lookupActiveContractTime$1;
                this.lookupActiveContractCount$1 = lookupActiveContractCount$1;
                this.lookupContractKeyTime$1 = lookupContractKeyTime$1;
                this.lookupContractKeyCount$1 = lookupContractKeyCount$1;
                this.interpretationTimeNanos$3 = interpretationTimeNanos$3;
            }
        }, this.ec);
    }

    private <T> T trackSyncExecution(AtomicLong atomicNano, Function0<T> computation) {
        long start2 = System.nanoTime();
        Object result = computation.apply();
        atomicNano.addAndGet(System.nanoTime() - start2);
        return (T)result;
    }

    private final Future resolveStep$1(Result result, Set readers$1, LoggingContext loggingContext$3, AtomicLong lookupActiveContractTime$1, AtomicLong lookupActiveContractCount$1, AtomicLong interpretationTimeNanos$3, AtomicLong lookupContractKeyTime$1, AtomicLong lookupContractKeyCount$1) {
        Future future;
        Result result2 = result;
        if (result2 instanceof ResultDone) {
            ResultDone resultDone = (ResultDone)result2;
            Object r = resultDone.result();
            future = Future$.MODULE$.successful((Object)package$.MODULE$.Right().apply(r));
        } else if (result2 instanceof ResultError) {
            ResultError resultError = (ResultError)result2;
            Error err = resultError.err();
            future = Future$.MODULE$.successful((Object)package$.MODULE$.Left().apply((Object)err));
        } else if (result2 instanceof ResultNeedContract) {
            ResultNeedContract resultNeedContract = (ResultNeedContract)result2;
            Value.ContractId acoid = resultNeedContract.acoid();
            Function1 resume = resultNeedContract.resume();
            long start2 = System.nanoTime();
            future = Timed$.MODULE$.future(this.com$daml$platform$apiserver$execution$StoreBackedCommandExecutor$$metrics.daml().execution().lookupActiveContract(), (Function0 & Serializable)() -> $this.contractStore.lookupActiveContract(readers$1, acoid, loggingContext$3)).flatMap((Function1 & Serializable)instance -> {
                lookupActiveContractTime$1.addAndGet(System.nanoTime() - start2);
                lookupActiveContractCount$1.incrementAndGet();
                return this.resolveStep$1((Result)Timed$.MODULE$.trackedValue($this.com$daml$platform$apiserver$execution$StoreBackedCommandExecutor$$metrics.daml().execution().engineRunning(), (Function0 & Serializable)() -> (Result)this.trackSyncExecution(interpretationTimeNanos$3, (Function0 & Serializable)() -> (Result)resume.apply(instance))), readers$1, loggingContext$3, lookupActiveContractTime$1, lookupActiveContractCount$1, interpretationTimeNanos$3, lookupContractKeyTime$1, lookupContractKeyCount$1);
            }, this.ec);
        } else if (result2 instanceof ResultNeedKey) {
            ResultNeedKey resultNeedKey = (ResultNeedKey)result2;
            GlobalKeyWithMaintainers key = resultNeedKey.key();
            Function1 resume = resultNeedKey.resume();
            long start3 = System.nanoTime();
            future = Timed$.MODULE$.future(this.com$daml$platform$apiserver$execution$StoreBackedCommandExecutor$$metrics.daml().execution().lookupContractKey(), (Function0 & Serializable)() -> $this.contractStore.lookupContractKey(readers$1, key.globalKey(), loggingContext$3)).flatMap((Function1 & Serializable)contractId -> {
                lookupContractKeyTime$1.addAndGet(System.nanoTime() - start3);
                lookupContractKeyCount$1.incrementAndGet();
                return this.resolveStep$1((Result)Timed$.MODULE$.trackedValue($this.com$daml$platform$apiserver$execution$StoreBackedCommandExecutor$$metrics.daml().execution().engineRunning(), (Function0 & Serializable)() -> (Result)this.trackSyncExecution(interpretationTimeNanos$3, (Function0 & Serializable)() -> (Result)resume.apply(contractId))), readers$1, loggingContext$3, lookupActiveContractTime$1, lookupActiveContractCount$1, interpretationTimeNanos$3, lookupContractKeyTime$1, lookupContractKeyCount$1);
            }, this.ec);
        } else if (result2 instanceof ResultNeedPackage) {
            ResultNeedPackage resultNeedPackage = (ResultNeedPackage)result2;
            String packageId2 = resultNeedPackage.packageId();
            Function1 resume = resultNeedPackage.resume();
            future = this.packageLoader.loadPackage(packageId2, (Function1<String, Future<Option<DamlLf.Archive>>>)(Function1 & Serializable)packageId -> $this.packagesService.getLfArchive(packageId, loggingContext$3), this.com$daml$platform$apiserver$execution$StoreBackedCommandExecutor$$metrics.daml().execution().getLfPackage(), this.ec).flatMap((Function1 & Serializable)maybePackage -> this.resolveStep$1((Result)Timed$.MODULE$.trackedValue($this.com$daml$platform$apiserver$execution$StoreBackedCommandExecutor$$metrics.daml().execution().engineRunning(), (Function0 & Serializable)() -> (Result)this.trackSyncExecution(interpretationTimeNanos$3, (Function0 & Serializable)() -> (Result)resume.apply(maybePackage))), readers$1, loggingContext$3, lookupActiveContractTime$1, lookupActiveContractCount$1, interpretationTimeNanos$3, lookupContractKeyTime$1, lookupContractKeyCount$1), this.ec);
        } else {
            throw new MatchError((Object)result2);
        }
        return future;
    }

    public StoreBackedCommandExecutor(Engine engine, String participant, IndexPackagesService packagesService, ContractStore contractStore, Metrics metrics, ExecutionContext ec) {
        this.engine = engine;
        this.participant = participant;
        this.packagesService = packagesService;
        this.contractStore = contractStore;
        this.com$daml$platform$apiserver$execution$StoreBackedCommandExecutor$$metrics = metrics;
        this.ec = ec;
        this.packageLoader = new DeduplicatingPackageLoader();
    }
}

