/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.apiserver.services.tracking;

import akka.Done;
import akka.NotUsed;
import akka.stream.BoundedSourceQueue;
import akka.stream.Materializer;
import akka.stream.QueueOfferResult;
import akka.stream.scaladsl.Flow;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.definitions.LedgerApiErrors;
import com.daml.ledger.client.services.commands.CommandSubmission;
import com.daml.ledger.client.services.commands.CommandTrackerFlow;
import com.daml.ledger.client.services.commands.tracker.CompletionResponse;
import com.daml.logging.LoggingContext;
import com.daml.platform.apiserver.services.tracking.QueueBackedTracker$;
import com.daml.platform.apiserver.services.tracking.Tracker;
import com.daml.util.Ctx;
import com.daml.util.Ctx$;
import com.google.rpc.Status;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005-h!B\b\u0011\u0005Ia\u0002\u0002C\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\t\u0015\u0005u\u0004A!A!\u0002\u0013\ty\b\u0003\u0005T\u0001\t\u0005\t\u0015a\u0003U\u0011\u0019q\u0004\u0001\"\u0001\u0002\f\"9\u0011Q\u0013\u0001\u0005B\u0005]\u0005bBA[\u0001\u0011%\u0011q\u0017\u0005\b\u0003C\u0004A\u0011IAr\u000f\u0019)\u0004\u0003#\u0001\u0013m\u00191q\u0002\u0005E\u0001%]BQAP\u0005\u0005\u0002}Bq\u0001Q\u0005C\u0002\u0013%\u0011\t\u0003\u0004I\u0013\u0001\u0006IA\u0011\u0005\u0006\u0013&!\tAS\u0003\u0006\u0003wJ\u0001a\u0018\u0002\u0013#V,W/\u001a\"bG.,G\r\u0016:bG.,'O\u0003\u0002\u0012%\u0005AAO]1dW&twM\u0003\u0002\u0014)\u0005A1/\u001a:wS\u000e,7O\u0003\u0002\u0016-\u0005I\u0011\r]5tKJ4XM\u001d\u0006\u0003/a\t\u0001\u0002\u001d7bi\u001a|'/\u001c\u0006\u00033i\tA\u0001Z1nY*\t1$A\u0002d_6\u001c2\u0001A\u000f&!\tq2%D\u0001 \u0015\t\u0001\u0013%\u0001\u0003mC:<'\"\u0001\u0012\u0002\t)\fg/Y\u0005\u0003I}\u0011aa\u00142kK\u000e$\bC\u0001\u0014(\u001b\u0005\u0001\u0012B\u0001\u0015\u0011\u0005\u001d!&/Y2lKJ\fQ!];fk\u0016\u001c\u0001\u0001E\u0002-cMj\u0011!\f\u0006\u0003]=\naa\u001d;sK\u0006l'\"\u0001\u0019\u0002\t\u0005\\7.Y\u0005\u0003e5\u0012!CQ8v]\u0012,GmU8ve\u000e,\u0017+^3vKB\u0011AG\u0004\b\u0003M!\t!#U;fk\u0016\u0014\u0015mY6fIR\u0013\u0018mY6feB\u0011a%C\n\u0003\u0013a\u0002\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00017\u0003\u0019awnZ4feV\t!\t\u0005\u0002D\r6\tAI\u0003\u0002F1\u00059An\\4hS:<\u0017BA$E\u0005Q\u0019uN\u001c;fqR,\u0018\r\\5{K\u0012dunZ4fe\u00069An\\4hKJ\u0004\u0013!B1qa2LHCC&X\u0003\u001f\nI&!\u001c\u0002rQ\u0019A*\u0014*\u0011\u0005\u0019\u0002\u0001\"\u0002(\u000e\u0001\by\u0015\u0001D7bi\u0016\u0014\u0018.\u00197ju\u0016\u0014\bC\u0001\u0017Q\u0013\t\tVF\u0001\u0007NCR,'/[1mSj,'\u000fC\u0003T\u001b\u0001\u000fA+\u0001\bm_\u001e<\u0017N\\4D_:$X\r\u001f;\u0011\u0005\r+\u0016B\u0001,E\u00059aunZ4j]\u001e\u001cuN\u001c;fqRDQ\u0001W\u0007A\u0002e\u000bq\u0001\u001e:bG.,'\u000fE\u0004[;~\u000b9$!\u000f\u000e\u0003mS!\u0001X\u0017\u0002\u0011M\u001c\u0017\r\\1eg2L!AX.\u0003\t\u0019cwn\u001e\t\u0006A\u000e,\u0017qF\u0007\u0002C*\u0011!\rG\u0001\u0005kRLG.\u0003\u0002eC\n\u00191\t\u001e=\u0011\u0007\u0019L7.D\u0001h\u0015\tA'(\u0001\u0006d_:\u001cWO\u001d:f]RL!A[4\u0003\u000fA\u0013x.\\5tKB)A\u000e^<\u0002*9\u0011QN\u001d\b\u0003]Fl\u0011a\u001c\u0006\u0003a*\na\u0001\u0010:p_Rt\u0014\"A\u001e\n\u0005MT\u0014a\u00029bG.\fw-Z\u0005\u0003kZ\u0014a!R5uQ\u0016\u0014(BA:;!\rA\u00181\u0005\b\u0004s\u0006uab\u0001>\u0002\u001a9\u001910a\u0005\u000f\u0007q\fyAD\u0002~\u0003\u0013q1A`A\u0003\u001d\ry\u00181\u0001\b\u0004]\u0006\u0005\u0011\"A\u000e\n\u0005eQ\u0012bAA\u00041\u00051A.\u001a3hKJLA!a\u0003\u0002\u000e\u000511\r\\5f]RT1!a\u0002\u0019\u0013\r\u0019\u0012\u0011\u0003\u0006\u0005\u0003\u0017\ti!\u0003\u0003\u0002\u0016\u0005]\u0011\u0001C2p[6\fg\u000eZ:\u000b\u0007M\t\t\"C\u0002Y\u00037QA!!\u0006\u0002\u0018%!\u0011qDA\u0011\u0003I\u0019u.\u001c9mKRLwN\u001c*fgB|gn]3\u000b\u0007a\u000bY\"\u0003\u0003\u0002&\u0005\u001d\"!E\"p[BdW\r^5p]\u001a\u000b\u0017\u000e\\;sK*!\u0011qDA\u0011!\rA\u00181F\u0005\u0005\u0003[\t9CA\tD_6\u0004H.\u001a;j_:\u001cVoY2fgN\u0004B!!\r\u000245\u0011\u00111D\u0005\u0005\u0003k\tYBA\tD_6l\u0017M\u001c3Tk\nl\u0017n]:j_:\u0004B\u0001Y2fWB9\u00111HA!\u0003\u000f*gb\u0001>\u0002>%!\u0011qHA\u000e\u0003I\u0019u.\\7b]\u0012$&/Y2lKJ4En\\<\n\t\u0005\r\u0013Q\t\u0002\r\u001b\u0006$XM]5bY&TX\r\u001a\u0006\u0005\u0003\u007f\tY\u0002\u0005\u0003\u0002J\u0005-S\"A\u0018\n\u0007\u00055sFA\u0004O_R,6/\u001a3\t\u000f\u0005ES\u00021\u0001\u0002T\u0005y\u0011N\u001c9vi\n+hMZ3s'&TX\rE\u0002:\u0003+J1!a\u0016;\u0005\rIe\u000e\u001e\u0005\b\u00037j\u0001\u0019AA/\u0003=\u0019\u0017\r]1dSRL8i\\;oi\u0016\u0014\b\u0003BA0\u0003Sj!!!\u0019\u000b\t\u0005\r\u0014QM\u0001\b[\u0016$(/[2t\u0015\r\t9GG\u0001\tG>$\u0017\r[1mK&!\u00111NA1\u0005\u001d\u0019u.\u001e8uKJDq!a\u001c\u000e\u0001\u0004\ti&A\u0007mK:<G\u000f[\"pk:$XM\u001d\u0005\b\u0003gj\u0001\u0019AA;\u0003)!W\r\\1z)&lWM\u001d\t\u0005\u0003?\n9(\u0003\u0003\u0002z\u0005\u0005$!\u0002+j[\u0016\u0014(AC)vKV,\u0017J\u001c9vi\u0006!Am\u001c8f!\u00151\u0017\u0011QAC\u0013\r\t\u0019i\u001a\u0002\u0007\rV$XO]3\u0011\t\u0005%\u0013qQ\u0005\u0004\u0003\u0013{#\u0001\u0002#p]\u0016$b!!$\u0002\u0012\u0006MEc\u0001'\u0002\u0010\")1\u000b\u0002a\u0002)\")\u0011\u0006\u0002a\u0001W!9\u0011Q\u0010\u0003A\u0002\u0005}\u0014!\u0002;sC\u000e\\G\u0003BAM\u0003c#b!a'\u0002&\u0006=\u0006#\u00024\u0002\u0002\u0006u\u0005C\u00027u\u0003?\u000bI\u0003E\u0002y\u0003CKA!a)\u0002(\tABK]1dW\u0016$7i\\7qY\u0016$\u0018n\u001c8GC&dWO]3\t\u000f\u0005\u001dV\u0001q\u0001\u0002*\u0006\u0001R\r_3dkRLwN\\\"p]R,\u0007\u0010\u001e\t\u0004M\u0006-\u0016bAAWO\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u0006'\u0016\u0001\u001d\u0001\u0016\u0005\b\u0003g+\u0001\u0019AA\u0018\u0003)\u0019XOY7jgNLwN\\\u0001\u0015i>\fV/Z;f'V\u0014W.\u001b;GC&dWO]3\u0015\t\u0005e\u0016Q\u001a\t\u0006M\u0006\u0005\u00151\u0018\t\bY\u0006u\u0016\u0011YAd\u0013\r\tyL\u001e\u0002\u0005\u0019\u00164G\u000fE\u0002y\u0003\u0007LA!!2\u0002(\t\u0011\u0012+^3vKN+(-\\5u\r\u0006LG.\u001e:f!\rI\u0014\u0011Z\u0005\u0004\u0003\u0017T$a\u0002(pi\"Lgn\u001a\u0005\b\u0003\u001f4\u0001\u0019AAi\u0003\u0005)\u0007\u0003BAj\u0003;l!!!6\u000b\t\u0005]\u0017\u0011\\\u0001\u0004eB\u001c'bAAn5\u00051qm\\8hY\u0016LA!a8\u0002V\n11\u000b^1ukN\fQa\u00197pg\u0016$\"!!:\u0011\u0007e\n9/C\u0002\u0002jj\u0012A!\u00168ji\u0002")
public final class QueueBackedTracker
implements Tracker {
    private final BoundedSourceQueue<Ctx<Promise<Either<CompletionResponse.CompletionFailure, CompletionResponse.CompletionSuccess>>, CommandSubmission>> queue;
    private final Future<Done> done;
    private final LoggingContext loggingContext;

    public static QueueBackedTracker apply(Flow<Ctx<Promise<Either<CompletionResponse.CompletionFailure, CompletionResponse.CompletionSuccess>>, CommandSubmission>, Ctx<Promise<Either<CompletionResponse.CompletionFailure, CompletionResponse.CompletionSuccess>>, Either<CompletionResponse.CompletionFailure, CompletionResponse.CompletionSuccess>>, CommandTrackerFlow.Materialized<NotUsed, Promise<Either<CompletionResponse.CompletionFailure, CompletionResponse.CompletionSuccess>>>> tracker, int inputBufferSize, Counter capacityCounter, Counter lengthCounter, Timer delayTimer, Materializer materializer, LoggingContext loggingContext) {
        return QueueBackedTracker$.MODULE$.apply(tracker, inputBufferSize, capacityCounter, lengthCounter, delayTimer, materializer, loggingContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Future<Either<CompletionResponse.TrackedCompletionFailure, CompletionResponse.CompletionSuccess>> track(CommandSubmission submission, ExecutionContext executionContext, LoggingContext loggingContext) {
        QueueOfferResult queueOfferResult;
        QueueOfferResult queueOfferResult2;
        QueueOfferResult queueOfferResult3;
        DamlContextualizedErrorLogger errorLogger = new DamlContextualizedErrorLogger(QueueBackedTracker$.MODULE$.com$daml$platform$apiserver$services$tracking$QueueBackedTracker$$logger(), loggingContext, (Option)new Some((Object)submission.commands().submissionId()));
        QueueBackedTracker$.MODULE$.com$daml$platform$apiserver$services$tracking$QueueBackedTracker$$logger().trace().apply((Function0 & Serializable)() -> "Tracking command", loggingContext);
        Promise trackedPromise = Promise$.MODULE$.apply();
        boolean bl = false;
        Success success = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.queue.offer((Object)new Ctx((Object)trackedPromise, (Object)submission, Ctx$.MODULE$.apply$default$3())));
        if (try_ instanceof Success) {
            bl = true;
            success = (Success)try_;
            QueueOfferResult queueOfferResult4 = (QueueOfferResult)success.value();
            if (QueueOfferResult.Enqueued$.MODULE$.equals(queueOfferResult4)) {
                return trackedPromise.future().map((Function1 & Serializable)x$1 -> x$1.left().map((Function1 & Serializable)completionFailure -> new CompletionResponse.QueueCompletionFailure(completionFailure)), executionContext);
            }
        }
        if (bl && (queueOfferResult3 = (QueueOfferResult)success.value()) instanceof QueueOfferResult.Failure) {
            QueueOfferResult.Failure failure = (QueueOfferResult.Failure)queueOfferResult3;
            Throwable throwable = failure.cause();
            return this.toQueueSubmitFailure(new LedgerApiErrors.InternalError$.Generic(new StringBuilder(21).append("Failed to enqueue: ").append(throwable.getClass().getSimpleName()).append(": ").append(throwable.getMessage()).toString(), (Option)new Some((Object)throwable), (ContextualizedErrorLogger)errorLogger).asGrpcStatus());
        }
        if (bl && QueueOfferResult.Dropped$.MODULE$.equals(queueOfferResult2 = (QueueOfferResult)success.value())) {
            return this.toQueueSubmitFailure(new LedgerApiErrors.ParticipantBackpressure$.Rejection("The submission ingress buffer is full", (ContextualizedErrorLogger)errorLogger).asGrpcStatus());
        }
        if (bl && QueueOfferResult.QueueClosed$.MODULE$.equals(queueOfferResult = (QueueOfferResult)success.value())) {
            return this.toQueueSubmitFailure(new LedgerApiErrors.ServiceNotRunning$.Reject("Command service queue", (ContextualizedErrorLogger)errorLogger).asGrpcStatus());
        }
        if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
        Failure failure = (Failure)try_;
        Throwable throwable = failure.exception();
        return this.toQueueSubmitFailure(new LedgerApiErrors.InternalError$.Generic(new StringBuilder(51).append("Unexpected `BoundedSourceQueue.offer` exception: ").append(throwable.getClass().getSimpleName()).append(": ").append(throwable.getMessage()).toString(), (Option)new Some((Object)throwable), (ContextualizedErrorLogger)errorLogger).asGrpcStatus());
    }

    private Future<Left<CompletionResponse.QueueSubmitFailure, Nothing$>> toQueueSubmitFailure(Status e) {
        return Future$.MODULE$.successful((Object)package$.MODULE$.Left().apply((Object)new CompletionResponse.QueueSubmitFailure(e)));
    }

    @Override
    public void close() {
        QueueBackedTracker$.MODULE$.com$daml$platform$apiserver$services$tracking$QueueBackedTracker$$logger().debug().apply((Function0 & Serializable)() -> "Shutting down tracking component.", this.loggingContext);
        this.queue.complete();
        Await$.MODULE$.result(this.done, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds());
    }

    public QueueBackedTracker(BoundedSourceQueue<Ctx<Promise<Either<CompletionResponse.CompletionFailure, CompletionResponse.CompletionSuccess>>, CommandSubmission>> queue, Future<Done> done, LoggingContext loggingContext) {
        this.queue = queue;
        this.done = done;
        this.loggingContext = loggingContext;
    }
}

