/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.index;

import akka.NotUsed;
import akka.stream.Materializer;
import akka.stream.scaladsl.Source;
import com.daml.daml_lf_dev.DamlLf;
import com.daml.error.definitions.IndexErrors;
import com.daml.ledger.offset.Offset;
import com.daml.ledger.offset.Offset$;
import com.daml.ledger.participant.state.index.v2.IndexService;
import com.daml.ledger.resources.ResourceContext;
import com.daml.ledger.resources.ResourceOwner$;
import com.daml.lf.engine.ValueEnricher;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.metrics.Metrics;
import com.daml.platform.akkastreams.dispatcher.Dispatcher;
import com.daml.platform.akkastreams.dispatcher.Dispatcher$;
import com.daml.platform.akkastreams.dispatcher.SubSource;
import com.daml.platform.common.LedgerIdNotFoundException;
import com.daml.platform.common.MismatchException;
import com.daml.platform.configuration.IndexServiceConfig;
import com.daml.platform.index.BuffersUpdater;
import com.daml.platform.index.BuffersUpdater$;
import com.daml.platform.index.IndexServiceBuilder$;
import com.daml.platform.index.IndexServiceImpl;
import com.daml.platform.index.InstrumentedSignalNewLedgerHead;
import com.daml.platform.index.InstrumentedSignalNewLedgerHead$;
import com.daml.platform.index.LedgerEndPoller;
import com.daml.platform.package$;
import com.daml.platform.store.DbSupport;
import com.daml.platform.store.EventSequentialId$;
import com.daml.platform.store.LfValueTranslationCache;
import com.daml.platform.store.backend.ParameterStorageBackend;
import com.daml.platform.store.backend.StringInterningStorageBackend;
import com.daml.platform.store.cache.ContractStateCaches$;
import com.daml.platform.store.cache.EventsBuffer;
import com.daml.platform.store.cache.LedgerEndCache;
import com.daml.platform.store.cache.MutableCacheBackedContractStore;
import com.daml.platform.store.cache.MutableCacheBackedContractStore$CacheUpdateSubscription$;
import com.daml.platform.store.cache.MutableLedgerEndCache;
import com.daml.platform.store.cache.MutableLedgerEndCache$;
import com.daml.platform.store.dao.JdbcLedgerDao$;
import com.daml.platform.store.dao.LedgerDaoTransactionsReader;
import com.daml.platform.store.dao.LedgerReadDao;
import com.daml.platform.store.dao.events.BufferedTransactionsReader;
import com.daml.platform.store.dao.events.BufferedTransactionsReader$;
import com.daml.platform.store.dao.events.ContractStateEvent;
import com.daml.platform.store.dao.events.LfValueTranslation;
import com.daml.platform.store.interfaces.TransactionLogUpdate;
import com.daml.platform.store.interning.LoadStringInterningEntries;
import com.daml.platform.store.interning.StringInterning;
import com.daml.platform.store.interning.StringInterningView;
import com.daml.platform.store.interning.UpdatingStringInterningView;
import com.daml.resources.AbstractResourceOwner;
import com.daml.resources.ProgramResource;
import com.daml.timer.RetryStrategy$;
import java.io.Serializable;
import java.sql.Connection;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple9;
import scala.collection.Iterator;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.control.NoStackTrace;

@ScalaSignature(bytes="\u0006\u0005\u0011=b!B\u001f?\u0001\u00023\u0005\u0002C/\u0001\u0005+\u0007I\u0011\u00010\t\u0011\u0015\u0004!\u0011#Q\u0001\n}C\u0001B\u001a\u0001\u0003\u0016\u0004%\ta\u001a\u0005\t]\u0002\u0011\t\u0012)A\u0005Q\"Aq\u000e\u0001BK\u0002\u0013\u0005\u0001\u000fC\u0005\u0002\n\u0001\u0011\t\u0012)A\u0005c\"Q\u00111\u0002\u0001\u0003\u0016\u0004%\t!!\u0004\t\u0015\u0005m\u0001A!E!\u0002\u0013\ty\u0001\u0003\u0006\u0002\u001e\u0001\u0011)\u001a!C\u0001\u0003?A!\"a\u000b\u0001\u0005#\u0005\u000b\u0011BA\u0011\u0011)\ti\u0003\u0001BK\u0002\u0013\u0005\u0011q\u0006\u0005\u000b\u0003\u007f\u0001!\u0011#Q\u0001\n\u0005E\u0002BCA!\u0001\tU\r\u0011\"\u0001\u0002D!Q\u0011Q\u000b\u0001\u0003\u0012\u0003\u0006I!!\u0012\t\u0015\u0005]\u0003A!f\u0001\n\u0003\tI\u0006\u0003\u0006\u0002p\u0001\u0011\t\u0012)A\u0005\u00037B!\"!\u001d\u0001\u0005+\u0007I\u0011AA:\u0011)\t9\t\u0001B\tB\u0003%\u0011Q\u000f\u0005\u000b\u0003\u0013\u0003!\u0011!Q\u0001\f\u0005-\u0005BCAN\u0001\t\u0005\t\u0015a\u0003\u0002\u001e\"Q\u0011\u0011\u0016\u0001\u0003\u0002\u0003\u0006Y!a\u0004\t\u000f\u0005-\u0006\u0001\"\u0001\u0002.\"I\u0011Q\u001a\u0001C\u0002\u0013%\u0011q\u001a\u0005\t\u0003/\u0004\u0001\u0015!\u0003\u0002R\"9\u0011\u0011\u001c\u0001\u0005\u0002\u0005m\u0007b\u0002B\u0004\u0001\u0011%!\u0011\u0002\u0005\b\u0005[\u0002A\u0011\u0002B8\u0011\u001d\u00119\b\u0001C\u0005\u0005sBqA!%\u0001\t\u0013\u0011\u0019\nC\u0004\u0003D\u0002!IA!2\t\u000f\t]\b\u0001\"\u0003\u0003z\"9!q \u0001\u0005\n\r\u0005\u0001bBB\u0004\u0001\u0011%1\u0011\u0002\u0005\b\u00073\u0001A\u0011BB\u000e\u0011%\u0019I\u0003AA\u0001\n\u0003\u0019Y\u0003C\u0005\u0004H\u0001\t\n\u0011\"\u0001\u0004J!I1q\f\u0001\u0012\u0002\u0013\u00051\u0011\r\u0005\n\u0007K\u0002\u0011\u0013!C\u0001\u0007OB\u0011ba\u001b\u0001#\u0003%\ta!\u001c\t\u0013\rE\u0004!%A\u0005\u0002\rM\u0004\"CB<\u0001E\u0005I\u0011AB=\u0011%\u0019i\bAI\u0001\n\u0003\u0019y\bC\u0005\u0004\u0004\u0002\t\n\u0011\"\u0001\u0004\u0006\"I1\u0011\u0012\u0001\u0012\u0002\u0013\u000511\u0012\u0005\n\u0007\u001f\u0003\u0011\u0011!C!\u0007#C\u0011ba)\u0001\u0003\u0003%\ta!*\t\u0013\r5\u0006!!A\u0005\u0002\r=\u0006\"CB^\u0001\u0005\u0005I\u0011IB_\u0011%\u0019Y\rAA\u0001\n\u0003\u0019i\rC\u0005\u0004R\u0002\t\t\u0011\"\u0011\u0004T\"I1q\u001b\u0001\u0002\u0002\u0013\u00053\u0011\u001c\u0005\n\u00077\u0004\u0011\u0011!C!\u0007;D\u0011ba8\u0001\u0003\u0003%\te!9\b\u0015\r\u0015h(!A\t\u0002\u0001\u001b9OB\u0005>}\u0005\u0005\t\u0012\u0001!\u0004j\"9\u00111V\u001c\u0005\u0002\rU\b\"CBno\u0005\u0005IQIBo\u0011%\u00199pNA\u0001\n\u0003\u001bI\u0010C\u0005\u0005\u0016]\n\t\u0011\"!\u0005\u0018!IAQE\u001c\u0002\u0002\u0013%Aq\u0005\u0002\u0014\u0013:$W\r_*feZL7-\u001a\"vS2$WM\u001d\u0006\u0003\u007f\u0001\u000bQ!\u001b8eKbT!!\u0011\"\u0002\u0011Ad\u0017\r\u001e4pe6T!a\u0011#\u0002\t\u0011\fW\u000e\u001c\u0006\u0002\u000b\u0006\u00191m\\7\u0014\t\u00019U\n\u0015\t\u0003\u0011.k\u0011!\u0013\u0006\u0002\u0015\u0006)1oY1mC&\u0011A*\u0013\u0002\u0007\u0003:L(+\u001a4\u0011\u0005!s\u0015BA(J\u0005\u001d\u0001&o\u001c3vGR\u0004\"!\u0015.\u000f\u0005ICfBA*X\u001b\u0005!&BA+W\u0003\u0019a$o\\8u}\r\u0001\u0011\"\u0001&\n\u0005eK\u0015a\u00029bG.\fw-Z\u0005\u00037r\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!!W%\u0002\r\r|gNZ5h+\u0005y\u0006C\u00011d\u001b\u0005\t'B\u00012A\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u0011A-\u0019\u0002\u0013\u0013:$W\r_*feZL7-Z\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\u0013\u0011\u00147+\u001e9q_J$X#\u00015\u0011\u0005%dW\"\u00016\u000b\u0005-\u0004\u0015!B:u_J,\u0017BA7k\u0005%!%mU;qa>\u0014H/\u0001\u0006eEN+\b\u000f]8si\u0002\nq\"\u001b8ji&\fG\u000eT3eO\u0016\u0014\u0018\nZ\u000b\u0002cB\u0019!/a\u0001\u000f\u0005MthB\u0001;|\u001d\t)\u0018P\u0004\u0002wq:\u00111k^\u0005\u0002\u000b&\u00111\tR\u0005\u0003u\n\u000ba\u0001\\3eO\u0016\u0014\u0018B\u0001?~\u0003\r\t\u0007/\u001b\u0006\u0003u\nK1a`A\u0001\u0003\u0019!w.\\1j]*\u0011A0`\u0005\u0005\u0003\u000b\t9A\u0001\u0005MK\u0012<WM]%e\u0015\ry\u0018\u0011A\u0001\u0011S:LG/[1m\u0019\u0016$w-\u001a:JI\u0002\n\u0001d]3sm&\u001cWm]#yK\u000e,H/[8o\u0007>tG/\u001a=u+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)\"S\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\r\u0003'\u0011\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\u00023M,'O^5dKN,\u00050Z2vi&|gnQ8oi\u0016DH\u000fI\u0001\b[\u0016$(/[2t+\t\t\t\u0003\u0005\u0003\u0002$\u0005\u001dRBAA\u0013\u0015\r\tiBQ\u0005\u0005\u0003S\t)CA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\nq\u0003\u001c4WC2,X\r\u0016:b]Nd\u0017\r^5p]\u000e\u000b7\r[3\u0016\u0005\u0005E\u0002\u0003BA\u001a\u0003sq1![A\u001b\u0013\r\t9D[\u0001\u0018\u0019\u001a4\u0016\r\\;f)J\fgn\u001d7bi&|gnQ1dQ\u0016LA!a\u000f\u0002>\t)1)Y2iK*\u0019\u0011q\u00076\u0002114g+\u00197vKR\u0013\u0018M\\:mCRLwN\\\"bG\",\u0007%\u0001\u0005f]JL7\r[3s+\t\t)\u0005\u0005\u0003\u0002H\u0005ESBAA%\u0015\u0011\tY%!\u0014\u0002\r\u0015tw-\u001b8f\u0015\r\tyEQ\u0001\u0003Y\u001aLA!a\u0015\u0002J\tia+\u00197vK\u0016s'/[2iKJ\f\u0011\"\u001a8sS\u000eDWM\u001d\u0011\u0002\u001bA\f'\u000f^5dSB\fg\u000e^%e+\t\tY\u0006\u0005\u0003\u0002^\u0005%d\u0002BA0\u0003Kj!!!\u0019\u000b\t\u0005\r\u0014QJ\u0001\u0005I\u0006$\u0018-\u0003\u0003\u0002h\u0005\u0005\u0014a\u0001*fM&!\u00111NA7\u00055\u0001\u0016M\u001d;jG&\u0004\u0018M\u001c;JI*!\u0011qMA1\u00039\u0001\u0018M\u001d;jG&\u0004\u0018M\u001c;JI\u0002\n!d\u001d5be\u0016$7\u000b\u001e:j]\u001eLe\u000e^3s]&twMV5fo>+\"!!\u001e\u0011\u000b!\u000b9(a\u001f\n\u0007\u0005e\u0014J\u0001\u0004PaRLwN\u001c\t\u0005\u0003{\n\u0019)\u0004\u0002\u0002\u0000)\u0019\u0011\u0011\u00116\u0002\u0013%tG/\u001a:oS:<\u0017\u0002BAC\u0003\u007f\u00121c\u0015;sS:<\u0017J\u001c;fe:Lgn\u001a,jK^\f1d\u001d5be\u0016$7\u000b\u001e:j]\u001eLe\u000e^3s]&twMV5fo>\u0003\u0013aA7biB!\u0011QRAL\u001b\t\tyI\u0003\u0003\u0002\u0012\u0006M\u0015AB:ue\u0016\fWN\u0003\u0002\u0002\u0016\u0006!\u0011m[6b\u0013\u0011\tI*a$\u0003\u00195\u000bG/\u001a:jC2L'0\u001a:\u0002\u001d1|wmZ5oO\u000e{g\u000e^3yiB!\u0011qTAS\u001b\t\t\tKC\u0002\u0002$\n\u000bq\u0001\\8hO&tw-\u0003\u0003\u0002(\u0006\u0005&A\u0004'pO\u001eLgnZ\"p]R,\u0007\u0010^\u0001\u0011Kb,7-\u001e;j_:\u001cuN\u001c;fqR\fa\u0001P5oSRtD\u0003FAX\u0003w\u000bi,a0\u0002B\u0006\r\u0017QYAd\u0003\u0013\fY\r\u0006\u0005\u00022\u0006U\u0016qWA]!\r\t\u0019\fA\u0007\u0002}!9\u0011\u0011\u0012\fA\u0004\u0005-\u0005bBAN-\u0001\u000f\u0011Q\u0014\u0005\b\u0003S3\u00029AA\b\u0011\u0015if\u00031\u0001`\u0011\u00151g\u00031\u0001i\u0011\u0015yg\u00031\u0001r\u0011\u001d\tYA\u0006a\u0001\u0003\u001fAq!!\b\u0017\u0001\u0004\t\t\u0003C\u0004\u0002.Y\u0001\r!!\r\t\u000f\u0005\u0005c\u00031\u0001\u0002F!9\u0011q\u000b\fA\u0002\u0005m\u0003bBA9-\u0001\u0007\u0011QO\u0001\u0007Y><w-\u001a:\u0016\u0005\u0005E\u0007\u0003BAP\u0003'LA!!6\u0002\"\n!2i\u001c8uKb$X/\u00197ju\u0016$Gj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0003po:,'\u000f\u0006\u0002\u0002^B1\u0011q\\Av\u0003ctA!!9\u0002h:\u0019A/a9\n\u0007\u0005\u0015X0A\u0005sKN|WO]2fg&\u0019\u0011,!;\u000b\u0007\u0005\u0015X0\u0003\u0003\u0002n\u0006=(!\u0004*fg>,(oY3Po:,'OC\u0002Z\u0003S\u0004B!a=\u0003\u00045\u0011\u0011Q\u001f\u0006\u0005\u0003o\fI0\u0001\u0002we)\u0019q(a?\u000b\t\u0005u\u0018q`\u0001\u0006gR\fG/\u001a\u0006\u0004\u0005\u0003i\u0018a\u00039beRL7-\u001b9b]RLAA!\u0002\u0002v\na\u0011J\u001c3fqN+'O^5dK\u0006I2-Y2iKN,\u0006\u000fZ1uKJ\u001cVOY:de&\u0004H/[8o)1\u0011YAa\u0005\u0003\u001e\t5\"q\u0007B!!\u0019\ty.a;\u0003\u000eA\u0019\u0001Ja\u0004\n\u0007\tE\u0011J\u0001\u0003V]&$\bb\u0002B\u000b5\u0001\u0007!qC\u0001\u001ag\"\f'/\u001a3TiJLgnZ%oi\u0016\u0014h.\u001b8h-&,w\u000fE\u0002I\u00053I1Aa\u0007J\u0005\u001d\u0011un\u001c7fC:DqAa\b\u001b\u0001\u0004\u0011\t#A\u0005mK\u0012<WM\u001d#b_B!!1\u0005B\u0015\u001b\t\u0011)CC\u0002\u0003()\f1\u0001Z1p\u0013\u0011\u0011YC!\n\u0003\u001b1+GmZ3s%\u0016\fG\rR1p\u0011\u001d\u0011yC\u0007a\u0001\u0005c\t1$\u001e9eCRLgnZ*ue&tw-\u00138uKJt\u0017N\\4WS\u0016<\b\u0003BA?\u0005gIAA!\u000e\u0002\u0000\tYR\u000b\u001d3bi&twm\u0015;sS:<\u0017J\u001c;fe:Lgn\u001a,jK^DqA!\u000f\u001b\u0001\u0004\u0011Y$A\u0010j]N$(/^7f]R,GmU5h]\u0006dg*Z<MK\u0012<WM\u001d%fC\u0012\u0004B!a-\u0003>%\u0019!q\b \u0003?%s7\u000f\u001e:v[\u0016tG/\u001a3TS\u001et\u0017\r\u001c(fo2+GmZ3s\u0011\u0016\fG\rC\u0004\u0003Di\u0001\rA!\u0012\u0002+A\u0014XMZ3uG\"Lgn\u001a#jgB\fGo\u00195feB1!q\tB)\u0005+j!A!\u0013\u000b\t\t-#QJ\u0001\u000bI&\u001c\b/\u0019;dQ\u0016\u0014(b\u0001B(\u0001\u0006Y\u0011m[6bgR\u0014X-Y7t\u0013\u0011\u0011\u0019F!\u0013\u0003\u0015\u0011K7\u000f]1uG\",'\u000fE\u0004I\u0005/\u0012YFa\u001a\n\u0007\te\u0013J\u0001\u0004UkBdWM\r\t\u0005\u0005;\u0012\u0019'\u0004\u0002\u0003`)\u0019!\u0011M?\u0002\r=4gm]3u\u0013\u0011\u0011)Ga\u0018\u0003\r=3gm]3u!\rA%\u0011N\u0005\u0004\u0005WJ%\u0001\u0002'p]\u001e\f!\u0004\\8bIN#(/\u001b8h\u0013:$XM\u001d8j]\u001e,e\u000e\u001e:jKN,\"A!\u001d\u0011\t\u0005u$1O\u0005\u0005\u0005k\nyH\u0001\u000eM_\u0006$7\u000b\u001e:j]\u001eLe\u000e^3s]&tw-\u00128ue&,7/\u0001\u0013ck&dG-\u00138tiJ,X.\u001a8uK\u0012\u001c\u0016n\u001a8bY:+w\u000fT3eO\u0016\u0014\b*Z1e)\u0019\u0011YDa\u001f\u0003\f\"9!Q\u0010\u000fA\u0002\t}\u0014A\u00047fI\u001e,'/\u00128e\u0007\u0006\u001c\u0007.\u001a\t\u0005\u0005\u0003\u00139)\u0004\u0002\u0003\u0004*\u0019!Q\u00116\u0002\u000b\r\f7\r[3\n\t\t%%1\u0011\u0002\u0016\u001bV$\u0018M\u00197f\u0019\u0016$w-\u001a:F]\u0012\u001c\u0015m\u00195f\u0011\u001d\u0011i\t\ba\u0001\u0005\u001f\u000b\u0011cZ3oKJ\fG\u000eR5ta\u0006$8\r[3s!\u0019\u00119E!\u0015\u0003\\\u0005yR.\u001e;bE2,7)Y2iK\n\u000b7m[3e\u0007>tGO]1diN#xN]3\u0015\u0011\tU%1\u0014BO\u0005\u007f\u0003BA!!\u0003\u0018&!!\u0011\u0014BB\u0005}iU\u000f^1cY\u0016\u001c\u0015m\u00195f\u0005\u0006\u001c7.\u001a3D_:$(/Y2u'R|'/\u001a\u0005\b\u0005?i\u0002\u0019\u0001B\u0011\u0011\u001d\u0011y*\ba\u0001\u0005C\u000b\u0011\u0002\\3eO\u0016\u0014XI\u001c3\u0011\t\t\r&\u0011\u0018\b\u0005\u0005K\u0013\u0019L\u0004\u0003\u0003(\n=f\u0002\u0002BU\u0005[s1!\u001eBV\u0013\t\t%)\u0003\u0002l\u0001&\u0019!\u0011\u00176\u0002\u000f\t\f7m[3oI&!!Q\u0017B\\\u0003]\u0001\u0016M]1nKR,'o\u0015;pe\u0006<WMQ1dW\u0016tGMC\u0002\u00032*LAAa/\u0003>\nIA*\u001a3hKJ,e\u000e\u001a\u0006\u0005\u0005k\u00139\fC\u0004\u0003Bv\u0001\rAa\u000f\u0002%\u0011L7\u000f]1uG\",'\u000fT1h\u001b\u0016$XM]\u0001\u001fG\u0006\u001c\u0007.Z\"p[B|g.\u001a8ug\u0006sGmU;cg\u000e\u0014\u0018\u000e\u001d;j_:$bBa2\u0003^\n}'1\u001dBt\u0005W\u0014y\u000f\u0005\u0004\u0002`\u0006-(\u0011\u001a\t\b\u0011\n]#1\u001aBi!\u0011\u0011\u0019C!4\n\t\t='Q\u0005\u0002\u001c\u0019\u0016$w-\u001a:EC>$&/\u00198tC\u000e$\u0018n\u001c8t%\u0016\fG-\u001a:\u0011\t\tM'q\u001b\b\u0005\u0005S\u0013).\u0003\u0002Z\u0001&!!\u0011\u001cBn\u00051\u0001&/\u001e8f\u0005V4g-\u001a:t\u0015\tI\u0006\tC\u0003^=\u0001\u0007q\fC\u0004\u0003bz\u0001\rA!&\u0002\u001b\r|g\u000e\u001e:bGR\u001cFo\u001c:f\u0011\u001d\u0011)O\ba\u0001\u0005C\tQ\u0002\\3eO\u0016\u0014(+Z1e\t\u0006|\u0007b\u0002Bu=\u0001\u0007!QI\u0001\u0017G\u0006\u001c\u0007.Z+qI\u0006$Xm\u001d#jgB\fGo\u00195fe\"9!Q\u001e\u0010A\u0002\tU\u0013AD:uCJ$X\t_2mkNLg/\u001a\u0005\b\u0005{r\u0002\u0019\u0001By!\u0011\u0011\tIa=\n\t\tU(1\u0011\u0002\u000f\u0019\u0016$w-\u001a:F]\u0012\u001c\u0015m\u00195f\u0003i!\u0017n\u001d9bi\u000eDWM](gMN,GoU3r\u0013\u0012|uO\\3s)\u0011\u0011YP!@\u0011\r\u0005}\u00171\u001eB#\u0011\u001d\u0011yj\ba\u0001\u0005C\u000bq\u0002Z5ta\u0006$8\r[3s\u001f^tWM\u001d\u000b\u0005\u0007\u0007\u0019)\u0001\u0005\u0004\u0002`\u0006-(q\u0012\u0005\b\u0005?\u0003\u0003\u0019\u0001B.\u000391XM]5gs2+GmZ3s\u0013\u0012$Baa\u0003\u0004\u0018Q11QBB\n\u0007+\u0001R!!\u0005\u0004\u0010ELAa!\u0005\u0002\u0014\t1a)\u001e;ve\u0016Dq!!+\"\u0001\b\ty\u0001C\u0004\u0002\u001c\u0006\u0002\u001d!!(\t\u000f\t}\u0011\u00051\u0001\u0003\"\u0005\u00192M]3bi\u0016dU\rZ4feJ+\u0017\r\u001a#b_R1!\u0011EB\u000f\u0007?AqA! #\u0001\u0004\u0011\t\u0010C\u0004\u0004\"\t\u0002\raa\t\u0002\u001fM$(/\u001b8h\u0013:$XM\u001d8j]\u001e\u0004B!! \u0004&%!1qEA@\u0005=\u0019FO]5oO&sG/\u001a:oS:<\u0017\u0001B2paf$Bc!\f\u00046\r]2\u0011HB\u001e\u0007{\u0019yd!\u0011\u0004D\r\u0015C\u0003CAY\u0007_\u0019\tda\r\t\u000f\u0005%5\u0005q\u0001\u0002\f\"9\u00111T\u0012A\u0004\u0005u\u0005bBAUG\u0001\u000f\u0011q\u0002\u0005\b;\u000e\u0002\n\u00111\u0001`\u0011\u001d17\u0005%AA\u0002!Dqa\\\u0012\u0011\u0002\u0003\u0007\u0011\u000fC\u0005\u0002\f\r\u0002\n\u00111\u0001\u0002\u0010!I\u0011QD\u0012\u0011\u0002\u0003\u0007\u0011\u0011\u0005\u0005\n\u0003[\u0019\u0003\u0013!a\u0001\u0003cA\u0011\"!\u0011$!\u0003\u0005\r!!\u0012\t\u0013\u0005]3\u0005%AA\u0002\u0005m\u0003\"CA9GA\u0005\t\u0019AA;\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"aa\u0013+\u0007}\u001bie\u000b\u0002\u0004PA!1\u0011KB.\u001b\t\u0019\u0019F\u0003\u0003\u0004V\r]\u0013!C;oG\",7m[3e\u0015\r\u0019I&S\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB/\u0007'\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"aa\u0019+\u0007!\u001ci%\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r%$fA9\u0004N\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAB8U\u0011\tya!\u0014\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%kU\u00111Q\u000f\u0016\u0005\u0003C\u0019i%\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001c\u0016\u0005\rm$\u0006BA\u0019\u0007\u001b\nabY8qs\u0012\"WMZ1vYR$s'\u0006\u0002\u0004\u0002*\"\u0011QIB'\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIa*\"aa\"+\t\u0005m3QJ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u0013:+\t\u0019iI\u000b\u0003\u0002v\r5\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0004\u0014B!1QSBP\u001b\t\u00199J\u0003\u0003\u0004\u001a\u000em\u0015\u0001\u00027b]\u001eT!a!(\u0002\t)\fg/Y\u0005\u0005\u0007C\u001b9J\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0007O\u00032\u0001SBU\u0013\r\u0019Y+\u0013\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0007c\u001b9\fE\u0002I\u0007gK1a!.J\u0005\r\te.\u001f\u0005\n\u0007s{\u0013\u0011!a\u0001\u0007O\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB`!\u0019\u0019\tma2\u000426\u001111\u0019\u0006\u0004\u0007\u000bL\u0015AC2pY2,7\r^5p]&!1\u0011ZBb\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t]1q\u001a\u0005\n\u0007s\u000b\u0014\u0011!a\u0001\u0007c\u000b!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!11SBk\u0011%\u0019ILMA\u0001\u0002\u0004\u00199+\u0001\u0005iCND7i\u001c3f)\t\u00199+\u0001\u0005u_N#(/\u001b8h)\t\u0019\u0019*\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005/\u0019\u0019\u000fC\u0005\u0004:V\n\t\u00111\u0001\u00042\u0006\u0019\u0012J\u001c3fqN+'O^5dK\n+\u0018\u000e\u001c3feB\u0019\u00111W\u001c\u0014\t]:51\u001e\t\u0005\u0007[\u001c\u00190\u0004\u0002\u0004p*!1\u0011_BN\u0003\tIw.C\u0002\\\u0007_$\"aa:\u0002\u000b\u0005\u0004\b\u000f\\=\u0015)\rmH1\u0001C\u0003\t\u000f!I\u0001b\u0003\u0005\u000e\u0011=A\u0011\u0003C\n)!\t\tl!@\u0004\u0000\u0012\u0005\u0001bBAEu\u0001\u000f\u00111\u0012\u0005\b\u00037S\u00049AAO\u0011\u001d\tIK\u000fa\u0002\u0003\u001fAQ!\u0018\u001eA\u0002}CQA\u001a\u001eA\u0002!DQa\u001c\u001eA\u0002EDq!a\u0003;\u0001\u0004\ty\u0001C\u0004\u0002\u001ei\u0002\r!!\t\t\u000f\u00055\"\b1\u0001\u00022!9\u0011\u0011\t\u001eA\u0002\u0005\u0015\u0003bBA,u\u0001\u0007\u00111\f\u0005\b\u0003cR\u0004\u0019AA;\u0003\u001d)h.\u00199qYf$B\u0001\"\u0007\u0005\"A)\u0001*a\u001e\u0005\u001cA\u0011\u0002\n\"\b`QF\fy!!\t\u00022\u0005\u0015\u00131LA;\u0013\r!y\"\u0013\u0002\u0007)V\u0004H.Z\u001d\t\u0013\u0011\r2(!AA\u0002\u0005E\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011A\u0011\u0006\t\u0005\u0007+#Y#\u0003\u0003\u0005.\r]%AB(cU\u0016\u001cG\u000f")
public class IndexServiceBuilder
implements Product,
Serializable {
    private final IndexServiceConfig config;
    private final DbSupport dbSupport;
    private final Object initialLedgerId;
    private final ExecutionContext servicesExecutionContext;
    private final Metrics metrics;
    private final LfValueTranslationCache.Cache lfValueTranslationCache;
    private final ValueEnricher enricher;
    private final String participantId;
    private final Option<StringInterningView> sharedStringInterningViewO;
    private final Materializer mat;
    private final LoggingContext loggingContext;
    private final ExecutionContext executionContext;
    private final ContextualizedLogger logger;

    public static Option<Tuple9<IndexServiceConfig, DbSupport, Object, ExecutionContext, Metrics, LfValueTranslationCache.Cache, ValueEnricher, String, Option<StringInterningView>>> unapply(IndexServiceBuilder x$0) {
        return IndexServiceBuilder$.MODULE$.unapply(x$0);
    }

    public static IndexServiceBuilder apply(IndexServiceConfig config, DbSupport dbSupport, Object initialLedgerId, ExecutionContext servicesExecutionContext, Metrics metrics, LfValueTranslationCache.Cache lfValueTranslationCache, ValueEnricher enricher, String participantId, Option<StringInterningView> sharedStringInterningViewO, Materializer mat, LoggingContext loggingContext, ExecutionContext executionContext) {
        return IndexServiceBuilder$.MODULE$.apply(config, dbSupport, initialLedgerId, servicesExecutionContext, metrics, lfValueTranslationCache, enricher, participantId, sharedStringInterningViewO, mat, loggingContext, executionContext);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public IndexServiceConfig config() {
        return this.config;
    }

    public DbSupport dbSupport() {
        return this.dbSupport;
    }

    public Object initialLedgerId() {
        return this.initialLedgerId;
    }

    public ExecutionContext servicesExecutionContext() {
        return this.servicesExecutionContext;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public LfValueTranslationCache.Cache lfValueTranslationCache() {
        return this.lfValueTranslationCache;
    }

    public ValueEnricher enricher() {
        return this.enricher;
    }

    public String participantId() {
        return this.participantId;
    }

    public Option<StringInterningView> sharedStringInterningViewO() {
        return this.sharedStringInterningViewO;
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    public AbstractResourceOwner<ResourceContext, IndexService> owner() {
        MutableLedgerEndCache ledgerEndCache = MutableLedgerEndCache$.MODULE$.apply();
        boolean isSharedStringInterningView = this.sharedStringInterningViewO().nonEmpty();
        StringInterningView stringInterningView = (StringInterningView)this.sharedStringInterningViewO().getOrElse((Function0 & Serializable)() -> new StringInterningView());
        LedgerReadDao ledgerDao = this.createLedgerReadDao(ledgerEndCache, stringInterningView);
        AbstractResourceOwner abstractResourceOwner = ResourceOwner$.MODULE$.forFuture((Function0 & Serializable)() -> this.verifyLedgerId(ledgerDao, $this.executionContext, $this.loggingContext));
        return abstractResourceOwner.flatMap((Function1 & Serializable)ledgerId -> {
            AbstractResourceOwner abstractResourceOwner = ResourceOwner$.MODULE$.forFuture((Function0 & Serializable)() -> ledgerDao.lookupLedgerEnd($this.loggingContext)).map((Function1 & Serializable)ledgerEnd -> {
                ledgerEndCache.set((Tuple2<Offset, Object>)new Tuple2((Object)ledgerEnd.lastOffset(), (Object)BoxesRunTime.boxToLong((long)ledgerEnd.lastEventSeqId())));
                BoxedUnit x$1 = BoxedUnit.UNIT;
                return new Tuple2(ledgerEnd, (Object)x$1);
            });
            return abstractResourceOwner.flatMap((Function1 & Serializable)x$6 -> {
                Tuple2 tuple2 = x$6;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ParameterStorageBackend.LedgerEnd ledgerEnd = (ParameterStorageBackend.LedgerEnd)tuple2._1();
                AbstractResourceOwner abstractResourceOwner = isSharedStringInterningView ? ResourceOwner$.MODULE$.unit() : ResourceOwner$.MODULE$.forFuture((Function0 & Serializable)() -> stringInterningView.update(ledgerEnd.lastStringInterningId(), this.loadStringInterningEntries(), $this.loggingContext));
                AbstractResourceOwner abstractResourceOwner2 = abstractResourceOwner.flatMap((Function1 & Serializable)x$5 -> {
                    BoxedUnit boxedUnit = x$5;
                    AbstractResourceOwner<ResourceContext, Dispatcher<Tuple2<Offset, Object>>> abstractResourceOwner = this.dispatcherOffsetSeqIdOwner(ledgerEnd);
                    AbstractResourceOwner abstractResourceOwner2 = abstractResourceOwner.flatMap((Function1 & Serializable)prefetchingDispatcher -> {
                        AbstractResourceOwner abstractResourceOwner = this.dispatcherOwner(ledgerEnd.lastOffset()).map((Function1 & Serializable)generalDispatcher -> {
                            InstrumentedSignalNewLedgerHead instrumentedSignalNewLedgerHead = this.buildInstrumentedSignalNewLedgerHead(ledgerEndCache, (Dispatcher<Offset>)generalDispatcher);
                            MutableCacheBackedContractStore contractStore = this.mutableCacheBackedContractStore(ledgerDao, ledgerEnd, instrumentedSignalNewLedgerHead);
                            return new Tuple3(generalDispatcher, (Object)instrumentedSignalNewLedgerHead, (Object)contractStore);
                        });
                        return abstractResourceOwner.flatMap((Function1 & Serializable)x$4 -> {
                            Tuple3 tuple3 = x$4;
                            if (tuple3 == null) {
                                throw new MatchError((Object)tuple3);
                            }
                            Dispatcher generalDispatcher = (Dispatcher)tuple3._1();
                            InstrumentedSignalNewLedgerHead instrumentedSignalNewLedgerHead = (InstrumentedSignalNewLedgerHead)tuple3._2();
                            MutableCacheBackedContractStore contractStore = (MutableCacheBackedContractStore)tuple3._3();
                            AbstractResourceOwner abstractResourceOwner = this.cacheComponentsAndSubscription(this.config(), contractStore, ledgerDao, (Dispatcher<Tuple2<Offset, Object>>)prefetchingDispatcher, (Tuple2<Offset, Object>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ledgerEnd.lastOffset()), (Object)BoxesRunTime.boxToLong((long)ledgerEnd.lastEventSeqId())), ledgerEndCache).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)IndexServiceBuilder.$anonfun$owner$12(check$ifrefutable$1)));
                            AbstractResourceOwner abstractResourceOwner2 = abstractResourceOwner.flatMap((Function1 & Serializable)x$3 -> {
                                Tuple2 tuple2 = x$3;
                                if (tuple2 == null) {
                                    throw new MatchError((Object)tuple2);
                                }
                                LedgerDaoTransactionsReader transactionsReader = (LedgerDaoTransactionsReader)tuple2._1();
                                Function1 pruneBuffers = (Function1)tuple2._2();
                                AbstractResourceOwner abstractResourceOwner = this.cachesUpdaterSubscription(isSharedStringInterningView, ledgerDao, stringInterningView, instrumentedSignalNewLedgerHead, (Dispatcher<Tuple2<Offset, Object>>)prefetchingDispatcher).map((Function1 & Serializable)x$2 -> {
                                    BoxedUnit boxedUnit = x$2;
                                    IndexServiceImpl indexServiceImpl = new IndexServiceImpl(ledgerId, this.participantId(), ledgerDao, transactionsReader, contractStore, (Function1<Offset, BoxedUnit>)pruneBuffers, (Dispatcher<Offset>)generalDispatcher, this.metrics());
                                    return indexServiceImpl;
                                });
                                return abstractResourceOwner;
                            });
                            return abstractResourceOwner2;
                        });
                    });
                    return abstractResourceOwner2;
                });
                return abstractResourceOwner2;
            });
        });
    }

    private AbstractResourceOwner<ResourceContext, BoxedUnit> cachesUpdaterSubscription(boolean sharedStringInterningView, LedgerReadDao ledgerDao, UpdatingStringInterningView updatingStringInterningView, InstrumentedSignalNewLedgerHead instrumentedSignalNewLedgerHead, Dispatcher<Tuple2<Offset, Object>> prefetchingDispatcher) {
        return ResourceOwner$.MODULE$.forReleasable((Function0 & Serializable)() -> new LedgerEndPoller(ledgerDao, (Function1<ParameterStorageBackend.LedgerEnd, Future<BoxedUnit>>)(Function1 & Serializable)newLedgerHead -> (sharedStringInterningView ? Future$.MODULE$.unit() : updatingStringInterningView.update(newLedgerHead.lastStringInterningId(), this.loadStringInterningEntries(), $this.loggingContext)).map((Function1 & Serializable)x$7 -> {
            IndexServiceBuilder.$anonfun$cachesUpdaterSubscription$3(instrumentedSignalNewLedgerHead, newLedgerHead, prefetchingDispatcher, x$7);
            return BoxedUnit.UNIT;
        }, $this.executionContext), $this.mat, $this.loggingContext), (Function1 & Serializable)x$8 -> x$8.release()).map((Function1 & Serializable)x$9 -> {
            IndexServiceBuilder.$anonfun$cachesUpdaterSubscription$5(x$9);
            return BoxedUnit.UNIT;
        });
    }

    private LoadStringInterningEntries loadStringInterningEntries() {
        return (fromExclusive, toInclusive) -> (Function1 & Serializable)loggingContext -> {
            StringInterningStorageBackend stringInterningStorageBackend = this.dbSupport().storageBackendFactory().createStringInterningStorageBackend();
            return this.dbSupport().dbDispatcher().executeSql(this.metrics().daml().index().db().loadStringInterningEntries(), (Function1 & Serializable)connection -> stringInterningStorageBackend.loadStringInterningEntries(fromExclusive, toInclusive, (Connection)connection), (LoggingContext)loggingContext);
        };
    }

    private InstrumentedSignalNewLedgerHead buildInstrumentedSignalNewLedgerHead(MutableLedgerEndCache ledgerEndCache, Dispatcher<Offset> generalDispatcher) {
        return new InstrumentedSignalNewLedgerHead((Function2<Offset, Object, BoxedUnit>)(Function2 & Serializable)(offset, eventSeqId) -> {
            IndexServiceBuilder.$anonfun$buildInstrumentedSignalNewLedgerHead$1(ledgerEndCache, generalDispatcher, offset, BoxesRunTime.unboxToLong((Object)eventSeqId));
            return BoxedUnit.UNIT;
        }, InstrumentedSignalNewLedgerHead$.MODULE$.$lessinit$greater$default$2(), this.metrics().daml().execution().cache().dispatcherLag());
    }

    private MutableCacheBackedContractStore mutableCacheBackedContractStore(LedgerReadDao ledgerDao, ParameterStorageBackend.LedgerEnd ledgerEnd, InstrumentedSignalNewLedgerHead dispatcherLagMeter) {
        return new MutableCacheBackedContractStore(this.metrics(), ledgerDao.contractsReader(), dispatcherLagMeter, ContractStateCaches$.MODULE$.build(ledgerEnd.lastOffset(), this.config().maxContractStateCacheSize(), this.config().maxContractKeyStateCacheSize(), this.metrics(), this.servicesExecutionContext(), this.loggingContext), this.servicesExecutionContext(), this.loggingContext);
    }

    private AbstractResourceOwner<ResourceContext, Tuple2<LedgerDaoTransactionsReader, Function1<Offset, BoxedUnit>>> cacheComponentsAndSubscription(IndexServiceConfig config, MutableCacheBackedContractStore contractStore, LedgerReadDao ledgerReadDao, Dispatcher<Tuple2<Offset, Object>> cacheUpdatesDispatcher, Tuple2<Offset, Object> startExclusive, LedgerEndCache ledgerEndCache) {
        AbstractResourceOwner abstractResourceOwner;
        if (config.enableInMemoryFanOutForLedgerApi()) {
            EventsBuffer<TransactionLogUpdate> transactionsBuffer = new EventsBuffer<TransactionLogUpdate>(config.maxTransactionsInMemoryFanOutBufferSize(), this.metrics(), "transactions", (Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)IndexServiceBuilder.$anonfun$cacheComponentsAndSubscription$1(x$10)), config.bufferedStreamsPageSize());
            LedgerDaoTransactionsReader x$1 = ledgerReadDao.transactionsReader();
            EventsBuffer<TransactionLogUpdate> x$2 = transactionsBuffer;
            LfValueTranslation x$3 = new LfValueTranslation(this.lfValueTranslationCache(), this.metrics(), (Option<ValueEnricher>)new Some((Object)this.enricher()), (Function2<String, LoggingContext, Future<Option<DamlLf.Archive>>>)(Function2 & Serializable)(packageId, loggingContext) -> ledgerReadDao.getLfArchive((String)packageId, (LoggingContext)loggingContext));
            Metrics x$4 = this.metrics();
            int x$5 = config.eventsProcessingParallelism();
            ExecutionContext x$6 = this.servicesExecutionContext();
            BufferedTransactionsReader bufferedTransactionsReader = BufferedTransactionsReader$.MODULE$.apply(x$1, x$2, x$5, x$3, x$4, x$6);
            Function1 & Serializable x$7 = (Function1 & Serializable)maybeOffsetSeqId -> {
                Tuple2 tuple2 = (Tuple2)maybeOffsetSeqId.getOrElse((Function0 & Serializable)() -> startExclusive);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Offset offsetStart = (Offset)tuple2._1();
                long eventSeqIdStart = tuple2._2$mcJ$sp();
                Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)offsetStart, (Object)BoxesRunTime.boxToLong((long)eventSeqIdStart));
                Tuple3 tuple32 = tuple3;
                Tuple2 subscriptionStartExclusive = (Tuple2)tuple32._1();
                Offset offsetStart2 = (Offset)tuple32._2();
                long eventSeqIdStart2 = BoxesRunTime.unboxToLong((Object)tuple32._3());
                this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(50).append("Subscribing for transaction log updates after ").append(offsetStart2.toHexString()).append(" -> ").append(eventSeqIdStart2).toString(), $this.loggingContext);
                return cacheUpdatesDispatcher.startingAt((Object)subscriptionStartExclusive, (SubSource)new SubSource.RangeSource((Function2 & Serializable)(x$12, x$13) -> ledgerReadDao.transactionsReader().getTransactionLogUpdates((Tuple2<Offset, Object>)x$12, (Tuple2<Offset, Object>)x$13, $this.loggingContext), Ordering$.MODULE$.Tuple2(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()), (Ordering)Ordering.Long$.MODULE$)), cacheUpdatesDispatcher.startingAt$default$3());
            };
            Function2 & Serializable x$8 = (Function2 & Serializable)(offset, entry) -> {
                transactionsBuffer.push(offset, entry);
                return BoxedUnit.UNIT;
            };
            Function1 & Serializable x$9 = (Function1 & Serializable)eventsBatch -> {
                contractStore.push((Vector<ContractStateEvent>)eventsBatch);
                return BoxedUnit.UNIT;
            };
            Metrics x$102 = this.metrics();
            Function1<TransactionLogUpdate, Iterator<ContractStateEvent>> x$11 = BuffersUpdater$.MODULE$.owner$default$4();
            FiniteDuration x$12 = BuffersUpdater$.MODULE$.owner$default$6();
            Function1<Object, BoxedUnit> x$13 = BuffersUpdater$.MODULE$.owner$default$7();
            abstractResourceOwner = BuffersUpdater$.MODULE$.owner((Function1<Option<Tuple2<Offset, Object>>, Source<Tuple2<Tuple2<Offset, Object>, TransactionLogUpdate>, NotUsed>>)x$7, (Function2<Offset, TransactionLogUpdate, BoxedUnit>)x$8, (Function1<Vector<ContractStateEvent>, BoxedUnit>)x$9, x$11, x$102, x$12, x$13, this.mat, this.loggingContext).map((Function1 & Serializable)x$14 -> {
                BuffersUpdater buffersUpdater = x$14;
                Tuple2 tuple2 = new Tuple2((Object)bufferedTransactionsReader, (Function1 & Serializable)endInclusive -> {
                    transactionsBuffer.prune(endInclusive);
                    return BoxedUnit.UNIT;
                });
                return tuple2;
            });
        } else {
            abstractResourceOwner = new MutableCacheBackedContractStore.CacheUpdateSubscription(contractStore, (Function0<Source<Vector<ContractStateEvent>, NotUsed>>)(Function0 & Serializable)() -> {
                Tuple2<Offset, Object> subscriptionStartExclusive = ledgerEndCache.apply();
                this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(43).append("Subscribing to contract state events after ").append(subscriptionStartExclusive).toString(), $this.loggingContext);
                return (Source)cacheUpdatesDispatcher.startingAt(subscriptionStartExclusive, (SubSource)new SubSource.RangeSource((Function2 & Serializable)(x$15, x$16) -> ledgerReadDao.transactionsReader().getContractStateEvents((Tuple2<Offset, Object>)x$15, (Tuple2<Offset, Object>)x$16, $this.loggingContext), Ordering$.MODULE$.Tuple2(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()), (Ordering)Ordering.Long$.MODULE$)), cacheUpdatesDispatcher.startingAt$default$3()).map((Function1 & Serializable)x$17 -> (Vector)x$17._2());
            }, MutableCacheBackedContractStore$CacheUpdateSubscription$.MODULE$.$lessinit$greater$default$3(), this.mat).map((Function1 & Serializable)x$18 -> new Tuple2((Object)ledgerReadDao.transactionsReader(), package$.MODULE$.PruneBuffersNoOp()));
        }
        return abstractResourceOwner;
    }

    private AbstractResourceOwner<ResourceContext, Dispatcher<Tuple2<Offset, Object>>> dispatcherOffsetSeqIdOwner(ParameterStorageBackend.LedgerEnd ledgerEnd) {
        return Dispatcher$.MODULE$.owner("cache-updates", (Object)new Tuple2((Object)Offset$.MODULE$.beforeBegin(), (Object)BoxesRunTime.boxToLong((long)EventSequentialId$.MODULE$.beforeBegin())), (Object)new Tuple2((Object)ledgerEnd.lastOffset(), (Object)BoxesRunTime.boxToLong((long)ledgerEnd.lastEventSeqId())), Dispatcher$.MODULE$.owner$default$4(), Dispatcher$.MODULE$.owner$default$5(), Ordering$.MODULE$.Tuple2(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()), (Ordering)Ordering.Long$.MODULE$));
    }

    private AbstractResourceOwner<ResourceContext, Dispatcher<Offset>> dispatcherOwner(Offset ledgerEnd) {
        return Dispatcher$.MODULE$.owner("sql-ledger", (Object)Offset$.MODULE$.beforeBegin(), (Object)ledgerEnd, this.config().apiStreamShutdownTimeout(), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.logger().warn().apply((Function0 & Serializable)() -> new StringBuilder(78).append("Shutdown of API streams did not finish in ").append(this.config().apiStreamShutdownTimeout().toSeconds()).append(" seconds. System shutdown continues.").toString(), $this.loggingContext), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    }

    private Future<Object> verifyLedgerId(LedgerReadDao ledgerDao, ExecutionContext executionContext, LoggingContext loggingContext) {
        Serializable isRetryable = new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Boolean bl = A1 instanceof IndexErrors.IndexDbException ? BoxesRunTime.boxToBoolean((boolean)true) : (A1 instanceof LedgerIdNotFoundException ? BoxesRunTime.boxToBoolean((boolean)true) : (A1 instanceof MismatchException.LedgerId ? BoxesRunTime.boxToBoolean((boolean)false) : BoxesRunTime.boxToBoolean((boolean)false)));
                return (B1)bl;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof IndexErrors.IndexDbException ? true : (throwable instanceof LedgerIdNotFoundException ? true : (throwable instanceof MismatchException.LedgerId ? true : true));
                return bl;
            }
        };
        FiniteDuration retryDelay = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(100)).millis();
        int maxAttempts = 3000;
        return RetryStrategy$.MODULE$.constant((Option)new Some((Object)BoxesRunTime.boxToInteger((int)maxAttempts)), (Duration)retryDelay, (PartialFunction)isRetryable).apply((Function2 & Serializable)(attempt, x$19) -> IndexServiceBuilder.$anonfun$verifyLedgerId$1(this, ledgerDao, loggingContext, maxAttempts, retryDelay, executionContext, BoxesRunTime.unboxToInt((Object)attempt), x$19), executionContext);
    }

    private LedgerReadDao createLedgerReadDao(LedgerEndCache ledgerEndCache, StringInterning stringInterning) {
        return JdbcLedgerDao$.MODULE$.read(this.dbSupport(), this.config().eventsPageSize(), this.config().eventsProcessingParallelism(), this.config().acsIdPageSize(), this.config().acsIdPageBufferSize(), this.config().acsIdPageWorkingMemoryBytes(), this.config().acsIdFetchingParallelism(), this.config().acsContractFetchingParallelism(), this.config().acsGlobalParallelism(), this.servicesExecutionContext(), this.metrics(), this.lfValueTranslationCache(), (Option<ValueEnricher>)new Some((Object)this.enricher()), this.participantId(), ledgerEndCache, stringInterning);
    }

    public IndexServiceBuilder copy(IndexServiceConfig config, DbSupport dbSupport, Object initialLedgerId, ExecutionContext servicesExecutionContext, Metrics metrics, LfValueTranslationCache.Cache lfValueTranslationCache, ValueEnricher enricher, String participantId, Option<StringInterningView> sharedStringInterningViewO, Materializer mat, LoggingContext loggingContext, ExecutionContext executionContext) {
        return new IndexServiceBuilder(config, dbSupport, initialLedgerId, servicesExecutionContext, metrics, lfValueTranslationCache, enricher, participantId, sharedStringInterningViewO, mat, loggingContext, executionContext);
    }

    public IndexServiceConfig copy$default$1() {
        return this.config();
    }

    public DbSupport copy$default$2() {
        return this.dbSupport();
    }

    public Object copy$default$3() {
        return this.initialLedgerId();
    }

    public ExecutionContext copy$default$4() {
        return this.servicesExecutionContext();
    }

    public Metrics copy$default$5() {
        return this.metrics();
    }

    public LfValueTranslationCache.Cache copy$default$6() {
        return this.lfValueTranslationCache();
    }

    public ValueEnricher copy$default$7() {
        return this.enricher();
    }

    public String copy$default$8() {
        return this.participantId();
    }

    public Option<StringInterningView> copy$default$9() {
        return this.sharedStringInterningViewO();
    }

    public String productPrefix() {
        return "IndexServiceBuilder";
    }

    public int productArity() {
        return 9;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.config();
                break;
            }
            case 1: {
                object = this.dbSupport();
                break;
            }
            case 2: {
                object = this.initialLedgerId();
                break;
            }
            case 3: {
                object = this.servicesExecutionContext();
                break;
            }
            case 4: {
                object = this.metrics();
                break;
            }
            case 5: {
                object = this.lfValueTranslationCache();
                break;
            }
            case 6: {
                object = this.enricher();
                break;
            }
            case 7: {
                object = this.participantId();
                break;
            }
            case 8: {
                object = this.sharedStringInterningViewO();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof IndexServiceBuilder;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "config";
                break;
            }
            case 1: {
                string = "dbSupport";
                break;
            }
            case 2: {
                string = "initialLedgerId";
                break;
            }
            case 3: {
                string = "servicesExecutionContext";
                break;
            }
            case 4: {
                string = "metrics";
                break;
            }
            case 5: {
                string = "lfValueTranslationCache";
                break;
            }
            case 6: {
                string = "enricher";
                break;
            }
            case 7: {
                string = "participantId";
                break;
            }
            case 8: {
                string = "sharedStringInterningViewO";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof IndexServiceBuilder)) return false;
        boolean bl = true;
        if (!bl) return false;
        IndexServiceBuilder indexServiceBuilder = (IndexServiceBuilder)x$1;
        IndexServiceConfig indexServiceConfig = this.config();
        IndexServiceConfig indexServiceConfig2 = indexServiceBuilder.config();
        if (indexServiceConfig == null) {
            if (indexServiceConfig2 != null) {
                return false;
            }
        } else if (!((Object)indexServiceConfig).equals(indexServiceConfig2)) return false;
        DbSupport dbSupport = this.dbSupport();
        DbSupport dbSupport2 = indexServiceBuilder.dbSupport();
        if (dbSupport == null) {
            if (dbSupport2 != null) {
                return false;
            }
        } else if (!((Object)dbSupport).equals(dbSupport2)) return false;
        if (!BoxesRunTime.equals((Object)this.initialLedgerId(), (Object)indexServiceBuilder.initialLedgerId())) return false;
        ExecutionContext executionContext = this.servicesExecutionContext();
        ExecutionContext executionContext2 = indexServiceBuilder.servicesExecutionContext();
        if (executionContext == null) {
            if (executionContext2 != null) {
                return false;
            }
        } else if (!executionContext.equals(executionContext2)) return false;
        Metrics metrics = this.metrics();
        Metrics metrics2 = indexServiceBuilder.metrics();
        if (metrics == null) {
            if (metrics2 != null) {
                return false;
            }
        } else if (!metrics.equals(metrics2)) return false;
        LfValueTranslationCache.Cache cache = this.lfValueTranslationCache();
        LfValueTranslationCache.Cache cache2 = indexServiceBuilder.lfValueTranslationCache();
        if (cache == null) {
            if (cache2 != null) {
                return false;
            }
        } else if (!((Object)cache).equals(cache2)) return false;
        ValueEnricher valueEnricher = this.enricher();
        ValueEnricher valueEnricher2 = indexServiceBuilder.enricher();
        if (valueEnricher == null) {
            if (valueEnricher2 != null) {
                return false;
            }
        } else if (!valueEnricher.equals(valueEnricher2)) return false;
        String string = this.participantId();
        String string2 = indexServiceBuilder.participantId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Option<StringInterningView> option = this.sharedStringInterningViewO();
        Option<StringInterningView> option2 = indexServiceBuilder.sharedStringInterningViewO();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!indexServiceBuilder.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$owner$12(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$cachesUpdaterSubscription$3(InstrumentedSignalNewLedgerHead instrumentedSignalNewLedgerHead$2, ParameterStorageBackend.LedgerEnd newLedgerHead$1, Dispatcher prefetchingDispatcher$2, BoxedUnit x$7) {
        BoxedUnit boxedUnit = x$7;
        instrumentedSignalNewLedgerHead$2.startTimer(newLedgerHead$1.lastOffset());
        prefetchingDispatcher$2.signalNewHead((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newLedgerHead$1.lastOffset()), (Object)BoxesRunTime.boxToLong((long)newLedgerHead$1.lastEventSeqId())));
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$cachesUpdaterSubscription$5(LedgerEndPoller x$9) {
    }

    public static final /* synthetic */ void $anonfun$buildInstrumentedSignalNewLedgerHead$1(MutableLedgerEndCache ledgerEndCache$2, Dispatcher generalDispatcher$2, Offset offset, long eventSeqId) {
        ledgerEndCache$2.set((Tuple2<Offset, Object>)new Tuple2((Object)offset, (Object)BoxesRunTime.boxToLong((long)eventSeqId)));
        generalDispatcher$2.signalNewHead((Object)offset);
    }

    public static final /* synthetic */ boolean $anonfun$cacheComponentsAndSubscription$1(TransactionLogUpdate x$10) {
        return x$10 instanceof TransactionLogUpdate.LedgerEndMarker;
    }

    public static final /* synthetic */ Future $anonfun$verifyLedgerId$1(IndexServiceBuilder $this, LedgerReadDao ledgerDao$3, LoggingContext loggingContext$1, int maxAttempts$1, FiniteDuration retryDelay$1, ExecutionContext executionContext$1, int attempt, Duration x$19) {
        return ledgerDao$3.lookupLedgerId(loggingContext$1).flatMap((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            Some some = null;
            Option option = x0$1;
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                Object object = some.value();
                if (BoxesRunTime.equals((Object)$this.initialLedgerId(), (Object)object)) {
                    $this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(31).append("Found existing ledger with ID: ").append($this.initialLedgerId()).toString(), loggingContext$1);
                    return Future$.MODULE$.successful($this.initialLedgerId());
                }
            }
            if (bl) {
                Object foundLedgerId = some.value();
                return Future$.MODULE$.failed((Throwable)new ProgramResource.StartupException($this, foundLedgerId){

                    public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
                        return super.fillInStackTrace();
                    }

                    public Throwable fillInStackTrace() {
                        return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
                    }
                    {
                        NoStackTrace.$init$((NoStackTrace)this);
                    }
                });
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            $this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(75).append("Ledger ID not found in the index database on attempt ").append(attempt).append("/").append(maxAttempts$1).append(". Retrying again in ").append(retryDelay$1).append(".").toString(), loggingContext$1);
            return Future$.MODULE$.failed((Throwable)new LedgerIdNotFoundException(attempt));
        }, executionContext$1);
    }

    public IndexServiceBuilder(IndexServiceConfig config, DbSupport dbSupport, Object initialLedgerId, ExecutionContext servicesExecutionContext, Metrics metrics, LfValueTranslationCache.Cache lfValueTranslationCache, ValueEnricher enricher, String participantId, Option<StringInterningView> sharedStringInterningViewO, Materializer mat, LoggingContext loggingContext, ExecutionContext executionContext) {
        this.config = config;
        this.dbSupport = dbSupport;
        this.initialLedgerId = initialLedgerId;
        this.servicesExecutionContext = servicesExecutionContext;
        this.metrics = metrics;
        this.lfValueTranslationCache = lfValueTranslationCache;
        this.enricher = enricher;
        this.participantId = participantId;
        this.sharedStringInterningViewO = sharedStringInterningViewO;
        this.mat = mat;
        this.loggingContext = loggingContext;
        this.executionContext = executionContext;
        Product.$init$((Product)this);
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
    }
}

