/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.index;

import akka.NotUsed;
import akka.stream.Graph;
import akka.stream.scaladsl.FlowOps;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import com.daml.daml_lf_dev.DamlLf;
import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.DamlContextualizedErrorLogger;
import com.daml.error.definitions.groups.RequestValidation;
import com.daml.ledger.api.TraceIdentifiers$;
import com.daml.ledger.api.domain;
import com.daml.ledger.api.domain$LedgerOffset$LedgerEnd$;
import com.daml.ledger.api.health.HealthStatus;
import com.daml.ledger.api.v1.active_contracts_service.GetActiveContractsResponse;
import com.daml.ledger.api.v1.active_contracts_service.GetActiveContractsResponse$;
import com.daml.ledger.api.v1.command_completion_service.CompletionStreamResponse;
import com.daml.ledger.api.v1.transaction_service.GetFlatTransactionResponse;
import com.daml.ledger.api.v1.transaction_service.GetTransactionResponse;
import com.daml.ledger.api.v1.transaction_service.GetTransactionTreesResponse;
import com.daml.ledger.api.v1.transaction_service.GetTransactionsResponse;
import com.daml.ledger.configuration.Configuration;
import com.daml.ledger.offset.Offset;
import com.daml.ledger.offset.Offset$;
import com.daml.ledger.participant.state.index.v2.ContractStore;
import com.daml.ledger.participant.state.index.v2.IndexService;
import com.daml.ledger.participant.state.index.v2.LedgerConfiguration;
import com.daml.ledger.participant.state.index.v2.MaximumLedgerTime;
import com.daml.ledger.participant.state.index.v2.MeteringStore;
import com.daml.ledger.participant.state.index.v2.PackageDetails;
import com.daml.lf.data.Ref;
import com.daml.lf.data.Time;
import com.daml.lf.transaction.GlobalKey;
import com.daml.lf.transaction.Versioned;
import com.daml.lf.value.Value;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.metrics.InstrumentedGraph;
import com.daml.metrics.InstrumentedGraph$;
import com.daml.metrics.Metrics;
import com.daml.platform.ApiOffset$;
import com.daml.platform.akkastreams.dispatcher.Dispatcher;
import com.daml.platform.akkastreams.dispatcher.SubSource;
import com.daml.platform.store.dao.LedgerDaoTransactionsReader;
import com.daml.platform.store.dao.LedgerReadDao;
import com.daml.platform.store.entries.ConfigurationEntry;
import com.daml.platform.store.entries.PackageLedgerEntry;
import com.daml.platform.store.entries.PartyLedgerEntry;
import com.daml.telemetry.Event;
import com.daml.telemetry.SpanAttribute$;
import com.daml.telemetry.Spans$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scalaz.syntax.TagOps$;
import scalaz.syntax.package$;

@ScalaSignature(bytes="\u0006\u0005\u0011ug!B\u0017/\u000192\u0004\u0002\u0003&\u0001\u0005\u000b\u0007I\u0011\u0001'\t\u0011\u0005\u0004!\u0011!Q\u0001\n5C\u0001B\u0019\u0001\u0003\u0002\u0003\u0006Ia\u0019\u0005\t_\u0002\u0011\t\u0011)A\u0005a\"A\u0001\u0010\u0001B\u0001B\u0003%\u0011\u0010\u0003\u0005}\u0001\t\u0005\t\u0015!\u0003~\u0011)\t\t\u0001\u0001B\u0001B\u0003%\u00111\u0001\u0005\u000b\u0003+\u0001!\u0011!Q\u0001\n\u0005]\u0001BCA\u0019\u0001\t\u0005\t\u0015!\u0003\u00024!9\u0011Q\b\u0001\u0005\u0002\u0005}\u0002\"CA+\u0001\t\u0007I\u0011BA,\u0011!\ty\u0006\u0001Q\u0001\n\u0005e\u0003\"CA1\u0001\t\u0007I\u0011BA2\u0011!\t\t\b\u0001Q\u0001\n\u0005\u0015\u0004bBA:\u0001\u0011\u0005\u0013Q\u000f\u0005\b\u0003\u001f\u0003A\u0011IAI\u0011\u001d\ty\n\u0001C!\u0003CCq!a=\u0001\t\u0003\n)\u0010C\u0004\u0003P\u0001!\tE!\u0015\t\u000f\t-\u0004\u0001\"\u0011\u0003n!9!1\u000e\u0001\u0005B\tE\u0005b\u0002BP\u0001\u0011\u0005#\u0011\u0015\u0005\b\u0005w\u0003A\u0011\tB_\u0011\u001d\u0011)\u000e\u0001C!\u0005/DqA!>\u0001\t\u0003\u00129\u0010C\u0004\u0004\f\u0001!\te!\u0004\t\u000f\r\u0005\u0002\u0001\"\u0011\u0004$!91\u0011\n\u0001\u0005B\r-\u0003bBB)\u0001\u0011\u000531\u000b\u0005\b\u0007g\u0002A\u0011IB;\u0011\u001d\u0019y\t\u0001C!\u0007#Cqaa-\u0001\t\u0003\u001a)\fC\u0004\u0004F\u0002!\tea2\t\u000f\r\r\b\u0001\"\u0011\u0004f\"911\u001f\u0001\u0005B\rU\bb\u0002C\u0006\u0001\u0011\u0005CQ\u0002\u0005\b\tG\u0001A\u0011\tC\u0013\u0011\u001d!y\u0007\u0001C!\tcBq\u0001\"\u001f\u0001\t\u0013!Y\bC\u0004\u0005~\u0001!I\u0001b \t\u000f\u0011%\u0005\u0001\"\u0003\u0005\f\"9AQ\u0018\u0001\u0005\n\u0011}\u0006b\u0002Ch\u0001\u0011%A\u0011\u001b\u0005\b\t/\u0004A\u0011\u0002Cm\u0005AIe\u000eZ3y'\u0016\u0014h/[2f\u00136\u0004HN\u0003\u00020a\u0005)\u0011N\u001c3fq*\u0011\u0011GM\u0001\ta2\fGOZ8s[*\u00111\u0007N\u0001\u0005I\u0006lGNC\u00016\u0003\r\u0019w.\\\n\u0004\u0001]j\u0004C\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ$AB!osJ+g\r\u0005\u0002?\u00116\tqH\u0003\u0002A\u0003\u0006\u0011aO\r\u0006\u0003_\tS!a\u0011#\u0002\u000bM$\u0018\r^3\u000b\u0005\u00153\u0015a\u00039beRL7-\u001b9b]RT!a\u0012\u001a\u0002\r1,GmZ3s\u0013\tIuH\u0001\u0007J]\u0012,\u0007pU3sm&\u001cW-\u0001\u0005mK\u0012<WM]%e\u0007\u0001)\u0012!\u0014\t\u0003\u001dzs!aT.\u000f\u0005AKfBA)Y\u001d\t\u0011vK\u0004\u0002T-6\tAK\u0003\u0002V\u0017\u00061AH]8pizJ\u0011!N\u0005\u0003gQJ!a\u0012\u001a\n\u0005i3\u0015aA1qS&\u0011A,X\u0001\u0007I>l\u0017-\u001b8\u000b\u0005i3\u0015BA0a\u0005!aU\rZ4fe&#'B\u0001/^\u0003%aW\rZ4fe&#\u0007%A\u0007qCJ$\u0018nY5qC:$\u0018\n\u001a\t\u0003I2t!!\u001a6\u000e\u0003\u0019T!a\u001a5\u0002\t\u0011\fG/\u0019\u0006\u0003SJ\n!\u0001\u001c4\n\u0005-4\u0017a\u0001*fM&\u0011QN\u001c\u0002\u000e!\u0006\u0014H/[2ja\u0006tG/\u00133\u000b\u0005-4\u0017!\u00037fI\u001e,'\u000fR1p!\t\th/D\u0001s\u0015\t\u0019H/A\u0002eC>T!!\u001e\u0019\u0002\u000bM$xN]3\n\u0005]\u0014(!\u0004'fI\u001e,'OU3bI\u0012\u000bw.\u0001\nue\u0006t7/Y2uS>t7OU3bI\u0016\u0014\bCA9{\u0013\tY(OA\u000eMK\u0012<WM\u001d#b_R\u0013\u0018M\\:bGRLwN\\:SK\u0006$WM]\u0001\u000eG>tGO]1diN#xN]3\u0011\u0005yr\u0018BA@@\u00055\u0019uN\u001c;sC\u000e$8\u000b^8sK\u0006a\u0001O];oK\n+hMZ3sgB!\u0011QAA\b\u001d\u0011\t9!a\u0003\u000f\u0007E\u000bI!\u0003\u00022e%\u0019\u0011Q\u0002\u0019\u0002\u000fA\f7m[1hK&!\u0011\u0011CA\n\u00051\u0001&/\u001e8f\u0005V4g-\u001a:t\u0015\r\ti\u0001M\u0001\u000bI&\u001c\b/\u0019;dQ\u0016\u0014\bCBA\r\u0003C\t)#\u0004\u0002\u0002\u001c)!\u0011QCA\u000f\u0015\r\ty\u0002M\u0001\fC.\\\u0017m\u001d;sK\u0006l7/\u0003\u0003\u0002$\u0005m!A\u0003#jgB\fGo\u00195feB!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,\u0019\u000baa\u001c4gg\u0016$\u0018\u0002BA\u0018\u0003S\u0011aa\u00144gg\u0016$\u0018aB7fiJL7m\u001d\t\u0005\u0003k\tI$\u0004\u0002\u00028)\u0019\u0011\u0011\u0007\u001a\n\t\u0005m\u0012q\u0007\u0002\b\u001b\u0016$(/[2t\u0003\u0019a\u0014N\\5u}Q\u0011\u0012\u0011IA#\u0003\u000f\nI%a\u0013\u0002N\u0005=\u0013\u0011KA*!\r\t\u0019\u0005A\u0007\u0002]!)!J\u0003a\u0001\u001b\")!M\u0003a\u0001G\")qN\u0003a\u0001a\")\u0001P\u0003a\u0001s\")AP\u0003a\u0001{\"9\u0011\u0011\u0001\u0006A\u0002\u0005\r\u0001bBA\u000b\u0015\u0001\u0007\u0011q\u0003\u0005\b\u0003cQ\u0001\u0019AA\u001a\u0003iaU\rZ4fe\u0006\u0003\u0018n\u0015;sK\u0006l7OQ;gM\u0016\u00148+\u001b>f+\t\tI\u0006E\u00029\u00037J1!!\u0018:\u0005\rIe\u000e^\u0001\u001c\u0019\u0016$w-\u001a:Ba&\u001cFO]3b[N\u0014UO\u001a4feNK'0\u001a\u0011\u0002\r1|wmZ3s+\t\t)\u0007\u0005\u0003\u0002h\u00055TBAA5\u0015\r\tYGM\u0001\bY><w-\u001b8h\u0013\u0011\ty'!\u001b\u0003)\r{g\u000e^3yiV\fG.\u001b>fI2{wmZ3s\u0003\u001dawnZ4fe\u0002\n\u0001cZ3u!\u0006\u0014H/[2ja\u0006tG/\u00133\u0015\u0005\u0005]D\u0003BA=\u0003\u000b\u0003R!a\u001f\u0002\u0002\u000el!!! \u000b\u0007\u0005}\u0014(\u0001\u0006d_:\u001cWO\u001d:f]RLA!a!\u0002~\t1a)\u001e;ve\u0016Dq!a\"\u0010\u0001\b\tI)\u0001\bm_\u001e<\u0017N\\4D_:$X\r\u001f;\u0011\t\u0005\u001d\u00141R\u0005\u0005\u0003\u001b\u000bIG\u0001\bM_\u001e<\u0017N\\4D_:$X\r\u001f;\u0002\u001b\r,(O]3oi\"+\u0017\r\u001c;i)\t\t\u0019\n\u0005\u0003\u0002\u0016\u0006mUBAAL\u0015\r\tI*X\u0001\u0007Q\u0016\fG\u000e\u001e5\n\t\u0005u\u0015q\u0013\u0002\r\u0011\u0016\fG\u000e\u001e5Ti\u0006$Xo]\u0001\u0012Y>|7.\u001e9D_:$(/Y2u\u0017\u0016LHCBAR\u0003\u0013\f\u0019\u000f\u0006\u0003\u0002&\u0006\u001d\u0007CBA>\u0003\u0003\u000b9\u000bE\u00039\u0003S\u000bi+C\u0002\u0002,f\u0012aa\u00149uS>t\u0007\u0003BAX\u0003\u0003tA!!-\u0002<:!\u00111WA\\\u001d\r\t\u0016QW\u0005\u0003SJJ1!!/i\u0003\u00151\u0018\r\\;f\u0013\u0011\ti,a0\u0002\u000bY\u000bG.^3\u000b\u0007\u0005e\u0006.\u0003\u0003\u0002D\u0006\u0015'AC\"p]R\u0014\u0018m\u0019;JI*!\u0011QXA`\u0011\u001d\t9)\u0005a\u0002\u0003\u0013Cq!a3\u0012\u0001\u0004\ti-A\u0004sK\u0006$WM]:\u0011\r\u0005=\u0017q[Ao\u001d\u0011\t\t.a5\u0011\u0005MK\u0014bAAks\u00051\u0001K]3eK\u001aLA!!7\u0002\\\n\u00191+\u001a;\u000b\u0007\u0005U\u0017\bE\u0002e\u0003?L1!!9o\u0005\u0015\u0001\u0016M\u001d;z\u0011\u001d\t)/\u0005a\u0001\u0003O\f1a[3z!\u0011\tI/a<\u000e\u0005\u0005-(bAAwQ\u0006YAO]1og\u0006\u001cG/[8o\u0013\u0011\t\t0a;\u0003\u0013\u001dcwNY1m\u0017\u0016L\u0018\u0001\u0004;sC:\u001c\u0018m\u0019;j_:\u001cHCCA|\u0005O\u0011)Da\u000f\u0003FQ!\u0011\u0011 B\u0013!!\tYP!\u0003\u0003\u000e\tuQBAA\u007f\u0015\u0011\tyP!\u0001\u0002\u0011M\u001c\u0017\r\\1eg2TAAa\u0001\u0003\u0006\u000511\u000f\u001e:fC6T!Aa\u0002\u0002\t\u0005\\7.Y\u0005\u0005\u0005\u0017\tiP\u0001\u0004T_V\u00148-\u001a\t\u0005\u0005\u001f\u0011I\"\u0004\u0002\u0003\u0012)!!1\u0003B\u000b\u0003M!(/\u00198tC\u000e$\u0018n\u001c8`g\u0016\u0014h/[2f\u0015\r\u00119\"X\u0001\u0003mFJAAa\u0007\u0003\u0012\t9r)\u001a;Ue\u0006t7/Y2uS>t7OU3ta>t7/\u001a\t\u0005\u0005?\u0011\t#\u0004\u0002\u0003\u0006%!!1\u0005B\u0003\u0005\u001dqu\u000e^+tK\u0012Dq!a\"\u0013\u0001\b\tI\tC\u0004\u0003*I\u0001\rAa\u000b\u0002\u001dM$\u0018M\u001d;Fq\u000edWo]5wKB!!Q\u0006B\u0019\u001d\r\u0011ycW\u0007\u0002;&\u0019!1\u00071\u0003\u00191+GmZ3s\u001f\u001a47/\u001a;\t\u000f\t]\"\u00031\u0001\u0003:\u0005aQM\u001c3J]\u000edWo]5wKB)\u0001(!+\u0003,!9!Q\b\nA\u0002\t}\u0012A\u00024jYR,'\u000f\u0005\u0003\u0003.\t\u0005\u0013b\u0001B\"A\n\tBK]1og\u0006\u001cG/[8o\r&dG/\u001a:\t\u000f\t\u001d#\u00031\u0001\u0003J\u00059a/\u001a:c_N,\u0007c\u0001\u001d\u0003L%\u0019!QJ\u001d\u0003\u000f\t{w\u000e\\3b]\u0006\u0001BO]1og\u0006\u001cG/[8o)J,Wm\u001d\u000b\u000b\u0005'\u0012yFa\u0019\u0003h\t%D\u0003\u0002B+\u0005;\u0002\u0002\"a?\u0003\n\t]#Q\u0004\t\u0005\u0005\u001f\u0011I&\u0003\u0003\u0003\\\tE!aG$fiR\u0013\u0018M\\:bGRLwN\u001c+sK\u0016\u001c(+Z:q_:\u001cX\rC\u0004\u0002\bN\u0001\u001d!!#\t\u000f\t%2\u00031\u0001\u0003bA\u0019aJ!\r\t\u000f\t]2\u00031\u0001\u0003fA)\u0001(!+\u0003b!9!QH\nA\u0002\t}\u0002b\u0002B$'\u0001\u0007!\u0011J\u0001\u000fO\u0016$8i\\7qY\u0016$\u0018n\u001c8t)!\u0011yG!!\u0003\u0004\n5E\u0003\u0002B9\u0005\u007f\u0002\u0002\"a?\u0003\n\tM$Q\u0004\t\u0005\u0005k\u0012Y(\u0004\u0002\u0003x)!!\u0011\u0010B\u000b\u0003i\u0019w.\\7b]\u0012|6m\\7qY\u0016$\u0018n\u001c8`g\u0016\u0014h/[2f\u0013\u0011\u0011iHa\u001e\u00031\r{W\u000e\u001d7fi&|gn\u0015;sK\u0006l'+Z:q_:\u001cX\rC\u0004\u0002\bR\u0001\u001d!!#\t\u000f\t%B\u00031\u0001\u0003b!9!Q\u0011\u000bA\u0002\t\u001d\u0015!D1qa2L7-\u0019;j_:LE\rE\u0002e\u0005\u0013K1Aa#o\u00055\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8JI\"9!q\u0012\u000bA\u0002\u00055\u0017a\u00029beRLWm\u001d\u000b\u000b\u0005'\u00139J!'\u0003\u001c\nuE\u0003\u0002B9\u0005+Cq!a\"\u0016\u0001\b\tI\tC\u0004\u0003*U\u0001\rA!\u0019\t\u000f\t]R\u00031\u0001\u0003b!9!QQ\u000bA\u0002\t\u001d\u0005b\u0002BH+\u0001\u0007\u0011QZ\u0001\u0013O\u0016$\u0018i\u0019;jm\u0016\u001cuN\u001c;sC\u000e$8\u000f\u0006\u0004\u0003$\nU&\u0011\u0018\u000b\u0005\u0005K\u0013\u0019\f\u0005\u0005\u0002|\n%!q\u0015B\u000f!\u0011\u0011IKa,\u000e\u0005\t-&\u0002\u0002BW\u0005+\t\u0001$Y2uSZ,wlY8oiJ\f7\r^:`g\u0016\u0014h/[2f\u0013\u0011\u0011\tLa+\u00035\u001d+G/Q2uSZ,7i\u001c8ue\u0006\u001cGo\u001d*fgB|gn]3\t\u000f\u0005\u001de\u0003q\u0001\u0002\n\"9!Q\b\fA\u0002\t]\u0006c\u0001(\u0003B!9!q\t\fA\u0002\t%\u0013\u0001\u00067p_.,\b/Q2uSZ,7i\u001c8ue\u0006\u001cG\u000f\u0006\u0004\u0003@\n5'\u0011\u001b\u000b\u0005\u0005\u0003\u0014Y\r\u0005\u0004\u0002|\u0005\u0005%1\u0019\t\u0006q\u0005%&Q\u0019\t\u0005\u0003_\u00139-\u0003\u0003\u0003J\u0006\u0015'!\u0007,feNLwN\\3e\u0007>tGO]1di&s7\u000f^1oG\u0016Dq!a\"\u0018\u0001\b\tI\tC\u0004\u0003P^\u0001\r!!4\u0002\u0015\u0019|'\u000fU1si&,7\u000fC\u0004\u0003T^\u0001\r!!,\u0002\u0015\r|g\u000e\u001e:bGRLE-\u0001\nhKR$&/\u00198tC\u000e$\u0018n\u001c8Cs&#GC\u0002Bm\u0005O\u0014\t\u0010\u0006\u0003\u0003\\\n\u0015\bCBA>\u0003\u0003\u0013i\u000eE\u00039\u0003S\u0013y\u000e\u0005\u0003\u0003\u0010\t\u0005\u0018\u0002\u0002Br\u0005#\u0011!dR3u\r2\fG\u000f\u0016:b]N\f7\r^5p]J+7\u000f]8og\u0016Dq!a\"\u0019\u0001\b\tI\tC\u0004\u0003jb\u0001\rAa;\u0002\u001bQ\u0014\u0018M\\:bGRLwN\\%e!\rq%Q^\u0005\u0004\u0005_\u0004'!\u0004+sC:\u001c\u0018m\u0019;j_:LE\rC\u0004\u0003tb\u0001\r!!4\u0002#I,\u0017/^3ti&tw\rU1si&,7/\u0001\fhKR$&/\u00198tC\u000e$\u0018n\u001c8Ue\u0016,')_%e)\u0019\u0011Ipa\u0002\u0004\nQ!!1`B\u0003!\u0019\tY(!!\u0003~B)\u0001(!+\u0003\u0000B!!qBB\u0001\u0013\u0011\u0019\u0019A!\u0005\u0003-\u001d+G\u000f\u0016:b]N\f7\r^5p]J+7\u000f]8og\u0016Dq!a\"\u001a\u0001\b\tI\tC\u0004\u0003jf\u0001\rAa;\t\u000f\tM\u0018\u00041\u0001\u0002N\u0006QCn\\8lkBl\u0015\r_5nk6dU\rZ4feRKW.Z!gi\u0016\u0014\u0018J\u001c;feB\u0014X\r^1uS>tG\u0003BB\b\u00077!Ba!\u0005\u0004\u001aA1\u00111PAA\u0007'\u00012APB\u000b\u0013\r\u00199b\u0010\u0002\u0012\u001b\u0006D\u0018.\\;n\u0019\u0016$w-\u001a:US6,\u0007bBAD5\u0001\u000f\u0011\u0011\u0012\u0005\b\u0007;Q\u0002\u0019AB\u0010\u0003-\u0019wN\u001c;sC\u000e$\u0018\nZ:\u0011\r\u0005=\u0017q[AW\u0003)9W\r\u001e)beRLWm\u001d\u000b\u0005\u0007K\u0019\t\u0005\u0006\u0003\u0004(\r}\u0002CBA>\u0003\u0003\u001bI\u0003\u0005\u0004\u0004,\rM2\u0011\b\b\u0005\u0007[\u0019\tDD\u0002T\u0007_I\u0011AO\u0005\u0004\u0003\u001bI\u0014\u0002BB\u001b\u0007o\u0011A\u0001T5ti*\u0019\u0011QB\u001d\u0011\t\t521H\u0005\u0004\u0007{\u0001'\u0001\u0004)beRLH)\u001a;bS2\u001c\bbBAD7\u0001\u000f\u0011\u0011\u0012\u0005\b\u0005\u001f[\u0002\u0019AB\"!\u0019\u0019Yc!\u0012\u0002^&!1qIB\u001c\u0005\r\u0019V-]\u0001\u0011Y&\u001cHo\u00138po:\u0004\u0016M\u001d;jKN$\"a!\u0014\u0015\t\r\u001d2q\n\u0005\b\u0003\u000fc\u00029AAE\u00031\u0001\u0018M\u001d;z\u000b:$(/[3t)\u0011\u0019)f!\u0019\u0015\t\r]3q\f\t\t\u0003w\u0014Ia!\u0017\u0003\u001eA\u0019aja\u0017\n\u0007\ru\u0003M\u0001\u0006QCJ$\u00180\u00128uefDq!a\"\u001e\u0001\b\tI\tC\u0004\u0003*u\u0001\raa\u0019\u0011\u000ba\nIk!\u001a\u0011\t\r\u001d4Q\u000e\b\u0004\u001d\u000e%\u0014bAB6A\u0006aA*\u001a3hKJ|eMZ:fi&!1qNB9\u0005!\t%m]8mkR,'bAB6A\u0006qA.[:u\u0019\u001a\u0004\u0016mY6bO\u0016\u001cHCAB<)\u0011\u0019Ih!$\u0011\r\u0005m\u0014\u0011QB>!!\tym! \u0004\u0002\u000e\u001d\u0015\u0002BB@\u00037\u00141!T1q!\r!71Q\u0005\u0004\u0007\u000bs'!\u0003)bG.\fw-Z%e!\rq4\u0011R\u0005\u0004\u0007\u0017{$A\u0004)bG.\fw-\u001a#fi\u0006LGn\u001d\u0005\b\u0003\u000fs\u00029AAE\u000319W\r\u001e'g\u0003J\u001c\u0007.\u001b<f)\u0011\u0019\u0019ja,\u0015\t\rU5Q\u0016\t\u0007\u0003w\n\tia&\u0011\u000ba\nIk!'\u0011\t\rm5q\u0015\b\u0005\u0007;\u001b\u0019+\u0004\u0002\u0004 *\u00191\u0011\u0015\u001a\u0002\u0017\u0011\fW\u000e\\0mM~#WM^\u0005\u0005\u0007K\u001by*\u0001\u0004EC6dGJZ\u0005\u0005\u0007S\u001bYKA\u0004Be\u000eD\u0017N^3\u000b\t\r\u00156q\u0014\u0005\b\u0003\u000f{\u00029AAE\u0011\u001d\u0019\tl\ba\u0001\u0007\u0003\u000b\u0011\u0002]1dW\u0006<W-\u00133\u0002\u001dA\f7m[1hK\u0016sGO]5fgR!1qWBb)\u0011\u0019Il!1\u0011\u0011\u0005m(\u0011BB^\u0005;\u00012ATB_\u0013\r\u0019y\f\u0019\u0002\r!\u0006\u001c7.Y4f\u000b:$(/\u001f\u0005\b\u0003\u000f\u0003\u00039AAE\u0011\u001d\u0011I\u0003\ta\u0001\u0007G\n1\u0003\\8pWV\u00048i\u001c8gS\u001e,(/\u0019;j_:$\"a!3\u0015\t\r-7\u0011\u001d\t\u0007\u0003w\n\ti!4\u0011\u000ba\nIka4\u0011\u000fa\u001a\tn!\u001a\u0004V&\u001911[\u001d\u0003\rQ+\b\u000f\\33!\u0011\u00199n!8\u000e\u0005\re'bABn\r\u0006i1m\u001c8gS\u001e,(/\u0019;j_:LAaa8\u0004Z\ni1i\u001c8gS\u001e,(/\u0019;j_:Dq!a\"\"\u0001\b\tI)\u0001\fhKRdU\rZ4fe\u000e{gNZ5hkJ\fG/[8o)\t\u00199\u000f\u0006\u0003\u0004j\u000eE\b\u0003CA~\u0005\u0013\u0019YO!\b\u0011\u0007y\u001ai/C\u0002\u0004p~\u00121\u0003T3eO\u0016\u00148i\u001c8gS\u001e,(/\u0019;j_:Dq!a\"#\u0001\b\tI)\u0001\u000bd_:4\u0017nZ;sCRLwN\\#oiJLWm\u001d\u000b\u0005\u0007o$I\u0001\u0006\u0003\u0004z\u0012\u001d\u0001\u0003CA~\u0005\u0013\u0019YP!\b\u0011\u000fa\u001a\tn!@\u0005\u0002A!1q`B7\u001d\u0011\u0011ic!\u001b\u0011\t\t5B1A\u0005\u0004\t\u000b\u0001'AE\"p]\u001aLw-\u001e:bi&|g.\u00128uefDq!a\"$\u0001\b\tI\tC\u0004\u0003*\r\u0002\raa\u0019\u0002\u000bA\u0014XO\\3\u0015\r\u0011=A1\u0004C\u0010)\u0011!\t\u0002\"\u0007\u0011\r\u0005m\u0014\u0011\u0011C\n!\rADQC\u0005\u0004\t/I$\u0001B+oSRDq!a\"%\u0001\b\tI\tC\u0004\u0005\u001e\u0011\u0002\r!!\n\u0002%A\u0014XO\\3VaR{\u0017J\\2mkNLg/\u001a\u0005\b\tC!\u0003\u0019\u0001B%\u0003e\u0001(/\u001e8f\u00032dG)\u001b<vY\u001e,GmQ8oiJ\f7\r^:\u0002+\u001d,G/T3uKJLgn\u001a*fa>\u0014H\u000fR1uCRAAq\u0005C&\tC\"9\u0007\u0006\u0003\u0005*\u0011%\u0003CBA>\u0003\u0003#Y\u0003\u0005\u0003\u0005.\u0011\rc\u0002\u0002C\u0018\t\u007fqA\u0001\"\r\u0005>9!A1\u0007C\u001e\u001d\u0011!)\u0004\"\u000f\u000f\u0007A#9$\u0003\u0002F\r&\u00111\tR\u0005\u0003_\tK!\u0001Q!\n\u0007\u0011\u0005s(A\u0007NKR,'/\u001b8h'R|'/Z\u0005\u0005\t\u000b\"9E\u0001\u0006SKB|'\u000f\u001e#bi\u0006T1\u0001\"\u0011@\u0011\u001d\t9)\na\u0002\u0003\u0013Cq\u0001\"\u0014&\u0001\u0004!y%\u0001\u0003ge>l\u0007\u0003\u0002C)\t7rA\u0001b\u0015\u0005X9!\u00111\u0017C+\u0013\t9\u0007.C\u0002\u0005Z\u0019\fA\u0001V5nK&!AQ\fC0\u0005%!\u0016.\\3ti\u0006l\u0007OC\u0002\u0005Z\u0019Dq\u0001b\u0019&\u0001\u0004!)'\u0001\u0002u_B)\u0001(!+\u0005P!9!QQ\u0013A\u0002\u0011%\u0004#\u0002\u001d\u0002*\u0012-\u0004\u0003\u0002C7\u0005\u0013s1\u0001b\u0015k\u0003A\u0019WO\u001d:f]RdU\rZ4fe\u0016sG\r\u0006\u0002\u0005tQ!AQ\u000fC<!\u0019\tY(!!\u0004f!9\u0011q\u0011\u0014A\u0004\u0005%\u0015!\u00037fI\u001e,'/\u00128e)\t\t)#A\u0007d_:4XM\u001d;PM\u001a\u001cX\r^\u000b\u0003\t\u0003\u0003r\u0001\u000fCB\u0005C\"9)C\u0002\u0005\u0006f\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0011\u0005m(\u0011BA\u0013\u0005;\tqAY3uo\u0016,g.\u0006\u0003\u0005\u000e\u0012eEC\u0002CH\ts#Y\f\u0006\u0003\u0005\u0012\u00125F\u0003\u0002CJ\tW\u0003\u0002\"a?\u0003\n\u0011U%Q\u0004\t\u0005\t/#I\n\u0004\u0001\u0005\u000f\u0011m\u0015F1\u0001\u0005\u001e\n\t\u0011)\u0005\u0003\u0005 \u0012\u0015\u0006c\u0001\u001d\u0005\"&\u0019A1U\u001d\u0003\u000f9{G\u000f[5oOB\u0019\u0001\bb*\n\u0007\u0011%\u0016HA\u0002B]fDq!a\"*\u0001\b\tI\tC\u0004\u00050&\u0002\r\u0001\"-\u0002\u0003\u0019\u0004\u0012\u0002\u000fCZ\to#9\fb%\n\u0007\u0011U\u0016HA\u0005Gk:\u001cG/[8oeA)\u0001(!+\u0002&!9!\u0011F\u0015A\u0002\t-\u0002b\u0002B\u001cS\u0001\u0007!\u0011H\u0001\u000eG>tg/\u001a:u\r&dG/\u001a:\u0015\t\u0011\u0005GQ\u001a\t\t\u0003\u001f\u001ci\bb1\u0005FB!AQNAp!\u0019\ty-a6\u0005HB!AQ\u000eCe\u0013\r!YM\u001c\u0002\u000b\u0013\u0012,g\u000e^5gS\u0016\u0014\bb\u0002B\u001fU\u0001\u0007!qW\u0001\u000fG>t7M]3uK>3gm]3u)\u0011!\u0019\u000e\"6\u0011\r\u0005m\u0014\u0011QA\u0013\u0011\u001d\u0011Ic\u000ba\u0001\u0007G\n!\u0002^8BEN|G.\u001e;f)\u0011\u0019)\u0007b7\t\u000f\u0005-B\u00061\u0001\u0002&\u0001")
public class IndexServiceImpl
implements IndexService {
    private final Object ledgerId;
    private final String participantId;
    private final LedgerReadDao ledgerDao;
    private final LedgerDaoTransactionsReader transactionsReader;
    private final ContractStore contractStore;
    private final Function1<Offset, BoxedUnit> pruneBuffers;
    private final Dispatcher<Offset> dispatcher;
    private final Metrics metrics;
    private final int LedgerApiStreamsBufferSize;
    private final ContextualizedLogger logger;

    public Object ledgerId() {
        return this.ledgerId;
    }

    private int LedgerApiStreamsBufferSize() {
        return this.LedgerApiStreamsBufferSize;
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    public Future<String> getParticipantId(LoggingContext loggingContext) {
        return Future$.MODULE$.successful((Object)this.participantId);
    }

    public HealthStatus currentHealth() {
        return this.ledgerDao.currentHealth();
    }

    public Future<Option<Value.ContractId>> lookupContractKey(Set<String> readers, GlobalKey key, LoggingContext loggingContext) {
        return this.contractStore.lookupContractKey(readers, key, loggingContext);
    }

    public Source<GetTransactionsResponse, NotUsed> transactions(domain.LedgerOffset startExclusive, Option<domain.LedgerOffset> endInclusive, domain.TransactionFilter filter, boolean verbose, LoggingContext loggingContext) {
        return (Source)this.between(startExclusive, endInclusive, (Function2 & Serializable)(from, to) -> {
            from.foreach((Function1 & Serializable)offset -> {
                Spans$.MODULE$.setCurrentSpanAttribute(SpanAttribute$.MODULE$.OffsetFrom(), offset.toHexString());
                return BoxedUnit.UNIT;
            });
            to.foreach((Function1 & Serializable)offset -> {
                Spans$.MODULE$.setCurrentSpanAttribute(SpanAttribute$.MODULE$.OffsetTo(), offset.toHexString());
                return BoxedUnit.UNIT;
            });
            return InstrumentedGraph.BufferedSource$.MODULE$.buffered$extension(InstrumentedGraph$.MODULE$.BufferedSource((Source)$this.dispatcher.startingAt(from.getOrElse((Function0 & Serializable)() -> Offset$.MODULE$.beforeBegin()), (SubSource)new SubSource.RangeSource((Function2 & Serializable)(x$1, x$2) -> $this.transactionsReader.getFlatTransactions((Offset)x$1, (Offset)x$2, this.convertFilter(filter), verbose, loggingContext), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())), to).map((Function1 & Serializable)x$3 -> (GetTransactionsResponse)x$3._2())), $this.metrics.daml().index().flatTransactionsBufferSize(), this.LedgerApiStreamsBufferSize());
        }, loggingContext).wireTap((Function1 & Serializable)x$4 -> {
            IndexServiceImpl.$anonfun$transactions$7(x$4);
            return BoxedUnit.UNIT;
        });
    }

    public Source<GetTransactionTreesResponse, NotUsed> transactionTrees(domain.LedgerOffset startExclusive, Option<domain.LedgerOffset> endInclusive, domain.TransactionFilter filter, boolean verbose, LoggingContext loggingContext) {
        return (Source)this.between(startExclusive, endInclusive, (Function2 & Serializable)(from, to) -> {
            from.foreach((Function1 & Serializable)offset -> {
                Spans$.MODULE$.setCurrentSpanAttribute(SpanAttribute$.MODULE$.OffsetFrom(), offset.toHexString());
                return BoxedUnit.UNIT;
            });
            to.foreach((Function1 & Serializable)offset -> {
                Spans$.MODULE$.setCurrentSpanAttribute(SpanAttribute$.MODULE$.OffsetTo(), offset.toHexString());
                return BoxedUnit.UNIT;
            });
            return InstrumentedGraph.BufferedSource$.MODULE$.buffered$extension(InstrumentedGraph$.MODULE$.BufferedSource((Source)$this.dispatcher.startingAt(from.getOrElse((Function0 & Serializable)() -> Offset$.MODULE$.beforeBegin()), (SubSource)new SubSource.RangeSource((Function2 & Serializable)(x$5, x$6) -> $this.transactionsReader.getTransactionTrees((Offset)x$5, (Offset)x$6, (Set<String>)filter.filtersByParty().keySet(), verbose, loggingContext), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())), to).map((Function1 & Serializable)x$7 -> (GetTransactionTreesResponse)x$7._2())), $this.metrics.daml().index().transactionTreesBufferSize(), this.LedgerApiStreamsBufferSize());
        }, loggingContext).wireTap((Function1 & Serializable)x$8 -> {
            IndexServiceImpl.$anonfun$transactionTrees$7(x$8);
            return BoxedUnit.UNIT;
        });
    }

    public Source<CompletionStreamResponse, NotUsed> getCompletions(domain.LedgerOffset startExclusive, String applicationId, Set<String> parties, LoggingContext loggingContext) {
        return InstrumentedGraph.BufferedSource$.MODULE$.buffered$extension(InstrumentedGraph$.MODULE$.BufferedSource((Source)((FlowOps)this.convertOffset().apply((Object)startExclusive)).flatMapConcat((Function1 & Serializable)beginOpt -> (Source)$this.dispatcher.startingAt(beginOpt, (SubSource)new SubSource.RangeSource((Function2 & Serializable)(x$9, x$10) -> $this.ledgerDao.completions().getCommandCompletions((Offset)x$9, (Offset)x$10, applicationId, parties, loggingContext), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())), (Option)None$.MODULE$).map((Function1 & Serializable)x$11 -> (CompletionStreamResponse)x$11._2()))), this.metrics.daml().index().completionsBufferSize(), this.LedgerApiStreamsBufferSize());
    }

    public Source<CompletionStreamResponse, NotUsed> getCompletions(domain.LedgerOffset startExclusive, domain.LedgerOffset endInclusive, String applicationId, Set<String> parties, LoggingContext loggingContext) {
        return InstrumentedGraph.BufferedSource$.MODULE$.buffered$extension(InstrumentedGraph$.MODULE$.BufferedSource(this.between(startExclusive, (Option<domain.LedgerOffset>)new Some((Object)endInclusive), (Function2 & Serializable)(start2, end) -> (Source)$this.dispatcher.startingAt(start2.getOrElse((Function0 & Serializable)() -> Offset$.MODULE$.beforeBegin()), (SubSource)new SubSource.RangeSource((Function2 & Serializable)(x$12, x$13) -> $this.ledgerDao.completions().getCommandCompletions((Offset)x$12, (Offset)x$13, applicationId, parties, loggingContext), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())), end).map((Function1 & Serializable)x$14 -> (CompletionStreamResponse)x$14._2()), loggingContext)), this.metrics.daml().index().completionsBufferSize(), this.LedgerApiStreamsBufferSize());
    }

    public Source<GetActiveContractsResponse, NotUsed> getActiveContracts(domain.TransactionFilter filter, boolean verbose, LoggingContext loggingContext) {
        Offset currentLedgerEnd = this.ledgerEnd();
        return InstrumentedGraph.BufferedSource$.MODULE$.buffered$extension(InstrumentedGraph$.MODULE$.BufferedSource((Source)this.ledgerDao.transactionsReader().getActiveContracts(currentLedgerEnd, this.convertFilter(filter), verbose, loggingContext).concat((Graph)Source$.MODULE$.single((Object)new GetActiveContractsResponse(ApiOffset$.MODULE$.toApiString(currentLedgerEnd), GetActiveContractsResponse$.MODULE$.apply$default$2(), GetActiveContractsResponse$.MODULE$.apply$default$3())))), this.metrics.daml().index().activeContractsBufferSize(), this.LedgerApiStreamsBufferSize());
    }

    public Future<Option<Versioned<Value.ContractInstance>>> lookupActiveContract(Set<String> forParties, Value.ContractId contractId, LoggingContext loggingContext) {
        return this.contractStore.lookupActiveContract(forParties, contractId, loggingContext);
    }

    public Future<Option<GetFlatTransactionResponse>> getTransactionById(Object transactionId, Set<String> requestingParties, LoggingContext loggingContext) {
        return this.ledgerDao.transactionsReader().lookupFlatTransactionById((String)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(transactionId)), requestingParties, loggingContext);
    }

    public Future<Option<GetTransactionResponse>> getTransactionTreeById(Object transactionId, Set<String> requestingParties, LoggingContext loggingContext) {
        return this.ledgerDao.transactionsReader().lookupTransactionTreeById((String)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(transactionId)), requestingParties, loggingContext);
    }

    public Future<MaximumLedgerTime> lookupMaximumLedgerTimeAfterInterpretation(Set<Value.ContractId> contractIds, LoggingContext loggingContext) {
        return this.contractStore.lookupMaximumLedgerTimeAfterInterpretation(contractIds, loggingContext);
    }

    public Future<List<domain.PartyDetails>> getParties(Seq<String> parties, LoggingContext loggingContext) {
        return this.ledgerDao.getParties(parties, loggingContext);
    }

    public Future<List<domain.PartyDetails>> listKnownParties(LoggingContext loggingContext) {
        return this.ledgerDao.listKnownParties(loggingContext);
    }

    public Source<domain.PartyEntry, NotUsed> partyEntries(Option<domain.LedgerOffset.Absolute> startExclusive, LoggingContext loggingContext) {
        return (Source)Source$.MODULE$.future(this.concreteOffset(startExclusive)).flatMapConcat((Function1 & Serializable)x$15 -> $this.dispatcher.startingAt(x$15, (SubSource)new SubSource.RangeSource((Function2 & Serializable)(startExclusive, endInclusive) -> $this.ledgerDao.getPartyEntries((Offset)startExclusive, (Offset)endInclusive, loggingContext), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())), $this.dispatcher.startingAt$default$3())).map((Function1 & Serializable)x0$1 -> {
            PartyLedgerEntry partyLedgerEntry;
            domain.PartyEntry$.AllocationRejected allocationRejected;
            PartyLedgerEntry partyLedgerEntry2;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null && (partyLedgerEntry2 = (PartyLedgerEntry)tuple2._2()) instanceof PartyLedgerEntry.AllocationRejected) {
                PartyLedgerEntry.AllocationRejected allocationRejected2 = (PartyLedgerEntry.AllocationRejected)partyLedgerEntry2;
                String subId = allocationRejected2.submissionId();
                String reason = allocationRejected2.reason();
                allocationRejected = new domain.PartyEntry$.AllocationRejected(subId, reason);
            } else if (tuple2 != null && (partyLedgerEntry = (PartyLedgerEntry)tuple2._2()) instanceof PartyLedgerEntry.AllocationAccepted) {
                PartyLedgerEntry.AllocationAccepted allocationAccepted = (PartyLedgerEntry.AllocationAccepted)partyLedgerEntry;
                Option<String> subId = allocationAccepted.submissionIdOpt();
                domain.PartyDetails details = allocationAccepted.partyDetails();
                allocationRejected = new domain.PartyEntry.AllocationAccepted(subId, details);
            } else {
                throw new MatchError((Object)tuple2);
            }
            return allocationRejected;
        });
    }

    public Future<Map<String, PackageDetails>> listLfPackages(LoggingContext loggingContext) {
        return this.ledgerDao.listLfPackages(loggingContext);
    }

    public Future<Option<DamlLf.Archive>> getLfArchive(String packageId, LoggingContext loggingContext) {
        return this.ledgerDao.getLfArchive(packageId, loggingContext);
    }

    public Source<domain.PackageEntry, NotUsed> packageEntries(Option<domain.LedgerOffset.Absolute> startExclusive, LoggingContext loggingContext) {
        return (Source)Source$.MODULE$.future(this.concreteOffset(startExclusive)).flatMapConcat((Function1 & Serializable)x$16 -> $this.dispatcher.startingAt(x$16, (SubSource)new SubSource.RangeSource((Function2 & Serializable)(startExclusive, endInclusive) -> $this.ledgerDao.getPackageEntries((Offset)startExclusive, (Offset)endInclusive, loggingContext), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())), $this.dispatcher.startingAt$default$3())).map((Function1 & Serializable)x$17 -> ((PackageLedgerEntry)x$17._2()).toDomain());
    }

    public Future<Option<Tuple2<domain.LedgerOffset.Absolute, Configuration>>> lookupConfiguration(LoggingContext loggingContext) {
        return this.ledgerDao.lookupLedgerConfiguration(loggingContext).map((Function1 & Serializable)x$18 -> x$18.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Offset offset = (Offset)tuple2._1();
            Configuration config = (Configuration)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)this.toAbsolute(offset), (Object)config);
            return tuple22;
        }), (ExecutionContext)ExecutionContext.parasitic$.MODULE$);
    }

    public Source<LedgerConfiguration, NotUsed> getLedgerConfiguration(LoggingContext loggingContext) {
        return (Source)Source$.MODULE$.future(this.lookupConfiguration(loggingContext)).flatMapConcat((Function1 & Serializable)optResult -> {
            Option offset = optResult.map((Function1 & Serializable)x$19 -> (domain.LedgerOffset.Absolute)x$19._1());
            Option foundConfig = optResult.map((Function1 & Serializable)x$20 -> (Configuration)x$20._2());
            Source initialConfig = Source$.MODULE$.apply((Iterable)foundConfig.toList());
            Source configStream = (Source)this.configurationEntries((Option<domain.LedgerOffset.Absolute>)offset, loggingContext).collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                public final <A1 extends Tuple2<domain.LedgerOffset.Absolute, domain.ConfigurationEntry>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    domain.ConfigurationEntry configurationEntry;
                    A1 A1 = x1;
                    if (A1 != null && (configurationEntry = (domain.ConfigurationEntry)A1._2()) instanceof domain.ConfigurationEntry$.Accepted) {
                        domain.ConfigurationEntry$.Accepted accepted = (domain.ConfigurationEntry$.Accepted)configurationEntry;
                        Configuration configuration = accepted.configuration();
                        object = configuration;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<domain.LedgerOffset.Absolute, domain.ConfigurationEntry> x1) {
                    domain.ConfigurationEntry configurationEntry;
                    Tuple2<domain.LedgerOffset.Absolute, domain.ConfigurationEntry> tuple2 = x1;
                    boolean bl = tuple2 != null && (configurationEntry = (domain.ConfigurationEntry)tuple2._2()) instanceof domain.ConfigurationEntry$.Accepted;
                    return bl;
                }
            });
            return (Source)initialConfig.concat((Graph)configStream).map((Function1 & Serializable)cfg -> new LedgerConfiguration(cfg.maxDeduplicationDuration()));
        });
    }

    public Source<Tuple2<domain.LedgerOffset.Absolute, domain.ConfigurationEntry>, NotUsed> configurationEntries(Option<domain.LedgerOffset.Absolute> startExclusive, LoggingContext loggingContext) {
        return (Source)Source$.MODULE$.future(this.concreteOffset(startExclusive)).flatMapConcat((Function1 & Serializable)x$21 -> (Source)$this.dispatcher.startingAt(x$21, (SubSource)new SubSource.RangeSource((Function2 & Serializable)(startExclusive, endInclusive) -> $this.ledgerDao.getConfigurationEntries((Offset)startExclusive, (Offset)endInclusive, loggingContext), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())), $this.dispatcher.startingAt$default$3()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Offset offset = (Offset)tuple2._1();
            ConfigurationEntry config = (ConfigurationEntry)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.toAbsolute(offset)), (Object)config.toDomain());
            return tuple22;
        }));
    }

    public Future<BoxedUnit> prune(Offset pruneUpToInclusive, boolean pruneAllDivulgedContracts, LoggingContext loggingContext) {
        this.pruneBuffers.apply((Object)pruneUpToInclusive);
        return this.ledgerDao.prune(pruneUpToInclusive, pruneAllDivulgedContracts, loggingContext);
    }

    public Future<MeteringStore.ReportData> getMeteringReportData(Time.Timestamp from, Option<Time.Timestamp> to, Option<String> applicationId, LoggingContext loggingContext) {
        return this.ledgerDao.meteringReportData(from, to, applicationId, loggingContext);
    }

    public Future<domain.LedgerOffset.Absolute> currentLedgerEnd(LoggingContext loggingContext) {
        Offset offset = this.ledgerEnd();
        Offset offset2 = Offset$.MODULE$.beforeBegin();
        Offset offset3 = !(offset != null ? !offset.equals(offset2) : offset2 != null) ? ApiOffset$.MODULE$.begin() : this.ledgerEnd();
        return Future$.MODULE$.successful((Object)this.toAbsolute(offset3));
    }

    private Offset ledgerEnd() {
        return (Offset)this.dispatcher.getHead();
    }

    private Function1<domain.LedgerOffset, Source<Offset, NotUsed>> convertOffset() {
        return (Function1 & Serializable)x0$1 -> {
            Source source;
            domain.LedgerOffset ledgerOffset = x0$1;
            if (domain.LedgerOffset$.LedgerBegin$.MODULE$.equals(ledgerOffset)) {
                source = Source$.MODULE$.single((Object)Offset$.MODULE$.beforeBegin());
            } else if (domain$LedgerOffset$LedgerEnd$.MODULE$.equals(ledgerOffset)) {
                source = Source$.MODULE$.single((Object)this.ledgerEnd());
            } else if (ledgerOffset instanceof domain.LedgerOffset.Absolute) {
                domain.LedgerOffset.Absolute absolute = (domain.LedgerOffset.Absolute)ledgerOffset;
                String offset = absolute.value();
                source = (Source)ApiOffset$.MODULE$.fromString(offset).fold((Function1 & Serializable)cause -> Source$.MODULE$.failed(cause), (Function1 & Serializable)off -> Source$.MODULE$.single(off));
            } else {
                throw new MatchError((Object)ledgerOffset);
            }
            return source;
        };
    }

    private <A> Source<A, NotUsed> between(domain.LedgerOffset startExclusive, Option<domain.LedgerOffset> endInclusive, Function2<Option<Offset>, Option<Offset>, Source<A, NotUsed>> f, LoggingContext loggingContext) {
        Function1<domain.LedgerOffset, Source<Offset, NotUsed>> convert = this.convertOffset();
        return (Source)((FlowOps)convert.apply((Object)startExclusive)).flatMapConcat((Function1 & Serializable)begin -> (Source)((FlowOps)endInclusive.map((Function1 & Serializable)x$22 -> (Source)((FlowOps)convert.apply(x$22)).map((Function1 & Serializable)x$23 -> new Some(x$23))).getOrElse((Function0 & Serializable)() -> Source$.MODULE$.single((Object)None$.MODULE$))).flatMapConcat((Function1 & Serializable)x0$1 -> {
            Offset end;
            boolean bl = false;
            Some some = null;
            Option option = x0$1;
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                Offset offset = (Offset)some.value();
                Offset offset2 = begin;
                Offset offset3 = offset;
                if (offset2 == null) {
                    if (offset3 == null) return Source$.MODULE$.empty();
                } else if (offset2.equals(offset3)) {
                    return Source$.MODULE$.empty();
                }
            }
            if (bl && begin.$greater((Object)(end = (Offset)some.value()))) {
                return Source$.MODULE$.failed((Throwable)new RequestValidation.OffsetOutOfRange$.Reject(new StringBuilder(36).append("End offset ").append(ApiOffset$.MODULE$.ApiOffsetConverter(end).toApiString()).append(" is before Begin offset ").append(ApiOffset$.MODULE$.ApiOffsetConverter((Offset)begin).toApiString()).append(".").toString(), (ContextualizedErrorLogger)new DamlContextualizedErrorLogger(this.logger(), loggingContext, (Option)None$.MODULE$)).asGrpcError());
            }
            if (option == null) throw new MatchError((Object)option);
            Option option2 = option;
            return (Source)f.apply((Object)new Some(begin), (Object)option2);
        }));
    }

    private Map<String, Set<Ref.Identifier>> convertFilter(domain.TransactionFilter filter) {
        return (Map)filter.filtersByParty().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String party = (String)tuple2._1();
            domain.Filters filters = (domain.Filters)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)party), filters.inclusive().fold((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty(), (Function1 & Serializable)x$24 -> x$24.templateIds()));
            return tuple22;
        });
    }

    private Future<Offset> concreteOffset(Option<domain.LedgerOffset.Absolute> startExclusive) {
        return (Future)startExclusive.map((Function1 & Serializable)off -> Future$.MODULE$.fromTry(ApiOffset$.MODULE$.fromString(off.value()))).getOrElse((Function0 & Serializable)() -> Future$.MODULE$.successful((Object)Offset$.MODULE$.beforeBegin()));
    }

    private domain.LedgerOffset.Absolute toAbsolute(Offset offset) {
        return new domain.LedgerOffset.Absolute(ApiOffset$.MODULE$.ApiOffsetConverter(offset).toApiString());
    }

    public static final /* synthetic */ void $anonfun$transactions$7(GetTransactionsResponse x$4) {
        x$4.transactions().view().map((Function1 & Serializable)transaction -> new Event(transaction.commandId(), TraceIdentifiers$.MODULE$.fromTransaction(transaction))).foreach((Function1 & Serializable)event -> {
            Spans$.MODULE$.addEventToCurrentSpan(event);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$transactionTrees$7(GetTransactionTreesResponse x$8) {
        x$8.transactions().view().map((Function1 & Serializable)transaction -> new Event(transaction.commandId(), TraceIdentifiers$.MODULE$.fromTransactionTree(transaction))).foreach((Function1 & Serializable)event -> {
            Spans$.MODULE$.addEventToCurrentSpan(event);
            return BoxedUnit.UNIT;
        });
    }

    public IndexServiceImpl(Object ledgerId, String participantId, LedgerReadDao ledgerDao, LedgerDaoTransactionsReader transactionsReader, ContractStore contractStore, Function1<Offset, BoxedUnit> pruneBuffers, Dispatcher<Offset> dispatcher, Metrics metrics) {
        this.ledgerId = ledgerId;
        this.participantId = participantId;
        this.ledgerDao = ledgerDao;
        this.transactionsReader = transactionsReader;
        this.contractStore = contractStore;
        this.pruneBuffers = pruneBuffers;
        this.dispatcher = dispatcher;
        this.metrics = metrics;
        this.LedgerApiStreamsBufferSize = 128;
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
    }
}

