/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.indexer;

import akka.actor.Scheduler;
import com.daml.ledger.api.health.HealthStatus;
import com.daml.ledger.api.health.HealthStatus$;
import com.daml.ledger.api.health.Healthy$;
import com.daml.ledger.api.health.ReportsHealth;
import com.daml.ledger.api.health.Unhealthy$;
import com.daml.ledger.resources.ResourceContext;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.platform.indexer.RecoveringIndexer$;
import com.daml.resources.AbstractResourceOwner;
import com.daml.resources.Resource;
import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.atomic.AtomicReference;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005%e!\u0002\f\u0018\u0005]y\u0002\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\t\u0011A\u0002!\u0011!Q\u0001\nEB\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005\u007f!Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005T\u0001\t\u0005\t\u0015a\u0003U\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u001d)\u0007A1A\u0005\f\u0019Daa\u001a\u0001!\u0002\u0013\t\u0004b\u00025\u0001\u0005\u0004%Y!\u001b\u0005\u0007a\u0002\u0001\u000b\u0011\u00026\t\u000fE\u0004!\u0019!C\u0005e\"1a\u000f\u0001Q\u0001\nMDqa\u001e\u0001C\u0002\u0013%\u0001\u0010C\u0004\u0002\u0004\u0001\u0001\u000b\u0011B=\t\u000f\u0005\u0015\u0001\u0001\"\u0001\u0002\b!9\u0011q\t\u0001\u0005\n\u0005%s\u0001CA:/!\u0005q#!\u001e\u0007\u000fY9\u0002\u0012A\f\u0002x!1!l\u0005C\u0001\u0003sBq!a\u001f\u0014\t\u0003\tiHA\tSK\u000e|g/\u001a:j]\u001eLe\u000eZ3yKJT!\u0001G\r\u0002\u000f%tG-\u001a=fe*\u0011!dG\u0001\ta2\fGOZ8s[*\u0011A$H\u0001\u0005I\u0006lGNC\u0001\u001f\u0003\r\u0019w.\\\n\u0003\u0001\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0017!C:dQ\u0016$W\u000f\\3s\u0007\u0001\u0001\"!\u000b\u0018\u000e\u0003)R!a\u000b\u0017\u0002\u000b\u0005\u001cGo\u001c:\u000b\u00035\nA!Y6lC&\u0011qF\u000b\u0002\n'\u000eDW\rZ;mKJ\f\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0011\u0005I*T\"A\u001a\u000b\u0005Q\u0012\u0013AC2p]\u000e,(O]3oi&\u0011ag\r\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fAB]3ti\u0006\u0014H\u000fR3mCf\u0004\"!\u000f\u001f\u000e\u0003iR!aO\u001a\u0002\u0011\u0011,(/\u0019;j_:L!!\u0010\u001e\u0003\u001d\u0019Kg.\u001b;f\tV\u0014\u0018\r^5p]\u0006\u0011R\u000f\u001d3bi\u0016DU-\u00197uQN#\u0018\r^;t!\u0011\t\u0003I\u0011'\n\u0005\u0005\u0013#!\u0003$v]\u000e$\u0018n\u001c82!\t\u0019%*D\u0001E\u0015\t)e)\u0001\u0004iK\u0006dG\u000f\u001b\u0006\u0003\u000f\"\u000b1!\u00199j\u0015\tI5$\u0001\u0004mK\u0012<WM]\u0005\u0003\u0017\u0012\u0013A\u0002S3bYRD7\u000b^1ukN\u0004\"!I'\n\u00059\u0013#\u0001B+oSR\fa\u0002[3bYRD'+\u001a9peR,'\u000f\u0005\u0002D#&\u0011!\u000b\u0012\u0002\u000e%\u0016\u0004xN\u001d;t\u0011\u0016\fG\u000e\u001e5\u0002\u001d1|wmZ5oO\u000e{g\u000e^3yiB\u0011Q\u000bW\u0007\u0002-*\u0011qkG\u0001\bY><w-\u001b8h\u0013\tIfK\u0001\bM_\u001e<\u0017N\\4D_:$X\r\u001f;\u0002\rqJg.\u001b;?)\u0019a\u0006-\u00192dIR\u0011Ql\u0018\t\u0003=\u0002i\u0011a\u0006\u0005\u0006'\u001e\u0001\u001d\u0001\u0016\u0005\u0006M\u001d\u0001\r\u0001\u000b\u0005\u0006a\u001d\u0001\r!\r\u0005\u0006o\u001d\u0001\r\u0001\u000f\u0005\u0006}\u001d\u0001\ra\u0010\u0005\u0006\u001f\u001e\u0001\r\u0001U\u0001\u0003K\u000e,\u0012!M\u0001\u0004K\u000e\u0004\u0013a\u0004:fg>,(oY3D_:$X\r\u001f;\u0016\u0003)\u0004\"a\u001b8\u000e\u00031T!!\u001c%\u0002\u0013I,7o\\;sG\u0016\u001c\u0018BA8m\u0005=\u0011Vm]8ve\u000e,7i\u001c8uKb$\u0018\u0001\u0005:fg>,(oY3D_:$X\r\u001f;!\u0003\u0019awnZ4feV\t1\u000f\u0005\u0002Vi&\u0011QO\u0016\u0002\u0015\u0007>tG/\u001a=uk\u0006d\u0017N_3e\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005)1\r\\8dWV\t\u0011\u0010\u0005\u0002{\u007f6\t1P\u0003\u0002}{\u0006!A/[7f\u0015\u0005q\u0018\u0001\u00026bm\u0006L1!!\u0001|\u0005\u0015\u0019En\\2l\u0003\u0019\u0019Gn\\2lA\u0005)1\u000f^1siR!\u0011\u0011BA\u001d!\u0019\tY!a\n\u0002.9!\u0011QBA\u0012\u001d\u0011\ty!!\t\u000f\t\u0005E\u0011q\u0004\b\u0005\u0003'\tiB\u0004\u0003\u0002\u0016\u0005mQBAA\f\u0015\r\tIbJ\u0001\u0007yI|w\u000e\u001e \n\u0003yI!\u0001H\u000f\n\u0005%[\u0012BA7I\u0013\r\t)\u0003\\\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI#a\u000b\u0003\u0011I+7o\\;sG\u0016T1!!\nm!\u0019\t\u0013q\u0006)\u00024%\u0019\u0011\u0011\u0007\u0012\u0003\rQ+\b\u000f\\33!\u0011\u0011\u0014Q\u0007'\n\u0007\u0005]2G\u0001\u0004GkR,(/\u001a\u0005\u00071A\u0001\r!a\u000f\u0011\t\u0005u\u0012\u0011\t\b\u0004=\u0006}\u0012bAA\u0013/%!\u00111IA#\u0005\u001dIe\u000eZ3yKJT1!!\n\u0018\u0003A\u0011X\r]8si\u0016\u0013(o\u001c:Ti\u0006$X\rF\u0003M\u0003\u0017\ny\u0006C\u0004\u0002NE\u0001\r!a\u0014\u0002\u0019\u0015\u0014(o\u001c:NKN\u001c\u0018mZ3\u0011\t\u0005E\u0013\u0011\f\b\u0005\u0003'\n)\u0006E\u0002\u0002\u0016\tJ1!a\u0016#\u0003\u0019\u0001&/\u001a3fM&!\u00111LA/\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u000b\u0012\t\u000f\u0005\u0005\u0014\u00031\u0001\u0002d\u0005IQ\r_2faRLwN\u001c\t\u0005\u0003K\niG\u0004\u0003\u0002h\u0005-d\u0002BA\u000b\u0003SJ\u0011aI\u0005\u0004\u0003K\u0011\u0013\u0002BA8\u0003c\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005\u0015\"%A\tSK\u000e|g/\u001a:j]\u001eLe\u000eZ3yKJ\u0004\"AX\n\u0014\u0005M\u0001CCAA;\u0003\u0015\t\u0007\u000f\u001d7z)!\ty(a!\u0002\u0006\u0006\u001dEcA/\u0002\u0002\")1+\u0006a\u0002)\")a%\u0006a\u0001Q!)\u0001'\u0006a\u0001c!)q'\u0006a\u0001q\u0001")
public final class RecoveringIndexer {
    private final Scheduler scheduler;
    private final FiniteDuration restartDelay;
    private final Function1<HealthStatus, BoxedUnit> updateHealthStatus;
    private final ReportsHealth healthReporter;
    private final LoggingContext loggingContext;
    private final ExecutionContext ec;
    private final ResourceContext resourceContext;
    private final ContextualizedLogger logger;
    private final Clock clock;

    public static RecoveringIndexer apply(Scheduler scheduler, ExecutionContext executionContext, FiniteDuration restartDelay, LoggingContext loggingContext) {
        return RecoveringIndexer$.MODULE$.apply(scheduler, executionContext, restartDelay, loggingContext);
    }

    private ExecutionContext ec() {
        return this.ec;
    }

    private ResourceContext resourceContext() {
        return this.resourceContext;
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    private Clock clock() {
        return this.clock;
    }

    public Resource<ResourceContext, Tuple2<ReportsHealth, Future<BoxedUnit>>> start(AbstractResourceOwner<ResourceContext, Future<BoxedUnit>> indexer) {
        Promise complete = Promise$.MODULE$.apply();
        this.logger().info().apply((Function0 & Serializable)() -> "Starting Indexer Server", this.loggingContext);
        AtomicReference<Object> subscription = new AtomicReference<Object>(null);
        Resource firstSubscription = indexer.acquire((Object)this.resourceContext()).map((Function1 & Serializable)handle -> {
            this.logger().info().apply((Function0 & Serializable)() -> "Started Indexer Server", $this.loggingContext);
            $this.updateHealthStatus.apply((Object)Healthy$.MODULE$);
            return handle;
        }, (Object)this.resourceContext());
        subscription.set(firstSubscription);
        this.resubscribeOnFailure$1(firstSubscription, (Function0)(JFunction0.mcV.sp & Serializable)() -> {}, complete, indexer, subscription);
        return com.daml.ledger.resources.package$.MODULE$.Resource().apply(((Resource)subscription.get()).asFuture().transform((Function1 & Serializable)x$5 -> new Success((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)$this.healthReporter), (Object)complete.future())), this.ec()), (Function1 & Serializable)x$6 -> {
            this.logger().info().apply((Function0 & Serializable)() -> "Stopping Indexer Server", $this.loggingContext);
            return ((Resource)subscription.getAndSet(null)).release().flatMap((Function1 & Serializable)x$7 -> complete.future(), this.ec()).map((Function1 & Serializable)x$8 -> {
                RecoveringIndexer.$anonfun$start$24(this, x$8);
                return BoxedUnit.UNIT;
            }, this.ec());
        }, (Object)this.resourceContext());
    }

    private void reportErrorState(String errorMessage, Throwable exception) {
        this.updateHealthStatus.apply((Object)Unhealthy$.MODULE$);
        this.logger().error().apply((Function0 & Serializable)() -> errorMessage, exception, this.loggingContext);
    }

    public static final /* synthetic */ boolean $anonfun$start$7(BoxedUnit x$1) {
        return false;
    }

    private final Future waitForRestart$1(Instant delayUntil, AtomicReference subscription$1, Promise complete$1) {
        Instant now = this.clock().instant();
        FiniteDuration delay = Duration$.MODULE$.fromNanos(ChronoUnit.NANOS.between(now, delayUntil));
        FiniteDuration delayIncrement = delay.min(new package.DurationLong(package$.MODULE$.DurationLong(1L)).second()).max(new package.DurationLong(package$.MODULE$.DurationLong(1L)).nanosecond());
        return akka.pattern.package$.MODULE$.after(delayIncrement, this.scheduler, (Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            if (subscription$1.get() == null) {
                this.logger().info().apply((Function0 & Serializable)() -> "Indexer Server was stopped; cancelling the restart", $this.loggingContext);
                complete$1.trySuccess((Object)BoxedUnit.UNIT);
                boxedUnit = complete$1.future().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RecoveringIndexer.$anonfun$start$7(x$1)), this.ec());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return this.clock().instant().isAfter(delayUntil) ? Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)true)) : this.waitForRestart$1(delayUntil, subscription$1, complete$1);
        }, this.ec());
    }

    private final Instant waitForRestart$default$1$1() {
        return this.clock().instant().plusMillis(this.restartDelay.toMillis());
    }

    public static final /* synthetic */ void $anonfun$start$15(BoxedUnit x$3) {
        BoxedUnit boxedUnit = x$3;
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Future $anonfun$start$8(RecoveringIndexer $this, AbstractResourceOwner indexer$1, AtomicReference subscription$1, Resource oldSubscription$1, Promise complete$1, boolean running) {
        Future future;
        if (running) {
            $this.logger().info().apply((Function0 & Serializable)() -> "Restarting Indexer Server", $this.loggingContext);
            Resource newSubscription = indexer$1.acquire((Object)$this.resourceContext());
            if (subscription$1.compareAndSet(oldSubscription$1, newSubscription)) {
                $this.resubscribeOnFailure$1(newSubscription, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                    $this.updateHealthStatus.apply((Object)HealthStatus$.MODULE$.healthy());
                    $this.logger().info().apply((Function0 & Serializable)() -> "Restarted Indexer Server", $this.loggingContext);
                }, complete$1, indexer$1, subscription$1);
                future = Future$.MODULE$.unit();
            } else {
                $this.logger().info().apply((Function0 & Serializable)() -> "Indexer Server was stopped; cancelling the restart", $this.loggingContext);
                future = newSubscription.release().flatMap((Function1 & Serializable)x$2 -> {
                    $this.logger().info().apply((Function0 & Serializable)() -> "Indexer Server restart was cancelled", $this.loggingContext);
                    complete$1.trySuccess((Object)BoxedUnit.UNIT);
                    return complete$1.future();
                }, $this.ec());
            }
        } else {
            future = Future$.MODULE$.unit();
        }
        return future.map((Function1 & Serializable)x$3 -> {
            RecoveringIndexer.$anonfun$start$15(x$3);
            return BoxedUnit.UNIT;
        }, $this.ec());
    }

    private final Future resubscribe$1(Resource oldSubscription, AbstractResourceOwner indexer$1, AtomicReference subscription$1, Promise complete$1) {
        return this.waitForRestart$1(this.waitForRestart$default$1$1(), subscription$1, complete$1).flatMap((Function1 & Serializable)running -> RecoveringIndexer.$anonfun$start$8(this, indexer$1, subscription$1, oldSubscription, complete$1, BoxesRunTime.unboxToBoolean((Object)running)), this.ec());
    }

    public static final /* synthetic */ void $anonfun$start$16(RecoveringIndexer $this, Function0 actOnSuccess$1, Promise complete$1, Resource currentSubscription$1, AbstractResourceOwner indexer$1, AtomicReference subscription$1, Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Future handle = (Future)success.value();
            actOnSuccess$1.apply$mcV$sp();
            handle.onComplete((Function1 & Serializable)x0$2 -> {
                Try try_ = x0$2;
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    BoxedUnit boxedUnit = (BoxedUnit)success.value();
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    BoxedUnit boxedUnit3 = boxedUnit;
                    if (!(boxedUnit2 != null ? !boxedUnit2.equals(boxedUnit3) : boxedUnit3 != null)) {
                        $this.logger().info().apply((Function0 & Serializable)() -> "Successfully finished processing state updates", $this.loggingContext);
                        complete$1.trySuccess((Object)BoxedUnit.UNIT);
                        return complete$1.future();
                    }
                }
                if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                $this.reportErrorState(new StringBuilder(53).append("Error while running indexer, restart scheduled after ").append($this.restartDelay).toString(), exception);
                return currentSubscription$1.release().recover((PartialFunction)new Serializable(null){
                    private static final long serialVersionUID = 0L;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return (B1)boxedUnit;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = true;
                        return bl;
                    }
                }, $this.ec()).flatMap((Function1 & Serializable)x$4 -> $this.resubscribe$1(currentSubscription$1, indexer$1, subscription$1, complete$1), $this.ec());
            }, $this.ec());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            $this.reportErrorState(new StringBuilder(54).append("Error while starting indexer, restart scheduled after ").append($this.restartDelay).toString(), exception);
            $this.resubscribe$1(currentSubscription$1, indexer$1, subscription$1, complete$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    private final void resubscribeOnFailure$1(Resource currentSubscription, Function0 actOnSuccess, Promise complete$1, AbstractResourceOwner indexer$1, AtomicReference subscription$1) {
        currentSubscription.asFuture().onComplete((Function1 & Serializable)x0$1 -> {
            RecoveringIndexer.$anonfun$start$16(this, actOnSuccess, complete$1, currentSubscription, indexer$1, subscription$1, x0$1);
            return BoxedUnit.UNIT;
        }, this.ec());
    }

    public static final /* synthetic */ void $anonfun$start$24(RecoveringIndexer $this, BoxedUnit x$8) {
        $this.updateHealthStatus.apply((Object)Unhealthy$.MODULE$);
        $this.logger().info().apply((Function0 & Serializable)() -> "Stopped Indexer Server", $this.loggingContext);
    }

    public RecoveringIndexer(Scheduler scheduler, ExecutionContext executionContext, FiniteDuration restartDelay, Function1<HealthStatus, BoxedUnit> updateHealthStatus, ReportsHealth healthReporter, LoggingContext loggingContext) {
        this.scheduler = scheduler;
        this.restartDelay = restartDelay;
        this.updateHealthStatus = updateHealthStatus;
        this.healthReporter = healthReporter;
        this.loggingContext = loggingContext;
        this.ec = executionContext;
        this.resourceContext = new ResourceContext(executionContext);
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.clock = Clock.systemUTC();
    }
}

