/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.indexer.ha;

import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.platform.indexer.ha.ConnectionInitializer;
import com.daml.platform.indexer.ha.HaConfig;
import com.daml.platform.indexer.ha.HaCoordinator;
import com.daml.platform.indexer.ha.HaCoordinator$;
import com.daml.platform.indexer.ha.Handle;
import com.daml.platform.indexer.ha.PollingChecker;
import com.daml.platform.indexer.ha.PreemptableSequence;
import com.daml.platform.indexer.ha.PreemptableSequence$;
import com.daml.platform.store.backend.DBLockStorageBackend;
import com.daml.platform.store.backend.DBLockStorageBackend$LockMode$Exclusive$;
import com.daml.platform.store.backend.DBLockStorageBackend$LockMode$Shared$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.sql.Connection;
import java.util.Timer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

public final class HaCoordinator$ {
    public static final HaCoordinator$ MODULE$ = new HaCoordinator$();
    private static final ContextualizedLogger com$daml$platform$indexer$ha$HaCoordinator$$logger = ContextualizedLogger$.MODULE$.get(MODULE$.getClass());

    public ContextualizedLogger com$daml$platform$indexer$ha$HaCoordinator$$logger() {
        return com$daml$platform$indexer$ha$HaCoordinator$$logger;
    }

    public HaCoordinator databaseLockBasedHaCoordinator(Function0<Connection> mainConnectionFactory, DBLockStorageBackend storageBackend, ExecutionContext executionContext, Timer timer, HaConfig haConfig, LoggingContext loggingContext) {
        ExecutionContext ec = executionContext;
        DBLockStorageBackend.LockId indexerLockId = storageBackend.lock(haConfig.indexerLockId());
        DBLockStorageBackend.LockId indexerWorkerLockId = storageBackend.lock(haConfig.indexerWorkerLockId());
        PreemptableSequence preemptableSequence = PreemptableSequence$.MODULE$.apply(timer, ec, loggingContext);
        return new HaCoordinator(loggingContext, storageBackend, indexerLockId, preemptableSequence, mainConnectionFactory, ec, haConfig, indexerWorkerLockId){
            private final LoggingContext loggingContext$1;
            private final DBLockStorageBackend storageBackend$1;
            private final DBLockStorageBackend.LockId indexerLockId$1;
            private final PreemptableSequence preemptableSequence$1;
            private final Function0 mainConnectionFactory$1;
            private final ExecutionContext ec$1;
            private final HaConfig haConfig$1;
            private final DBLockStorageBackend.LockId indexerWorkerLockId$1;

            public Handle protectedExecution(Function1<ConnectionInitializer, Future<Handle>> initializeExecution) {
                return this.preemptableSequence$1.executeSequence((Function1 & Serializable)sequenceHelper -> {
                    HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().info().apply((Function0 & Serializable)() -> "Starting IndexDB HA Coordinator", $this.loggingContext$1);
                    return sequenceHelper.go($this.mainConnectionFactory$1).map((Function1 & Serializable)mainConnection -> {
                        HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().debug().apply((Function0 & Serializable)() -> "Step 1: creating main-connection - DONE", $this.loggingContext$1);
                        BoxedUnit x$3 = BoxedUnit.UNIT;
                        sequenceHelper.registerRelease((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                            HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().debug().apply((Function0 & Serializable)() -> "Releasing main connection...", $this.loggingContext$1);
                            mainConnection.close();
                            HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().debug().apply((Function0 & Serializable)() -> "Step 8: Released main connection", $this.loggingContext$1);
                            HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().info().apply((Function0 & Serializable)() -> "Stepped down as leader, IndexDB HA Coordinator shut down", $this.loggingContext$1);
                        });
                        BoxedUnit x$4 = BoxedUnit.UNIT;
                        HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().info().apply((Function0 & Serializable)() -> "Waiting to be elected as leader", $this.loggingContext$1);
                        BoxedUnit x$5 = BoxedUnit.UNIT;
                        return new Tuple4(mainConnection, (Object)x$3, (Object)x$4, (Object)x$5);
                    }, $this.ec$1).flatMap((Function1 & Serializable)x$24 -> {
                        Tuple4 tuple4 = x$24;
                        if (tuple4 == null) {
                            throw new MatchError((Object)tuple4);
                        }
                        Connection mainConnection = (Connection)tuple4._1();
                        long x$12 = $this.haConfig$1.mainLockAcquireRetryMillis();
                        Function1 & Serializable x$2 = (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$protectedExecution$13(x$1));
                        long x$3 = sequenceHelper.retry$default$2();
                        JFunction0.mcV.sp & Serializable x$4 = (JFunction0.mcV.sp & Serializable)() -> this.acquireMainLock$1(mainConnection);
                        Future future = sequenceHelper.retry(x$12, x$3, (Function1<Throwable, Object>)x$2, x$4).map((Function1 & Serializable)x$6 -> {
                            HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().info().apply((Function0 & Serializable)() -> "Elected as leader: starting initialization", $this.loggingContext$1);
                            BoxedUnit x$7 = BoxedUnit.UNIT;
                            HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().info().apply((Function0 & Serializable)() -> "Waiting for previous IndexDB HA Coordinator to finish work", $this.loggingContext$1);
                            BoxedUnit x$8 = BoxedUnit.UNIT;
                            HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().debug().apply((Function0 & Serializable)() -> "Step 2: acquire exclusive Indexer Main Lock on main-connection - DONE", $this.loggingContext$1);
                            BoxedUnit x$9 = BoxedUnit.UNIT;
                            return new Tuple4(x$6, (Object)x$7, (Object)x$8, (Object)x$9);
                        }, $this.ec$1).flatMap((Function1 & Serializable)x$23 -> {
                            Tuple4 tuple4 = x$23;
                            if (tuple4 == null) {
                                throw new MatchError((Object)tuple4);
                            }
                            Future future = sequenceHelper.retry($this.haConfig$1.workerLockAcquireRetryMillis(), $this.haConfig$1.workerLockAcquireMaxRetry(), (Function1<Throwable, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$protectedExecution$20(x$2)), (Function0 & Serializable)() -> this.acquireLock$1(mainConnection, $this.indexerWorkerLockId$1, DBLockStorageBackend$LockMode$Exclusive$.MODULE$)).map((Function1 & Serializable)exclusiveWorkerLock -> {
                                HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().info().apply((Function0 & Serializable)() -> "Previous IndexDB HA Coordinator finished work, starting DB connectivity polling", $this.loggingContext$1);
                                BoxedUnit x$10 = BoxedUnit.UNIT;
                                HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().debug().apply((Function0 & Serializable)() -> "Step 3: acquire exclusive Indexer Worker Lock on main-connection - DONE", $this.loggingContext$1);
                                BoxedUnit x$11 = BoxedUnit.UNIT;
                                return new Tuple3(exclusiveWorkerLock, (Object)x$10, (Object)x$11);
                            }, $this.ec$1).flatMap((Function1 & Serializable)x$22 -> {
                                Tuple3 tuple3 = x$22;
                                if (tuple3 == null) {
                                    throw new MatchError((Object)tuple3);
                                }
                                DBLockStorageBackend.Lock exclusiveWorkerLock = (DBLockStorageBackend.Lock)tuple3._1();
                                Future future = sequenceHelper.go((JFunction0.mcZ.sp & Serializable)() -> $this.storageBackend$1.release(exclusiveWorkerLock, mainConnection)).map((Function1 & Serializable)x$12 -> anon.1.$anonfun$protectedExecution$27(this, BoxesRunTime.unboxToBoolean((Object)x$12)), $this.ec$1).flatMap((Function1 & Serializable)x$21 -> {
                                    Tuple2 tuple2 = x$21;
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    Future future = sequenceHelper.go((Function0 & Serializable)() -> new PollingChecker($this.haConfig$1.mainLockCheckerPeriodMillis(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.acquireMainLock$1(mainConnection), sequenceHelper.handle().killSwitch(), $this.loggingContext$1)).map((Function1 & Serializable)mainLockChecker -> {
                                        HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().debug().apply((Function0 & Serializable)() -> "Step 5: activate periodic checker of the exclusive Indexer Main Lock on the main connection - DONE", $this.loggingContext$1);
                                        BoxedUnit x$14 = BoxedUnit.UNIT;
                                        sequenceHelper.registerRelease((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                                            HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().debug().apply((Function0 & Serializable)() -> "Releasing periodic checker of the exclusive Indexer Main Lock on the main connection...", $this.loggingContext$1);
                                            HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().info().apply((Function0 & Serializable)() -> "Stepping down as leader, stopping DB connectivity polling", $this.loggingContext$1);
                                            mainLockChecker.close();
                                            HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().debug().apply((Function0 & Serializable)() -> "Step 7: Released periodic checker of the exclusive Indexer Main Lock on the main connection", $this.loggingContext$1);
                                        });
                                        BoxedUnit x$15 = BoxedUnit.UNIT;
                                        return new Tuple3(mainLockChecker, (Object)x$14, (Object)x$15);
                                    }, $this.ec$1).flatMap((Function1 & Serializable)x$20 -> {
                                        Tuple3 tuple3 = x$20;
                                        if (tuple3 == null) {
                                            throw new MatchError((Object)tuple3);
                                        }
                                        PollingChecker mainLockChecker = (PollingChecker)tuple3._1();
                                        Future future = sequenceHelper.goF((Function0 & Serializable)() -> (Future)initializeExecution.apply(workerConnection -> {
                                            HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().debug().apply((Function0 & Serializable)() -> "Preparing worker connection. Step 1: acquire lock.", $this.loggingContext$1);
                                            this.acquireLock$1(workerConnection, $this.indexerWorkerLockId$1, DBLockStorageBackend$LockMode$Shared$.MODULE$);
                                            HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().debug().apply((Function0 & Serializable)() -> "Preparing worker connection. Step 2: checking main lock.", $this.loggingContext$1);
                                            mainLockChecker.check();
                                            HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().debug().apply((Function0 & Serializable)() -> "Preparing worker connection DONE.", $this.loggingContext$1);
                                        })).map((Function1 & Serializable)protectedHandle -> {
                                            HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().debug().apply((Function0 & Serializable)() -> "Step 6: initialize protected execution - DONE", $this.loggingContext$1);
                                            BoxedUnit x$16 = BoxedUnit.UNIT;
                                            HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().info().apply((Function0 & Serializable)() -> "Elected as leader: initialization complete", $this.loggingContext$1);
                                            BoxedUnit x$17 = BoxedUnit.UNIT;
                                            return new Tuple3(protectedHandle, (Object)x$16, (Object)x$17);
                                        }, $this.ec$1).flatMap((Function1 & Serializable)x$19 -> {
                                            Tuple3 tuple3 = x$19;
                                            if (tuple3 == null) {
                                                throw new MatchError((Object)tuple3);
                                            }
                                            Handle protectedHandle = (Handle)tuple3._1();
                                            Future future = sequenceHelper.merge(protectedHandle).map((Function1 & Serializable)x$18 -> {
                                                BoxedUnit boxedUnit = x$18;
                                                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                                return boxedUnit2;
                                            }, $this.ec$1);
                                            return future;
                                        }, $this.ec$1);
                                        return future;
                                    }, $this.ec$1);
                                    return future;
                                }, $this.ec$1);
                                return future;
                            }, $this.ec$1);
                            return future;
                        }, $this.ec$1);
                        return future;
                    }, $this.ec$1);
                });
            }

            private final DBLockStorageBackend.Lock acquireLock$1(Connection connection, DBLockStorageBackend.LockId lockId, DBLockStorageBackend.LockMode lockMode) {
                HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(16).append("Acquiring lock ").append(lockId).append(" ").append(lockMode).toString(), this.loggingContext$1);
                return (DBLockStorageBackend.Lock)this.storageBackend$1.tryAcquire(lockId, lockMode, connection).getOrElse((Function0 & Serializable)() -> {
                    throw new HaCoordinator.CannotAcquireLockException(lockId, lockMode);
                });
            }

            private final void acquireMainLock$1(Connection connection) {
                this.acquireLock$1(connection, this.indexerLockId$1, DBLockStorageBackend$LockMode$Exclusive$.MODULE$);
            }

            public static final /* synthetic */ boolean $anonfun$protectedExecution$13(Throwable x$1) {
                return x$1 instanceof HaCoordinator.CannotAcquireLockException;
            }

            public static final /* synthetic */ boolean $anonfun$protectedExecution$20(Throwable x$2) {
                return x$2 instanceof HaCoordinator.CannotAcquireLockException;
            }

            public static final /* synthetic */ Tuple2 $anonfun$protectedExecution$27(anon.1 $this, boolean x$12) {
                HaCoordinator$.MODULE$.com$daml$platform$indexer$ha$HaCoordinator$$logger().debug().apply((Function0 & Serializable)() -> "Step 4: release exclusive Indexer Worker Lock on main-connection - DONE", $this.loggingContext$1);
                BoxedUnit x$13 = BoxedUnit.UNIT;
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)x$12), (Object)x$13);
            }
            {
                this.loggingContext$1 = loggingContext$1;
                this.storageBackend$1 = storageBackend$1;
                this.indexerLockId$1 = indexerLockId$1;
                this.preemptableSequence$1 = preemptableSequence$1;
                this.mainConnectionFactory$1 = mainConnectionFactory$1;
                this.ec$1 = ec$1;
                this.haConfig$1 = haConfig$1;
                this.indexerWorkerLockId$1 = indexerWorkerLockId$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$protectedExecution$1(com.daml.platform.store.backend.DBLockStorageBackend$LockId com.daml.platform.store.backend.DBLockStorageBackend$LockMode ), $anonfun$protectedExecution$10(), $anonfun$protectedExecution$11(), $anonfun$protectedExecution$12(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 com.daml.platform.indexer.ha.SequenceHelper scala.Function1 scala.Tuple4 ), $anonfun$protectedExecution$13$adapted(java.lang.Throwable ), $anonfun$protectedExecution$14(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 java.sql.Connection ), $anonfun$protectedExecution$15(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 scala.runtime.BoxedUnit ), $anonfun$protectedExecution$16(), $anonfun$protectedExecution$17(), $anonfun$protectedExecution$18(), $anonfun$protectedExecution$19(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 com.daml.platform.indexer.ha.SequenceHelper java.sql.Connection scala.Function1 scala.Tuple4 ), $anonfun$protectedExecution$2(com.daml.platform.store.backend.DBLockStorageBackend$LockId com.daml.platform.store.backend.DBLockStorageBackend$LockMode ), $anonfun$protectedExecution$20$adapted(java.lang.Throwable ), $anonfun$protectedExecution$21(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 java.sql.Connection ), $anonfun$protectedExecution$22(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 com.daml.platform.store.backend.DBLockStorageBackend$Lock ), $anonfun$protectedExecution$23(), $anonfun$protectedExecution$24(), $anonfun$protectedExecution$25(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 com.daml.platform.indexer.ha.SequenceHelper java.sql.Connection scala.Function1 scala.Tuple3 ), $anonfun$protectedExecution$26(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 com.daml.platform.store.backend.DBLockStorageBackend$Lock java.sql.Connection ), $anonfun$protectedExecution$27$adapted(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 java.lang.Object ), $anonfun$protectedExecution$28(), $anonfun$protectedExecution$29(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 com.daml.platform.indexer.ha.SequenceHelper java.sql.Connection scala.Function1 scala.Tuple2 ), $anonfun$protectedExecution$3(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 scala.Function1 com.daml.platform.indexer.ha.SequenceHelper ), $anonfun$protectedExecution$30(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 java.sql.Connection com.daml.platform.indexer.ha.SequenceHelper ), $anonfun$protectedExecution$31(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 java.sql.Connection ), $anonfun$protectedExecution$32(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 com.daml.platform.indexer.ha.SequenceHelper com.daml.platform.indexer.ha.PollingChecker ), $anonfun$protectedExecution$33(), $anonfun$protectedExecution$34(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 com.daml.platform.indexer.ha.PollingChecker ), $anonfun$protectedExecution$35(), $anonfun$protectedExecution$36(), $anonfun$protectedExecution$37(), $anonfun$protectedExecution$38(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 com.daml.platform.indexer.ha.SequenceHelper scala.Function1 scala.Tuple3 ), $anonfun$protectedExecution$39(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 scala.Function1 com.daml.platform.indexer.ha.PollingChecker ), $anonfun$protectedExecution$4(), $anonfun$protectedExecution$41(), $anonfun$protectedExecution$42(), $anonfun$protectedExecution$43(), $anonfun$protectedExecution$44(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 com.daml.platform.indexer.ha.Handle ), $anonfun$protectedExecution$45(), $anonfun$protectedExecution$46(), $anonfun$protectedExecution$47(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 com.daml.platform.indexer.ha.SequenceHelper scala.Tuple3 ), $anonfun$protectedExecution$48(scala.runtime.BoxedUnit ), $anonfun$protectedExecution$5(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 com.daml.platform.indexer.ha.SequenceHelper java.sql.Connection ), $anonfun$protectedExecution$6(), $anonfun$protectedExecution$7(com.daml.platform.indexer.ha.HaCoordinator$$anon$1 java.sql.Connection ), $anonfun$protectedExecution$8(), $anonfun$protectedExecution$9()}, serializedLambda);
            }
        };
    }

    private HaCoordinator$() {
    }
}

