/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.indexer.ha;

import akka.stream.KillSwitch;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import java.io.Serializable;
import java.util.Timer;
import java.util.TimerTask;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u000594A!\u0005\n\u0001;!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u00051\u0001\t\u0005I\u0015!\u00032\u0011!9\u0004A!A!\u0002\u0013A\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b1B!\t\u000b\u001d\u0003A\u0011\u0001%\t\u000fA\u0003!\u0019!C\u0005#\"1Q\u000b\u0001Q\u0001\nICqA\u0016\u0001C\u0002\u0013%q\u000b\u0003\u0004_\u0001\u0001\u0006I\u0001\u0017\u0005\b?\u0002\u0001\r\u0011\"\u0003a\u0011\u001d!\u0007\u00011A\u0005\n\u0015Da\u0001\u001b\u0001!B\u0013\t\u0007\"B5\u0001\t\u0003Q\u0007\"B6\u0001\t\u0013Q\u0007\"\u00027\u0001\t\u0013Q\u0007\"B7\u0001\t\u0003Q'A\u0004)pY2LgnZ\"iK\u000e\\WM\u001d\u0006\u0003'Q\t!\u0001[1\u000b\u0005U1\u0012aB5oI\u0016DXM\u001d\u0006\u0003/a\t\u0001\u0002\u001d7bi\u001a|'/\u001c\u0006\u00033i\tA\u0001Z1nY*\t1$A\u0002d_6\u001c\u0001aE\u0002\u0001=\u0019\u0002\"a\b\u0013\u000e\u0003\u0001R!!\t\u0012\u0002\t1\fgn\u001a\u0006\u0002G\u0005!!.\u0019<b\u0013\t)\u0003E\u0001\u0004PE*,7\r\u001e\t\u0003?\u001dJ!\u0001\u000b\u0011\u0003\u001b\u0005+Ho\\\"m_N,\u0017M\u00197f\u00031\u0001XM]5pI6KG\u000e\\5t!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0011auN\\4\u0002\u0013\rDWmY6C_\u0012L\bcA\u00163i%\u00111\u0007\f\u0002\ty\tLh.Y7f}A\u00111&N\u0005\u0003m1\u0012A!\u00168ji\u0006Q1.\u001b7m'^LGo\u00195\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014AB:ue\u0016\fWNC\u0001>\u0003\u0011\t7n[1\n\u0005}R$AC&jY2\u001cv/\u001b;dQ\u0006qAn\\4hS:<7i\u001c8uKb$\bC\u0001\"F\u001b\u0005\u0019%B\u0001#\u0019\u0003\u001dawnZ4j]\u001eL!AR\"\u0003\u001d1{wmZ5oO\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"B!S'O\u001fR\u0011!\n\u0014\t\u0003\u0017\u0002i\u0011A\u0005\u0005\u0006\u0001\u0016\u0001\u001d!\u0011\u0005\u0006S\u0015\u0001\rA\u000b\u0005\u0007a\u0015!\t\u0019A\u0019\t\u000b]*\u0001\u0019\u0001\u001d\u0002\r1|wmZ3s+\u0005\u0011\u0006C\u0001\"T\u0013\t!6I\u0001\u000bD_:$X\r\u001f;vC2L'0\u001a3M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003\u0015!\u0018.\\3s+\u0005A\u0006CA-]\u001b\u0005Q&BA.#\u0003\u0011)H/\u001b7\n\u0005uS&!\u0002+j[\u0016\u0014\u0018A\u0002;j[\u0016\u0014\b%\u0001\u0004dY>\u001cX\rZ\u000b\u0002CB\u00111FY\u0005\u0003G2\u0012qAQ8pY\u0016\fg.\u0001\u0006dY>\u001cX\rZ0%KF$\"\u0001\u000e4\t\u000f\u001d\\\u0011\u0011!a\u0001C\u0006\u0019\u0001\u0010J\u0019\u0002\u000f\rdwn]3eA\u0005)1\r[3dWR\tA'\u0001\btG\",G-\u001e7fI\u000eCWmY6\u0002\u001b\rDWmY6J]R,'O\\1m\u0003\u0015\u0019Gn\\:f\u0001")
public class PollingChecker
implements AutoCloseable {
    private final Function0<BoxedUnit> checkBody;
    private final KillSwitch killSwitch;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;
    private final Timer timer;
    private boolean closed;

    private ContextualizedLogger logger() {
        return this.logger;
    }

    private Timer timer() {
        return this.timer;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    public synchronized void check() {
        this.logger().debug().apply((Function0 & Serializable)() -> "Checking...", this.loggingContext);
        if (this.closed()) {
            String errorMsg = "Internal Error: This check should not be called from outside by the time the PollingChecker is closed.";
            this.logger().error().apply((Function0 & Serializable)() -> errorMsg, this.loggingContext);
            throw new Exception(errorMsg);
        }
        this.checkInternal();
    }

    public synchronized void com$daml$platform$indexer$ha$PollingChecker$$scheduledCheck() {
        block0: {
            this.logger().debug().apply((Function0 & Serializable)() -> "Scheduled checking...", this.loggingContext);
            if (this.closed()) break block0;
            this.checkInternal();
        }
    }

    private synchronized void checkInternal() {
        Try try_ = Try$.MODULE$.apply(this.checkBody);
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(42).append("Check failed (").append(ex.getMessage()).append("). Calling KillSwitch/abort.").toString(), this.loggingContext);
                this.killSwitch.abort((Throwable)new Exception("check failed, killSwitch aborted", ex));
                throw ex;
            }
            throw new MatchError((Object)try_);
        }
        this.logger().debug().apply((Function0 & Serializable)() -> "Check successful.", this.loggingContext);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    @Override
    public synchronized void close() {
        this.closed_$eq(true);
        this.timer().cancel();
    }

    public PollingChecker(long periodMillis, Function0<BoxedUnit> checkBody, KillSwitch killSwitch, LoggingContext loggingContext) {
        this.checkBody = checkBody;
        this.killSwitch = killSwitch;
        this.loggingContext = loggingContext;
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.timer = new Timer("ha-polling-checker-timer-thread", true);
        this.closed = false;
        this.timer().schedule(new TimerTask(this){
            private final /* synthetic */ PollingChecker $outer;

            public void run() {
                this.$outer.com$daml$platform$indexer$ha$PollingChecker$$scheduledCheck();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, periodMillis, periodMillis);
    }
}

