/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store;

import com.daml.api.util.TimestampConversion$;
import com.daml.ledger.api.v1.command_completion_service.Checkpoint;
import com.daml.ledger.api.v1.command_completion_service.Checkpoint$;
import com.daml.ledger.api.v1.command_completion_service.CompletionStreamResponse;
import com.daml.ledger.api.v1.command_completion_service.CompletionStreamResponse$;
import com.daml.ledger.api.v1.completion.Completion;
import com.daml.ledger.api.v1.completion.Completion$;
import com.daml.ledger.api.v1.ledger_offset.LedgerOffset;
import com.daml.ledger.api.v1.ledger_offset.LedgerOffset$;
import com.daml.ledger.offset.Offset;
import com.daml.lf.data.Time;
import com.daml.platform.ApiOffset$;
import com.google.protobuf.duration.Duration;
import com.google.protobuf.duration.Duration$;
import com.google.rpc.status.Status;
import com.google.rpc.status.Status$;
import io.grpc.Status;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class CompletionFromTransaction$ {
    public static final CompletionFromTransaction$ MODULE$ = new CompletionFromTransaction$();
    private static final Status OkStatus = Status$.MODULE$.of(Status.Code.OK.value(), "", (Seq)package$.MODULE$.Seq().empty());
    private static final String RejectionTransactionId = "";

    private Status OkStatus() {
        return OkStatus;
    }

    private String RejectionTransactionId() {
        return RejectionTransactionId;
    }

    public CompletionStreamResponse acceptedCompletion(Time.Timestamp recordTime, Offset offset, String commandId, String transactionId, String applicationId, Option<String> optSubmissionId, Option<String> optDeduplicationOffset, Option<Object> optDeduplicationDurationSeconds, Option<Object> optDeduplicationDurationNanos) {
        return CompletionStreamResponse$.MODULE$.of((Option)new Some((Object)this.toApiCheckpoint(recordTime, offset)), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Completion[]{this.toApiCompletion(commandId, transactionId, applicationId, (Option<Status>)new Some((Object)this.OkStatus()), optSubmissionId, optDeduplicationOffset, optDeduplicationDurationSeconds, optDeduplicationDurationNanos)})));
    }

    public Option<String> acceptedCompletion$default$6() {
        return None$.MODULE$;
    }

    public Option<String> acceptedCompletion$default$7() {
        return None$.MODULE$;
    }

    public Option<Object> acceptedCompletion$default$8() {
        return None$.MODULE$;
    }

    public Option<Object> acceptedCompletion$default$9() {
        return None$.MODULE$;
    }

    public CompletionStreamResponse rejectedCompletion(Time.Timestamp recordTime, Offset offset, String commandId, Status status, String applicationId, Option<String> optSubmissionId, Option<String> optDeduplicationOffset, Option<Object> optDeduplicationDurationSeconds, Option<Object> optDeduplicationDurationNanos) {
        return CompletionStreamResponse$.MODULE$.of((Option)new Some((Object)this.toApiCheckpoint(recordTime, offset)), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Completion[]{this.toApiCompletion(commandId, this.RejectionTransactionId(), applicationId, (Option<Status>)new Some((Object)status), optSubmissionId, optDeduplicationOffset, optDeduplicationDurationSeconds, optDeduplicationDurationNanos)})));
    }

    public Option<String> rejectedCompletion$default$6() {
        return None$.MODULE$;
    }

    public Option<String> rejectedCompletion$default$7() {
        return None$.MODULE$;
    }

    public Option<Object> rejectedCompletion$default$8() {
        return None$.MODULE$;
    }

    public Option<Object> rejectedCompletion$default$9() {
        return None$.MODULE$;
    }

    private Checkpoint toApiCheckpoint(Time.Timestamp recordTime, Offset offset) {
        return Checkpoint$.MODULE$.of((Option)new Some((Object)TimestampConversion$.MODULE$.fromInstant(recordTime.toInstant())), (Option)new Some((Object)LedgerOffset$.MODULE$.of((LedgerOffset.Value)new LedgerOffset.Value$.Absolute(ApiOffset$.MODULE$.ApiOffsetConverter(offset).toApiString()))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Completion toApiCompletion(String commandId, String transactionId, String applicationId, Option<Status> optStatus, Option<String> optSubmissionId, Option<String> optDeduplicationOffset, Option<Object> optDeduplicationDurationSeconds, Option<Object> optDeduplicationDurationNanos) {
        Completion.DeduplicationPeriod deduplicationPeriod;
        Completion completionWithMandatoryFields = new Completion(commandId, optStatus, transactionId, applicationId, Completion$.MODULE$.apply$default$5(), Completion$.MODULE$.apply$default$6(), Completion$.MODULE$.apply$default$7());
        Option<Completion.DeduplicationPeriod> optDeduplicationPeriod = this.toApiDeduplicationPeriod(optDeduplicationOffset, optDeduplicationDurationSeconds, optDeduplicationDurationNanos);
        Tuple2 tuple2 = new Tuple2(optSubmissionId, optDeduplicationPeriod);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String submissionId = (String)some.value();
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Completion.DeduplicationPeriod deduplicationPeriod2 = (Completion.DeduplicationPeriod)some2.value();
                    String x$1 = submissionId;
                    Completion.DeduplicationPeriod x$2 = deduplicationPeriod2;
                    String x$3 = completionWithMandatoryFields.copy$default$1();
                    Option x$4 = completionWithMandatoryFields.copy$default$2();
                    String x$5 = completionWithMandatoryFields.copy$default$3();
                    String x$6 = completionWithMandatoryFields.copy$default$4();
                    Seq x$7 = completionWithMandatoryFields.copy$default$5();
                    return completionWithMandatoryFields.copy(x$3, x$4, x$5, x$6, x$7, x$1, x$2);
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String submissionId = (String)some.value();
                if (None$.MODULE$.equals(option3)) {
                    String x$8 = submissionId;
                    String x$9 = completionWithMandatoryFields.copy$default$1();
                    Option x$10 = completionWithMandatoryFields.copy$default$2();
                    String x$11 = completionWithMandatoryFields.copy$default$3();
                    String x$12 = completionWithMandatoryFields.copy$default$4();
                    Seq x$13 = completionWithMandatoryFields.copy$default$5();
                    Completion.DeduplicationPeriod x$14 = completionWithMandatoryFields.copy$default$7();
                    return completionWithMandatoryFields.copy(x$9, x$10, x$11, x$12, x$13, x$8, x$14);
                }
            }
        }
        if (tuple2 == null) return completionWithMandatoryFields;
        Option option = (Option)tuple2._1();
        Option option4 = (Option)tuple2._2();
        if (!None$.MODULE$.equals(option)) return completionWithMandatoryFields;
        if (!(option4 instanceof Some)) return completionWithMandatoryFields;
        Some some = (Some)option4;
        Completion.DeduplicationPeriod x$15 = deduplicationPeriod = (Completion.DeduplicationPeriod)some.value();
        String x$16 = completionWithMandatoryFields.copy$default$1();
        Option x$17 = completionWithMandatoryFields.copy$default$2();
        String x$18 = completionWithMandatoryFields.copy$default$3();
        String x$19 = completionWithMandatoryFields.copy$default$4();
        Seq x$20 = completionWithMandatoryFields.copy$default$5();
        String x$21 = completionWithMandatoryFields.copy$default$6();
        return completionWithMandatoryFields.copy(x$16, x$17, x$18, x$19, x$20, x$21, x$15);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<Completion.DeduplicationPeriod> toApiDeduplicationPeriod(Option<String> optDeduplicationOffset, Option<Object> optDeduplicationDurationSeconds, Option<Object> optDeduplicationDurationNanos) {
        Option option;
        Tuple2 tuple2 = new Tuple2(optDeduplicationOffset, (Object)new Tuple2(optDeduplicationDurationSeconds, optDeduplicationDurationNanos));
        if (tuple2 != null) {
            Option option2 = (Option)tuple2._1();
            Tuple2 tuple22 = (Tuple2)tuple2._2();
            if (None$.MODULE$.equals(option2) && tuple22 != null) {
                Option option3 = (Option)tuple22._1();
                Option option4 = (Option)tuple22._2();
                if (None$.MODULE$.equals(option3) && None$.MODULE$.equals(option4)) {
                    return None$.MODULE$;
                }
            }
        }
        if (tuple2 != null && (option = (Option)tuple2._1()) instanceof Some) {
            Some some = (Some)option;
            String offset = (String)some.value();
            return new Some((Object)new Completion.DeduplicationPeriod$.DeduplicationOffset(offset));
        }
        if (tuple2 == null) throw new IllegalArgumentException("One of deduplication duration seconds and nanos has been provided but they must be either both provided or both absent");
        Tuple2 tuple23 = (Tuple2)tuple2._2();
        if (tuple23 == null) throw new IllegalArgumentException("One of deduplication duration seconds and nanos has been provided but they must be either both provided or both absent");
        Option option5 = (Option)tuple23._1();
        Option option6 = (Option)tuple23._2();
        if (!(option5 instanceof Some)) throw new IllegalArgumentException("One of deduplication duration seconds and nanos has been provided but they must be either both provided or both absent");
        Some some = (Some)option5;
        long deduplicationDurationSeconds = BoxesRunTime.unboxToLong((Object)some.value());
        if (!(option6 instanceof Some)) throw new IllegalArgumentException("One of deduplication duration seconds and nanos has been provided but they must be either both provided or both absent");
        Some some2 = (Some)option6;
        int deduplicationDurationNanos = BoxesRunTime.unboxToInt((Object)some2.value());
        return new Some((Object)new Completion.DeduplicationPeriod$.DeduplicationDuration(new Duration(deduplicationDurationSeconds, deduplicationDurationNanos, Duration$.MODULE$.$lessinit$greater$default$3())));
    }

    private CompletionFromTransaction$() {
    }
}

