/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.backend.common;

import anorm.;
import anorm.Column$;
import anorm.Row;
import anorm.RowParser;
import anorm.SimpleSql;
import anorm.SqlParser$;
import anorm.ToParameterValue$;
import anorm.ToStatement;
import anorm.ToStatement$;
import anorm.ToStatementPriority0;
import com.daml.ledger.api.domain$;
import com.daml.ledger.offset.Offset;
import com.daml.ledger.offset.Offset$;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.platform.common.MismatchException;
import com.daml.platform.store.backend.Conversions$;
import com.daml.platform.store.backend.Conversions$OffsetToStatement$;
import com.daml.platform.store.backend.ParameterStorageBackend;
import com.daml.platform.store.backend.ParameterStorageBackend$LedgerEnd$;
import com.daml.platform.store.backend.common.ComposableQuery;
import com.daml.platform.store.backend.common.ComposableQuery$;
import com.daml.platform.store.backend.common.ComposableQuery$QueryPart$;
import com.daml.platform.store.backend.common.ComposableQuery$SqlStringInterpolation$;
import com.daml.scalautil.Statement$;
import java.io.Serializable;
import java.sql.Connection;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scalaz.syntax.TagOps$;
import scalaz.syntax.package$;

public final class ParameterStorageBackendImpl$
implements ParameterStorageBackend {
    public static final ParameterStorageBackendImpl$ MODULE$ = new ParameterStorageBackendImpl$();
    private static final ContextualizedLogger logger = ContextualizedLogger$.MODULE$.get(MODULE$.getClass());
    private static final SimpleSql<Row> SqlGetLedgerEnd = ComposableQuery$SqlStringInterpolation$.MODULE$.SQL$extension(ComposableQuery$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      SELECT\n        ledger_end,\n        ledger_end_sequential_id,\n        ledger_end_string_interning_id\n      FROM\n        parameters\n      "}))), (Seq<ComposableQuery.QueryPart>)Nil$.MODULE$);
    private static final String TableName = "parameters";
    private static final String LedgerIdColumnName = "ledger_id";
    private static final String ParticipantIdColumnName = "participant_id";
    private static final String LedgerEndColumnName = "ledger_end";
    private static final String LedgerEndSequentialIdColumnName = "ledger_end_sequential_id";
    private static final String LedgerEndStringInterningIdColumnName = "ledger_end_string_interning_id";
    private static final RowParser<Object> LedgerIdParser = Conversions$.MODULE$.ledgerString(MODULE$.LedgerIdColumnName()).map((Function1 & Serializable)x$1 -> domain$.MODULE$.LedgerId().apply(x$1));
    private static final RowParser<Object> ParticipantIdParser = Conversions$.MODULE$.participantId(MODULE$.ParticipantIdColumnName()).map((Function1 & Serializable)x$2 -> domain$.MODULE$.ParticipantId().apply(x$2));
    private static final RowParser<Offset> LedgerEndOffsetParser = Conversions$.MODULE$.offset(MODULE$.LedgerEndColumnName()).$qmark().map((Function1 & Serializable)x$3 -> (Offset)x$3.getOrElse((Function0 & Serializable)() -> Offset$.MODULE$.beforeBegin()));
    private static final RowParser<Object> LedgerEndSequentialIdParser = SqlParser$.MODULE$.long(MODULE$.LedgerEndSequentialIdColumnName(), Column$.MODULE$.columnToLong());
    private static final RowParser<Object> LedgerEndStringInterningIdParser = SqlParser$.MODULE$.int(MODULE$.LedgerEndStringInterningIdColumnName(), Column$.MODULE$.columnToInt());
    private static final RowParser<ParameterStorageBackend.IdentityParams> LedgerIdentityParser = MODULE$.LedgerIdParser().$tilde(MODULE$.ParticipantIdParser()).map((Function1 & Serializable)x0$1 -> {
        .tilde tilde2 = x0$1;
        if (tilde2 == null) {
            throw new MatchError((Object)tilde2);
        }
        Object ledgerId = tilde2._1();
        Object participantId = tilde2._2();
        ParameterStorageBackend.IdentityParams identityParams = new ParameterStorageBackend.IdentityParams(ledgerId, participantId);
        return identityParams;
    });
    private static final RowParser<ParameterStorageBackend.LedgerEnd> LedgerEndParser = MODULE$.LedgerEndOffsetParser().$tilde(MODULE$.LedgerEndSequentialIdParser()).$tilde(MODULE$.LedgerEndStringInterningIdParser()).map((Function1 & Serializable)x0$2 -> {
        int lastStringInterningId;
        .tilde tilde2;
        block3: {
            .tilde tilde3;
            block2: {
                tilde3 = x0$2;
                if (tilde3 == null) break block2;
                tilde2 = (.tilde)tilde3._1();
                lastStringInterningId = BoxesRunTime.unboxToInt((Object)tilde3._2());
                if (tilde2 != null) break block3;
            }
            throw new MatchError((Object)tilde3);
        }
        Offset lastOffset = (Offset)tilde2._1();
        long lastEventSequentialId = BoxesRunTime.unboxToLong((Object)tilde2._2());
        ParameterStorageBackend.LedgerEnd ledgerEnd = new ParameterStorageBackend.LedgerEnd(lastOffset, lastEventSequentialId, lastStringInterningId);
        return ledgerEnd;
    });
    private static final SimpleSql<Row> SqlSelectMostRecentPruning = ComposableQuery$SqlStringInterpolation$.MODULE$.SQL$extension(ComposableQuery$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select participant_pruned_up_to_inclusive from parameters"}))), (Seq<ComposableQuery.QueryPart>)Nil$.MODULE$);
    private static final SimpleSql<Row> SqlSelectMostRecentPruningAllDivulgedContracts = ComposableQuery$SqlStringInterpolation$.MODULE$.SQL$extension(ComposableQuery$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select participant_all_divulged_contracts_pruned_up_to_inclusive from parameters"}))), (Seq<ComposableQuery.QueryPart>)Nil$.MODULE$);

    private ContextualizedLogger logger() {
        return logger;
    }

    @Override
    public void updateLedgerEnd(ParameterStorageBackend.LedgerEnd ledgerEnd, Connection connection) {
        ComposableQuery.QueryPart[] queryPartArray = new ComposableQuery.QueryPart[3];
        Conversions$OffsetToStatement$ x$3 = Conversions$OffsetToStatement$.MODULE$;
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        queryPartArray[0] = ComposableQuery$QueryPart$.MODULE$.from(ledgerEnd.lastOffset(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        ToStatementPriority0.longToStatement$ x$7 = ToStatement$.MODULE$.longToStatement();
        Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
        queryPartArray[1] = ComposableQuery$QueryPart$.MODULE$.from(BoxesRunTime.boxToLong((long)ledgerEnd.lastEventSeqId()), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
        ToStatementPriority0.intToStatement$ x$11 = ToStatement$.MODULE$.intToStatement();
        Null$ x$12 = ToParameterValue$.MODULE$.apply$default$1();
        queryPartArray[2] = ComposableQuery$QueryPart$.MODULE$.from(BoxesRunTime.boxToInteger((int)ledgerEnd.lastStringInterningId()), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$11));
        ComposableQuery$SqlStringInterpolation$.MODULE$.SQL$extension(ComposableQuery$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      UPDATE\n        parameters\n      SET\n        ledger_end = ", ",\n        ledger_end_sequential_id = ", ",\n        ledger_end_string_interning_id = ", "\n      "}))), (Seq<ComposableQuery.QueryPart>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])queryPartArray)).execute(connection);
    }

    private SimpleSql<Row> SqlGetLedgerEnd() {
        return SqlGetLedgerEnd;
    }

    @Override
    public ParameterStorageBackend.LedgerEnd ledgerEnd(Connection connection) {
        return (ParameterStorageBackend.LedgerEnd)((Option)this.SqlGetLedgerEnd().as(this.LedgerEndParser().singleOpt(), connection)).getOrElse((Function0 & Serializable)() -> ParameterStorageBackend$LedgerEnd$.MODULE$.beforeBegin());
    }

    private String TableName() {
        return TableName;
    }

    private String LedgerIdColumnName() {
        return LedgerIdColumnName;
    }

    private String ParticipantIdColumnName() {
        return ParticipantIdColumnName;
    }

    private String LedgerEndColumnName() {
        return LedgerEndColumnName;
    }

    private String LedgerEndSequentialIdColumnName() {
        return LedgerEndSequentialIdColumnName;
    }

    private String LedgerEndStringInterningIdColumnName() {
        return LedgerEndStringInterningIdColumnName;
    }

    private RowParser<Object> LedgerIdParser() {
        return LedgerIdParser;
    }

    private RowParser<Object> ParticipantIdParser() {
        return ParticipantIdParser;
    }

    private RowParser<Offset> LedgerEndOffsetParser() {
        return LedgerEndOffsetParser;
    }

    private RowParser<Object> LedgerEndSequentialIdParser() {
        return LedgerEndSequentialIdParser;
    }

    private RowParser<Object> LedgerEndStringInterningIdParser() {
        return LedgerEndStringInterningIdParser;
    }

    private RowParser<ParameterStorageBackend.IdentityParams> LedgerIdentityParser() {
        return LedgerIdentityParser;
    }

    private RowParser<ParameterStorageBackend.LedgerEnd> LedgerEndParser() {
        return LedgerEndParser;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void initializeParameters(ParameterStorageBackend.IdentityParams params, Connection connection, LoggingContext loggingContext) {
        Object existing;
        ParameterStorageBackend.IdentityParams identityParams;
        Option<ParameterStorageBackend.IdentityParams> previous = this.ledgerIdentity(connection);
        Object ledgerId = params.ledgerId();
        Object participantId = params.participantId();
        boolean bl = false;
        Some some = null;
        Option<ParameterStorageBackend.IdentityParams> option = previous;
        if (None$.MODULE$.equals(option)) {
            this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(62).append("Initializing new database for ledgerId '").append(params.ledgerId()).append("' and participantId '").append(params.participantId()).append("'").toString(), loggingContext);
            ParameterStorageBackend.LedgerEnd ledgerEnd = ParameterStorageBackend$LedgerEnd$.MODULE$.beforeBegin();
            ComposableQuery.QueryPart[] queryPartArray = new ComposableQuery.QueryPart[11];
            ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
            queryPartArray[0] = ComposableQuery$QueryPart$.MODULE$.from(this.TableName(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
            ToStatementPriority0.stringToStatement$ x$7 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
            queryPartArray[1] = ComposableQuery$QueryPart$.MODULE$.from(this.LedgerIdColumnName(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
            ToStatementPriority0.stringToStatement$ x$11 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$12 = ToParameterValue$.MODULE$.apply$default$1();
            queryPartArray[2] = ComposableQuery$QueryPart$.MODULE$.from(this.ParticipantIdColumnName(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$11));
            ToStatementPriority0.stringToStatement$ x$15 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$16 = ToParameterValue$.MODULE$.apply$default$1();
            queryPartArray[3] = ComposableQuery$QueryPart$.MODULE$.from(this.LedgerEndColumnName(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$15));
            ToStatementPriority0.stringToStatement$ x$19 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$20 = ToParameterValue$.MODULE$.apply$default$1();
            queryPartArray[4] = ComposableQuery$QueryPart$.MODULE$.from(this.LedgerEndSequentialIdColumnName(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$19));
            ToStatementPriority0.stringToStatement$ x$23 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$24 = ToParameterValue$.MODULE$.apply$default$1();
            queryPartArray[5] = ComposableQuery$QueryPart$.MODULE$.from(this.LedgerEndStringInterningIdColumnName(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$23));
            ToStatementPriority0.stringToStatement$ x$27 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$28 = ToParameterValue$.MODULE$.apply$default$1();
            queryPartArray[6] = ComposableQuery$QueryPart$.MODULE$.from(TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(ledgerId)), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$27));
            ToStatementPriority0.stringToStatement$ x$31 = ToStatement$.MODULE$.stringToStatement();
            Null$ x$32 = ToParameterValue$.MODULE$.apply$default$1();
            queryPartArray[7] = ComposableQuery$QueryPart$.MODULE$.from((String)TagOps$.MODULE$.unwrap$extension(package$.MODULE$.tag().ToTagOps(participantId)), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$31));
            Conversions$OffsetToStatement$ x$35 = Conversions$OffsetToStatement$.MODULE$;
            Null$ x$36 = ToParameterValue$.MODULE$.apply$default$1();
            queryPartArray[8] = ComposableQuery$QueryPart$.MODULE$.from(ledgerEnd.lastOffset(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$35));
            ToStatementPriority0.longToStatement$ x$39 = ToStatement$.MODULE$.longToStatement();
            Null$ x$40 = ToParameterValue$.MODULE$.apply$default$1();
            queryPartArray[9] = ComposableQuery$QueryPart$.MODULE$.from(BoxesRunTime.boxToLong((long)ledgerEnd.lastEventSeqId()), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$39));
            ToStatementPriority0.intToStatement$ x$43 = ToStatement$.MODULE$.intToStatement();
            Null$ x$44 = ToParameterValue$.MODULE$.apply$default$1();
            queryPartArray[10] = ComposableQuery$QueryPart$.MODULE$.from(BoxesRunTime.boxToInteger((int)ledgerEnd.lastStringInterningId()), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$43));
            Statement$.MODULE$.discard((Object)BoxesRunTime.boxToBoolean((boolean)ComposableQuery$SqlStringInterpolation$.MODULE$.SQL$extension(ComposableQuery$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"insert into #", "(\n              #", ",\n              #", ",\n              #", ",\n              #", ",\n              #", "\n            ) values(\n              ", ",\n              ", ",\n              ", ",\n              ", ",\n              ", "\n            )"}))), (Seq<ComposableQuery.QueryPart>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])queryPartArray)).execute(connection)));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            ParameterStorageBackend.IdentityParams identityParams2 = (ParameterStorageBackend.IdentityParams)some.value();
            if (identityParams2 != null) {
                Object object = identityParams2.ledgerId();
                Object object2 = identityParams2.participantId();
                if (BoxesRunTime.equals((Object)ledgerId, (Object)object) && BoxesRunTime.equals((Object)participantId, (Object)object2)) {
                    this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(60).append("Found existing database for ledgerId '").append(params.ledgerId()).append("' and participantId '").append(params.participantId()).append("'").toString(), loggingContext);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (bl && (identityParams = (ParameterStorageBackend.IdentityParams)some.value()) != null && !BoxesRunTime.equals((Object)(existing = identityParams.ledgerId()), (Object)params.ledgerId())) {
            this.logger().error().apply((Function0 & Serializable)() -> new StringBuilder(75).append("Found existing database with mismatching ledgerId: existing '").append(existing).append("', provided '").append(params.ledgerId()).append("'").toString(), loggingContext);
            throw new MismatchException.LedgerId(existing, params.ledgerId());
        }
        if (!bl) throw new MatchError(option);
        ParameterStorageBackend.IdentityParams identityParams3 = (ParameterStorageBackend.IdentityParams)some.value();
        if (identityParams3 == null) throw new MatchError(option);
        Object existing2 = identityParams3.participantId();
        this.logger().error().apply((Function0 & Serializable)() -> new StringBuilder(80).append("Found existing database with mismatching participantId: existing '").append(existing2).append("', provided '").append(params.participantId()).append("'").toString(), loggingContext);
        throw new MismatchException.ParticipantId(existing2, params.participantId());
    }

    @Override
    public Option<ParameterStorageBackend.IdentityParams> ledgerIdentity(Connection connection) {
        ComposableQuery.QueryPart[] queryPartArray = new ComposableQuery.QueryPart[3];
        ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        queryPartArray[0] = ComposableQuery$QueryPart$.MODULE$.from(this.LedgerIdColumnName(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        ToStatementPriority0.stringToStatement$ x$7 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
        queryPartArray[1] = ComposableQuery$QueryPart$.MODULE$.from(this.ParticipantIdColumnName(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
        ToStatementPriority0.stringToStatement$ x$11 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$12 = ToParameterValue$.MODULE$.apply$default$1();
        queryPartArray[2] = ComposableQuery$QueryPart$.MODULE$.from(this.TableName(), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$11));
        return (Option)ComposableQuery$SqlStringInterpolation$.MODULE$.SQL$extension(ComposableQuery$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select #", ", #", " from #", ""}))), (Seq<ComposableQuery.QueryPart>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])queryPartArray)).as(this.LedgerIdentityParser().singleOpt(), connection);
    }

    @Override
    public void updatePrunedUptoInclusive(Offset prunedUpToInclusive, Connection connection) {
        ComposableQuery.QueryPart[] queryPartArray = new ComposableQuery.QueryPart[2];
        Conversions$OffsetToStatement$ x$3 = Conversions$OffsetToStatement$.MODULE$;
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        queryPartArray[0] = ComposableQuery$QueryPart$.MODULE$.from(prunedUpToInclusive, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        Conversions$OffsetToStatement$ x$7 = Conversions$OffsetToStatement$.MODULE$;
        Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
        queryPartArray[1] = ComposableQuery$QueryPart$.MODULE$.from(prunedUpToInclusive, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
        ComposableQuery$SqlStringInterpolation$.MODULE$.SQL$extension(ComposableQuery$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      update parameters set participant_pruned_up_to_inclusive=", "\n      where participant_pruned_up_to_inclusive < ", " or participant_pruned_up_to_inclusive is null\n      "}))), (Seq<ComposableQuery.QueryPart>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])queryPartArray)).execute(connection);
    }

    @Override
    public void updatePrunedAllDivulgedContractsUpToInclusive(Offset prunedUpToInclusive, Connection connection) {
        ComposableQuery.QueryPart[] queryPartArray = new ComposableQuery.QueryPart[2];
        Conversions$OffsetToStatement$ x$3 = Conversions$OffsetToStatement$.MODULE$;
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        queryPartArray[0] = ComposableQuery$QueryPart$.MODULE$.from(prunedUpToInclusive, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        Conversions$OffsetToStatement$ x$7 = Conversions$OffsetToStatement$.MODULE$;
        Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
        queryPartArray[1] = ComposableQuery$QueryPart$.MODULE$.from(prunedUpToInclusive, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
        ComposableQuery$SqlStringInterpolation$.MODULE$.SQL$extension(ComposableQuery$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n      update parameters set participant_all_divulged_contracts_pruned_up_to_inclusive=", "\n      where participant_all_divulged_contracts_pruned_up_to_inclusive < ", " or participant_all_divulged_contracts_pruned_up_to_inclusive is null\n      "}))), (Seq<ComposableQuery.QueryPart>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])queryPartArray)).execute(connection);
    }

    private SimpleSql<Row> SqlSelectMostRecentPruning() {
        return SqlSelectMostRecentPruning;
    }

    @Override
    public Option<Offset> prunedUpToInclusive(Connection connection) {
        return (Option)this.SqlSelectMostRecentPruning().as(Conversions$.MODULE$.offset("participant_pruned_up_to_inclusive").$qmark().single(), connection);
    }

    private SimpleSql<Row> SqlSelectMostRecentPruningAllDivulgedContracts() {
        return SqlSelectMostRecentPruningAllDivulgedContracts;
    }

    @Override
    public Option<Offset> participantAllDivulgedContractsPrunedUpToInclusive(Connection connection) {
        return (Option)this.SqlSelectMostRecentPruningAllDivulgedContracts().as(Conversions$.MODULE$.offset("participant_all_divulged_contracts_pruned_up_to_inclusive").$qmark().single(), connection);
    }

    private ParameterStorageBackendImpl$() {
    }
}

