/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.backend.h2;

import com.daml.logging.LoggingContext;
import com.daml.platform.store.backend.DataSourceStorageBackend;
import com.daml.platform.store.backend.common.DataSourceStorageBackendImpl$;
import com.daml.platform.store.backend.common.InitHookDataSourceProxy$;
import java.io.Serializable;
import java.sql.Connection;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.util.matching.Regex;

public final class H2DataSourceStorageBackend$
implements DataSourceStorageBackend {
    public static final H2DataSourceStorageBackend$ MODULE$ = new H2DataSourceStorageBackend$();

    static {
        DataSourceStorageBackend.$init$(MODULE$);
    }

    @Override
    public Option<Function1<Connection, BoxedUnit>> createDataSource$default$2() {
        return DataSourceStorageBackend.createDataSource$default$2$(this);
    }

    @Override
    public void checkCompatibility(Connection connection, LoggingContext loggingContext) {
        DataSourceStorageBackend.checkCompatibility$(this, connection, loggingContext);
    }

    @Override
    public DataSource createDataSource(DataSourceStorageBackend.DataSourceConfig dataSourceConfig, Option<Function1<Connection, BoxedUnit>> connectionInitHook, LoggingContext loggingContext) {
        JdbcDataSource h2DataSource = new JdbcDataSource();
        Tuple3<String, Option<String>, Option<String>> tuple3 = this.extractUserPasswordAndRemoveFromUrl(dataSourceConfig.jdbcUrl());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String urlNoUserNoPassword = (String)tuple3._1();
        Option user = (Option)tuple3._2();
        Option password = (Option)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)urlNoUserNoPassword, (Object)user, (Object)password);
        Tuple3 tuple33 = tuple32;
        String urlNoUserNoPassword2 = (String)tuple33._1();
        Option user2 = (Option)tuple33._2();
        Option password2 = (Option)tuple33._3();
        user2.foreach((Function1 & Serializable)x$1 -> {
            h2DataSource.setUser(x$1);
            return BoxedUnit.UNIT;
        });
        password2.foreach((Function1 & Serializable)x$1 -> {
            h2DataSource.setPassword(x$1);
            return BoxedUnit.UNIT;
        });
        h2DataSource.setUrl(urlNoUserNoPassword2);
        return InitHookDataSourceProxy$.MODULE$.apply((DataSource)h2DataSource, (List<Function1<Connection, BoxedUnit>>)connectionInitHook.toList(), loggingContext);
    }

    public Tuple3<String, Option<String>, Option<String>> extractUserPasswordAndRemoveFromUrl(String jdbcUrl) {
        Tuple2 tuple2 = H2DataSourceStorageBackend$.setKeyValueAndRemoveFromUrl$1(jdbcUrl, "user");
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String urlNoUser = (String)tuple2._1();
        Option user = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)urlNoUser, (Object)user);
        Tuple2 tuple23 = tuple22;
        String urlNoUser2 = (String)tuple23._1();
        Option user2 = (Option)tuple23._2();
        Tuple2 tuple24 = H2DataSourceStorageBackend$.setKeyValueAndRemoveFromUrl$1(urlNoUser2, "password");
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        String urlNoUserNoPassword = (String)tuple24._1();
        Option password = (Option)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)urlNoUserNoPassword, (Object)password);
        Tuple2 tuple26 = tuple25;
        String urlNoUserNoPassword2 = (String)tuple26._1();
        Option password2 = (Option)tuple26._2();
        return new Tuple3((Object)urlNoUserNoPassword2, (Object)user2, (Object)password2);
    }

    @Override
    public void checkDatabaseAvailable(Connection connection) {
        DataSourceStorageBackendImpl$.MODULE$.checkDatabaseAvailable(connection);
    }

    private static final Tuple2 setKeyValueAndRemoveFromUrl$1(String url, String key) {
        Tuple2 tuple2;
        Option option;
        Regex regex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(19).append(".*(;(?i)").append(key).append("=([^;]*)).*").toString()));
        String string = url;
        if (string != null && !(option = regex.unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
            String keyAndValue = (String)((LinearSeqOps)option.get()).apply(0);
            String value = (String)((LinearSeqOps)option.get()).apply(1);
            tuple2 = new Tuple2((Object)url.replace(keyAndValue, ""), (Object)new Some((Object)value));
        } else {
            tuple2 = new Tuple2((Object)url, (Object)None$.MODULE$);
        }
        return tuple2;
    }

    private H2DataSourceStorageBackend$() {
    }
}

