/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.backend.oracle;

import anorm.Column$;
import anorm.ParameterValue;
import anorm.ParameterValue$;
import anorm.SqlParser$;
import anorm.ToParameterValue$;
import anorm.ToStatement;
import anorm.ToStatement$;
import anorm.ToStatementPriority0;
import anorm.package;
import anorm.package$;
import com.daml.platform.store.backend.DBLockStorageBackend;
import com.daml.platform.store.backend.DBLockStorageBackend$LockMode$Exclusive$;
import com.daml.platform.store.backend.DBLockStorageBackend$LockMode$Shared$;
import com.daml.platform.store.backend.oracle.OracleDBLockStorageBackend;
import java.sql.Connection;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

public final class OracleDBLockStorageBackend$
implements DBLockStorageBackend {
    public static final OracleDBLockStorageBackend$ MODULE$ = new OracleDBLockStorageBackend$();

    @Override
    public Option<DBLockStorageBackend.Lock> tryAcquire(DBLockStorageBackend.LockId lockId, DBLockStorageBackend.LockMode lockMode, Connection connection) {
        None$ none$;
        String string;
        DBLockStorageBackend.LockMode lockMode2 = lockMode;
        if (DBLockStorageBackend$LockMode$Exclusive$.MODULE$.equals(lockMode2)) {
            string = "6";
        } else if (DBLockStorageBackend$LockMode$Shared$.MODULE$.equals(lockMode2)) {
            string = "4";
        } else {
            throw new MatchError((Object)lockMode2);
        }
        String oracleLockMode = string;
        ParameterValue[] parameterValueArray = new ParameterValue[2];
        ToStatementPriority0.intToStatement$ x$3 = ToStatement$.MODULE$.intToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)this.oracleIntLockId(lockId)), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        ToStatementPriority0.stringToStatement$ x$7 = ToStatement$.MODULE$.stringToStatement();
        Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[1] = ParameterValue$.MODULE$.from((Object)oracleLockMode, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
        int n = BoxesRunTime.unboxToInt((Object)package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n          SELECT DBMS_LOCK.REQUEST(\n            id => ", ",\n            lockmode => #", ",\n            timeout => 0\n          ) FROM DUAL"}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.get(1, Column$.MODULE$.columnToInt()).single(), connection));
        switch (n) {
            case 0: {
                none$ = new Some((Object)new DBLockStorageBackend.Lock(lockId, lockMode));
                break;
            }
            case 1: {
                none$ = None$.MODULE$;
                break;
            }
            case 2: {
                throw new Exception("DBMS_LOCK.REQUEST Error 2: Acquiring lock caused a deadlock!");
            }
            case 3: {
                throw new Exception("DBMS_LOCK.REQUEST Error 3: Parameter error as acquiring lock");
            }
            case 4: {
                none$ = new Some((Object)new DBLockStorageBackend.Lock(lockId, lockMode));
                break;
            }
            case 5: {
                throw new Exception("DBMS_LOCK.REQUEST Error 5: Illegal lock handle as acquiring lock");
            }
            default: {
                throw new Exception(new StringBuilder(39).append("Invalid result from DBMS_LOCK.REQUEST: ").append(n).toString());
            }
        }
        return none$;
    }

    @Override
    public boolean release(DBLockStorageBackend.Lock lock, Connection connection) {
        boolean bl;
        ParameterValue[] parameterValueArray = new ParameterValue[1];
        ToStatementPriority0.intToStatement$ x$3 = ToStatement$.MODULE$.intToStatement();
        Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
        parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)this.oracleIntLockId(lock.lockId())), ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
        int n = BoxesRunTime.unboxToInt((Object)package.SqlStringInterpolation$.MODULE$.SQL$extension(package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n          SELECT DBMS_LOCK.RELEASE(\n            id => ", "\n          ) FROM DUAL"}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.get(1, Column$.MODULE$.columnToInt()).single(), connection));
        switch (n) {
            case 0: {
                bl = true;
                break;
            }
            case 3: {
                throw new Exception("DBMS_LOCK.RELEASE Error 3: Parameter error as releasing lock");
            }
            case 4: {
                bl = false;
                break;
            }
            case 5: {
                throw new Exception("DBMS_LOCK.RELEASE Error 5: Illegal lock handle as releasing lock");
            }
            default: {
                throw new Exception(new StringBuilder(39).append("Invalid result from DBMS_LOCK.RELEASE: ").append(n).toString());
            }
        }
        return bl;
    }

    private int oracleIntLockId(DBLockStorageBackend.LockId lockId) {
        int id;
        DBLockStorageBackend.LockId lockId2 = lockId;
        if (!(lockId2 instanceof OracleDBLockStorageBackend.OracleLockId)) {
            throw new Exception(new StringBuilder(87).append("LockId ").append(lockId2).append(" not supported. Probable cause: LockId was created by a different StorageBackend").toString());
        }
        OracleDBLockStorageBackend.OracleLockId oracleLockId = (OracleDBLockStorageBackend.OracleLockId)lockId2;
        int n = id = oracleLockId.id();
        return n;
    }

    @Override
    public DBLockStorageBackend.LockId lock(int id) {
        return new OracleDBLockStorageBackend.OracleLockId(id);
    }

    @Override
    public boolean dbLockSupported() {
        return true;
    }

    private OracleDBLockStorageBackend$() {
    }
}

