/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.cache;

import akka.Done;
import akka.NotUsed;
import akka.stream.Graph;
import akka.stream.KillSwitches$;
import akka.stream.Materializer;
import akka.stream.RestartSettings$;
import akka.stream.UniqueKillSwitch;
import akka.stream.scaladsl.Keep$;
import akka.stream.scaladsl.RestartSource$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import com.daml.ledger.offset.Offset;
import com.daml.ledger.participant.state.index.v2.ContractStore;
import com.daml.ledger.participant.state.index.v2.MaximumLedgerTime;
import com.daml.ledger.participant.state.index.v2.MaximumLedgerTime$;
import com.daml.ledger.resources.ResourceContext;
import com.daml.ledger.resources.package$;
import com.daml.lf.data.Time;
import com.daml.lf.transaction.GlobalKey;
import com.daml.lf.transaction.Versioned;
import com.daml.lf.value.Value;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.metrics.Metrics;
import com.daml.platform.store.cache.ContractKeyStateValue;
import com.daml.platform.store.cache.ContractKeyStateValue$Unassigned$;
import com.daml.platform.store.cache.ContractStateCaches;
import com.daml.platform.store.cache.ContractStateValue;
import com.daml.platform.store.cache.ContractStateValue$NotFound$;
import com.daml.platform.store.dao.events.ContractStateEvent;
import com.daml.platform.store.interfaces.LedgerDaoContractsReader;
import com.daml.platform.store.interfaces.LedgerDaoContractsReader$KeyUnassigned$;
import com.daml.resources.AbstractResourceOwner;
import com.daml.resources.HasExecutionContext;
import com.daml.resources.Resource;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NoStackTrace;

@ScalaSignature(bytes="\u0006\u0005\u0011ee!\u0002#F\u0001%{\u0005\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011\u00024\t\u0011-\u0004!\u0011!Q\u0001\n1D\u0001B\u001d\u0001\u0003\u0002\u0003\u0006Ia\u001d\u0005\f\u0005s\u0004!Q1A\u0005\u0002\u0015\u0013Y\u0010\u0003\u0006\u0004\u0004\u0001\u0011\t\u0011)A\u0005\u0005{D!b!\u0002\u0001\u0005\u0003\u0005\u000b1BB\u0004\u0011)\u0019y\u0001\u0001B\u0001B\u0003-1\u0011\u0003\u0005\b\u0003\u001b\u0001A\u0011AB\u000f\u0011%\u0019i\u0003\u0001b\u0001\n\u0013\u0019y\u0003\u0003\u0005\u00048\u0001\u0001\u000b\u0011BB\u0019\u0011\u001d\u0019I\u0004\u0001C\u0001\u0007wAqa!\u0011\u0001\t\u0003\u001a\u0019\u0005C\u0004\u0004j\u0001!\tea\u001b\t\u000f\r%\u0005\u0001\"\u0011\u0004\f\"91q\u0014\u0001\u0005\n\r\u0005\u0006bBBg\u0001\u0011%1q\u001a\u0005\b\u0007K\u0004A\u0011BBt\u0011\u001d\u00199\u0010\u0001C\u0005\u0007sDq\u0001b\u0002\u0001\t\u0013!I\u0001C\u0004\u0005\u0018\u0001!I\u0001\"\u0007\t\u0013\u0011%\u0002A1A\u0005\n\u0011-\u0002\u0002\u0003C$\u0001\u0001\u0006I\u0001\"\f\t\u0013\u0011%\u0003A1A\u0005\n\u0011-\u0003\u0002\u0003C+\u0001\u0001\u0006I\u0001\"\u0014\t\u000f\u0011]\u0003\u0001\"\u0003\u0005Z!9A1\r\u0001\u0005\n\u0011\u0015\u0004b\u0002CB\u0001\u0011%AQ\u0011\u0005\b\t\u001f\u0003A\u0011\u0002CI\u000f!\t)!\u0012E\u0001\u0013\u0006\u001daa\u0002#F\u0011\u0003I\u00151\u0002\u0005\b\u0003\u001bqB\u0011AA\b\u000b\u0019\t\tB\b\u0001\u0002\u0014\u00151\u0011\u0011\u0004\u0010\u0001\u00037)a!a\u000e\u001f\u0001\u0005ebABA?=\t\ty\b\u0003\u0006\u0002\u001a\u000e\u0012\t\u0011)A\u0005\u00037C!\"!($\u0005\u0003\u0005\u000b\u0011BAP\u0011)\t\tk\tB\u0001B\u0003%\u00111\u0015\u0005\u000b\u0003g\u001b#\u0011!Q\u0001\f\u0005U\u0006bBA\u0007G\u0011\u0005\u0011Q\u0018\u0005\b\u0003\u0017\u001cC\u0011IAg\u000f%\t\u0019OHA\u0001\u0012\u0003\t)OB\u0005\u0002~y\t\t\u0011#\u0001\u0002h\"9\u0011QB\u0016\u0005\u0002\u0005%\b\"CAvWE\u0005I\u0011AAw\r\u0019\u0011\u0019A\b\"\u0003\u0006!Q!1\u0006\u0018\u0003\u0016\u0004%\tA!\f\t\u0015\tmbF!E!\u0002\u0013\u0011y\u0003C\u0004\u0002\u000e9\"\tA!\u0010\t\u000f\t\rc\u0006\"\u0011\u0003F!I!q\u000b\u0018\u0002\u0002\u0013\u0005!\u0011\f\u0005\n\u0005;r\u0013\u0013!C\u0001\u0005?B\u0011Ba\u0019/\u0003\u0003%\tE!\u001a\t\u0013\tUd&!A\u0005\u0002\t]\u0004\"\u0003B@]\u0005\u0005I\u0011\u0001BA\u0011%\u0011iILA\u0001\n\u0003\u0012y\tC\u0005\u0003\u001e:\n\t\u0011\"\u0001\u0003 \"I!\u0011\u0016\u0018\u0002\u0002\u0013\u0005#1\u0016\u0005\n\u0005_s\u0013\u0011!C!\u0005cC\u0011Ba-/\u0003\u0003%\tE!.\b\u0013\tef$!A\t\u0002\tmf!\u0003B\u0002=\u0005\u0005\t\u0012\u0001B_\u0011\u001d\tiA\u0010C\u0001\u0005+D\u0011Ba6?\u0003\u0003%)E!7\t\u0013\tmg(!A\u0005\u0002\nu\u0007\"\u0003Bq}\u0005\u0005I\u0011\u0011Br\u0011%\u0011yOPA\u0001\n\u0013\u0011\tPA\u0010NkR\f'\r\\3DC\u000eDWMQ1dW\u0016$7i\u001c8ue\u0006\u001cGo\u0015;pe\u0016T!AR$\u0002\u000b\r\f7\r[3\u000b\u0005!K\u0015!B:u_J,'B\u0001&L\u0003!\u0001H.\u0019;g_Jl'B\u0001'N\u0003\u0011!\u0017-\u001c7\u000b\u00039\u000b1aY8n'\r\u0001\u0001K\u0016\t\u0003#Rk\u0011A\u0015\u0006\u0002'\u0006)1oY1mC&\u0011QK\u0015\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]\u0013W\"\u0001-\u000b\u0005eS\u0016A\u0001<3\u0015\tYF,A\u0003j]\u0012,\u0007P\u0003\u0002^=\u0006)1\u000f^1uK*\u0011q\fY\u0001\fa\u0006\u0014H/[2ja\u0006tGO\u0003\u0002b\u0017\u00061A.\u001a3hKJL!a\u0019-\u0003\u001b\r{g\u000e\u001e:bGR\u001cFo\u001c:f\u0003\u001diW\r\u001e:jGN\u001c\u0001\u0001\u0005\u0002hS6\t\u0001N\u0003\u0002e\u0017&\u0011!\u000e\u001b\u0002\b\u001b\u0016$(/[2t\u0003=\u0019wN\u001c;sC\u000e$8OU3bI\u0016\u0014\bCA7q\u001b\u0005q'BA8H\u0003)Ig\u000e^3sM\u0006\u001cWm]\u0005\u0003c:\u0014\u0001\u0004T3eO\u0016\u0014H)Y8D_:$(/Y2ugJ+\u0017\rZ3s\u0003M\u0019\u0018n\u001a8bY:+w\u000fT3eO\u0016\u0014\b*Z1e!\t!\u0018E\u0004\u0002v;9\u0019a/a\u0001\u000f\u0007]\f\tA\u0004\u0002y\u007f:\u0011\u0011P \b\u0003uvl\u0011a\u001f\u0006\u0003y\u0016\fa\u0001\u0010:p_Rt\u0014\"\u0001(\n\u00051k\u0015B\u0001&L\u0013\tA\u0015*\u0003\u0002G\u000f\u0006yR*\u001e;bE2,7)Y2iK\n\u000b7m[3e\u0007>tGO]1diN#xN]3\u0011\u0007\u0005%a$D\u0001F'\tq\u0002+\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003\u000f\u0011\u0011#\u0012<f]R\u001cV-];f]RL\u0017\r\\%e!\r\t\u0016QC\u0005\u0004\u0003/\u0011&\u0001\u0002'p]\u001e\u00141cU5h]\u0006dg*Z<MK\u0012<WM\u001d%fC\u0012\u0004\u0012\"UA\u000f\u0003C\ti#!\r\n\u0007\u0005}!KA\u0005Gk:\u001cG/[8oeA!\u00111EA\u0015\u001b\t\t)CC\u0002\u0002(\u0001\faa\u001c4gg\u0016$\u0018\u0002BA\u0016\u0003K\u0011aa\u00144gg\u0016$\bcAA\u0018A5\ta\u0004E\u0002R\u0003gI1!!\u000eS\u0005\u0011)f.\u001b;\u0003=M+(m]2sS\n,Gk\\\"p]R\u0014\u0018m\u0019;Ti\u0006$X-\u0012<f]R\u001c\b#B)\u0002<\u0005}\u0012bAA\u001f%\nIa)\u001e8di&|g\u000e\r\t\t\u0003\u0003\ny%a\u0015\u0002v5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\u0011\tI%a\u0013\u0002\rM$(/Z1n\u0015\t\ti%\u0001\u0003bW.\f\u0017\u0002BA)\u0003\u0007\u0012aaU8ve\u000e,\u0007CBA+\u0003?\n)G\u0004\u0003\u0002X\u0005mcb\u0001>\u0002Z%\t1+C\u0002\u0002^I\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002b\u0005\r$A\u0002,fGR|'OC\u0002\u0002^I\u0003B!a\u001a\u0002r5\u0011\u0011\u0011\u000e\u0006\u0005\u0003W\ni'\u0001\u0004fm\u0016tGo\u001d\u0006\u0004\u0003_:\u0015a\u00013b_&!\u00111OA5\u0005I\u0019uN\u001c;sC\u000e$8\u000b^1uK\u00163XM\u001c;\u0011\t\u0005]\u0014\u0011P\u0007\u0003\u0003\u0017JA!a\u001f\u0002L\t9aj\u001c;Vg\u0016$'aF\"bG\",W\u000b\u001d3bi\u0016\u001cVOY:de&\u0004H/[8o'\r\u0019\u0013\u0011\u0011\t\u0007\u0003\u0007\u000b\u0019*!\r\u000f\t\u0005\u0015\u0015q\u0012\b\u0005\u0003\u000f\u000bYID\u0002y\u0003\u0013K!!Y&\n\u0007\u00055\u0005-A\u0005sKN|WO]2fg&!\u0011QLAI\u0015\r\ti\tY\u0005\u0005\u0003+\u000b9JA\u0007SKN|WO]2f\u001f^tWM\u001d\u0006\u0005\u0003;\n\t*A\u0007d_:$(/Y2u'R|'/\u001a\t\u0004\u0003\u0013\u0001\u0011AH:vEN\u001c'/\u001b2f)>\u001cuN\u001c;sC\u000e$8\u000b^1uK\u00163XM\u001c;t!\r\tyCI\u0001\u0018[&t')Y2l_\u001a47\u000b\u001e:fC6\u0014Vm\u001d;beR\u0004B!!*\u000206\u0011\u0011q\u0015\u0006\u0005\u0003S\u000bY+\u0001\u0005ekJ\fG/[8o\u0015\r\tiKU\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BAY\u0003O\u0013aBR5oSR,G)\u001e:bi&|g.\u0001\u0007nCR,'/[1mSj,'\u000f\u0005\u0003\u00028\u0006eVBAA$\u0013\u0011\tY,a\u0012\u0003\u00195\u000bG/\u001a:jC2L'0\u001a:\u0015\u0011\u0005}\u0016QYAd\u0003\u0013$B!!1\u0002DB\u0019\u0011qF\u0012\t\u000f\u0005M\u0006\u0006q\u0001\u00026\"9\u0011\u0011\u0014\u0015A\u0002\u0005m\u0005bBAOQ\u0001\u0007\u0011q\u0014\u0005\n\u0003CC\u0003\u0013!a\u0001\u0003G\u000bq!Y2rk&\u0014X\r\u0006\u0002\u0002PR!\u0011\u0011[Al!\u0019\t\u0019)a5\u00022%!\u0011Q[AL\u0005!\u0011Vm]8ve\u000e,\u0007bBAmS\u0001\u000f\u00111\\\u0001\bG>tG/\u001a=u!\u0011\ti.a8\u000e\u0005\u0005E\u0015\u0002BAq\u0003#\u0013qBU3t_V\u00148-Z\"p]R,\u0007\u0010^\u0001\u0018\u0007\u0006\u001c\u0007.Z+qI\u0006$XmU;cg\u000e\u0014\u0018\u000e\u001d;j_:\u00042!a\f,'\tY\u0003\u000b\u0006\u0002\u0002f\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!a<+\t\u0005\r\u0016\u0011_\u0016\u0003\u0003g\u0004B!!>\u0002\u00006\u0011\u0011q\u001f\u0006\u0005\u0003s\fY0A\u0005v]\u000eDWmY6fI*\u0019\u0011Q *\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0002\u0005](!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\nY2i\u001c8ue\u0006\u001cGOU3bIRC'o\\;hQ:{GOR8v]\u0012\u001c\u0012B\fB\u0004\u0005\u001f\u0011yB!\n\u0011\t\t%!1\u0002\b\u0004#\u0006m\u0013\u0002\u0002B\u0007\u0003G\u0012\u0011\u0002\u00165s_^\f'\r\\3\u0011\t\tE!1D\u0007\u0003\u0005'QAA!\u0006\u0003\u0018\u000591m\u001c8ue>d'b\u0001B\r%\u0006!Q\u000f^5m\u0013\u0011\u0011iBa\u0005\u0003\u00199{7\u000b^1dWR\u0013\u0018mY3\u0011\u0007E\u0013\t#C\u0002\u0003$I\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0002V\t\u001d\u0012\u0002\u0002B\u0015\u0003G\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f!bY8oiJ\f7\r^%e+\t\u0011y\u0003\u0005\u0003\u00032\tUb\u0002BA\u0005\u0005gI1!!\u0018F\u0013\u0011\u00119D!\u000f\u0003\u0015\r{g\u000e\u001e:bGRLEMC\u0002\u0002^\u0015\u000b1bY8oiJ\f7\r^%eAQ!!q\bB!!\r\tyC\f\u0005\b\u0005W\t\u0004\u0019\u0001B\u0018\u0003)9W\r^'fgN\fw-\u001a\u000b\u0003\u0005\u000f\u0002BA!\u0013\u0003R9!!1\nB'!\tQ(+C\u0002\u0003PI\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002B*\u0005+\u0012aa\u0015;sS:<'b\u0001B(%\u0006!1m\u001c9z)\u0011\u0011yDa\u0017\t\u0013\t-2\u0007%AA\u0002\t=\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005CRCAa\f\u0002r\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"Aa\u001a\u0011\t\t%$1O\u0007\u0003\u0005WRAA!\u001c\u0003p\u0005!A.\u00198h\u0015\t\u0011\t(\u0001\u0003kCZ\f\u0017\u0002\u0002B*\u0005W\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"A!\u001f\u0011\u0007E\u0013Y(C\u0002\u0003~I\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa!\u0003\nB\u0019\u0011K!\"\n\u0007\t\u001d%KA\u0002B]fD\u0011Ba#8\u0003\u0003\u0005\rA!\u001f\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\t\n\u0005\u0004\u0003\u0014\ne%1Q\u0007\u0003\u0005+S1Aa&S\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00057\u0013)J\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002BQ\u0005O\u00032!\u0015BR\u0013\r\u0011)K\u0015\u0002\b\u0005>|G.Z1o\u0011%\u0011Y)OA\u0001\u0002\u0004\u0011\u0019)\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003\u0002B4\u0005[C\u0011Ba#;\u0003\u0003\u0005\rA!\u001f\u0002\u0011!\f7\u000f[\"pI\u0016$\"A!\u001f\u0002\r\u0015\fX/\u00197t)\u0011\u0011\tKa.\t\u0013\t-E(!AA\u0002\t\r\u0015aG\"p]R\u0014\u0018m\u0019;SK\u0006$G\u000b\u001b:pk\u001eDgj\u001c;G_VtG\rE\u0002\u00020y\u001aRA\u0010B`\u0005\u0017\u0004\u0002B!1\u0003H\n=\"qH\u0007\u0003\u0005\u0007T1A!2S\u0003\u001d\u0011XO\u001c;j[\u0016LAA!3\u0003D\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0011\t\t5'1[\u0007\u0003\u0005\u001fTAA!5\u0003p\u0005\u0011\u0011n\\\u0005\u0005\u0005S\u0011y\r\u0006\u0002\u0003<\u0006AAo\\*ue&tw\r\u0006\u0002\u0003h\u0005)\u0011\r\u001d9msR!!q\bBp\u0011\u001d\u0011Y#\u0011a\u0001\u0005_\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003f\n-\b#B)\u0003h\n=\u0012b\u0001Bu%\n1q\n\u001d;j_:D\u0011B!<C\u0003\u0003\u0005\rAa\u0010\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003tB!!\u0011\u000eB{\u0013\u0011\u00119Pa\u001b\u0003\r=\u0013'.Z2u\u0003M\u0019wN\u001c;sC\u000e$8\u000b^1uK\u000e\u000b7\r[3t+\t\u0011i\u0010\u0005\u0003\u0002\n\t}\u0018bAB\u0001\u000b\n\u00192i\u001c8ue\u0006\u001cGo\u0015;bi\u0016\u001c\u0015m\u00195fg\u0006!2m\u001c8ue\u0006\u001cGo\u0015;bi\u0016\u001c\u0015m\u00195fg\u0002\n\u0001#\u001a=fGV$\u0018n\u001c8D_:$X\r\u001f;\u0011\t\r%11B\u0007\u0003\u0003WKAa!\u0004\u0002,\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u000fY><w-\u001b8h\u0007>tG/\u001a=u!\u0011\u0019\u0019b!\u0007\u000e\u0005\rU!bAB\f\u0017\u00069An\\4hS:<\u0017\u0002BB\u000e\u0007+\u0011a\u0002T8hO&twmQ8oi\u0016DH\u000f\u0006\u0006\u0004 \r\u00152qEB\u0015\u0007W!b!a'\u0004\"\r\r\u0002bBB\u0003\u0011\u0001\u000f1q\u0001\u0005\b\u0007\u001fA\u00019AB\t\u0011\u0015!\u0007\u00021\u0001g\u0011\u0015Y\u0007\u00021\u0001m\u0011\u0015\u0011\b\u00021\u0001t\u0011\u001d\u0011I\u0010\u0003a\u0001\u0005{\fa\u0001\\8hO\u0016\u0014XCAB\u0019!\u0011\u0019\u0019ba\r\n\t\rU2Q\u0003\u0002\u0015\u0007>tG/\u001a=uk\u0006d\u0017N_3e\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u0005!\u0001/^:i)\u0011\t\td!\u0010\t\u000f\r}2\u00021\u0001\u0002T\u0005YQM^3oiN\u0014\u0015\r^2i\u0003Qawn\\6va\u0006\u001bG/\u001b<f\u0007>tGO]1diR11QIB,\u0007O\"Baa\u0012\u0004VA11\u0011BB%\u0007\u001bJAaa\u0013\u0002,\n1a)\u001e;ve\u0016\u0004R!\u0015Bt\u0007\u001f\u0002BA!\r\u0004R%!11\u000bB\u001d\u0005!\u0019uN\u001c;sC\u000e$\bbBB\b\u0019\u0001\u000f1\u0011\u0003\u0005\b\u00073b\u0001\u0019AB.\u0003\u001d\u0011X-\u00193feN\u0004bA!\u0013\u0004^\r\u0005\u0014\u0002BB0\u0005+\u00121aU3u!\u0011\u0011\tda\u0019\n\t\r\u0015$\u0011\b\u0002\u0006!\u0006\u0014H/\u001f\u0005\b\u0005Wa\u0001\u0019\u0001B\u0018\u0003Eawn\\6va\u000e{g\u000e\u001e:bGR\\U-\u001f\u000b\u0007\u0007[\u001a\u0019h!\u001e\u0015\t\r=4\u0011\u000f\t\u0007\u0007\u0013\u0019IE!:\t\u000f\r=Q\u0002q\u0001\u0004\u0012!91\u0011L\u0007A\u0002\rm\u0003bBB<\u001b\u0001\u00071\u0011P\u0001\u0004W\u0016L\b\u0003BB>\u0007\u000bk!a! \u000b\t\r}4\u0011Q\u0001\fiJ\fgn]1di&|gNC\u0002\u0004\u0004.\u000b!\u0001\u001c4\n\t\r\u001d5Q\u0010\u0002\n\u000f2|'-\u00197LKf\f!\u0006\\8pWV\u0004X*\u0019=j[VlG*\u001a3hKJ$\u0016.\\3BMR,'/\u00138uKJ\u0004(/\u001a;bi&|g\u000e\u0006\u0003\u0004\u000e\u000eeE\u0003BBH\u0007/\u0003ba!\u0003\u0004J\rE\u0005cA,\u0004\u0014&\u00191Q\u0013-\u0003#5\u000b\u00070[7v[2+GmZ3s)&lW\rC\u0004\u0004\u00109\u0001\u001da!\u0005\t\u000f\rme\u00021\u0001\u0004\u001e\u0006\u0019\u0011\u000eZ:\u0011\r\t%3Q\fB\u0018\u0003q\u0011X-\u00193UQJ|Wo\u001a5NCbLW.^7MK\u0012<WM\u001d+j[\u0016$baa$\u0004$\u000e5\u0006bBBS\u001f\u0001\u00071qU\u0001\b[&\u001c8/\u001b8h!\u0019\t)f!+\u00030%!11VA2\u0005\u0011a\u0015n\u001d;\t\u000f\r=v\u00021\u0001\u00042\u0006\u0019\u0011mY2\u0011\u000bE\u00139oa-\u0011\t\rU6q\u0019\b\u0005\u0007o\u001b\tM\u0004\u0003\u0004:\u000eufb\u0001=\u0004<&\u001911Q&\n\t\r}6\u0011Q\u0001\u0005I\u0006$\u0018-\u0003\u0003\u0004D\u000e\u0015\u0017\u0001\u0002+j[\u0016TAaa0\u0004\u0002&!1\u0011ZBf\u0005%!\u0016.\\3ti\u0006l\u0007O\u0003\u0003\u0004D\u000e\u0015\u0017a\u00049beRLG/[8o\u0007\u0006\u001c\u0007.\u001a3\u0015\t\rE71\u001d\u000b\u0005\u0007'\u001c\t\u000f\u0005\u0005\u0002V\rU7QTBm\u0013\u0011\u00199.a\u0019\u0003\r\u0015KG\u000f[3s!\u001d\t61\\Bp\u0007;K1a!8S\u0005\u0019!V\u000f\u001d7feA1!\u0011JB/\u0007gCqaa\u0004\u0011\u0001\b\u0019\t\u0002C\u0004\u0004\u001cB\u0001\ra!(\u00023I,\u0017\r\u001a+ie>,x\r[\"p]R\u0014\u0018m\u0019;t\u0007\u0006\u001c\u0007.\u001a\u000b\u0005\u0007S\u001c)\u0010\u0006\u0003\u0004l\u000eM\bCBB\u0005\u0007\u0013\u001ai\u000f\u0005\u0003\u0002\n\r=\u0018bABy\u000b\n\u00112i\u001c8ue\u0006\u001cGo\u0015;bi\u00164\u0016\r\\;f\u0011\u001d\u0019y!\u0005a\u0002\u0007#AqAa\u000b\u0012\u0001\u0004\u0011y#\u0001\nlKf\u001cF/\u0019;f)>\u0014Vm\u001d9p]N,GC\u0002Bs\u0007w$)\u0001C\u0004\u0004~J\u0001\raa@\u0002\u000bY\fG.^3\u0011\t\u0005%A\u0011A\u0005\u0004\t\u0007)%!F\"p]R\u0014\u0018m\u0019;LKf\u001cF/\u0019;f-\u0006dW/\u001a\u0005\b\u00073\u0012\u0002\u0019AB.\u0003]\u0019wN\u001c;sC\u000e$8\u000b^1uKR{'+Z:q_:\u001cX\r\u0006\u0004\u0005\f\u0011MAQ\u0003\u000b\u0005\t\u001b!\t\u0002\u0006\u0003\u0004H\u0011=\u0001bBB\b'\u0001\u000f1\u0011\u0003\u0005\b\u0007{\u001c\u0002\u0019ABw\u0011\u001d\u0019If\u0005a\u0001\u00077BqAa\u000b\u0014\u0001\u0004\u0011y#A\fsKN|GN^3ESZ,HnZ3oG\u0016dun\\6vaRAA1\u0004C\u0010\tG!)\u0003\u0006\u0003\u0004H\u0011u\u0001bBB\b)\u0001\u000f1\u0011\u0003\u0005\b\tC!\u0002\u0019ABw\u0003I\u0019wN\u001c;sC\u000e$8\u000b^1uKZ\u000bG.^3\t\u000f\t-B\u00031\u0001\u00030!9Aq\u0005\u000bA\u0002\rm\u0013A\u00034peB\u000b'\u000f^5fg\u0006!Bo\\\"p]R\u0014\u0018m\u0019;DC\u000eDWMV1mk\u0016,\"\u0001\"\f\u0011\u000fE#y\u0003b\r\u0004n&\u0019A\u0011\u0007*\u0003\u0013\u0019+hn\u0019;j_:\f\u0004#B)\u0003h\u0012U\u0002\u0003\u0002C\u001c\t\u0003rA\u0001\"\u000f\u0005>9\u0019a\u000fb\u000f\n\u0005=<\u0015b\u0001C ]\u0006AB*\u001a3hKJ$\u0015m\\\"p]R\u0014\u0018m\u0019;t%\u0016\fG-\u001a:\n\t\u0011\rCQ\t\u0002\u000e\u0007>tGO]1diN#\u0018\r^3\u000b\u0007\u0011}b.A\u000bu_\u000e{g\u000e\u001e:bGR\u001c\u0015m\u00195f-\u0006dW/\u001a\u0011\u0002\u001fQ|7*Z=DC\u000eDWMV1mk\u0016,\"\u0001\"\u0014\u0011\u000fE#y\u0003b\u0014\u0004\u0000B!Aq\u0007C)\u0013\u0011!\u0019\u0006\"\u0012\u0003\u0011-+\u0017p\u0015;bi\u0016\f\u0001\u0003^8LKf\u001c\u0015m\u00195f-\u0006dW/\u001a\u0011\u0002'I,\u0017\r\u001a+ie>,x\r[&fs\u000e\u000b7\r[3\u0015\t\u0011mC\u0011\r\u000b\u0005\t;\"y\u0006\u0005\u0004\u0004\n\r%3q \u0005\b\u0007\u001fI\u00029AB\t\u0011\u001d\u00199(\u0007a\u0001\u0007s\nAC\\8o\u000b6\u0004H/_%oi\u0016\u00148/Z2uS>tW\u0003\u0002C4\tg\"bA!)\u0005j\u0011}\u0004b\u0002C65\u0001\u0007AQN\u0001\u0004_:,\u0007C\u0002B%\u0007;\"y\u0007\u0005\u0003\u0005r\u0011MD\u0002\u0001\u0003\b\tkR\"\u0019\u0001C<\u0005\u0005!\u0016\u0003\u0002C=\u0005\u0007\u00032!\u0015C>\u0013\r!iH\u0015\u0002\b\u001d>$\b.\u001b8h\u0011\u001d!\tI\u0007a\u0001\t[\nQa\u001c;iKJ\fQ\"\u001e9eCR,wJ\u001a4tKR\u001cH\u0003BA\u0019\t\u000fCqaa\u0010\u001c\u0001\u0004!I\t\u0005\u0004\u0002V\u0011-\u0015QM\u0005\u0005\t\u001b\u000b\u0019GA\u0002TKF\f1\u0002Z3ck\u001e,e/\u001a8ugR!A1\u0013CL)\u0011\t\t\u0004\"&\t\u000f\r=A\u0004q\u0001\u0004\u0012!91q\b\u000fA\u0002\u0011%\u0005")
public class MutableCacheBackedContractStore
implements ContractStore {
    private final Metrics metrics;
    private final LedgerDaoContractsReader contractsReader;
    private final Function2<Offset, Object, BoxedUnit> signalNewLedgerHead;
    private final ContractStateCaches contractStateCaches;
    private final ExecutionContext executionContext;
    private final LoggingContext loggingContext;
    private final ContextualizedLogger logger;
    private final Function1<Option<LedgerDaoContractsReader.ContractState>, ContractStateValue> toContractCacheValue;
    private final Function1<LedgerDaoContractsReader.KeyState, ContractKeyStateValue> toKeyCacheValue;

    public ContractStateCaches contractStateCaches() {
        return this.contractStateCaches;
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    public void push(Vector<ContractStateEvent> eventsBatch) {
        this.debugEvents((Seq<ContractStateEvent>)eventsBatch, this.loggingContext);
        this.contractStateCaches().push(eventsBatch);
        this.updateOffsets((Seq<ContractStateEvent>)eventsBatch);
    }

    public Future<Option<Versioned<Value.ContractInstance>>> lookupActiveContract(Set<String> readers, Value.ContractId contractId, LoggingContext loggingContext) {
        return ((Future)this.contractStateCaches().contractState().get(contractId, loggingContext).map((Function1 & Serializable)result -> Future$.MODULE$.successful(result)).getOrElse((Function0 & Serializable)() -> this.readThroughContractsCache(contractId, loggingContext))).flatMap((Function1 & Serializable)value -> this.contractStateToResponse(readers, contractId, (ContractStateValue)value, loggingContext), this.executionContext);
    }

    public Future<Option<Value.ContractId>> lookupContractKey(Set<String> readers, GlobalKey key, LoggingContext loggingContext) {
        return ((Future)this.contractStateCaches().keyState().get(key, loggingContext).map((Function1 & Serializable)result -> Future$.MODULE$.successful(result)).getOrElse((Function0 & Serializable)() -> this.readThroughKeyCache(key, loggingContext))).map((Function1 & Serializable)x$1 -> this.keyStateToResponse((ContractKeyStateValue)x$1, readers), this.executionContext);
    }

    public Future<MaximumLedgerTime> lookupMaximumLedgerTimeAfterInterpretation(Set<Value.ContractId> ids, LoggingContext loggingContext) {
        return Future$.MODULE$.successful(this.partitionCached(ids, loggingContext)).flatMap((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            Right right = null;
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                Set archivedContracts = (Set)left.value();
                return Future$.MODULE$.successful((Object)new MaximumLedgerTime.Archived(archivedContracts));
            }
            if (either instanceof Right) {
                bl = true;
                right = (Right)either;
                Tuple2 tuple2 = (Tuple2)right.value();
                if (tuple2 != null) {
                    Set cached = (Set)tuple2._1();
                    Set toBeFetched = (Set)tuple2._2();
                    if (toBeFetched.isEmpty()) {
                        return Future$.MODULE$.successful((Object)MaximumLedgerTime$.MODULE$.from(cached.maxOption(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))));
                    }
                }
            }
            if (!bl) throw new MatchError((Object)either);
            Tuple2 tuple2 = (Tuple2)right.value();
            if (tuple2 == null) throw new MatchError((Object)either);
            Set cached = (Set)tuple2._1();
            Set toBeFetched = (Set)tuple2._2();
            return this.readThroughMaximumLedgerTime((List<Value.ContractId>)toBeFetched.toList(), (Option<Time.Timestamp>)cached.maxOption(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
        }, this.executionContext);
    }

    private Future<MaximumLedgerTime> readThroughMaximumLedgerTime(List<Value.ContractId> missing, Option<Time.Timestamp> acc) {
        Future future;
        List<Value.ContractId> list = missing;
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Value.ContractId contractId = (Value.ContractId)colon2.head();
            List restOfMissing = colon2.next$access$1();
            future = this.readThroughContractsCache(contractId, this.loggingContext).flatMap((Function1 & Serializable)x0$1 -> {
                Future<MaximumLedgerTime> future;
                ContractStateValue contractStateValue = x0$1;
                if (contractStateValue instanceof ContractStateValue.Active) {
                    ContractStateValue.Active active = (ContractStateValue.Active)contractStateValue;
                    Time.Timestamp timestamp = active.createLedgerEffectiveTime();
                    Some newMaximumLedgerTime = new Some(acc.toList().$colon$colon((Object)timestamp).max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
                    future = this.readThroughMaximumLedgerTime((List<Value.ContractId>)restOfMissing, (Option<Time.Timestamp>)newMaximumLedgerTime);
                } else if (contractStateValue instanceof ContractStateValue.Archived) {
                    future = Future$.MODULE$.successful((Object)new MaximumLedgerTime.Archived((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Value.ContractId[]{contractId}))));
                } else if (ContractStateValue$NotFound$.MODULE$.equals(contractStateValue)) {
                    future = this.readThroughMaximumLedgerTime((List<Value.ContractId>)restOfMissing, acc);
                } else {
                    throw new MatchError((Object)contractStateValue);
                }
                return future;
            }, this.executionContext);
        } else {
            future = Future$.MODULE$.successful((Object)MaximumLedgerTime$.MODULE$.from(acc));
        }
        return future;
    }

    private Either<Set<Value.ContractId>, Tuple2<Set<Time.Timestamp>, Set<Value.ContractId>>> partitionCached(Set<Value.ContractId> ids, LoggingContext loggingContext) {
        Vector cacheQueried = ((IterableOnceOps)ids.view().map((Function1 & Serializable)id -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(id), this.contractStateCaches().contractState().get((Value.ContractId)id, loggingContext)))).toVector();
        Either cached2 = (Either)cacheQueried.foldLeft((Object)scala.package$.MODULE$.Right().apply((Object)Predef$.MODULE$.Set().empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Either either = (Either)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (either instanceof Right) {
                    Some some;
                    ContractStateValue active;
                    Option option;
                    Right right = (Right)either;
                    Set timestamps = (Set)right.value();
                    if (tuple22 != null && (option = (Option)tuple22._2()) instanceof Some && (active = (ContractStateValue)(some = (Some)option).value()) instanceof ContractStateValue.Active) {
                        ContractStateValue.Active active2 = (ContractStateValue.Active)active;
                        return scala.package$.MODULE$.Right().apply((Object)timestamps.$plus((Object)active2.createLedgerEffectiveTime()));
                    }
                }
            }
            if (tuple2 != null) {
                Either either = (Either)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (either instanceof Right) {
                    Option option;
                    Right right = (Right)either;
                    Set timestamps = (Set)right.value();
                    if (tuple23 != null && None$.MODULE$.equals(option = (Option)tuple23._2())) {
                        return scala.package$.MODULE$.Right().apply((Object)timestamps);
                    }
                }
            }
            if (tuple2 != null) {
                Either acc = (Either)tuple2._1();
                Tuple2 tuple24 = (Tuple2)tuple2._2();
                if (tuple24 != null) {
                    Some some;
                    ContractStateValue contractStateValue;
                    boolean bl;
                    Value.ContractId cid = (Value.ContractId)tuple24._1();
                    Option option = (Option)tuple24._2();
                    if (option instanceof Some && (bl = (contractStateValue = (ContractStateValue)(some = (Some)option).value()) instanceof ContractStateValue.Archived ? true : ContractStateValue$NotFound$.MODULE$.equals(contractStateValue))) {
                        Set missingContracts = (Set)((SetOps)acc.left().getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())).$plus((Object)cid);
                        return scala.package$.MODULE$.Left().apply((Object)missingContracts);
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Either acc = (Either)tuple2._1();
            if (!(acc instanceof Left)) throw new MatchError((Object)tuple2);
            Left left = (Left)acc;
            return left;
        });
        return cached2.map((Function1 & Serializable)cached -> {
            Set missing = ((IterableOnceOps)cacheQueried.view().collect((PartialFunction)new Serializable(null){
                private static final long serialVersionUID = 0L;

                /*
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<Value.ContractId, Option<ContractStateValue>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 != null) {
                        Value.ContractId id = (Value.ContractId)A1._1();
                        Option option = (Option)A1._2();
                        if (None$.MODULE$.equals(option)) {
                            object = id;
                            return (B1)object;
                        }
                    }
                    object = function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(Tuple2<Value.ContractId, Option<ContractStateValue>> x1) {
                    Option option;
                    Tuple2<Value.ContractId, Option<ContractStateValue>> tuple2 = x1;
                    boolean bl = tuple2 != null && None$.MODULE$.equals(option = (Option)tuple2._2());
                    return bl;
                }
            })).toSet();
            return new Tuple2(cached, (Object)missing);
        });
    }

    private Future<ContractStateValue> readThroughContractsCache(Value.ContractId contractId, LoggingContext loggingContext) {
        Function1 & Serializable readThroughRequest = (Function1 & Serializable)validAt -> $this.contractsReader.lookupContractState(contractId, (Offset)validAt, loggingContext).map(this.toContractCacheValue(), $this.executionContext).transformWith((Function1 & Serializable)x0$1 -> {
            Future future;
            Success success;
            ContractStateValue contractStateValue;
            Try try_ = x0$1;
            if (try_ instanceof Success && ContractStateValue$NotFound$.MODULE$.equals(contractStateValue = (ContractStateValue)(success = (Success)try_).value())) {
                $this.metrics.daml().execution().cache().readThroughNotFound().inc();
                future = Future$.MODULE$.failed((Throwable)new ContractReadThroughNotFound(contractId));
            } else {
                future = Future$.MODULE$.fromTry(try_);
            }
            return future;
        }, $this.executionContext);
        return this.contractStateCaches().contractState().putAsync(contractId, (Function1<Offset, Future<ContractStateValue>>)readThroughRequest, loggingContext).transformWith((Function1 & Serializable)x0$2 -> {
            Failure failure;
            Try try_ = x0$2;
            Future future = try_ instanceof Failure && (failure = (Failure)try_).exception() instanceof ContractReadThroughNotFound ? Future$.MODULE$.successful((Object)ContractStateValue$NotFound$.MODULE$) : Future$.MODULE$.fromTry(try_);
            return future;
        }, this.executionContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<Value.ContractId> keyStateToResponse(ContractKeyStateValue value, Set<String> readers) {
        ContractKeyStateValue contractKeyStateValue = value;
        if (contractKeyStateValue instanceof ContractKeyStateValue.Assigned) {
            ContractKeyStateValue.Assigned assigned = (ContractKeyStateValue.Assigned)contractKeyStateValue;
            Value.ContractId contractId = assigned.contractId();
            Set<String> createWitnesses = assigned.createWitnesses();
            if (this.nonEmptyIntersection(readers, createWitnesses)) {
                return new Some((Object)contractId);
            }
        }
        boolean bl = contractKeyStateValue instanceof ContractKeyStateValue.Assigned ? true : ContractKeyStateValue$Unassigned$.MODULE$.equals(contractKeyStateValue);
        if (!bl) throw new MatchError((Object)contractKeyStateValue);
        return Option$.MODULE$.empty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Future<Option<Versioned<Value.ContractInstance>>> contractStateToResponse(Set<String> readers, Value.ContractId contractId, ContractStateValue value, LoggingContext loggingContext) {
        ContractStateValue.Archived archived;
        Set<String> stakeholders;
        ContractStateValue contractStateValue = value;
        if (contractStateValue instanceof ContractStateValue.Active) {
            ContractStateValue.Active active = (ContractStateValue.Active)contractStateValue;
            Versioned<Value.ContractInstance> contract = active.contract();
            Set<String> stakeholders2 = active.stakeholders();
            if (this.nonEmptyIntersection(stakeholders2, readers)) {
                return Future$.MODULE$.successful((Object)new Some(contract));
            }
        }
        if (contractStateValue instanceof ContractStateValue.Archived && this.nonEmptyIntersection(stakeholders = (archived = (ContractStateValue.Archived)contractStateValue).stakeholders(), readers)) {
            return Future$.MODULE$.successful((Object)Option$.MODULE$.empty());
        }
        this.logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(48).append("Checking divulgence for contractId=").append(contractId.coid()).append(" and readers=").append(readers).toString(), loggingContext);
        return this.resolveDivulgenceLookup(contractStateValue, contractId, readers, loggingContext);
    }

    private Future<Option<Versioned<Value.ContractInstance>>> resolveDivulgenceLookup(ContractStateValue contractStateValue, Value.ContractId contractId, Set<String> forParties, LoggingContext loggingContext) {
        Future<Option<Versioned<Value.ContractInstance>>> future;
        ContractStateValue contractStateValue2 = contractStateValue;
        if (contractStateValue2 instanceof ContractStateValue.Active) {
            ContractStateValue.Active active = (ContractStateValue.Active)contractStateValue2;
            Versioned<Value.ContractInstance> contract = active.contract();
            this.metrics.daml().execution().cache().resolveDivulgenceLookup().inc();
            future = this.contractsReader.lookupActiveContractWithCachedArgument(forParties, contractId, (Versioned<Value>)contract.map((Function1 & Serializable)x$2 -> x$2.arg()), loggingContext);
        } else {
            boolean bl = contractStateValue2 instanceof ContractStateValue.Archived ? true : ContractStateValue$NotFound$.MODULE$.equals(contractStateValue2);
            if (bl) {
                this.metrics.daml().execution().cache().resolveFullLookup().inc();
                future = this.contractsReader.lookupActiveContractAndLoadArgument(forParties, contractId, loggingContext);
            } else {
                throw new MatchError((Object)contractStateValue2);
            }
        }
        return future;
    }

    private Function1<Option<LedgerDaoContractsReader.ContractState>, ContractStateValue> toContractCacheValue() {
        return this.toContractCacheValue;
    }

    private Function1<LedgerDaoContractsReader.KeyState, ContractKeyStateValue> toKeyCacheValue() {
        return this.toKeyCacheValue;
    }

    private Future<ContractKeyStateValue> readThroughKeyCache(GlobalKey key, LoggingContext loggingContext) {
        Function1 & Serializable readThroughRequest = (Function1 & Serializable)validAt -> $this.contractsReader.lookupKeyState(key, (Offset)validAt, loggingContext).map(this.toKeyCacheValue(), $this.executionContext);
        return this.contractStateCaches().keyState().putAsync(key, (Function1<Offset, Future<ContractKeyStateValue>>)readThroughRequest, loggingContext);
    }

    private <T> boolean nonEmptyIntersection(Set<T> one, Set<T> other) {
        return one.intersect(other).nonEmpty();
    }

    private void updateOffsets(Seq<ContractStateEvent> eventsBatch) {
        eventsBatch.foreach((Function1 & Serializable)x0$1 -> {
            MutableCacheBackedContractStore.$anonfun$updateOffsets$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void debugEvents(Seq<ContractStateEvent> eventsBatch, LoggingContext loggingContext) {
        eventsBatch.foreach((Function1 & Serializable)x0$1 -> {
            MutableCacheBackedContractStore.$anonfun$debugEvents$1(this, loggingContext, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$updateOffsets$1(MutableCacheBackedContractStore $this, ContractStateEvent x0$1) {
        ContractStateEvent contractStateEvent = x0$1;
        if (contractStateEvent instanceof ContractStateEvent.LedgerEndMarker) {
            ContractStateEvent.LedgerEndMarker ledgerEndMarker = (ContractStateEvent.LedgerEndMarker)contractStateEvent;
            Offset eventOffset = ledgerEndMarker.eventOffset();
            long eventSequentialId = ledgerEndMarker.eventSequentialId();
            $this.metrics.daml().execution().cache().indexSequentialId().updateValue((Object)BoxesRunTime.boxToLong((long)eventSequentialId));
            BoxedUnit boxedUnit = (BoxedUnit)$this.signalNewLedgerHead.apply((Object)eventOffset, (Object)BoxesRunTime.boxToLong((long)eventSequentialId));
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$debugEvents$1(MutableCacheBackedContractStore $this, LoggingContext loggingContext$6, ContractStateEvent x0$1) {
        ContractStateEvent contractStateEvent = x0$1;
        if (contractStateEvent instanceof ContractStateEvent.Created) {
            ContractStateEvent.Created created = (ContractStateEvent.Created)contractStateEvent;
            Value.ContractId contractId = created.contractId();
            Option<GlobalKey> globalKey = created.globalKey();
            Offset eventOffset = created.eventOffset();
            long eventSequentialId = created.eventSequentialId();
            $this.logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(82).append("State events update: Created(contractId=").append(contractId.coid()).append(", globalKey=").append(globalKey).append(", offset=").append(eventOffset).append(", eventSequentialId=").append(eventSequentialId).append(")").toString(), loggingContext$6);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (contractStateEvent instanceof ContractStateEvent.Archived) {
            ContractStateEvent.Archived archived = (ContractStateEvent.Archived)contractStateEvent;
            Value.ContractId contractId = archived.contractId();
            Option<GlobalKey> globalKey = archived.globalKey();
            Offset eventOffset = archived.eventOffset();
            long eventSequentialId = archived.eventSequentialId();
            $this.logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(83).append("State events update: Archived(contractId=").append(contractId.coid()).append(", globalKey=").append(globalKey).append(", offset=").append(eventOffset).append(", eventSequentialId=").append(eventSequentialId).append(")").toString(), loggingContext$6);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (contractStateEvent instanceof ContractStateEvent.LedgerEndMarker) {
            ContractStateEvent.LedgerEndMarker ledgerEndMarker = (ContractStateEvent.LedgerEndMarker)contractStateEvent;
            Offset eventOffset = ledgerEndMarker.eventOffset();
            long eventSequentialId = ledgerEndMarker.eventSequentialId();
            $this.logger().debug().apply((Function0 & Serializable)() -> new StringBuilder(24).append("Ledger end reached: ").append(eventOffset).append(" -> ").append(eventSequentialId).toString(), loggingContext$6);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)contractStateEvent);
        }
    }

    public MutableCacheBackedContractStore(Metrics metrics, LedgerDaoContractsReader contractsReader, Function2<Offset, Object, BoxedUnit> signalNewLedgerHead, ContractStateCaches contractStateCaches, ExecutionContext executionContext, LoggingContext loggingContext) {
        this.metrics = metrics;
        this.contractsReader = contractsReader;
        this.signalNewLedgerHead = signalNewLedgerHead;
        this.contractStateCaches = contractStateCaches;
        this.executionContext = executionContext;
        this.loggingContext = loggingContext;
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.toContractCacheValue = (Function1 & Serializable)x0$1 -> {
            LedgerDaoContractsReader.ContractState contractState;
            void var1_12;
            boolean bl = false;
            Some some = null;
            Option option = x0$1;
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                LedgerDaoContractsReader.ContractState contractState2 = (LedgerDaoContractsReader.ContractState)some.value();
                if (contractState2 instanceof LedgerDaoContractsReader.ActiveContract) {
                    LedgerDaoContractsReader.ActiveContract activeContract = (LedgerDaoContractsReader.ActiveContract)contractState2;
                    Versioned<Value.ContractInstance> contract = activeContract.contract();
                    Set<String> stakeholders = activeContract.stakeholders();
                    Time.Timestamp ledgerEffectiveTime = activeContract.ledgerEffectiveTime();
                    ContractStateValue.Active active = new ContractStateValue.Active(contract, stakeholders, ledgerEffectiveTime);
                    return var1_12;
                }
            }
            if (bl && (contractState = (LedgerDaoContractsReader.ContractState)some.value()) instanceof LedgerDaoContractsReader.ArchivedContract) {
                LedgerDaoContractsReader.ArchivedContract archivedContract = (LedgerDaoContractsReader.ArchivedContract)contractState;
                Set<String> stakeholders = archivedContract.stakeholders();
                ContractStateValue.Archived archived = new ContractStateValue.Archived(stakeholders);
                return var1_12;
            }
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            ContractStateValue$NotFound$ contractStateValue$NotFound$ = ContractStateValue$NotFound$.MODULE$;
            return var1_12;
        };
        this.toKeyCacheValue = (Function1 & Serializable)x0$2 -> {
            ContractKeyStateValue contractKeyStateValue;
            LedgerDaoContractsReader.KeyState keyState = x0$2;
            if (keyState instanceof LedgerDaoContractsReader.KeyAssigned) {
                LedgerDaoContractsReader.KeyAssigned keyAssigned = (LedgerDaoContractsReader.KeyAssigned)keyState;
                Value.ContractId contractId = keyAssigned.contractId();
                Set<String> stakeholders = keyAssigned.stakeholders();
                contractKeyStateValue = new ContractKeyStateValue.Assigned(contractId, stakeholders);
            } else if (LedgerDaoContractsReader$KeyUnassigned$.MODULE$.equals(keyState)) {
                contractKeyStateValue = ContractKeyStateValue$Unassigned$.MODULE$;
            } else {
                throw new MatchError((Object)keyState);
            }
            return contractKeyStateValue;
        };
    }

    public static final class CacheUpdateSubscription
    extends AbstractResourceOwner<ResourceContext, BoxedUnit> {
        private final MutableCacheBackedContractStore contractStore;
        private final Function0<Source<Vector<ContractStateEvent>, NotUsed>> subscribeToContractStateEvents;
        private final FiniteDuration minBackoffStreamRestart;
        private final Materializer materializer;

        public Resource<ResourceContext, BoxedUnit> acquire(ResourceContext context) {
            return package$.MODULE$.Resource().apply(Future$.MODULE$.apply((Function0 & Serializable)() -> (Tuple2)((Source)RestartSource$.MODULE$.withBackoff(RestartSettings$.MODULE$.apply($this.minBackoffStreamRestart, new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds(), 0.2), (Function0 & Serializable)() -> (Source)$this.subscribeToContractStateEvents.apply()).map((Function1 & Serializable)eventsBatch -> {
                this.contractStore.push((Vector<ContractStateEvent>)eventsBatch);
                return BoxedUnit.UNIT;
            })).viaMat(KillSwitches$.MODULE$.single(), Keep$.MODULE$.right()).toMat((Graph)Sink$.MODULE$.ignore(), Keep$.MODULE$.both()).run($this.materializer), context.executionContext()), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                UniqueKillSwitch contractStateUpdateKillSwitch = (UniqueKillSwitch)tuple2._1();
                Future contractStateUpdateDone = (Future)tuple2._2();
                contractStateUpdateKillSwitch.shutdown();
                Future future = contractStateUpdateDone.map((Function1 & Serializable)x$3 -> {
                    CacheUpdateSubscription.$anonfun$acquire$5(x$3);
                    return BoxedUnit.UNIT;
                }, context.executionContext());
                return future;
            }, (Object)context).map((Function1 & Serializable)x$4 -> {
                CacheUpdateSubscription.$anonfun$acquire$6(x$4);
                return BoxedUnit.UNIT;
            }, (Object)context);
        }

        public static final /* synthetic */ void $anonfun$acquire$5(Done x$3) {
        }

        public static final /* synthetic */ void $anonfun$acquire$6(Tuple2 x$4) {
        }

        public CacheUpdateSubscription(MutableCacheBackedContractStore contractStore, Function0<Source<Vector<ContractStateEvent>, NotUsed>> subscribeToContractStateEvents, FiniteDuration minBackoffStreamRestart, Materializer materializer) {
            this.contractStore = contractStore;
            this.subscribeToContractStateEvents = subscribeToContractStateEvents;
            this.minBackoffStreamRestart = minBackoffStreamRestart;
            this.materializer = materializer;
            super((HasExecutionContext)ResourceContext.Context$u0020has$u0020ExecutionContext$.MODULE$);
        }
    }

    public static final class ContractReadThroughNotFound
    extends Throwable
    implements NoStackTrace,
    Product {
        private final Value.ContractId contractId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public /* synthetic */ Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public Throwable fillInStackTrace() {
            return NoStackTrace.fillInStackTrace$((NoStackTrace)this);
        }

        public Value.ContractId contractId() {
            return this.contractId;
        }

        @Override
        public String getMessage() {
            return new StringBuilder(95).append("Contract not found for contract id ").append(this.contractId().coid()).append(". Hint: this could be due racing with a concurrent archival.").toString();
        }

        public ContractReadThroughNotFound copy(Value.ContractId contractId) {
            return new ContractReadThroughNotFound(contractId);
        }

        public Value.ContractId copy$default$1() {
            return this.contractId();
        }

        public String productPrefix() {
            return "ContractReadThroughNotFound";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.contractId();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ContractReadThroughNotFound;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "contractId";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ContractReadThroughNotFound)) return false;
            boolean bl = true;
            if (!bl) return false;
            ContractReadThroughNotFound contractReadThroughNotFound = (ContractReadThroughNotFound)x$1;
            Value.ContractId contractId = this.contractId();
            Value.ContractId contractId2 = contractReadThroughNotFound.contractId();
            if (contractId != null) {
                if (!contractId.equals(contractId2)) return false;
                return true;
            }
            if (contractId2 == null) return true;
            return false;
        }

        public ContractReadThroughNotFound(Value.ContractId contractId) {
            this.contractId = contractId;
            NoStackTrace.$init$((NoStackTrace)this);
            Product.$init$((Product)this);
        }
    }
}

