/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.dao;

import com.daml.error.ContextualizedErrorLogger;
import com.daml.error.definitions.IndexErrors;
import io.grpc.StatusRuntimeException;
import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLTransientException;
import org.h2.jdbc.JdbcSQLIntegrityConstraintViolationException;
import org.postgresql.util.PSQLException;
import scala.Function1;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class DatabaseSelfServiceError$ {
    public static final DatabaseSelfServiceError$ MODULE$ = new DatabaseSelfServiceError$();

    public Throwable apply(Throwable exception, ContextualizedErrorLogger contextualizedErrorLogger) {
        Throwable throwable;
        block6: {
            SQLException sQLException;
            Throwable throwable2;
            while (true) {
                BatchUpdateException batchUpdateException;
                if ((throwable2 = exception) instanceof JdbcSQLIntegrityConstraintViolationException) {
                    JdbcSQLIntegrityConstraintViolationException jdbcSQLIntegrityConstraintViolationException = (JdbcSQLIntegrityConstraintViolationException)throwable2;
                    throwable = this.retryable((SQLException)jdbcSQLIntegrityConstraintViolationException, contextualizedErrorLogger);
                    break block6;
                }
                if (throwable2 instanceof SQLRecoverableException) {
                    SQLRecoverableException sQLRecoverableException = (SQLRecoverableException)throwable2;
                    throwable = this.retryable(sQLRecoverableException, contextualizedErrorLogger);
                    break block6;
                }
                if (throwable2 instanceof SQLTransientException) {
                    SQLTransientException sQLTransientException = (SQLTransientException)throwable2;
                    throwable = this.retryable(sQLTransientException, contextualizedErrorLogger);
                    break block6;
                }
                if (throwable2 instanceof SQLNonTransientException) {
                    SQLNonTransientException sQLNonTransientException = (SQLNonTransientException)throwable2;
                    throwable = this.nonRetryable(sQLNonTransientException, contextualizedErrorLogger);
                    break block6;
                }
                if (throwable2 instanceof PSQLException) {
                    PSQLException pSQLException = (PSQLException)throwable2;
                    throwable = this.isRetryablePsqlException(pSQLException) ? this.retryable((SQLException)pSQLException, contextualizedErrorLogger) : this.nonRetryable((SQLException)pSQLException, contextualizedErrorLogger);
                    break block6;
                }
                if (!(throwable2 instanceof BatchUpdateException) || (batchUpdateException = (BatchUpdateException)throwable2).getCause() == null) break;
                exception = batchUpdateException.getCause();
            }
            throwable = throwable2 instanceof SQLException ? (this.isRetryableOracleException(sQLException = (SQLException)throwable2) ? this.retryable(sQLException, contextualizedErrorLogger) : this.nonRetryable(sQLException, contextualizedErrorLogger)) : throwable2;
        }
        return throwable;
    }

    private StatusRuntimeException retryable(SQLException ex, ContextualizedErrorLogger contextualizedErrorLogger) {
        return new IndexErrors.DatabaseErrors$.SqlTransientError$.Reject((Throwable)ex, contextualizedErrorLogger).asGrpcError();
    }

    private StatusRuntimeException nonRetryable(SQLException ex, ContextualizedErrorLogger contextualizedErrorLogger) {
        return new IndexErrors.DatabaseErrors$.SqlNonTransientError$.Reject((Throwable)ex, contextualizedErrorLogger).asGrpcError();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isRetryablePsqlException(PSQLException exception) {
        String string = exception.getSQLState();
        if (string.startsWith("08")) {
            return true;
        }
        if ("40001".equals(string)) {
            return true;
        }
        if ("25006".equals(string)) {
            return true;
        }
        if (!string.startsWith("57P")) return false;
        String string2 = string;
        String string3 = "57014";
        if (string2 == null) {
            if (string3 == null) return false;
        } else if (string2.equals(string3)) return false;
        String string4 = string;
        String string5 = "57P04";
        if (string4 == null) {
            if (string5 == null) return false;
            return true;
        } else if (string4.equals(string5)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isRetryableOracleException(SQLException ex) {
        int n = ex.getErrorCode();
        switch (n) {
            case 1: {
                return false;
            }
            case 54: {
                return true;
            }
            case 604: {
                if (!this.oracleMessageRetryable(ex)) break;
                return true;
            }
            case 4021: {
                return true;
            }
            case 8176: {
                return true;
            }
            case 8177: {
                return true;
            }
            case 1088: 
            case 1089: 
            case 1090: 
            case 1092: {
                return true;
            }
            case 17002: {
                return true;
            }
            case 17410: {
                return true;
            }
        }
        String string = ex.getMessage();
        String string2 = "Connection is closed";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    private boolean oracleMessageRetryable(SQLException ex) {
        String consistentReadFailure = "ORA-08176";
        String cantSerializeAccess = "ORA-08177";
        String message = ex.getMessage();
        return ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{consistentReadFailure, cantSerializeAccess}))).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)message.contains(x$1)));
    }

    private DatabaseSelfServiceError$() {
    }
}

