/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.store.dao;

import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.MetricRegistry;
import com.daml.ledger.resources.ResourceContext;
import com.daml.ledger.resources.ResourceOwner$;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.metrics.MetricName;
import com.daml.metrics.MetricName$;
import com.daml.metrics.Metrics;
import com.daml.platform.configuration.ServerRole;
import com.daml.platform.store.dao.DataSourceConnectionProvider$;
import com.daml.platform.store.dao.DbDispatcher;
import com.daml.platform.store.dao.DbDispatcherImpl;
import com.daml.platform.store.dao.HikariDataSourceOwner$;
import com.daml.platform.store.dao.JdbcConnectionProvider;
import com.daml.resources.AbstractResourceOwner;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.sql.DataSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.ScalaRunTime$;

public final class DbDispatcher$ {
    public static final DbDispatcher$ MODULE$ = new DbDispatcher$();
    private static final ContextualizedLogger logger = ContextualizedLogger$.MODULE$.get(MODULE$.getClass());

    private ContextualizedLogger logger() {
        return logger;
    }

    public AbstractResourceOwner<ResourceContext, DbDispatcher> owner(DataSource dataSource, ServerRole serverRole, int connectionPoolSize, FiniteDuration connectionTimeout, Metrics metrics, LoggingContext loggingContext) {
        AbstractResourceOwner<ResourceContext, DataSource> abstractResourceOwner = HikariDataSourceOwner$.MODULE$.apply(dataSource, serverRole, connectionPoolSize, connectionPoolSize, connectionTimeout, (Option<MetricRegistry>)new Some((Object)metrics.registry()), HikariDataSourceOwner$.MODULE$.apply$default$7());
        return abstractResourceOwner.flatMap((Function1 & Serializable)hikariDataSource -> {
            AbstractResourceOwner abstractResourceOwner = DataSourceConnectionProvider$.MODULE$.owner((DataSource)hikariDataSource).map((Function1 & Serializable)connectionProvider -> {
                Vector threadPoolName = MetricName$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MetricName$.MODULE$.metricNameToString(metrics.daml().index().db().threadpool().connection()), serverRole.threadPoolSuffix()}));
                return new Tuple2(connectionProvider, (Object)new MetricName(threadPoolName));
            });
            return abstractResourceOwner.flatMap((Function1 & Serializable)x$2 -> {
                Tuple2 tuple2 = x$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                JdbcConnectionProvider connectionProvider = (JdbcConnectionProvider)tuple2._1();
                Vector threadPoolName = ((MetricName)tuple2._2()).com$daml$metrics$MetricName$$segments();
                AbstractResourceOwner abstractResourceOwner = ResourceOwner$.MODULE$.forExecutorService((Function0 & Serializable)() -> new InstrumentedExecutorService(Executors.newFixedThreadPool(connectionPoolSize, new ThreadFactoryBuilder().setNameFormat(new StringBuilder(3).append(new MetricName(threadPoolName)).append("-%d").toString()).setUncaughtExceptionHandler((x$1, e) -> MODULE$.logger().error().apply((Function0 & Serializable)() -> "Uncaught exception in the SQL executor.", e, loggingContext)).build()), metrics.registry(), MetricName$.MODULE$.metricNameToString(threadPoolName))).map((Function1 & Serializable)executor -> new DbDispatcherImpl(connectionProvider, (Executor)executor, metrics.daml().index().db().waitAll(), metrics.daml().index().db().execAll(), loggingContext));
                return abstractResourceOwner;
            });
        });
    }

    private DbDispatcher$() {
    }
}

