/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.usermanagement;

import com.daml.api.util.TimeProvider;
import com.daml.ledger.api.domain;
import com.daml.ledger.participant.state.index.v2.UserManagementStore;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.metrics.DatabaseMetrics;
import com.daml.metrics.Metrics;
import com.daml.platform.store.DbSupport;
import com.daml.platform.store.backend.UserManagementStorageBackend;
import com.daml.platform.store.dao.DbDispatcher;
import com.daml.platform.usermanagement.PersistentUserManagementStore$;
import java.io.Serializable;
import java.sql.Connection;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\rmx!B\u00193\u0011\u0003Yd!B\u001f3\u0011\u0003q\u0004\"B#\u0002\t\u00031e\u0001B$\u0002\u0005\"C\u0001bW\u0002\u0003\u0016\u0004%\t\u0001\u0018\u0005\tS\u000e\u0011\t\u0012)A\u0005;\")Qi\u0001C\u0001U\"9anAA\u0001\n\u0003y\u0007bB9\u0004#\u0003%\tA\u001d\u0005\b{\u000e\t\t\u0011\"\u0011\u007f\u0011%\tyaAA\u0001\n\u0003\t\t\u0002C\u0005\u0002\u001a\r\t\t\u0011\"\u0001\u0002\u001c!I\u0011qE\u0002\u0002\u0002\u0013\u0005\u0013\u0011\u0006\u0005\n\u0003o\u0019\u0011\u0011!C\u0001\u0003sA\u0011\"a\u0011\u0004\u0003\u0003%\t%!\u0012\t\u0013\u0005%3!!A\u0005B\u0005-\u0003\"CA'\u0007\u0005\u0005I\u0011IA(\u000f%\t\u0019&AA\u0001\u0012\u0003\t)F\u0002\u0005H\u0003\u0005\u0005\t\u0012AA,\u0011\u0019)%\u0003\"\u0001\u0002p!I\u0011\u0011\u000f\n\u0002\u0002\u0013\u0015\u00131\u000f\u0005\n\u0003k\u0012\u0012\u0011!CA\u0003oB\u0011\"a\u001f\u0013\u0003\u0003%\t)! \t\u0013\u0005%%#!A\u0005\n\u0005-\u0005bBAJ\u0003\u0011\u0005\u0011Q\u0013\u0004\u0006{I\u0002!1\u0003\u0005\u000b\u0003/L\"\u0011!Q\u0001\n\u0005e\u0007BCAt3\t\u0005\t\u0015!\u0003\u0002j\"Q\u0011Q_\r\u0003\u0002\u0003\u0006I!a>\t\u0015\tE\u0011D!A!\u0002\u0013\t\u0019\u0002\u0003\u0004F3\u0011\u0005!Q\u0003\u0005\n\u0005CI\"\u0019!C\u0005\u0005GA\u0001Ba\f\u001aA\u0003%!Q\u0005\u0005\n\u0005cI\"\u0019!C\u0005\u0005gA\u0001B!\u0016\u001aA\u0003%!Q\u0007\u0005\n\u0005/J\"\u0019!C\u0005\u00053B\u0001B!\u0019\u001aA\u0003%!1\f\u0005\b\u0005GJB\u0011\tB3\u0011\u001d\u0011\t,\u0007C!\u0005gCqA!=\u001a\t\u0003\u0012\u0019\u0010C\u0004\u0003|f!\tE!@\t\u000f\r-\u0011\u0004\"\u0011\u0004\u000e!91qC\r\u0005B\re\u0001bBB\u00193\u0011%11\u0007\u0005\b\u0007\u0007KB\u0011BBC\u0011\u001d\u0019i+\u0007C\u0005\u0007_Cqaa3\u001a\t\u0013\u0019i\rC\u0004\u0004bf!Iaa9\t\u000f\rE\u0018\u0004\"\u0003\u0004t\u0006i\u0002+\u001a:tSN$XM\u001c;Vg\u0016\u0014X*\u00198bO\u0016lWM\u001c;Ti>\u0014XM\u0003\u00024i\u0005qQo]3s[\u0006t\u0017mZ3nK:$(BA\u001b7\u0003!\u0001H.\u0019;g_Jl'BA\u001c9\u0003\u0011!\u0017-\u001c7\u000b\u0003e\n1aY8n\u0007\u0001\u0001\"\u0001P\u0001\u000e\u0003I\u0012Q\u0004U3sg&\u001cH/\u001a8u+N,'/T1oC\u001e,W.\u001a8u'R|'/Z\n\u0003\u0003}\u0002\"\u0001Q\"\u000e\u0003\u0005S\u0011AQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\t\u0006\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001<\u0005\u0005\"vn\\'b]f,6/\u001a:SS\u001eDGo\u001d*v]RLW.Z#yG\u0016\u0004H/[8o'\u0011\u0019\u0011*\u0016-\u0011\u0005)\u0013fBA&Q\u001d\tau*D\u0001N\u0015\tq%(\u0001\u0004=e>|GOP\u0005\u0002\u0005&\u0011\u0011+Q\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019FK\u0001\tSk:$\u0018.\\3Fq\u000e,\u0007\u000f^5p]*\u0011\u0011+\u0011\t\u0003\u0001ZK!aV!\u0003\u000fA\u0013x\u000eZ;diB\u0011!*W\u0005\u00035R\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fa!^:fe&#W#A/\u0011\u0005y3gBA0e\u001b\u0005\u0001'BA1c\u0003\u0011!\u0017\r^1\u000b\u0005\r4\u0014A\u00017g\u0013\t)\u0007-A\u0002SK\u001aL!a\u001a5\u0003\rU\u001bXM]%e\u0015\t)\u0007-A\u0004vg\u0016\u0014\u0018\n\u001a\u0011\u0015\u0005-l\u0007C\u00017\u0004\u001b\u0005\t\u0001\"B.\u0007\u0001\u0004i\u0016\u0001B2paf$\"a\u001b9\t\u000fm;\u0001\u0013!a\u0001;\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#A:+\u0005u#8&A;\u0011\u0005Y\\X\"A<\u000b\u0005aL\u0018!C;oG\",7m[3e\u0015\tQ\u0018)\u0001\u0006b]:|G/\u0019;j_:L!\u0001`<\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002\u007fB!\u0011\u0011AA\u0006\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011\u0001\u00027b]\u001eT!!!\u0003\u0002\t)\fg/Y\u0005\u0005\u0003\u001b\t\u0019A\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003'\u00012\u0001QA\u000b\u0013\r\t9\"\u0011\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003;\t\u0019\u0003E\u0002A\u0003?I1!!\tB\u0005\r\te.\u001f\u0005\n\u0003KY\u0011\u0011!a\u0001\u0003'\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\u0016!\u0019\ti#a\r\u0002\u001e5\u0011\u0011q\u0006\u0006\u0004\u0003c\t\u0015AC2pY2,7\r^5p]&!\u0011QGA\u0018\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005m\u0012\u0011\t\t\u0004\u0001\u0006u\u0012bAA \u0003\n9!i\\8mK\u0006t\u0007\"CA\u0013\u001b\u0005\u0005\t\u0019AA\u000f\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\u0007}\f9\u0005C\u0005\u0002&9\t\t\u00111\u0001\u0002\u0014\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\u0014\u00051Q-];bYN$B!a\u000f\u0002R!I\u0011Q\u0005\t\u0002\u0002\u0003\u0007\u0011QD\u0001\")>|W*\u00198z+N,'OU5hQR\u001c(+\u001e8uS6,W\t_2faRLwN\u001c\t\u0003YJ\u0019RAEA-\u0003K\u0002b!a\u0017\u0002bu[WBAA/\u0015\r\ty&Q\u0001\beVtG/[7f\u0013\u0011\t\u0019'!\u0018\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0005\u0003\u0002h\u00055TBAA5\u0015\u0011\tY'a\u0002\u0002\u0005%|\u0017b\u0001.\u0002jQ\u0011\u0011QK\u0001\ti>\u001cFO]5oOR\tq0A\u0003baBd\u0017\u0010F\u0002l\u0003sBQaW\u000bA\u0002u\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0000\u0005\u0015\u0005\u0003\u0002!\u0002\u0002vK1!a!B\u0005\u0019y\u0005\u000f^5p]\"A\u0011q\u0011\f\u0002\u0002\u0003\u00071.A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!$\u0011\t\u0005\u0005\u0011qR\u0005\u0005\u0003#\u000b\u0019A\u0001\u0004PE*,7\r^\u0001\u0007G\u0006\u001c\u0007.\u001a3\u0015\u001d\u0005]\u0015Q[As\u0003g\u00149Aa\u0003\u0003\u0010Q1\u0011\u0011TA[\u0003\u000b\u0004B!a'\u000226\u0011\u0011Q\u0014\u0006\u0005\u0003?\u000b\t+\u0001\u0002we)!\u00111UAS\u0003\u0015Ig\u000eZ3y\u0015\u0011\t9+!+\u0002\u000bM$\u0018\r^3\u000b\t\u0005-\u0016QV\u0001\fa\u0006\u0014H/[2ja\u0006tGOC\u0002\u00020Z\na\u0001\\3eO\u0016\u0014\u0018\u0002BAZ\u0003;\u00131#V:fe6\u000bg.Y4f[\u0016tGo\u0015;pe\u0016Dq!a.\u0019\u0001\b\tI,\u0001\tfq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yiB!\u00111XAa\u001b\t\tiLC\u0002\u0002@\u0006\u000b!bY8oGV\u0014(/\u001a8u\u0013\u0011\t\u0019-!0\u0003!\u0015CXmY;uS>t7i\u001c8uKb$\bbBAd1\u0001\u000f\u0011\u0011Z\u0001\u000fY><w-\u001b8h\u0007>tG/\u001a=u!\u0011\tY-!5\u000e\u0005\u00055'bAAhm\u00059An\\4hS:<\u0017\u0002BAj\u0003\u001b\u0014a\u0002T8hO&twmQ8oi\u0016DH\u000fC\u0004\u0002Xb\u0001\r!!7\u0002\u0013\u0011\u00147+\u001e9q_J$\b\u0003BAn\u0003Cl!!!8\u000b\u0007\u0005}G'A\u0003ti>\u0014X-\u0003\u0003\u0002d\u0006u'!\u0003#c'V\u0004\bo\u001c:u\u0011\u001d\t9\u000f\u0007a\u0001\u0003S\fq!\\3ue&\u001c7\u000f\u0005\u0003\u0002l\u0006=XBAAw\u0015\r\t9ON\u0005\u0005\u0003c\fiOA\u0004NKR\u0014\u0018nY:\t\u000f\u0005U\b\u00041\u0001\u0002x\u0006aA/[7f!J|g/\u001b3feB!\u0011\u0011 B\u0002\u001b\t\tYP\u0003\u0003\u0002~\u0006}\u0018\u0001B;uS2T1A!\u00017\u0003\r\t\u0007/[\u0005\u0005\u0005\u000b\tYP\u0001\u0007US6,\u0007K]8wS\u0012,'\u000fC\u0004\u0003\na\u0001\r!a\u0005\u0002=\r\f7\r[3FqBL'/_!gi\u0016\u0014xK]5uK&s7+Z2p]\u0012\u001c\bb\u0002B\u00071\u0001\u0007\u00111C\u0001\r[\u0006D8)Y2iKNK'0\u001a\u0005\b\u0005#A\u0002\u0019AA\n\u0003Ai\u0017\r\u001f*jO\"$8\u000fU3s+N,'o\u0005\u0003\u001a\u007f\u0005eEC\u0003B\f\u00053\u0011YB!\b\u0003 A\u0011A(\u0007\u0005\b\u0003/t\u0002\u0019AAm\u0011\u001d\t9O\ba\u0001\u0003SDq!!>\u001f\u0001\u0004\t9\u0010C\u0004\u0003\u0012y\u0001\r!a\u0005\u0002\u000f\t\f7m[3oIV\u0011!Q\u0005\t\u0005\u0005O\u0011Y#\u0004\u0002\u0003*)!!\u0011EAo\u0013\u0011\u0011iC!\u000b\u00039U\u001bXM]'b]\u0006<W-\\3oiN#xN]1hK\n\u000b7m[3oI\u0006A!-Y2lK:$\u0007%\u0001\u0007eE\u0012K7\u000f]1uG\",'/\u0006\u0002\u00036I1!q\u0007B\u001e\u0005\u000f2aA!\u000f\u0001\u0001\tU\"\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004\u0003\u0002B\u001f\u0005\u0007j!Aa\u0010\u000b\t\t\u0005\u0013Q\\\u0001\u0004I\u0006|\u0017\u0002\u0002B#\u0005\u007f\u0011A\u0002\u00122ESN\u0004\u0018\r^2iKJ\u0004BA!\u0013\u0003R5\u0011!1\n\u0006\u0005\u0005\u001b\u0012y%\u0001\u0004iK\u0006dG\u000f\u001b\u0006\u0005\u0005\u0003\ti+\u0003\u0003\u0003T\t-#!\u0004*fa>\u0014Ho\u001d%fC2$\b.A\u0007eE\u0012K7\u000f]1uG\",'\u000fI\u0001\u0007Y><w-\u001a:\u0016\u0005\tm\u0003\u0003BAf\u0005;JAAa\u0018\u0002N\n!2i\u001c8uKb$X/\u00197ju\u0016$Gj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0006hKR,6/\u001a:J]\u001a|G\u0003\u0002B4\u0005C#BA!\u001b\u0003 B1\u00111\u0018B6\u0005_JAA!\u001c\u0002>\n1a)\u001e;ve\u0016\u0004bA!\u001d\u0003\u0014\nee\u0002\u0002B:\u0005\u001fsAA!\u001e\u0003\u000e:!!q\u000fBF\u001d\u0011\u0011IH!#\u000f\t\tm$q\u0011\b\u0005\u0005{\u0012)I\u0004\u0003\u0003\u0000\t\reb\u0001'\u0003\u0002&\t\u0011(\u0003\u00028q%\u0019\u0011q\u0016\u001c\n\t\u0005-\u0016QV\u0005\u0005\u0003O\u000bI+\u0003\u0003\u0002$\u0006\u0015\u0016\u0002BAP\u0003CKAA!%\u0002\u001e\u0006\u0019Rk]3s\u001b\u0006t\u0017mZ3nK:$8\u000b^8sK&!!Q\u0013BL\u0005\u0019\u0011Vm];mi*!!\u0011SAO!\u0011\u0011\tHa'\n\t\tu%q\u0013\u0002\t+N,'/\u00138g_\"9\u0011qY\u0013A\u0004\u0005%\u0007b\u0002BRK\u0001\u0007!QU\u0001\u0003S\u0012\u00042Aa*g\u001d\r\u0011I\u000b\u001a\b\u0005\u0005W\u0013yK\u0004\u0003\u0003~\t5\u0016BA27\u0013\t\t'-\u0001\u0006de\u0016\fG/Z+tKJ$bA!.\u0003D\n]G\u0003\u0002B\\\u0005\u0003\u0004b!a/\u0003l\te\u0006C\u0002B9\u0005'\u0013Y\fE\u0002A\u0005{K1Aa0B\u0005\u0011)f.\u001b;\t\u000f\u0005\u001dg\u0005q\u0001\u0002J\"9!Q\u0019\u0014A\u0002\t\u001d\u0017\u0001B;tKJ\u0004BA!3\u0003R:!!1\u001aBg\u001b\t\u0011y%\u0003\u0003\u0003P\n=\u0013A\u00023p[\u0006Lg.\u0003\u0003\u0003T\nU'\u0001B+tKJTAAa4\u0003P!9!\u0011\u001c\u0014A\u0002\tm\u0017A\u0002:jO\"$8\u000f\u0005\u0004\u0003^\n\u0015(1\u001e\b\u0005\u0005?\u0014\t\u000f\u0005\u0002M\u0003&\u0019!1]!\u0002\rA\u0013X\rZ3g\u0013\u0011\u00119O!;\u0003\u0007M+GOC\u0002\u0003d\u0006\u0003BA!3\u0003n&!!q\u001eBk\u0005%)6/\u001a:SS\u001eDG/\u0001\u0006eK2,G/Z+tKJ$BA!>\u0003zR!!q\u0017B|\u0011\u001d\t9m\na\u0002\u0003\u0013DqAa)(\u0001\u0004\u0011)+A\u0006he\u0006tGOU5hQR\u001cHC\u0002B\u0000\u0007\u000f\u0019I\u0001\u0006\u0003\u0004\u0002\r\u0015\u0001CBA^\u0005W\u001a\u0019\u0001\u0005\u0004\u0003r\tM%1\u001c\u0005\b\u0003\u000fD\u00039AAe\u0011\u001d\u0011\u0019\u000b\u000ba\u0001\u0005KCqA!7)\u0001\u0004\u0011Y.\u0001\u0007sKZ|7.\u001a*jO\"$8\u000f\u0006\u0004\u0004\u0010\rM1Q\u0003\u000b\u0005\u0007\u0003\u0019\t\u0002C\u0004\u0002H&\u0002\u001d!!3\t\u000f\t\r\u0016\u00061\u0001\u0003&\"9!\u0011\\\u0015A\u0002\tm\u0017!\u00037jgR,6/\u001a:t)\u0019\u0019Yb!\u000b\u0004.Q!1QDB\u0014!\u0019\tYLa\u001b\u0004 A1!\u0011\u000fBJ\u0007C\u0001BA!\u001d\u0004$%!1Q\u0005BL\u0005%)6/\u001a:t!\u0006<W\rC\u0004\u0002H*\u0002\u001d!!3\t\u000f\r-\"\u00061\u0001\u0002\u0000\u0005AaM]8n\u000bb\u001cG\u000eC\u0004\u00040)\u0002\r!a\u0005\u0002\u00155\f\u0007PU3tk2$8/A\u0007j]R\u0013\u0018M\\:bGRLwN\\\u000b\u0005\u0007k\u0019\u0019\u0005\u0006\u0003\u00048\r\u001dD\u0003BB\u001d\u0007#\"Baa\u000f\u0004PA1\u00111\u0018B6\u0007{\u0001bA!\u001d\u0003\u0014\u000e}\u0002\u0003BB!\u0007\u0007b\u0001\u0001B\u0004\u0004F-\u0012\raa\u0012\u0003\u0003Q\u000bBa!\u0013\u0002\u001eA\u0019\u0001ia\u0013\n\u0007\r5\u0013IA\u0004O_RD\u0017N\\4\t\u000f\u0005\u001d7\u0006q\u0001\u0002J\"911K\u0016A\u0002\rU\u0013!\u0002;ik:\\\u0007c\u0002!\u0004X\rm3QH\u0005\u0004\u00073\n%!\u0003$v]\u000e$\u0018n\u001c82!\u0011\u0019ifa\u0019\u000e\u0005\r}#\u0002BB1\u0003\u000f\t1a]9m\u0013\u0011\u0019)ga\u0018\u0003\u0015\r{gN\\3di&|g\u000eC\u0004\u0004j-\u0002\raa\u001b\u0002\u0011\u0011\u0014W*\u001a;sS\u000e\u0004r\u0001QB,\u0007[\u001aiH\u0004\u0003\u0004p\r]d\u0002BB9\u0007kr1aa\u001d\u001c\u001b\u0005I\u0012bA\u001c\u0002p&!1\u0011PB>\u00039)8/\u001a:NC:\fw-Z7f]RT1aNAx!\u0011\tYoa \n\t\r\u0005\u0015Q\u001e\u0002\u0010\t\u0006$\u0018MY1tK6+GO]5dg\u0006Aq/\u001b;i+N,'/\u0006\u0003\u0004\b\u000eEE\u0003BBE\u0007W#Baa#\u0004\u0018R!1QRBJ!\u0019\u0011\tHa%\u0004\u0010B!1\u0011IBI\t\u001d\u0019)\u0005\fb\u0001\u0007\u000fBqa!&-\u0001\b\u0019Y&\u0001\u0006d_:tWm\u0019;j_:Dqa!'-\u0001\u0004\u0019Y*A\u0001g!\u001d\u00015qKBO\u0007\u001f\u0003Baa(\u0004&:!!qEBQ\u0013\u0011\u0019\u0019K!\u000b\u00029U\u001bXM]'b]\u0006<W-\\3oiN#xN]1hK\n\u000b7m[3oI&!1qUBU\u0005\u0019!%-V:fe*!11\u0015B\u0015\u0011\u0019\u0011\u0019\u000b\fa\u0001;\u0006Yq/\u001b;i_V$Xk]3s+\u0011\u0019\tla/\u0015\t\rM6\u0011\u001a\u000b\u0005\u0007k\u001by\f\u0006\u0003\u00048\u000eu\u0006C\u0002B9\u0005'\u001bI\f\u0005\u0003\u0004B\rmFaBB#[\t\u00071q\t\u0005\b\u0007+k\u00039AB.\u0011!\u0019\t-\fCA\u0002\r\r\u0017!\u0001;\u0011\u000b\u0001\u001b)m!/\n\u0007\r\u001d\u0017I\u0001\u0005=Eft\u0017-\\3?\u0011\u0019\u0011\u0019+\fa\u0001;\u0006QA/\u00199Tk\u000e\u001cWm]:\u0016\t\r=7q\u001b\u000b\u0005\u0007#\u001ci\u000e\u0006\u0003\u0004T\u000ee\u0007C\u0002B9\u0005'\u001b)\u000e\u0005\u0003\u0004B\r]GaBB#]\t\u00071q\t\u0005\b\u00077t\u0003\u0019ABj\u0003\u0005\u0011\bbBBM]\u0001\u00071q\u001c\t\b\u0001\u000e]3Q\u001bB^\u0003A\u0011\u0018n\u001a5ug\u0012Kw-Z:u)\u0016DH\u000f\u0006\u0003\u0004f\u000e%\b\u0003\u0002Bo\u0007OLA!!\u0004\u0003j\"9!\u0011\\\u0018A\u0002\r-\b#\u0002&\u0004n\n-\u0018bABx)\nA\u0011\n^3sC\ndW-A\tfa>\u001c\u0007.T5de>\u001cXmY8oIN$\"a!>\u0011\u0007\u0001\u001b90C\u0002\u0004z\u0006\u0013A\u0001T8oO\u0002")
public class PersistentUserManagementStore
implements UserManagementStore {
    private final Metrics metrics;
    private final TimeProvider timeProvider;
    private final int maxRightsPerUser;
    private final UserManagementStorageBackend backend;
    private final DbDispatcher dbDispatcher;
    private final ContextualizedLogger logger;

    public static UserManagementStore cached(DbSupport dbSupport, Metrics metrics, TimeProvider timeProvider, int cacheExpiryAfterWriteInSeconds, int maxCacheSize, int maxRightsPerUser, ExecutionContext executionContext, LoggingContext loggingContext) {
        return PersistentUserManagementStore$.MODULE$.cached(dbSupport, metrics, timeProvider, cacheExpiryAfterWriteInSeconds, maxCacheSize, maxRightsPerUser, executionContext, loggingContext);
    }

    public final Future<Either<UserManagementStore.Error, domain.User>> getUser(String id, LoggingContext loggingContext) {
        return UserManagementStore.getUser$((UserManagementStore)this, (String)id, (LoggingContext)loggingContext);
    }

    public final Future<Either<UserManagementStore.Error, Set<domain.UserRight>>> listUserRights(String id, LoggingContext loggingContext) {
        return UserManagementStore.listUserRights$((UserManagementStore)this, (String)id, (LoggingContext)loggingContext);
    }

    private UserManagementStorageBackend backend() {
        return this.backend;
    }

    private DbDispatcher dbDispatcher() {
        return this.dbDispatcher;
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    public Future<Either<UserManagementStore.Error, UserManagementStore.UserInfo>> getUserInfo(String id, LoggingContext loggingContext) {
        return this.inTransaction((Function1<Metrics.daml$.userManagement$, DatabaseMetrics>)(Function1 & Serializable)x$1 -> x$1.getUserInfo(), (Function1 & Serializable)connection -> this.withUser(id, (Function1 & Serializable)dbUser -> {
            Set<UserManagementStorageBackend.DbUserRight> rights = this.backend().getUserRights(dbUser.internalId(), (Connection)connection);
            return new UserManagementStore.UserInfo(dbUser.domainUser(), (Set)rights.map((Function1 & Serializable)x$2 -> x$2.domainRight()));
        }, (Connection)connection), loggingContext);
    }

    public Future<Either<UserManagementStore.Error, BoxedUnit>> createUser(domain.User user, Set<domain.UserRight> rights, LoggingContext loggingContext) {
        Function1 & Serializable intersect = (Function1 & Serializable)x$4 -> {
            PersistentUserManagementStore.$anonfun$createUser$5(this, user, rights, loggingContext, x$4);
            return BoxedUnit.UNIT;
        };
        return this.inTransaction((Function1<Metrics.daml$.userManagement$, DatabaseMetrics>)(Function1 & Serializable)x$3 -> x$3.createUser(), (Function1 & Serializable)connection -> this.withoutUser(user.id(), (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            long now = this.epochMicroseconds();
            int internalId = this.backend().createUser(user, now, (Connection)connection);
            rights.foreach((Function1 & Serializable)right -> {
                PersistentUserManagementStore.$anonfun$createUser$4(this, internalId, now, connection, right);
                return BoxedUnit.UNIT;
            });
            if (this.backend().countUserRights(internalId, (Connection)connection) > $this.maxRightsPerUser) {
                throw new TooManyUserRightsRuntimeException(user.id());
            }
        }, (Connection)connection), loggingContext).map((Function1 & Serializable)r -> this.tapSuccess((Function1)intersect, (Either)r), (ExecutionContext)ExecutionContext.parasitic$.MODULE$);
    }

    public Future<Either<UserManagementStore.Error, BoxedUnit>> deleteUser(String id, LoggingContext loggingContext) {
        Function1 & Serializable intersect = (Function1 & Serializable)x$6 -> {
            PersistentUserManagementStore.$anonfun$deleteUser$3(this, id, loggingContext, x$6);
            return BoxedUnit.UNIT;
        };
        return this.inTransaction((Function1<Metrics.daml$.userManagement$, DatabaseMetrics>)(Function1 & Serializable)x$5 -> x$5.deleteUser(), (Function1 & Serializable)connection -> !this.backend().deleteUser(id, (Connection)connection) ? package$.MODULE$.Left().apply((Object)new UserManagementStore.UserNotFound(id)) : package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT), loggingContext).map((Function1 & Serializable)r -> this.tapSuccess((Function1)intersect, (Either)r), (ExecutionContext)ExecutionContext.parasitic$.MODULE$);
    }

    public Future<Either<UserManagementStore.Error, Set<domain.UserRight>>> grantRights(String id, Set<domain.UserRight> rights, LoggingContext loggingContext) {
        Function1 & Serializable intersect = (Function1 & Serializable)grantedRights -> {
            PersistentUserManagementStore.$anonfun$grantRights$5(this, id, loggingContext, grantedRights);
            return BoxedUnit.UNIT;
        };
        return this.inTransaction((Function1<Metrics.daml$.userManagement$, DatabaseMetrics>)(Function1 & Serializable)x$7 -> x$7.grantRights(), (Function1 & Serializable)connection -> this.withUser(id, (Function1 & Serializable)user -> {
            long now = this.epochMicroseconds();
            Set addedRights = (Set)rights.filter((Function1 & Serializable)right -> BoxesRunTime.boxToBoolean((boolean)PersistentUserManagementStore.$anonfun$grantRights$4(this, user, connection, now, right)));
            if (this.backend().countUserRights(user.internalId(), (Connection)connection) > $this.maxRightsPerUser) {
                throw new TooManyUserRightsRuntimeException(user.domainUser().id());
            }
            return addedRights;
        }, (Connection)connection), loggingContext).map((Function1 & Serializable)r -> this.tapSuccess((Function1)intersect, (Either)r), (ExecutionContext)ExecutionContext.parasitic$.MODULE$);
    }

    public Future<Either<UserManagementStore.Error, Set<domain.UserRight>>> revokeRights(String id, Set<domain.UserRight> rights, LoggingContext loggingContext) {
        Function1 & Serializable intersect = (Function1 & Serializable)revokedRights -> {
            PersistentUserManagementStore.$anonfun$revokeRights$5(this, id, loggingContext, revokedRights);
            return BoxedUnit.UNIT;
        };
        return this.inTransaction((Function1<Metrics.daml$.userManagement$, DatabaseMetrics>)(Function1 & Serializable)x$8 -> x$8.revokeRights(), (Function1 & Serializable)connection -> this.withUser(id, (Function1 & Serializable)user -> {
            Set revokedRights = (Set)rights.filter((Function1 & Serializable)right -> BoxesRunTime.boxToBoolean((boolean)PersistentUserManagementStore.$anonfun$revokeRights$4(this, user, connection, right)));
            return revokedRights;
        }, (Connection)connection), loggingContext).map((Function1 & Serializable)r -> this.tapSuccess((Function1)intersect, (Either)r), (ExecutionContext)ExecutionContext.parasitic$.MODULE$);
    }

    public Future<Either<UserManagementStore.Error, UserManagementStore.UsersPage>> listUsers(Option<String> fromExcl, int maxResults, LoggingContext loggingContext) {
        return this.inTransaction((Function1<Metrics.daml$.userManagement$, DatabaseMetrics>)(Function1 & Serializable)x$9 -> x$9.listUsers(), (Function1 & Serializable)connection -> {
            Vector<domain.User> vector;
            Option option = fromExcl;
            if (None$.MODULE$.equals(option)) {
                vector = this.backend().getUsersOrderedById((Option<String>)None$.MODULE$, maxResults, (Connection)connection);
            } else if (option instanceof Some) {
                Some some = (Some)option;
                String fromExcl = (String)some.value();
                vector = this.backend().getUsersOrderedById((Option<String>)new Some((Object)fromExcl), maxResults, (Connection)connection);
            } else {
                throw new MatchError((Object)option);
            }
            Vector<domain.User> users = vector;
            return package$.MODULE$.Right().apply((Object)new UserManagementStore.UsersPage(users));
        }, loggingContext);
    }

    private <T> Future<Either<UserManagementStore.Error, T>> inTransaction(Function1<Metrics.daml$.userManagement$, DatabaseMetrics> dbMetric, Function1<Connection, Either<UserManagementStore.Error, T>> thunk, LoggingContext loggingContext) {
        return this.dbDispatcher().executeSql((DatabaseMetrics)dbMetric.apply((Object)this.metrics.daml().userManagement()), thunk, loggingContext).recover((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof TooManyUserRightsRuntimeException) {
                    TooManyUserRightsRuntimeException tooManyUserRightsRuntimeException = (TooManyUserRightsRuntimeException)A1;
                    String userId = tooManyUserRightsRuntimeException.userId();
                    object = package$.MODULE$.Left().apply((Object)new UserManagementStore.TooManyUserRights(userId));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof TooManyUserRightsRuntimeException;
                return bl;
            }
        }, (ExecutionContext)ExecutionContext.parasitic$.MODULE$);
    }

    private <T> Either<UserManagementStore.Error, T> withUser(String id, Function1<UserManagementStorageBackend.DbUser, T> f, Connection connection) {
        Left left;
        Option<UserManagementStorageBackend.DbUser> option = this.backend().getUser(id, connection);
        if (option instanceof Some) {
            Some some = (Some)option;
            UserManagementStorageBackend.DbUser user = (UserManagementStorageBackend.DbUser)some.value();
            left = package$.MODULE$.Right().apply(f.apply((Object)user));
        } else if (None$.MODULE$.equals(option)) {
            left = package$.MODULE$.Left().apply((Object)new UserManagementStore.UserNotFound(id));
        } else {
            throw new MatchError(option);
        }
        return left;
    }

    private <T> Either<UserManagementStore.Error, T> withoutUser(String id, Function0<T> t, Connection connection) {
        Right right;
        Option<UserManagementStorageBackend.DbUser> option = this.backend().getUser(id, connection);
        if (option instanceof Some) {
            Some some = (Some)option;
            UserManagementStorageBackend.DbUser user = (UserManagementStorageBackend.DbUser)some.value();
            right = package$.MODULE$.Left().apply((Object)new UserManagementStore.UserExists(user.domainUser().id()));
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Right().apply(t.apply());
        } else {
            throw new MatchError(option);
        }
        return right;
    }

    private <T> Either<UserManagementStore.Error, T> tapSuccess(Function1<T, BoxedUnit> f, Either<UserManagementStore.Error, T> r) {
        r.foreach(f);
        return r;
    }

    private String rightsDigestText(Iterable<domain.UserRight> rights) {
        String closingBracket = rights.size() > 5 ? ", ..." : "";
        return ((IterableOnceOps)rights.take(5)).mkString("", ", ", closingBracket);
    }

    private long epochMicroseconds() {
        Instant now = this.timeProvider.getCurrentTime();
        return now.getEpochSecond() * 1000L * 1000L + (long)(now.getNano() / 1000);
    }

    public static final /* synthetic */ void $anonfun$createUser$4(PersistentUserManagementStore $this, int internalId$1, long now$1, Connection connection$2, domain.UserRight right) {
        $this.backend().addUserRight(internalId$1, right, now$1, connection$2);
    }

    public static final /* synthetic */ void $anonfun$createUser$5(PersistentUserManagementStore $this, domain.User user$1, Set rights$1, LoggingContext loggingContext$1, BoxedUnit x$4) {
        $this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(33).append("Created new user: ").append(user$1).append(" with ").append(rights$1.size()).append(" rights: ").append($this.rightsDigestText((Iterable<domain.UserRight>)rights$1)).toString(), loggingContext$1);
    }

    public static final /* synthetic */ void $anonfun$deleteUser$3(PersistentUserManagementStore $this, String id$2, LoggingContext loggingContext$2, BoxedUnit x$6) {
        $this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(22).append("Deleted user with id: ").append(id$2).toString(), loggingContext$2);
    }

    public static final /* synthetic */ boolean $anonfun$grantRights$4(PersistentUserManagementStore $this, UserManagementStorageBackend.DbUser user$2, Connection connection$3, long now$2, domain.UserRight right) {
        boolean bl;
        if (!$this.backend().userRightExists(user$2.internalId(), right, connection$3)) {
            $this.backend().addUserRight(user$2.internalId(), right, now$2, connection$3);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$grantRights$5(PersistentUserManagementStore $this, String id$3, LoggingContext loggingContext$3, Set grantedRights) {
        $this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(31).append("Granted ").append(grantedRights.size()).append(" user rights to user ").append(id$3).append(": ").append($this.rightsDigestText((Iterable<domain.UserRight>)grantedRights)).toString(), loggingContext$3);
    }

    public static final /* synthetic */ boolean $anonfun$revokeRights$4(PersistentUserManagementStore $this, UserManagementStorageBackend.DbUser user$3, Connection connection$4, domain.UserRight right) {
        return $this.backend().deleteUserRight(user$3.internalId(), right, connection$4);
    }

    public static final /* synthetic */ void $anonfun$revokeRights$5(PersistentUserManagementStore $this, String id$4, LoggingContext loggingContext$4, Set revokedRights) {
        $this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(33).append("Revoked ").append(revokedRights.size()).append(" user rights from user ").append(id$4).append(": ").append($this.rightsDigestText((Iterable<domain.UserRight>)revokedRights)).toString(), loggingContext$4);
    }

    public PersistentUserManagementStore(DbSupport dbSupport, Metrics metrics, TimeProvider timeProvider, int maxRightsPerUser) {
        this.metrics = metrics;
        this.timeProvider = timeProvider;
        this.maxRightsPerUser = maxRightsPerUser;
        UserManagementStore.$init$((UserManagementStore)this);
        this.backend = dbSupport.storageBackendFactory().createUserManagementStorageBackend();
        this.dbDispatcher = dbSupport.dbDispatcher();
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
    }

    public static final class TooManyUserRightsRuntimeException
    extends RuntimeException
    implements Product {
        private final String userId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String userId() {
            return this.userId;
        }

        public TooManyUserRightsRuntimeException copy(String userId) {
            return new TooManyUserRightsRuntimeException(userId);
        }

        public String copy$default$1() {
            return this.userId();
        }

        public String productPrefix() {
            return "TooManyUserRightsRuntimeException";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.userId();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TooManyUserRightsRuntimeException;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "userId";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof TooManyUserRightsRuntimeException)) return false;
            boolean bl = true;
            if (!bl) return false;
            TooManyUserRightsRuntimeException tooManyUserRightsRuntimeException = (TooManyUserRightsRuntimeException)x$1;
            String string = this.userId();
            String string2 = tooManyUserRightsRuntimeException.userId();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public TooManyUserRightsRuntimeException(String userId) {
            this.userId = userId;
            Product.$init$((Product)this);
        }
    }
}

