/*
 * Decompiled with CFR 0.152.
 */
package com.daml.platform.localstore;

import com.daml.ledger.api.domain;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.platform.localstore.InMemoryPartyRecordStore$;
import com.daml.platform.localstore.api.PartyRecord;
import com.daml.platform.localstore.api.PartyRecordStore;
import com.daml.platform.localstore.api.PartyRecordUpdate;
import com.daml.platform.localstore.utils.LocalAnnotationsUtils$;
import com.daml.platform.server.api.validation.ResourceAnnotationValidation$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\r%t!B\u001c9\u0011\u0003\te!B\"9\u0011\u0003!\u0005\"B&\u0002\t\u0003ae\u0001B'\u0002\u0001:C\u0001BX\u0002\u0003\u0016\u0004%\ta\u0018\u0005\tY\u000e\u0011\t\u0012)A\u0005A\"AQn\u0001BK\u0002\u0013\u0005a\u000e\u0003\u0005s\u0007\tE\t\u0015!\u0003p\u0011!\u00198A!f\u0001\n\u0003!\b\"CA\u0001\u0007\tE\t\u0015!\u0003v\u0011)\t\u0019a\u0001BK\u0002\u0013\u0005\u0011Q\u0001\u0005\u000b\u0003[\u0019!\u0011#Q\u0001\n\u0005\u001d\u0001BB&\u0004\t\u0003\ty\u0003C\u0005\u0002>\r\t\t\u0011\"\u0001\u0002@!I\u0011\u0011J\u0002\u0012\u0002\u0013\u0005\u00111\n\u0005\n\u0003C\u001a\u0011\u0013!C\u0001\u0003GB\u0011\"a\u001a\u0004#\u0003%\t!!\u001b\t\u0013\u000554!%A\u0005\u0002\u0005=\u0004\"CA:\u0007\u0005\u0005I\u0011IA;\u0011%\t)iAA\u0001\n\u0003\t9\tC\u0005\u0002\u0010\u000e\t\t\u0011\"\u0001\u0002\u0012\"I\u0011QT\u0002\u0002\u0002\u0013\u0005\u0013q\u0014\u0005\n\u0003[\u001b\u0011\u0011!C\u0001\u0003_C\u0011\"!/\u0004\u0003\u0003%\t%a/\t\u0013\u0005}6!!A\u0005B\u0005\u0005\u0007\"CAb\u0007\u0005\u0005I\u0011IAc\u0011%\t9mAA\u0001\n\u0003\nImB\u0005\u0002N\u0006\t\t\u0011#\u0001\u0002P\u001aAQ*AA\u0001\u0012\u0003\t\t\u000e\u0003\u0004L9\u0011\u0005\u0011\u0011\u001e\u0005\n\u0003\u0007d\u0012\u0011!C#\u0003\u000bD\u0011\"a;\u001d\u0003\u0003%\t)!<\t\u0013\u0005]H$!A\u0005\u0002\u0006e\b\"\u0003B\u00069\u0005\u0005I\u0011\u0002B\u0007\u0011\u001d\u0011)\"\u0001C\u0001\u0005/1Qa\u0011\u001d\u0001\u0005OA!Ba\f$\u0005\u0003\u0005\u000b\u0011\u0002B\u0019\u0011\u0019Y5\u0005\"\u0001\u0003>!I!1I\u0012C\u0002\u0013-!Q\t\u0005\t\u0005\u000f\u001a\u0003\u0015!\u0003\u00032!I!\u0011J\u0012C\u0002\u0013%!1\n\u0005\t\u00053\u001a\u0003\u0015!\u0003\u0003N!I!1L\u0012C\u0002\u0013%!Q\f\u0005\t\u0005_\u001a\u0003\u0015!\u0003\u0003`!9!\u0011O\u0012\u0005B\tM\u0004b\u0002BYG\u0011\u0005#1\u0017\u0005\b\u0005\u0003\u001cC\u0011\tBb\u0011\u001d\u00119n\tC\u0005\u00053DqAa9$\t\u0013\u0011)\u000fC\u0004\u0003j\u000e\"IAa;\t\u000f\r-1\u0005\"\u0003\u0004\u000e!91qD\u0012\u0005\n\r\u0005\u0002bBB!G\u0011%11\t\u0005\b\u0007\u0017\u001aC\u0011IB'\u0011\u001d\u0019Ye\tC!\u0007C\n\u0001$\u00138NK6|'/\u001f)beRL(+Z2pe\u0012\u001cFo\u001c:f\u0015\tI$(\u0001\u0006m_\u000e\fGn\u001d;pe\u0016T!a\u000f\u001f\u0002\u0011Ad\u0017\r\u001e4pe6T!!\u0010 \u0002\t\u0011\fW\u000e\u001c\u0006\u0002\u007f\u0005\u00191m\\7\u0004\u0001A\u0011!)A\u0007\u0002q\tA\u0012J\\'f[>\u0014\u0018\u0010U1sif\u0014VmY8sIN#xN]3\u0014\u0005\u0005)\u0005C\u0001$J\u001b\u00059%\"\u0001%\u0002\u000bM\u001c\u0017\r\\1\n\u0005);%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0003\ny\u0001+\u0019:usJ+7m\u001c:e\u0013:4wn\u0005\u0003\u0004\u000b>\u0013\u0006C\u0001$Q\u0013\t\tvIA\u0004Qe>$Wo\u0019;\u0011\u0005M[fB\u0001+Z\u001d\t)\u0006,D\u0001W\u0015\t9\u0006)\u0001\u0004=e>|GOP\u0005\u0002\u0011&\u0011!lR\u0001\ba\u0006\u001c7.Y4f\u0013\taVL\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002[\u000f\u0006)\u0001/\u0019:usV\t\u0001\r\u0005\u0002bS:\u0011!mZ\u0007\u0002G*\u0011A-Z\u0001\u0005I\u0006$\u0018M\u0003\u0002gy\u0005\u0011ANZ\u0005\u0003Q\u000e\f1AU3g\u0013\tQ7NA\u0003QCJ$\u0018P\u0003\u0002iG\u00061\u0001/\u0019:us\u0002\nqB]3t_V\u00148-\u001a,feNLwN\\\u000b\u0002_B\u0011a\t]\u0005\u0003c\u001e\u0013A\u0001T8oO\u0006\u0001\"/Z:pkJ\u001cWMV3sg&|g\u000eI\u0001\fC:tw\u000e^1uS>t7/F\u0001v!\u00111(0`?\u000f\u0005]D\bCA+H\u0013\tIx)\u0001\u0004Qe\u0016$WMZ\u0005\u0003wr\u00141!T1q\u0015\tIx\t\u0005\u0002w}&\u0011q\u0010 \u0002\u0007'R\u0014\u0018N\\4\u0002\u0019\u0005tgn\u001c;bi&|gn\u001d\u0011\u0002%%$WM\u001c;jif\u0004&o\u001c<jI\u0016\u0014\u0018\nZ\u000b\u0003\u0003\u000f\u0001B!!\u0003\u0002(9!\u00111BA\u0011\u001d\u0011\ti!a\u0007\u000f\t\u0005=\u0011q\u0003\b\u0005\u0003#\t)BD\u0002V\u0003'I\u0011aP\u0005\u0003{yJ1!!\u0007=\u0003\u0019aW\rZ4fe&!\u0011QDA\u0010\u0003\r\t\u0007/\u001b\u0006\u0004\u00033a\u0014\u0002BA\u0012\u0003K\ta\u0001Z8nC&t'\u0002BA\u000f\u0003?IA!!\u000b\u0002,\t\u0011\u0012\nZ3oi&$\u0018\u0010\u0015:pm&$WM]%e\u0015\u0011\t\u0019#!\n\u0002'%$WM\u001c;jif\u0004&o\u001c<jI\u0016\u0014\u0018\n\u001a\u0011\u0015\u0015\u0005E\u0012QGA\u001c\u0003s\tY\u0004E\u0002\u00024\ri\u0011!\u0001\u0005\u0006=2\u0001\r\u0001\u0019\u0005\u0006[2\u0001\ra\u001c\u0005\u0006g2\u0001\r!\u001e\u0005\b\u0003\u0007a\u0001\u0019AA\u0004\u0003\u0011\u0019w\u000e]=\u0015\u0015\u0005E\u0012\u0011IA\"\u0003\u000b\n9\u0005C\u0004_\u001bA\u0005\t\u0019\u00011\t\u000f5l\u0001\u0013!a\u0001_\"91/\u0004I\u0001\u0002\u0004)\b\"CA\u0002\u001bA\u0005\t\u0019AA\u0004\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0014+\u0007\u0001\fye\u000b\u0002\u0002RA!\u00111KA/\u001b\t\t)F\u0003\u0003\u0002X\u0005e\u0013!C;oG\",7m[3e\u0015\r\tYfR\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA0\u0003+\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\u001a+\u0007=\fy%\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005-$fA;\u0002P\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAA9U\u0011\t9!a\u0014\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\b\u0005\u0003\u0002z\u0005\rUBAA>\u0015\u0011\ti(a \u0002\t1\fgn\u001a\u0006\u0003\u0003\u0003\u000bAA[1wC&\u0019q0a\u001f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005%\u0005c\u0001$\u0002\f&\u0019\u0011QR$\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005M\u0015\u0011\u0014\t\u0004\r\u0006U\u0015bAAL\u000f\n\u0019\u0011I\\=\t\u0013\u0005mE#!AA\u0002\u0005%\u0015a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\"B1\u00111UAU\u0003'k!!!*\u000b\u0007\u0005\u001dv)\u0001\u0006d_2dWm\u0019;j_:LA!a+\u0002&\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\t,a.\u0011\u0007\u0019\u000b\u0019,C\u0002\u00026\u001e\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002\u001cZ\t\t\u00111\u0001\u0002\u0014\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t9(!0\t\u0013\u0005mu#!AA\u0002\u0005%\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005%\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0014AB3rk\u0006d7\u000f\u0006\u0003\u00022\u0006-\u0007\"CAN5\u0005\u0005\t\u0019AAJ\u0003=\u0001\u0016M\u001d;z%\u0016\u001cwN\u001d3J]\u001a|\u0007cAA\u001a9M)A$a5\u0002`BY\u0011Q[AnA>,\u0018qAA\u0019\u001b\t\t9NC\u0002\u0002Z\u001e\u000bqA];oi&lW-\u0003\u0003\u0002^\u0006]'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oiA!\u0011\u0011]At\u001b\t\t\u0019O\u0003\u0003\u0002f\u0006}\u0014AA5p\u0013\ra\u00161\u001d\u000b\u0003\u0003\u001f\fQ!\u00199qYf$\"\"!\r\u0002p\u0006E\u00181_A{\u0011\u0015qv\u00041\u0001a\u0011\u0015iw\u00041\u0001p\u0011\u0015\u0019x\u00041\u0001v\u0011\u001d\t\u0019a\ba\u0001\u0003\u000f\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002|\n\u001d\u0001#\u0002$\u0002~\n\u0005\u0011bAA\u0000\u000f\n1q\n\u001d;j_:\u0004\u0002B\u0012B\u0002A>,\u0018qA\u0005\u0004\u0005\u000b9%A\u0002+va2,G\u0007C\u0005\u0003\n\u0001\n\t\u00111\u0001\u00022\u0005\u0019\u0001\u0010\n\u0019\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t=\u0001\u0003BA=\u0005#IAAa\u0005\u0002|\t1qJ\u00196fGR\fQ\u0002^8QCJ$\u0018PU3d_J$G\u0003\u0002B\r\u0005G\u0001BAa\u0007\u0003 5\u0011!Q\u0004\u0006\u0004\u0003;A\u0014\u0002\u0002B\u0011\u0005;\u00111\u0002U1sif\u0014VmY8sI\"9!Q\u0005\u0012A\u0002\u0005E\u0012\u0001B5oM>\u001cBaI#\u0003*A!!1\u0004B\u0016\u0013\u0011\u0011iC!\b\u0003!A\u000b'\u000f^=SK\u000e|'\u000fZ*u_J,\u0017\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u!\u0011\u0011\u0019D!\u000f\u000e\u0005\tU\"b\u0001B\u001c\u000f\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\tm\"Q\u0007\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR$BAa\u0010\u0003BA\u0011!i\t\u0005\b\u0005_)\u0003\u0019\u0001B\u0019\u0003\t)7-\u0006\u0002\u00032\u0005\u0019Qm\u0019\u0011\u0002\r1|wmZ3s+\t\u0011i\u0005\u0005\u0003\u0003P\tUSB\u0001B)\u0015\r\u0011\u0019\u0006P\u0001\bY><w-\u001b8h\u0013\u0011\u00119F!\u0015\u0003)\r{g\u000e^3yiV\fG.\u001b>fI2{wmZ3s\u0003\u001dawnZ4fe\u0002\nQa\u001d;bi\u0016,\"Aa\u0018\u0011\u000f\t\u0005$q\r1\u0003l5\u0011!1\r\u0006\u0005\u0005K\n)+A\u0004nkR\f'\r\\3\n\t\t%$1\r\u0002\b)J,W-T1q!\r\u0011ig\u0001\b\u0003\u0005\u0002\taa\u001d;bi\u0016\u0004\u0013aD4fiB\u000b'\u000f^=SK\u000e|'\u000fZ(\u0015\t\tU$1\u0015\u000b\u0005\u0005o\u0012I\n\u0005\u0004\u00034\te$QP\u0005\u0005\u0005w\u0012)D\u0001\u0004GkR,(/\u001a\t\u0007\u0005\u007f\u0012\tJa&\u000f\t\t\u0005%Q\u0012\b\u0005\u0005\u0007\u0013YI\u0004\u0003\u0003\u0006\n%e\u0002BA\b\u0005\u000fK!a\u000f\u001f\n\u0005eR\u0014bAA\u000fq%!!q\u0012B\u000f\u0003A\u0001\u0016M\u001d;z%\u0016\u001cwN\u001d3Ti>\u0014X-\u0003\u0003\u0003\u0014\nU%A\u0002*fgVdGO\u0003\u0003\u0003\u0010\nu\u0001#\u0002$\u0002~\ne\u0001b\u0002BNY\u0001\u000f!QT\u0001\u000fY><w-\u001b8h\u0007>tG/\u001a=u!\u0011\u0011yEa(\n\t\t\u0005&\u0011\u000b\u0002\u000f\u0019><w-\u001b8h\u0007>tG/\u001a=u\u0011\u0019qF\u00061\u0001\u0003&B\u0019!qU5\u000f\u0007\t%vM\u0004\u0003\u0003,\n=f\u0002BA\b\u0005[K!A\u001a\u001f\n\u0005\u0011,\u0017!E2sK\u0006$X\rU1sif\u0014VmY8sIR!!Q\u0017B_)\u0011\u00119La/\u0011\r\tM\"\u0011\u0010B]!\u0019\u0011yH!%\u0003\u001a!9!1T\u0017A\u0004\tu\u0005b\u0002B`[\u0001\u0007!\u0011D\u0001\fa\u0006\u0014H/\u001f*fG>\u0014H-A\tva\u0012\fG/\u001a)beRL(+Z2pe\u0012$bA!2\u0003J\nMG\u0003\u0002B\\\u0005\u000fDqAa'/\u0001\b\u0011i\nC\u0004\u0003L:\u0002\rA!4\u0002#A\f'\u000f^=SK\u000e|'\u000fZ+qI\u0006$X\r\u0005\u0003\u0003\u001c\t=\u0017\u0002\u0002Bi\u0005;\u0011\u0011\u0003U1sif\u0014VmY8sIV\u0003H-\u0019;f\u0011\u001d\u0011)N\fa\u0001\u0003c\u000b!\u0003\\3eO\u0016\u0014\b+\u0019:us&\u001bHj\\2bY\u0006\u0019Bm\\+qI\u0006$X\rU1sif\u0014VmY8sIRA!1\u001cBo\u0005?\u0014\t\u000f\u0005\u0004\u0003\u0000\tE%1\u000e\u0005\b\u0005\u0017|\u0003\u0019\u0001Bg\u0011\u0019qv\u00061\u0001\u0003&\"9!QE\u0018A\u0002\t-\u0014a\u00053p\u0007J,\u0017\r^3QCJ$\u0018PU3d_J$G\u0003\u0002Bn\u0005ODqAa01\u0001\u0004\u0011I\"A\u0005xSRD7\u000b^1uKV!!Q\u001eB{)\u0011\u0011yo!\u0001\u0011\r\tM\"\u0011\u0010By!\u0011\u0011\u0019P!>\r\u0001\u00119!q_\u0019C\u0002\te(!\u0001+\u0012\t\tm\u00181\u0013\t\u0004\r\nu\u0018b\u0001B\u0000\u000f\n9aj\u001c;iS:<\u0007\u0002CB\u0002c\u0011\u0005\ra!\u0002\u0002\u0003Q\u0004RARB\u0004\u0005cL1a!\u0003H\u0005!a$-\u001f8b[\u0016t\u0014AE<ji\"|W\u000f\u001e)beRL(+Z2pe\u0012,Baa\u0004\u0004\u0018Q!1\u0011CB\u000f)\u0011\u0019\u0019b!\u0007\u0011\r\t}$\u0011SB\u000b!\u0011\u0011\u0019pa\u0006\u0005\u000f\t](G1\u0001\u0003z\"A11\u0001\u001a\u0005\u0002\u0004\u0019Y\u0002E\u0003G\u0007\u000f\u0019\u0019\u0002C\u0003_e\u0001\u0007\u0001-\u0001\u0006uCB\u001cVoY2fgN,Baa\t\u0004,Q!1QEB\u0019)\u0011\u00199c!\f\u0011\r\t}$\u0011SB\u0015!\u0011\u0011\u0019pa\u000b\u0005\u000f\t]8G1\u0001\u0003z\"91qF\u001aA\u0002\r\u001d\u0012!\u0001:\t\u000f\rM2\u00071\u0001\u00046\u0005\ta\rE\u0004G\u0007o\u0019Ica\u000f\n\u0007\rerIA\u0005Gk:\u001cG/[8ocA\u0019ai!\u0010\n\u0007\r}rI\u0001\u0003V]&$\u0018a\u0006<bY&$\u0017\r^3B]:|G/\u0019;j_:\u001c8+\u001b>f)\u0019\u0019)ea\u0012\u0004JA1!q\u0010BI\u0007wAQa\u001d\u001bA\u0002UDQA\u0018\u001bA\u0002\u0001\fQCZ5mi\u0016\u0014X\t_5ti&tw\rU1si&,7\u000f\u0006\u0004\u0004P\rm3q\f\u000b\u0005\u0007#\u001aI\u0006\u0005\u0004\u00034\te41\u000b\t\u0006m\u000eU#QU\u0005\u0004\u0007/b(aA*fi\"9!1T\u001bA\u0004\tu\u0005bBB/k\u0001\u000711K\u0001\ba\u0006\u0014H/[3t\u0011\u001d\t\u0019!\u000ea\u0001\u0003\u000f!Baa\u0019\u0004hQ!1\u0011KB3\u0011\u001d\u0011YJ\u000ea\u0002\u0005;Cqa!\u00187\u0001\u0004\u0019\u0019\u0006")
public class InMemoryPartyRecordStore
implements PartyRecordStore {
    private final ExecutionContext ec;
    private final ContextualizedLogger logger;
    private final TreeMap<String, PartyRecordInfo> state;

    public static PartyRecord toPartyRecord(PartyRecordInfo info) {
        return InMemoryPartyRecordStore$.MODULE$.toPartyRecord(info);
    }

    private ExecutionContext ec() {
        return this.ec;
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    private TreeMap<String, PartyRecordInfo> state() {
        return this.state;
    }

    @Override
    public Future<Either<PartyRecordStore.Error, Option<PartyRecord>>> getPartyRecordO(String party, LoggingContext loggingContext) {
        return this.withState((Function0 & Serializable)() -> {
            Option option = this.state().get((Object)party);
            if (option instanceof Some) {
                Some some = (Some)option;
                PartyRecordInfo info = (PartyRecordInfo)some.value();
                return package$.MODULE$.Right().apply((Object)new Some((Object)InMemoryPartyRecordStore$.MODULE$.toPartyRecord(info)));
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Right().apply((Object)None$.MODULE$);
            }
            throw new MatchError((Object)option);
        });
    }

    @Override
    public Future<Either<PartyRecordStore.Error, PartyRecord>> createPartyRecord(PartyRecord partyRecord, LoggingContext loggingContext) {
        return this.withState((Function0 & Serializable)() -> this.withoutPartyRecord(partyRecord.party(), (Function0 & Serializable)() -> this.doCreatePartyRecord(partyRecord).map((Function1 & Serializable)info -> InMemoryPartyRecordStore$.MODULE$.toPartyRecord((PartyRecordInfo)info))));
    }

    @Override
    public Future<Either<PartyRecordStore.Error, PartyRecord>> updatePartyRecord(PartyRecordUpdate partyRecordUpdate, boolean ledgerPartyIsLocal, LoggingContext loggingContext) {
        String party = partyRecordUpdate.party();
        Function1 & Serializable intersect = (Function1 & Serializable)updatePartyRecord -> {
            InMemoryPartyRecordStore.$anonfun$updatePartyRecord$5(this, loggingContext, updatePartyRecord);
            return BoxedUnit.UNIT;
        };
        return this.withState((Function0 & Serializable)() -> {
            Option option = this.state().get((Object)party);
            if (option instanceof Some) {
                Some some = (Some)option;
                PartyRecordInfo info2 = (PartyRecordInfo)some.value();
                return this.doUpdatePartyRecord(partyRecordUpdate, party, info2).map((Function1 & Serializable)updatedInfo -> InMemoryPartyRecordStore$.MODULE$.toPartyRecord((PartyRecordInfo)updatedInfo));
            }
            if (None$.MODULE$.equals(option)) {
                if (ledgerPartyIsLocal) {
                    PartyRecord newPartyRecord = new PartyRecord(party, new domain.ObjectMeta((Option)None$.MODULE$, (Map)partyRecordUpdate.metadataUpdate().annotationsUpdateO().getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty())), partyRecordUpdate.identityProviderId());
                    return this.doCreatePartyRecord(newPartyRecord).map((Function1 & Serializable)info -> InMemoryPartyRecordStore$.MODULE$.toPartyRecord((PartyRecordInfo)info));
                }
                return package$.MODULE$.Left().apply((Object)new PartyRecordStore.PartyNotFound(party));
            }
            throw new MatchError((Object)option);
        }).map((Function1 & Serializable)r -> this.tapSuccess((Function1)intersect, (Either)r), this.ec()).map((Function1 & Serializable)updatedPartyRecord -> updatedPartyRecord, this.ec());
    }

    private Either<PartyRecordStore.Error, PartyRecordInfo> doUpdatePartyRecord(PartyRecordUpdate partyRecordUpdate, String party, PartyRecordInfo info) {
        Object object;
        Map<String, String> existingAnnotations = info.annotations();
        Map updatedAnnotations = (Map)partyRecordUpdate.metadataUpdate().annotationsUpdateO().fold((Function0 & Serializable)() -> existingAnnotations, (Function1 & Serializable)newAnnotations -> LocalAnnotationsUtils$.MODULE$.calculateUpdatedAnnotations((Map<String, String>)newAnnotations, existingAnnotations));
        long currentResourceVersion = info.resourceVersion();
        Option<Object> option = partyRecordUpdate.metadataUpdate().resourceVersionO();
        if (None$.MODULE$.equals(option)) {
            object = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)(currentResourceVersion + 1L)));
        } else if (option instanceof Some) {
            Some some = (Some)option;
            long requestResourceVersion = BoxesRunTime.unboxToLong((Object)some.value());
            object = requestResourceVersion == currentResourceVersion ? package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)(currentResourceVersion + 1L))) : package$.MODULE$.Left().apply((Object)new PartyRecordStore.ConcurrentPartyUpdate(partyRecordUpdate.party()));
        } else {
            throw new MatchError(option);
        }
        Right newResourceVersionEither = object;
        return this.validateAnnotationsSize((Map<String, String>)updatedAnnotations, party).flatMap(arg_0 -> InMemoryPartyRecordStore.$anonfun$doUpdatePartyRecord$3(this, (Either)newResourceVersionEither, party, updatedAnnotations, partyRecordUpdate, arg_0));
    }

    private Either<PartyRecordStore.Error, PartyRecordInfo> doCreatePartyRecord(PartyRecord partyRecord) {
        return this.validateAnnotationsSize((Map<String, String>)partyRecord.metadata().annotations(), partyRecord.party()).map((Function1 & Serializable)x$2 -> {
            BoxedUnit boxedUnit = x$2;
            PartyRecordInfo info = new PartyRecordInfo(partyRecord.party(), 0L, (Map<String, String>)partyRecord.metadata().annotations(), partyRecord.identityProviderId());
            this.state().update((Object)partyRecord.party(), (Object)info);
            return info;
        });
    }

    private <T> Future<T> withState(Function0<T> t) {
        Future future;
        TreeMap<String, PartyRecordInfo> treeMap = this.state();
        synchronized (treeMap) {
            future = Future$.MODULE$.apply(t, this.ec());
        }
        return future;
    }

    private <T> Either<PartyRecordStore.Error, T> withoutPartyRecord(String party, Function0<Either<PartyRecordStore.Error, T>> t) {
        Option option = this.state().get((Object)party);
        if (option instanceof Some) {
            return package$.MODULE$.Left().apply((Object)new PartyRecordStore.PartyRecordExistsFatal(party));
        }
        if (None$.MODULE$.equals(option)) {
            return (Either)t.apply();
        }
        throw new MatchError((Object)option);
    }

    private <T> Either<PartyRecordStore.Error, T> tapSuccess(Function1<T, BoxedUnit> f, Either<PartyRecordStore.Error, T> r) {
        r.foreach(f);
        return r;
    }

    private Either<PartyRecordStore.Error, BoxedUnit> validateAnnotationsSize(Map<String, String> annotations, String party) {
        if (!ResourceAnnotationValidation$.MODULE$.isWithinMaxAnnotationsByteSize(annotations)) {
            return package$.MODULE$.Left().apply((Object)new PartyRecordStore.MaxAnnotationsSizeExceeded(party));
        }
        return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
    }

    @Override
    public Future<Set<String>> filterExistingParties(Set<String> parties, domain.IdentityProviderId identityProviderId, LoggingContext loggingContext) {
        return this.withState((Function0 & Serializable)() -> (Set)((IterableOps)parties.map((Function1 & Serializable)party -> new Tuple2(party, (Object)this.state().get(party)))).collect((PartialFunction)new Serializable(null, identityProviderId){
            private static final long serialVersionUID = 0L;
            private final domain.IdentityProviderId identityProviderId$1;

            public final <A1 extends Tuple2<String, Option<PartyRecordInfo>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String party = (String)A1._1();
                    Option option = (Option)A1._2();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        PartyRecordInfo record = (PartyRecordInfo)some.value();
                        domain.IdentityProviderId identityProviderId = record.identityProviderId();
                        domain.IdentityProviderId identityProviderId2 = this.identityProviderId$1;
                        if (!(identityProviderId != null ? !identityProviderId.equals(identityProviderId2) : identityProviderId2 != null)) {
                            return (B1)party;
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<String, Option<PartyRecordInfo>> x1) {
                Option option;
                Tuple2<String, Option<PartyRecordInfo>> tuple2 = x1;
                if (tuple2 != null && (option = (Option)tuple2._2()) instanceof Some) {
                    Some some = (Some)option;
                    PartyRecordInfo record = (PartyRecordInfo)some.value();
                    domain.IdentityProviderId identityProviderId = record.identityProviderId();
                    domain.IdentityProviderId identityProviderId2 = this.identityProviderId$1;
                    if (!(identityProviderId != null ? !identityProviderId.equals(identityProviderId2) : identityProviderId2 != null)) {
                        return true;
                    }
                }
                return false;
            }
            {
                this.identityProviderId$1 = identityProviderId$1;
            }
        }));
    }

    @Override
    public Future<Set<String>> filterExistingParties(Set<String> parties, LoggingContext loggingContext) {
        return this.withState((Function0 & Serializable)() -> (Set)((IterableOps)parties.map((Function1 & Serializable)party -> new Tuple2(party, (Object)this.state().get(party)))).collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<String, Option<PartyRecordInfo>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String party = (String)A1._1();
                    Option option = (Option)A1._2();
                    if (option instanceof Some) {
                        return (B1)party;
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<String, Option<PartyRecordInfo>> x1) {
                Option option;
                Tuple2<String, Option<PartyRecordInfo>> tuple2 = x1;
                return tuple2 != null && (option = (Option)tuple2._2()) instanceof Some;
            }
        }));
    }

    public static final /* synthetic */ void $anonfun$updatePartyRecord$5(InMemoryPartyRecordStore $this, LoggingContext loggingContext$1, PartyRecord updatePartyRecord) {
        $this.logger().info().apply((Function0 & Serializable)() -> new StringBuilder(51).append("Updated party record in a participant local store: ").append(updatePartyRecord).toString(), loggingContext$1);
    }

    public static final /* synthetic */ PartyRecordInfo $anonfun$doUpdatePartyRecord$4(InMemoryPartyRecordStore $this, String party$3, Map updatedAnnotations$1, PartyRecordUpdate partyRecordUpdate$2, long newResourceVersion) {
        PartyRecordInfo updatedInfo = new PartyRecordInfo(party$3, newResourceVersion, (Map<String, String>)updatedAnnotations$1, partyRecordUpdate$2.identityProviderId());
        $this.state().put((Object)party$3, (Object)updatedInfo);
        return updatedInfo;
    }

    public static final /* synthetic */ Either $anonfun$doUpdatePartyRecord$3(InMemoryPartyRecordStore $this, Either newResourceVersionEither$1, String party$3, Map updatedAnnotations$1, PartyRecordUpdate partyRecordUpdate$2, BoxedUnit x$1) {
        BoxedUnit boxedUnit = x$1;
        return newResourceVersionEither$1.map((Function1 & Serializable)newResourceVersion -> InMemoryPartyRecordStore.$anonfun$doUpdatePartyRecord$4($this, party$3, updatedAnnotations$1, partyRecordUpdate$2, BoxesRunTime.unboxToLong((Object)newResourceVersion)));
    }

    public InMemoryPartyRecordStore(ExecutionContext executionContext) {
        this.ec = executionContext;
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        this.state = (TreeMap)TreeMap$.MODULE$.apply((Seq)Nil$.MODULE$, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    }

    public static class PartyRecordInfo
    implements Product,
    Serializable {
        private final String party;
        private final long resourceVersion;
        private final Map<String, String> annotations;
        private final domain.IdentityProviderId identityProviderId;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String party() {
            return this.party;
        }

        public long resourceVersion() {
            return this.resourceVersion;
        }

        public Map<String, String> annotations() {
            return this.annotations;
        }

        public domain.IdentityProviderId identityProviderId() {
            return this.identityProviderId;
        }

        public PartyRecordInfo copy(String party, long resourceVersion, Map<String, String> annotations, domain.IdentityProviderId identityProviderId) {
            return new PartyRecordInfo(party, resourceVersion, annotations, identityProviderId);
        }

        public String copy$default$1() {
            return this.party();
        }

        public long copy$default$2() {
            return this.resourceVersion();
        }

        public Map<String, String> copy$default$3() {
            return this.annotations();
        }

        public domain.IdentityProviderId copy$default$4() {
            return this.identityProviderId();
        }

        public String productPrefix() {
            return "PartyRecordInfo";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.party();
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.resourceVersion());
                }
                case 2: {
                    return this.annotations();
                }
                case 3: {
                    return this.identityProviderId();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PartyRecordInfo;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "party";
                }
                case 1: {
                    return "resourceVersion";
                }
                case 2: {
                    return "annotations";
                }
                case 3: {
                    return "identityProviderId";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.party()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.resourceVersion()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.annotations()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.identityProviderId()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PartyRecordInfo)) return false;
            boolean bl = true;
            if (!bl) return false;
            PartyRecordInfo partyRecordInfo = (PartyRecordInfo)x$1;
            if (this.resourceVersion() != partyRecordInfo.resourceVersion()) return false;
            String string = this.party();
            String string2 = partyRecordInfo.party();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Map<String, String> map = this.annotations();
            Map<String, String> map2 = partyRecordInfo.annotations();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            domain.IdentityProviderId identityProviderId = this.identityProviderId();
            domain.IdentityProviderId identityProviderId2 = partyRecordInfo.identityProviderId();
            if (identityProviderId == null) {
                if (identityProviderId2 != null) {
                    return false;
                }
            } else if (!identityProviderId.equals(identityProviderId2)) return false;
            if (!partyRecordInfo.canEqual(this)) return false;
            return true;
        }

        public PartyRecordInfo(String party, long resourceVersion, Map<String, String> annotations, domain.IdentityProviderId identityProviderId) {
            this.party = party;
            this.resourceVersion = resourceVersion;
            this.annotations = annotations;
            this.identityProviderId = identityProviderId;
            Product.$init$((Product)this);
        }
    }
}

