/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.participant.state.kvutils.app;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.ClassicActorSystemProvider;
import akka.stream.Materializer;
import akka.stream.Materializer$;
import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.MetricSet;
import com.daml.daml_lf_dev.DamlLf;
import com.daml.ledger.api.auth.AuthService;
import com.daml.ledger.api.health.HealthChecks;
import com.daml.ledger.participant.state.kvutils.app.Config;
import com.daml.ledger.participant.state.kvutils.app.Config$;
import com.daml.ledger.participant.state.kvutils.app.Config$EngineMode$Dev$;
import com.daml.ledger.participant.state.kvutils.app.Config$EngineMode$EarlyAccess$;
import com.daml.ledger.participant.state.kvutils.app.Config$EngineMode$Stable$;
import com.daml.ledger.participant.state.kvutils.app.LedgerFactory;
import com.daml.ledger.participant.state.kvutils.app.Mode;
import com.daml.ledger.participant.state.kvutils.app.Mode$Run$;
import com.daml.ledger.participant.state.kvutils.app.ParticipantConfig;
import com.daml.ledger.participant.state.kvutils.app.ParticipantRunMode;
import com.daml.ledger.participant.state.kvutils.app.ParticipantRunMode$Combined$;
import com.daml.ledger.participant.state.kvutils.app.ParticipantRunMode$Indexer$;
import com.daml.ledger.participant.state.kvutils.app.ParticipantRunMode$LedgerApiServer$;
import com.daml.ledger.participant.state.v1.ReadService;
import com.daml.ledger.participant.state.v1.SubmissionResult;
import com.daml.ledger.participant.state.v1.WritePackagesService;
import com.daml.ledger.participant.state.v1.WriteService;
import com.daml.ledger.participant.state.v1.metrics.TimedReadService;
import com.daml.ledger.participant.state.v1.metrics.TimedWriteService;
import com.daml.ledger.resources.ResourceContext;
import com.daml.ledger.resources.ResourceOwner$;
import com.daml.ledger.resources.package$;
import com.daml.lf.VersionRange;
import com.daml.lf.archive.Dar;
import com.daml.lf.archive.DarReader$;
import com.daml.lf.engine.Engine;
import com.daml.lf.engine.EngineConfig;
import com.daml.lf.engine.EngineConfig$;
import com.daml.lf.language.LanguageVersion$;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.logging.LoggingContext$;
import com.daml.metrics.JvmMetricSet;
import com.daml.metrics.MetricName$;
import com.daml.metrics.Metrics;
import com.daml.platform.apiserver.ApiServerConfig;
import com.daml.platform.apiserver.StandaloneApiServer;
import com.daml.platform.apiserver.StandaloneApiServer$;
import com.daml.platform.apiserver.TimeServiceBackend;
import com.daml.platform.configuration.CommandConfiguration;
import com.daml.platform.configuration.LedgerConfiguration;
import com.daml.platform.configuration.PartyConfiguration;
import com.daml.platform.indexer.StandaloneIndexerServer;
import com.daml.platform.store.IndexMetadata;
import com.daml.platform.store.IndexMetadata$;
import com.daml.platform.store.dao.events.LfValueTranslation;
import com.daml.resources.AbstractResourceOwner;
import com.daml.resources.HasExecutionContext;
import com.daml.resources.Resource;
import io.grpc.ServerInterceptor;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.compat.java8.FutureConverters;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005mc\u0001B\u0005\u000b\u0005eA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\t[\u0001\u0011\t\u0011)A\u0005]!)A\t\u0001C\u0001\u000b\")Q\n\u0001C\u0001\u001d\")Q\n\u0001C\u0001U\")\u0001\u000f\u0001C\u0005c\"9\u00111\u0002\u0001\u0005\n\u00055\u0001bBA\f\u0001\u0011%\u0011\u0011\u0004\u0002\u0007%Vtg.\u001a:\u000b\u0005-a\u0011aA1qa*\u0011QBD\u0001\bWZ,H/\u001b7t\u0015\ty\u0001#A\u0003ti\u0006$XM\u0003\u0002\u0012%\u0005Y\u0001/\u0019:uS\u000eL\u0007/\u00198u\u0015\t\u0019B#\u0001\u0004mK\u0012<WM\u001d\u0006\u0003+Y\tA\u0001Z1nY*\tq#A\u0002d_6\u001c\u0001!F\u0002\u001b\u0011n\u001a\"\u0001A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g\u0003\u0011q\u0017-\\3\u0011\u0005\rRcB\u0001\u0013)!\t)S$D\u0001'\u0015\t9\u0003$\u0001\u0004=e>|GOP\u0005\u0003Su\ta\u0001\u0015:fI\u00164\u0017BA\u0016-\u0005\u0019\u0019FO]5oO*\u0011\u0011&H\u0001\bM\u0006\u001cGo\u001c:z!\u0011y\u0003GM\u001d\u000e\u0003)I!!\r\u0006\u0003\u001b1+GmZ3s\r\u0006\u001cGo\u001c:z!\t\u0019dG\u0004\u00020i%\u0011QGC\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0004H\u0001\tSK\u0006$wK]5uKN+'O^5dK*\u0011QG\u0003\t\u0003umb\u0001\u0001B\u0003=\u0001\t\u0007QHA\u0003FqR\u0014\u0018-\u0005\u0002?\u0003B\u0011AdP\u0005\u0003\u0001v\u0011qAT8uQ&tw\r\u0005\u0002\u001d\u0005&\u00111)\b\u0002\u0004\u0003:L\u0018A\u0002\u001fj]&$h\bF\u0002G\u00172\u0003Ba\f\u0001HsA\u0011!\b\u0013\u0003\u0006\u0013\u0002\u0011\rA\u0013\u0002\u0002)F\u0011aH\r\u0005\u0006C\r\u0001\rA\t\u0005\u0006[\r\u0001\rAL\u0001\u0006_^tWM\u001d\u000b\u0003\u001f\n\u00042\u0001\u0015/`\u001d\t\t&L\u0004\u0002S1:\u00111k\u0016\b\u0003)Zs!!J+\n\u0003]I!!\u0006\f\n\u0005M!\u0012BA-\u0013\u0003%\u0011Xm]8ve\u000e,7/\u0003\u000267*\u0011\u0011LE\u0005\u0003;z\u0013QBU3t_V\u00148-Z(x]\u0016\u0014(BA\u001b\\!\ta\u0002-\u0003\u0002b;\t!QK\\5u\u0011\u0015\u0019G\u00011\u0001e\u0003\u0011\t'oZ:\u0011\u0007\u0015D'%D\u0001g\u0015\t9W$\u0001\u0006d_2dWm\u0019;j_:L!!\u001b4\u0003\u0007M+\u0017\u000f\u0006\u0002PW\")A.\u0002a\u0001[\u0006qqN]5hS:\fGnQ8oM&<\u0007cA\u0018os%\u0011qN\u0003\u0002\u0007\u0007>tg-[4\u0002#\u0011,X\u000e]%oI\u0016DX*\u001a;bI\u0006$\u0018\r\u0006\u0002syR\u00111O\u001e\t\u0004!R|\u0016BA;_\u0005!\u0011Vm]8ve\u000e,\u0007\"B<\u0007\u0001\bA\u0018a\u0004:fg>,(oY3D_:$X\r\u001f;\u0011\u0005eTX\"A.\n\u0005m\\&a\u0004*fg>,(oY3D_:$X\r\u001f;\t\u000bu4\u0001\u0019\u0001@\u0002\u0011)$'mY+sYN\u0004Ba`A\u0004E9!\u0011\u0011AA\u0003\u001d\r)\u00131A\u0005\u0002=%\u0011Q'H\u0005\u0004S\u0006%!BA\u001b\u001e\u0003\r\u0011XO\u001c\u000b\u0005\u0003\u001f\t\u0019\u0002F\u0002t\u0003#AQa^\u0004A\u0004aDa!!\u0006\b\u0001\u0004i\u0017AB2p]\u001aLw-A\u0005va2|\u0017\r\u001a#beR1\u00111DA\u001a\u0003\u0017\"B!!\b\u0002*A)\u0011qDA\u0013?6\u0011\u0011\u0011\u0005\u0006\u0004\u0003Gi\u0012AC2p]\u000e,(O]3oi&!\u0011qEA\u0011\u0005\u00191U\u000f^;sK\"9\u00111\u0006\u0005A\u0004\u00055\u0012\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u!\u0011\ty\"a\f\n\t\u0005E\u0012\u0011\u0005\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRDq!!\u000e\t\u0001\u0004\t9$\u0001\u0003ge>l\u0007\u0003BA\u001d\u0003\u000fj!!a\u000f\u000b\t\u0005u\u0012qH\u0001\u0005M&dWM\u0003\u0003\u0002B\u0005\r\u0013a\u00018j_*\u0011\u0011QI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002J\u0005m\"\u0001\u0002)bi\"Dq!!\u0014\t\u0001\u0004\ty%\u0001\u0002u_B!\u0011\u0011KA,\u001b\t\t\u0019FC\u0002\u0002V9\t!A^\u0019\n\t\u0005e\u00131\u000b\u0002\u0015/JLG/\u001a)bG.\fw-Z:TKJ4\u0018nY3")
public final class Runner<T extends ReadService & WriteService, Extra> {
    private final String name;
    public final LedgerFactory<ReadService, Extra> com$daml$ledger$participant$state$kvutils$app$Runner$$factory;

    public AbstractResourceOwner<ResourceContext, BoxedUnit> owner(Seq<String> args) {
        return Config$.MODULE$.owner(this.name, (Function1 & Serializable & scala.Serializable)parser -> {
            this.com$daml$ledger$participant$state$kvutils$app$Runner$$factory.extraConfigParser(parser);
            return BoxedUnit.UNIT;
        }, this.com$daml$ledger$participant$state$kvutils$app$Runner$$factory.defaultExtraConfig(), args).flatMap((Function1 & Serializable & scala.Serializable)originalConfig -> this.owner((Config)originalConfig));
    }

    public AbstractResourceOwner<ResourceContext, BoxedUnit> owner(Config<Extra> originalConfig) {
        return new AbstractResourceOwner<ResourceContext, BoxedUnit>(this, originalConfig){
            private final /* synthetic */ Runner $outer;
            private final Config originalConfig$1;

            public Resource<ResourceContext, BoxedUnit> acquire(ResourceContext context) {
                Config<ExtraConfig> config = this.$outer.com$daml$ledger$participant$state$kvutils$app$Runner$$factory.manipulateConfig(this.originalConfig$1);
                Mode mode = config.mode();
                if (mode instanceof Mode.DumpIndexMetadata) {
                    Mode.DumpIndexMetadata dumpIndexMetadata2 = (Mode.DumpIndexMetadata)mode;
                    Vector<String> jdbcUrls = dumpIndexMetadata2.jdbcUrls();
                    this.$outer.com$daml$ledger$participant$state$kvutils$app$Runner$$dumpIndexMetadata((Seq<String>)jdbcUrls, context);
                    throw scala.sys.package$.MODULE$.exit(0);
                }
                if (!Mode$Run$.MODULE$.equals(mode)) {
                    throw new MatchError((Object)mode);
                }
                Resource<ResourceContext, BoxedUnit> resource = this.$outer.com$daml$ledger$participant$state$kvutils$app$Runner$$run(config, context);
                return resource;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.originalConfig$1 = originalConfig$1;
                super((HasExecutionContext)ResourceContext.Context$u0020has$u0020ExecutionContext$.MODULE$);
            }
        };
    }

    public Resource<ResourceContext, BoxedUnit> com$daml$ledger$participant$state$kvutils$app$Runner$$dumpIndexMetadata(Seq<String> jdbcUrls, ResourceContext resourceContext) {
        ContextualizedLogger logger = ContextualizedLogger$.MODULE$.get(this.getClass());
        return package$.MODULE$.Resource().sequenceIgnoringValues((Iterable)jdbcUrls.map((Function1 & Serializable & scala.Serializable)jdbcUrl -> (Resource)LoggingContext$.MODULE$.newLoggingContext((Function1 & Serializable & scala.Serializable)loggingContext -> package$.MODULE$.Resource().fromFuture(IndexMetadata$.MODULE$.read(jdbcUrl, resourceContext, ExecutionContext.Implicits$.MODULE$.global(), loggingContext).andThen((PartialFunction)new scala.Serializable(null, logger, (LoggingContext)loggingContext){
            public static final long serialVersionUID = 0L;
            private final ContextualizedLogger logger$1;
            private final LoggingContext loggingContext$1;

            public final <A1 extends Try<IndexMetadata>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Failure) {
                    Failure failure = (Failure)A1;
                    Throwable exception = failure.exception();
                    this.logger$1.error().apply((Function0 & Serializable & scala.Serializable)() -> "Error while retrieving the index metadata", exception, this.loggingContext$1);
                    object = BoxedUnit.UNIT;
                } else if (A1 instanceof Success) {
                    Success success = (Success)A1;
                    IndexMetadata metadata = (IndexMetadata)success.value();
                    this.logger$1.warn().apply((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("ledger_id: ").append(metadata.ledgerId()).toString(), this.loggingContext$1);
                    this.logger$1.warn().apply((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("participant_id: ").append(metadata.participantId()).toString(), this.loggingContext$1);
                    this.logger$1.warn().apply((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("ledger_end: ").append(metadata.ledgerEnd()).toString(), this.loggingContext$1);
                    this.logger$1.warn().apply((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("version: ").append(metadata.participantIntegrationApiVersion()).toString(), this.loggingContext$1);
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Try<IndexMetadata> x1) {
                Try<IndexMetadata> try_ = x1;
                boolean bl = try_ instanceof Failure ? true : try_ instanceof Success;
                return bl;
            }
            {
                this.logger$1 = logger$1;
                this.loggingContext$1 = loggingContext$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2(com.daml.platform.store.IndexMetadata ), $anonfun$applyOrElse$3(com.daml.platform.store.IndexMetadata ), $anonfun$applyOrElse$4(com.daml.platform.store.IndexMetadata ), $anonfun$applyOrElse$5(com.daml.platform.store.IndexMetadata )}, serializedLambda);
            }
        }, ExecutionContext.Implicits$.MODULE$.global()))), Seq$.MODULE$.canBuildFrom()), (Object)resourceContext);
    }

    public Resource<ResourceContext, BoxedUnit> com$daml$ledger$participant$state$kvutils$app$Runner$$run(Config<Extra> config, ResourceContext resourceContext) {
        VersionRange versionRange;
        ActorSystem actorSystem = ActorSystem$.MODULE$.apply(new StringOps(Predef$.MODULE$.augmentString("[^A-Za-z0-9_\\-]")).r().replaceAllIn((CharSequence)this.name.toLowerCase(), "-"));
        Materializer materializer = Materializer$.MODULE$.apply((ClassicActorSystemProvider)actorSystem);
        Config.EngineMode engineMode = config.engineMode();
        if (Config$EngineMode$Stable$.MODULE$.equals(engineMode)) {
            versionRange = LanguageVersion$.MODULE$.StableVersions();
        } else if (Config$EngineMode$EarlyAccess$.MODULE$.equals(engineMode)) {
            versionRange = LanguageVersion$.MODULE$.EarlyAccessVersions();
        } else if (Config$EngineMode$Dev$.MODULE$.equals(engineMode)) {
            versionRange = LanguageVersion$.MODULE$.DevVersions();
        } else {
            throw new MatchError((Object)engineMode);
        }
        VersionRange allowedLanguageVersions = versionRange;
        Engine sharedEngine = new Engine(new EngineConfig(allowedLanguageVersions, EngineConfig$.MODULE$.apply$default$2(), EngineConfig$.MODULE$.apply$default$3(), EngineConfig$.MODULE$.apply$default$4()));
        return (Resource)LoggingContext$.MODULE$.newLoggingContext((Function1 & Serializable & scala.Serializable)loggingContext -> ResourceOwner$.MODULE$.forActorSystem((Function0 & Serializable & scala.Serializable)() -> actorSystem).acquire((Object)resourceContext).flatMap((Function1 & Serializable & scala.Serializable)_ -> ResourceOwner$.MODULE$.forMaterializer((Function0 & Serializable & scala.Serializable)() -> materializer).acquire((Object)resourceContext).flatMap((Function1 & Serializable & scala.Serializable)_2 -> package$.MODULE$.Resource().sequence((Iterable)config.participants().map((Function1 & Serializable & scala.Serializable)participantConfig -> {
            Metrics metrics = $this.com$daml$ledger$participant$state$kvutils$app$Runner$$factory.createMetrics((ParticipantConfig)participantConfig, config);
            metrics.registry().registerAll((MetricSet)new JvmMetricSet());
            LfValueTranslation.Cache lfValueTranslationCache = LfValueTranslation.Cache$.MODULE$.newInstrumentedInstance(config.lfValueTranslationEventCache(), config.lfValueTranslationContractCache(), metrics);
            return ((Resource)config.metricsReporter().fold((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Resource().unit(), (Function1 & Serializable & scala.Serializable)reporter -> ResourceOwner$.MODULE$.forCloseable((Function0 & Serializable & scala.Serializable)() -> reporter.register(metrics.registry())).map((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.start(config.metricsReportingInterval().getSeconds(), TimeUnit.SECONDS);
                return BoxedUnit.UNIT;
            }).acquire((Object)resourceContext))).flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.com$daml$ledger$participant$state$kvutils$app$Runner$$factory.readWriteServiceOwner(config, (ParticipantConfig)participantConfig, sharedEngine, materializer, (LoggingContext)loggingContext).acquire((Object)resourceContext).map((Function1 & Serializable & scala.Serializable)ledger -> {
                TimedReadService readService = new TimedReadService(ledger, metrics);
                TimedWriteService writeService = new TimedWriteService((WriteService)ledger, metrics);
                HealthChecks healthChecks = new HealthChecks((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"read"), (Object)readService), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"write"), (Object)writeService)}));
                return new Tuple4(ledger, (Object)readService, (Object)writeService, (Object)healthChecks);
            }, (Object)resourceContext).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
                Tuple4 tuple4 = x$2;
                if (tuple4 == null) {
                    throw new MatchError((Object)tuple4);
                }
                TimedReadService readService = (TimedReadService)tuple4._2();
                TimedWriteService writeService = (TimedWriteService)tuple4._3();
                HealthChecks healthChecks = (HealthChecks)tuple4._4();
                Resource resource = package$.MODULE$.Resource().sequence((Iterable)config.archiveFiles().map((Function1 & Serializable & scala.Serializable)path -> package$.MODULE$.Resource().fromFuture(this.uploadDar((Path)path, (WritePackagesService)writeService, resourceContext.executionContext())), Seq$.MODULE$.canBuildFrom()), Predef$.MODULE$.fallbackStringCanBuildFrom(), (Object)resourceContext).flatMap((Function1 & Serializable & scala.Serializable)_ -> ResourceOwner$.MODULE$.forExecutorService((Function0 & Serializable & scala.Serializable)() -> new InstrumentedExecutorService(Executors.newWorkStealingPool(), metrics.registry(), MetricName$.MODULE$.toString$extension(metrics.daml().lapi().threadpool().apiServices()))).map((Function1 & Serializable & scala.Serializable)e -> ExecutionContext$.MODULE$.fromExecutorService(e)).acquire((Object)resourceContext).flatMap((Function1 & Serializable & scala.Serializable)servicesExecutionContext -> {
                    Resource resource;
                    ParticipantRunMode participantRunMode = participantConfig.mode();
                    boolean bl = ParticipantRunMode$Combined$.MODULE$.equals(participantRunMode) ? true : ParticipantRunMode$Indexer$.MODULE$.equals(participantRunMode);
                    if (bl) {
                        resource = new StandaloneIndexerServer((ReadService)readService, $this.com$daml$ledger$participant$state$kvutils$app$Runner$$factory.indexerConfig((ParticipantConfig)participantConfig, config), (ExecutionContext)servicesExecutionContext, metrics, lfValueTranslationCache, materializer, loggingContext).acquire(resourceContext).map((Function1 & Serializable & scala.Serializable)indexerHealth -> healthChecks.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"indexer"), indexerHealth)), (Object)resourceContext);
                    } else if (ParticipantRunMode$LedgerApiServer$.MODULE$.equals(participantRunMode)) {
                        resource = package$.MODULE$.Resource().successful((Object)healthChecks);
                    } else {
                        throw new MatchError((Object)participantRunMode);
                    }
                    return resource.flatMap((Function1 & Serializable & scala.Serializable)healthChecksWithIndexer -> {
                        Resource resource;
                        ParticipantRunMode participantRunMode = participantConfig.mode();
                        boolean bl = ParticipantRunMode$Combined$.MODULE$.equals(participantRunMode) ? true : ParticipantRunMode$LedgerApiServer$.MODULE$.equals(participantRunMode);
                        if (bl) {
                            String x$1 = config.ledgerId();
                            ApiServerConfig x$2 = $this.com$daml$ledger$participant$state$kvutils$app$Runner$$factory.apiServerConfig((ParticipantConfig)participantConfig, config);
                            CommandConfiguration x$3 = $this.com$daml$ledger$participant$state$kvutils$app$Runner$$factory.commandConfig((ParticipantConfig)participantConfig, config);
                            PartyConfiguration x$4 = $this.com$daml$ledger$participant$state$kvutils$app$Runner$$factory.partyConfig(config);
                            LedgerConfiguration x$5 = $this.com$daml$ledger$participant$state$kvutils$app$Runner$$factory.ledgerConfig(config);
                            Some x$6 = new Some((Object)writeService);
                            AuthService x$7 = $this.com$daml$ledger$participant$state$kvutils$app$Runner$$factory.authService(config);
                            HealthChecks x$8 = healthChecksWithIndexer;
                            Metrics x$9 = metrics;
                            Option<TimeServiceBackend> x$10 = $this.com$daml$ledger$participant$state$kvutils$app$Runner$$factory.timeServiceBackend(config);
                            List<ServerInterceptor> x$11 = $this.com$daml$ledger$participant$state$kvutils$app$Runner$$factory.interceptors(config);
                            Engine x$12 = sharedEngine;
                            ExecutionContextExecutorService x$13 = servicesExecutionContext;
                            LfValueTranslation.Cache x$14 = lfValueTranslationCache;
                            scala.collection.immutable.Seq x$15 = StandaloneApiServer$.MODULE$.$lessinit$greater$default$11();
                            resource = new StandaloneApiServer(x$1, x$2, x$3, x$4, x$5, (Option)x$6, x$7, x$8, x$9, x$10, x$15, x$11, x$12, (ExecutionContextExecutor)x$13, x$14, actorSystem, materializer, loggingContext).acquire(resourceContext);
                        } else if (ParticipantRunMode$Indexer$.MODULE$.equals(participantRunMode)) {
                            resource = package$.MODULE$.Resource().unit();
                        } else {
                            throw new MatchError((Object)participantRunMode);
                        }
                        return resource.map((Function1 & Serializable & scala.Serializable)_ -> {
                            Runner.$anonfun$run$21(_);
                            return BoxedUnit.UNIT;
                        }, (Object)resourceContext);
                    }, (Object)resourceContext);
                }, (Object)resourceContext), (Object)resourceContext);
                return resource;
            }, (Object)resourceContext), (Object)resourceContext);
        }, Seq$.MODULE$.canBuildFrom()), Predef$.MODULE$.fallbackStringCanBuildFrom(), (Object)resourceContext).map((Function1 & Serializable & scala.Serializable)_ -> {
            Runner.$anonfun$run$22(_);
            return BoxedUnit.UNIT;
        }, (Object)resourceContext), (Object)resourceContext), (Object)resourceContext));
    }

    private Future<BoxedUnit> uploadDar(Path from, WritePackagesService to, ExecutionContext executionContext) {
        String submissionId = (String)com.daml.ledger.participant.state.v1.package$.MODULE$.SubmissionId().assertFromString(UUID.randomUUID().toString());
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Dar)DarReader$.MODULE$.apply((Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> Runner.$anonfun$uploadDar$2(BoxesRunTime.unboxToLong((Object)x0$1), x1$1)).readArchiveFromFile(from.toFile()).get(), executionContext).flatMap((Function1 & Serializable & scala.Serializable)dar -> FutureConverters.CompletionStageOps$.MODULE$.toScala$extension(FutureConverters$.MODULE$.CompletionStageOps(to.uploadPackages(submissionId, dar.all(), (Option)None$.MODULE$))).map((Function1 & Serializable & scala.Serializable)_ -> {
            Runner.$anonfun$uploadDar$5(_);
            return BoxedUnit.UNIT;
        }, executionContext), executionContext);
    }

    public static final /* synthetic */ void $anonfun$run$21(Object _) {
    }

    public static final /* synthetic */ void $anonfun$run$22(IndexedSeq _) {
    }

    public static final /* synthetic */ Try $anonfun$uploadDar$2(long x0$1, InputStream x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        InputStream x = (InputStream)tuple2._2();
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> DamlLf.Archive.parseFrom((InputStream)x));
        return try_;
    }

    public static final /* synthetic */ void $anonfun$uploadDar$5(SubmissionResult _) {
    }

    public Runner(String name, LedgerFactory<ReadService, Extra> factory) {
        this.name = name;
        this.com$daml$ledger$participant$state$kvutils$app$Runner$$factory = factory;
    }
}

