/*
 * Decompiled with CFR 0.152.
 */
package com.daml.ledger.participant.state.kvutils.app;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import akka.actor.ClassicActorSystemProvider;
import akka.stream.Materializer;
import akka.stream.Materializer$;
import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.MetricSet;
import com.daml.api.util.TimeProvider;
import com.daml.buildinfo.BuildInfo$;
import com.daml.ledger.api.auth.AuthService;
import com.daml.ledger.api.auth.AuthServiceJWT;
import com.daml.ledger.api.auth.AuthServiceNone$;
import com.daml.ledger.api.auth.AuthServiceStatic;
import com.daml.ledger.api.auth.AuthServiceWildcard$;
import com.daml.ledger.api.health.HealthChecks;
import com.daml.ledger.participant.state.index.v2.IndexCompletionsService;
import com.daml.ledger.participant.state.index.v2.IndexService;
import com.daml.ledger.participant.state.index.v2.UserManagementStore;
import com.daml.ledger.participant.state.kvutils.app.KeyValueDeduplicationSupportFactory;
import com.daml.ledger.participant.state.kvutils.app.LedgerFactory;
import com.daml.ledger.participant.state.kvutils.app.ReadWriteServiceFactory;
import com.daml.ledger.participant.state.v2.ReadService;
import com.daml.ledger.participant.state.v2.WriteService;
import com.daml.ledger.participant.state.v2.metrics.TimedReadService;
import com.daml.ledger.participant.state.v2.metrics.TimedWriteService;
import com.daml.ledger.resources.ResourceContext;
import com.daml.ledger.resources.ResourceOwner$;
import com.daml.ledger.resources.package$;
import com.daml.ledger.runner.common.Config;
import com.daml.ledger.runner.common.Config$;
import com.daml.ledger.runner.common.ConfigProvider;
import com.daml.ledger.runner.common.DumpIndexMetadata$;
import com.daml.ledger.runner.common.Mode;
import com.daml.ledger.runner.common.ParticipantConfig;
import com.daml.ledger.runner.common.ParticipantRunMode;
import com.daml.lf.VersionRange;
import com.daml.lf.engine.Engine;
import com.daml.lf.engine.EngineConfig;
import com.daml.lf.engine.EngineConfig$;
import com.daml.lf.interpretation.Limits;
import com.daml.lf.transaction.ContractKeyUniquenessMode;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.LoggingContext;
import com.daml.logging.LoggingContext$;
import com.daml.logging.entries.LoggingValue$;
import com.daml.logging.entries.ToLoggingValue$;
import com.daml.metrics.JvmMetricSet;
import com.daml.metrics.MetricName$;
import com.daml.metrics.Metrics;
import com.daml.platform.apiserver.ApiServerConfig;
import com.daml.platform.apiserver.LedgerFeatures;
import com.daml.platform.apiserver.StandaloneApiServer$;
import com.daml.platform.apiserver.StandaloneIndexService$;
import com.daml.platform.configuration.CommandConfiguration;
import com.daml.platform.configuration.PartyConfiguration;
import com.daml.platform.configuration.ServerRole;
import com.daml.platform.indexer.StandaloneIndexerServer;
import com.daml.platform.indexer.StandaloneIndexerServer$;
import com.daml.platform.store.DbSupport;
import com.daml.platform.store.DbSupport$;
import com.daml.platform.store.LfValueTranslationCache;
import com.daml.platform.usermanagement.PersistentUserManagementStore$;
import com.daml.platform.usermanagement.UserManagementConfig;
import com.daml.platform.usermanagement.UserManagementConfig$;
import com.daml.ports.Port;
import com.daml.ports.Port$;
import com.daml.resources.AbstractResourceOwner;
import com.daml.resources.HasExecutionContext;
import com.daml.resources.Resource;
import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.ExecutionContextExecutorService;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001B\b\u0011\u0005}A\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001\u000b\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005M\u0001\t\u0005\t\u0015!\u0003N\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u001d9\u0007A1A\u0005\n!Da!\u001b\u0001!\u0002\u0013A\u0003b\u00026\u0001\u0005\u0004%Ia\u001b\u0005\u0007e\u0002\u0001\u000b\u0011\u00027\t\u000bM\u0004A\u0011\u0001;\t\rM\u0004A\u0011AA\u0011\u0011!\ti\u0003\u0001C\u0001!\u0005=\u0002bBA&\u0001\u0011%\u0011Q\n\u0005\t\u0003#\u0002A\u0011\u0001\t\u0002T\t1!+\u001e8oKJT!!\u0005\n\u0002\u0007\u0005\u0004\bO\u0003\u0002\u0014)\u000591N^;uS2\u001c(BA\u000b\u0017\u0003\u0015\u0019H/\u0019;f\u0015\t9\u0002$A\u0006qCJ$\u0018nY5qC:$(BA\r\u001b\u0003\u0019aW\rZ4fe*\u00111\u0004H\u0001\u0005I\u0006lGNC\u0001\u001e\u0003\r\u0019w.\\\u0002\u0001+\r\u0001\u0013LO\n\u0003\u0001\u0005\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0017\u0001\u00028b[\u0016\u0004\"!\u000b\u0019\u000f\u0005)r\u0003CA\u0016$\u001b\u0005a#BA\u0017\u001f\u0003\u0019a$o\\8u}%\u0011qfI\u0001\u0007!J,G-\u001a4\n\u0005E\u0012$AB*ue&twM\u0003\u00020G\u00059a-Y2u_JL\bcA\u001b7q5\t\u0001#\u0003\u00028!\tiA*\u001a3hKJ4\u0015m\u0019;pef\u0004\"!\u000f\u001e\r\u0001\u0011)1\b\u0001b\u0001y\t)Q\t\u001f;sCF\u0011Q\b\u0011\t\u0003EyJ!aP\u0012\u0003\u000f9{G\u000f[5oOB\u0011!%Q\u0005\u0003\u0005\u000e\u00121!\u00118z\u00039\u0019wN\u001c4jOB\u0013xN^5eKJ\u00042!\u0012&9\u001b\u00051%BA$I\u0003\u0019\u0019w.\\7p]*\u0011\u0011\nG\u0001\u0007eVtg.\u001a:\n\u0005-3%AD\"p]\u001aLw\r\u0015:pm&$WM]\u0001\u000fY\u0016$w-\u001a:GK\u0006$XO]3t!\tq5+D\u0001P\u0015\t\u0001\u0016+A\u0005ba&\u001cXM\u001d<fe*\u0011!KG\u0001\ta2\fGOZ8s[&\u0011Ak\u0014\u0002\u000f\u0019\u0016$w-\u001a:GK\u0006$XO]3t\u0003\u0019a\u0014N\\5u}Q)qk\u00193fMB!Q\u0007\u0001-9!\tI\u0014\fB\u0003[\u0001\t\u00071LA\u0001U#\tiD\f\u0005\u0002^A:\u0011QGX\u0005\u0003?B\tq\u0001]1dW\u0006<W-\u0003\u0002bE\n\u0001\"+Z1e/JLG/Z*feZL7-\u001a\u0006\u0003?BAQaJ\u0003A\u0002!BQaM\u0003A\u0002QBQaQ\u0003A\u0002\u0011CQ\u0001T\u0003A\u00025\u000b1b\u00197fC:,GMT1nKV\t\u0001&\u0001\u0007dY\u0016\fg.\u001a3OC6,\u0007%\u0001\u0004m_\u001e<WM]\u000b\u0002YB\u0011Q\u000e]\u0007\u0002]*\u0011qNG\u0001\bY><w-\u001b8h\u0013\t\thN\u0001\u000bD_:$X\r\u001f;vC2L'0\u001a3M_\u001e<WM]\u0001\bY><w-\u001a:!\u0003\u0015ywO\\3s)\r)\u0018\u0011\u0003\t\u0006m\u0006\u0015\u00111\u0002\b\u0004o\u0006\u0005aB\u0001=\u007f\u001d\tIXP\u0004\u0002{y:\u00111f_\u0005\u0002;%\u00111\u0004H\u0005\u00033iI!a \r\u0002\u0013I,7o\\;sG\u0016\u001c\u0018bA0\u0002\u0004)\u0011q\u0010G\u0005\u0005\u0003\u000f\tIAA\u0007SKN|WO]2f\u001f^tWM\u001d\u0006\u0004?\u0006\r\u0001c\u0001\u0012\u0002\u000e%\u0019\u0011qB\u0012\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003'Q\u0001\u0019AA\u000b\u0003\u0011\t'oZ:\u0011\u000b\u0005]\u0011Q\u0004\u0015\u000e\u0005\u0005e!bAA\u000eG\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0011\u0011\u0004\u0002\u0004'\u0016\fHcA;\u0002$!9\u0011QE\u0006A\u0002\u0005\u001d\u0012AD8sS\u001eLg.\u00197D_:4\u0017n\u001a\t\u0005\u000b\u0006%\u0002(C\u0002\u0002,\u0019\u0013aaQ8oM&<\u0017a\u0001:v]R1\u0011\u0011GA#\u0003\u0013\"B!a\r\u0002:A)a/!\u000e\u0002\f%!\u0011qGA\u0005\u0005!\u0011Vm]8ve\u000e,\u0007bBA\u001e\u0019\u0001\u000f\u0011QH\u0001\u0010e\u0016\u001cx.\u001e:dK\u000e{g\u000e^3yiB!\u0011qHA!\u001b\t\t\u0019!\u0003\u0003\u0002D\u0005\r!a\u0004*fg>,(oY3D_:$X\r\u001f;\t\u000f\u0005\u001dC\u00021\u0001\u0002(\u000511m\u001c8gS\u001eDQ\u0001\u0014\u0007A\u00025\u000bq\u0003\\8h\u0013:LG/[1mSj\fG/[8o\u0011\u0016\fG-\u001a:\u0015\t\u0005-\u0011q\n\u0005\b\u0003\u000fj\u0001\u0019AA\u0014\u00039\u0011XO\u001c)beRL7-\u001b9b]R$\"\"!\u0016\u0002\u001c\u0006u\u0015qUA^))\t9&a\u001b\u0002n\u0005]\u00141\u0012\t\u0006m\u0006U\u0012\u0011\f\t\u0006E\u0005m\u0013qL\u0005\u0004\u0003;\u001a#AB(qi&|g\u000e\u0005\u0003\u0002b\u0005\u001dTBAA2\u0015\r\t)GG\u0001\u0006a>\u0014Ho]\u0005\u0005\u0003S\n\u0019G\u0001\u0003Q_J$\bbBA\u001e\u001d\u0001\u000f\u0011Q\b\u0005\b\u0003_r\u00019AA9\u00039awnZ4j]\u001e\u001cuN\u001c;fqR\u00042!\\A:\u0013\r\t)H\u001c\u0002\u000f\u0019><w-\u001b8h\u0007>tG/\u001a=u\u0011\u001d\tIH\u0004a\u0002\u0003w\n1\"Y2u_J\u001c\u0016p\u001d;f[B!\u0011QPAD\u001b\t\tyH\u0003\u0003\u0002\u0002\u0006\r\u0015!B1di>\u0014(BAAC\u0003\u0011\t7n[1\n\t\u0005%\u0015q\u0010\u0002\f\u0003\u000e$xN]*zgR,W\u000eC\u0004\u0002\u000e:\u0001\u001d!a$\u0002\u00195\fG/\u001a:jC2L'0\u001a:\u0011\t\u0005E\u0015qS\u0007\u0003\u0003'SA!!&\u0002\u0004\u000611\u000f\u001e:fC6LA!!'\u0002\u0014\naQ*\u0019;fe&\fG.\u001b>fe\"9\u0011q\t\bA\u0002\u0005\u001d\u0002bBAP\u001d\u0001\u0007\u0011\u0011U\u0001\u0012a\u0006\u0014H/[2ja\u0006tGoQ8oM&<\u0007cA#\u0002$&\u0019\u0011Q\u0015$\u0003#A\u000b'\u000f^5dSB\fg\u000e^\"p]\u001aLw\rC\u0004\u0002*:\u0001\r!a+\u0002\u0019MD\u0017M]3e\u000b:<\u0017N\\3\u0011\t\u00055\u0016qW\u0007\u0003\u0003_SA!!-\u00024\u00061QM\\4j]\u0016T1!!.\u001b\u0003\tag-\u0003\u0003\u0002:\u0006=&AB#oO&tW\rC\u0003M\u001d\u0001\u0007Q\n")
public final class Runner<T extends ReadService & WriteService, Extra> {
    public final String com$daml$ledger$participant$state$kvutils$app$Runner$$name;
    private final LedgerFactory<Extra> factory;
    public final ConfigProvider<Extra> com$daml$ledger$participant$state$kvutils$app$Runner$$configProvider;
    public final LedgerFeatures com$daml$ledger$participant$state$kvutils$app$Runner$$ledgerFeatures;
    private final String cleanedName;
    private final ContextualizedLogger logger;

    private String cleanedName() {
        return this.cleanedName;
    }

    private ContextualizedLogger logger() {
        return this.logger;
    }

    public AbstractResourceOwner<ResourceContext, BoxedUnit> owner(Seq<String> args) {
        AbstractResourceOwner abstractResourceOwner = Config$.MODULE$.owner(this.com$daml$ledger$participant$state$kvutils$app$Runner$$name, (Function1 & Serializable)parser -> {
            this.com$daml$ledger$participant$state$kvutils$app$Runner$$configProvider.extraConfigParser(parser);
            return BoxedUnit.UNIT;
        }, this.com$daml$ledger$participant$state$kvutils$app$Runner$$configProvider.defaultExtraConfig(), args);
        return abstractResourceOwner.flatMap((Function1 & Serializable)originalConfig -> this.owner((Config)originalConfig));
    }

    public AbstractResourceOwner<ResourceContext, BoxedUnit> owner(Config<Extra> originalConfig) {
        return new AbstractResourceOwner<ResourceContext, BoxedUnit>(this, originalConfig){
            private final /* synthetic */ Runner $outer;
            private final Config originalConfig$1;

            public Resource<ResourceContext, BoxedUnit> acquire(ResourceContext context) {
                Config config = this.$outer.com$daml$ledger$participant$state$kvutils$app$Runner$$configProvider.manipulateConfig(this.originalConfig$1);
                Mode mode = config.mode();
                if (mode instanceof Mode.DumpIndexMetadata) {
                    Mode.DumpIndexMetadata dumpIndexMetadata = (Mode.DumpIndexMetadata)mode;
                    Vector jdbcUrls = dumpIndexMetadata.jdbcUrls();
                    DumpIndexMetadata$.MODULE$.apply((scala.collection.immutable.Seq)jdbcUrls, this.$outer.com$daml$ledger$participant$state$kvutils$app$Runner$$name, context);
                    throw scala.sys.package$.MODULE$.exit(0);
                }
                if (!Mode.Run$.MODULE$.equals(mode)) {
                    throw new MatchError((Object)mode);
                }
                Resource<ResourceContext, BoxedUnit> resource = this.$outer.run(config, this.$outer.com$daml$ledger$participant$state$kvutils$app$Runner$$ledgerFeatures, context);
                return resource;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.originalConfig$1 = originalConfig$1;
                super((HasExecutionContext)ResourceContext.Context$u0020has$u0020ExecutionContext$.MODULE$);
            }
        };
    }

    public Resource<ResourceContext, BoxedUnit> run(Config<Extra> config, LedgerFeatures ledgerFeatures, ResourceContext resourceContext) {
        ActorSystem actorSystem = ActorSystem$.MODULE$.apply(this.cleanedName());
        Materializer materializer = Materializer$.MODULE$.apply((ClassicActorSystemProvider)actorSystem);
        return (Resource)LoggingContext$.MODULE$.newLoggingContext((Function1 & Serializable)loggingContext -> {
            Resource resource = ResourceOwner$.MODULE$.forActorSystem((Function0 & Serializable)() -> actorSystem).acquire((Object)resourceContext);
            return resource.flatMap((Function1 & Serializable)x$4 -> {
                ActorSystem actorSystem = x$4;
                Resource resource = ResourceOwner$.MODULE$.forMaterializer((Function0 & Serializable)() -> materializer).acquire((Object)resourceContext).map((Function1 & Serializable)x$1 -> {
                    VersionRange x$12 = config.allowedLanguageVersions();
                    boolean x$2 = true;
                    Option x$3 = config.profileDir();
                    boolean x$4 = config.stackTraces();
                    boolean x$5 = EngineConfig$.MODULE$.apply$default$2();
                    ContractKeyUniquenessMode x$6 = EngineConfig$.MODULE$.apply$default$5();
                    boolean x$7 = EngineConfig$.MODULE$.apply$default$7();
                    Limits x$8 = EngineConfig$.MODULE$.apply$default$8();
                    Engine sharedEngine = new Engine(new EngineConfig(x$12, x$5, x$4, x$3, x$6, true, x$7, x$8));
                    return new Tuple2(x$1, (Object)sharedEngine);
                }, (Object)resourceContext);
                Resource resource2 = resource.flatMap((Function1 & Serializable)x$3 -> {
                    Tuple2 tuple2 = x$3;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Engine sharedEngine = (Engine)tuple2._2();
                    Resource resource = package$.MODULE$.Resource().sequenceIgnoringValues((Iterable)config.participants().map((Function1 & Serializable)participantConfig -> this.runParticipant(config, (ParticipantConfig)participantConfig, sharedEngine, ledgerFeatures, resourceContext, (LoggingContext)loggingContext, actorSystem, materializer)), (Object)resourceContext).map((Function1 & Serializable)x$2 -> {
                        Runner.$anonfun$run$8(this, config, x$2);
                        return BoxedUnit.UNIT;
                    }, (Object)resourceContext);
                    return resource;
                }, (Object)resourceContext);
                return resource2;
            }, (Object)resourceContext);
        });
    }

    private void logInitializationHeader(Config<Extra> config) {
        AuthService authService = this.com$daml$ledger$participant$state$kvutils$app$Runner$$configProvider.authService(config);
        String string = authService instanceof AuthServiceJWT ? "JWT-based authentication" : (AuthServiceNone$.MODULE$.equals(authService) ? "none authenticated" : (authService instanceof AuthServiceStatic ? "static authentication" : (AuthServiceWildcard$.MODULE$.equals(authService) ? "all unauthenticated allowed" : authService.getClass().getSimpleName())));
        String authentication = string;
        String participantsInitializationText = ((IterableOnceOps)config.participants().map((Function1 & Serializable)participantConfig -> new StringBuilder(57).append("{participant-id = ").append(participantConfig.participantId()).append(", shared-name = ").append(participantConfig.shardName()).append(", run-mode = ").append(participantConfig.mode()).append(", port = ").append(Port$.MODULE$.toString$extension(participantConfig.port())).append("}").toString())).mkString("[", ", ", "]");
        this.logger().withoutContext().info("Initialized {} version {} with ledger-id = {}, ledger = {}, allowed language versions = {}, authentication = {}, contract ids seeding = {} with participants: {}", new Object[]{this.com$daml$ledger$participant$state$kvutils$app$Runner$$name, BuildInfo$.MODULE$.Version(), config.ledgerId(), this.factory.ledgerName(), new StringBuilder(16).append("[min = ").append(config.allowedLanguageVersions().min()).append(", max = ").append(config.allowedLanguageVersions().max()).append("]").toString(), authentication, config.seeding(), participantsInitializationText});
    }

    public Resource<ResourceContext, Option<Port>> runParticipant(Config<Extra> config, ParticipantConfig participantConfig, Engine sharedEngine, LedgerFeatures ledgerFeatures, ResourceContext resourceContext, LoggingContext loggingContext2, ActorSystem actorSystem, Materializer materializer) {
        return (Resource)LoggingContext$.MODULE$.withEnrichedLoggingContext(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"participantId"), (Object)LoggingValue$.MODULE$.from((Object)participantConfig.participantId(), ToLoggingValue$.MODULE$.String$u0020to$u0020LoggingValue())), (scala.collection.immutable.Seq)Nil$.MODULE$, (Function1 & Serializable)loggingContext -> {
            Metrics metrics = $this.com$daml$ledger$participant$state$kvutils$app$Runner$$configProvider.createMetrics(participantConfig, config);
            metrics.registry().registerAll((MetricSet)new JvmMetricSet());
            LfValueTranslationCache.Cache lfValueTranslationCache = LfValueTranslationCache.Cache$.MODULE$.newInstrumentedInstance(config.lfValueTranslationEventCache(), config.lfValueTranslationContractCache(), metrics);
            Resource resource = (Resource)config.metricsReporter().fold((Function0 & Serializable)() -> package$.MODULE$.Resource().unit(), (Function1 & Serializable)reporter -> ResourceOwner$.MODULE$.forCloseable((Function0 & Serializable)() -> reporter.register(metrics.registry())).map((Function1 & Serializable)x$5 -> {
                x$5.start(config.metricsReportingInterval().getSeconds(), TimeUnit.SECONDS);
                return BoxedUnit.UNIT;
            }).acquire((Object)resourceContext));
            return resource.flatMap((Function1 & Serializable)x$9 -> {
                BoxedUnit boxedUnit = x$9;
                Resource resource = ResourceOwner$.MODULE$.forExecutorService((Function0 & Serializable)() -> new InstrumentedExecutorService(Executors.newWorkStealingPool(), metrics.registry(), MetricName$.MODULE$.toString$extension(metrics.daml().lapi().threadpool().apiServices()))).map((Function1 & Serializable)e -> ExecutionContext$.MODULE$.fromExecutorService(e)).acquire((Object)resourceContext);
                Resource resource2 = resource.flatMap((Function1 & Serializable)servicesExecutionContext -> {
                    Resource resource = $this.factory.readWriteServiceFactoryOwner(config, participantConfig, sharedEngine, metrics, materializer, (ExecutionContext)servicesExecutionContext, (LoggingContext)loggingContext).acquire((Object)resourceContext);
                    return resource.flatMap((Function1 & Serializable)ledgerFactory -> {
                        Resource resource;
                        ParticipantRunMode participantRunMode = participantConfig.mode();
                        boolean bl = ParticipantRunMode.Combined$.MODULE$.equals(participantRunMode) ? true : ParticipantRunMode.Indexer$.MODULE$.equals(participantRunMode);
                        if (bl) {
                            TimedReadService readService = new TimedReadService(ledgerFactory.readService(), metrics);
                            resource = new StandaloneIndexerServer((ReadService)readService, $this.com$daml$ledger$participant$state$kvutils$app$Runner$$configProvider.indexerConfig(participantConfig, config), metrics, lfValueTranslationCache, StandaloneIndexerServer$.MODULE$.$lessinit$greater$default$5(), materializer, loggingContext).acquire(resourceContext).map((Function1 & Serializable)indexerHealth -> new HealthChecks((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"read"), (Object)readService), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"indexer"), indexerHealth)})), (Object)resourceContext);
                        } else if (ParticipantRunMode.LedgerApiServer$.MODULE$.equals(participantRunMode)) {
                            resource = package$.MODULE$.Resource().successful((Object)new HealthChecks((scala.collection.immutable.Seq)Nil$.MODULE$));
                        } else {
                            throw new MatchError((Object)participantRunMode);
                        }
                        Resource resource2 = resource.map((Function1 & Serializable)healthChecksWithIndexer -> {
                            ApiServerConfig apiServerConfig = $this.com$daml$ledger$participant$state$kvutils$app$Runner$$configProvider.apiServerConfig(participantConfig, config);
                            return new Tuple2(healthChecksWithIndexer, (Object)apiServerConfig);
                        }, (Object)resourceContext);
                        return resource2.flatMap((Function1 & Serializable)x$8 -> {
                            Resource resource;
                            Tuple2 tuple2 = x$8;
                            if (tuple2 == null) throw new MatchError((Object)tuple2);
                            HealthChecks healthChecksWithIndexer = (HealthChecks)tuple2._1();
                            ApiServerConfig apiServerConfig = (ApiServerConfig)tuple2._2();
                            ParticipantRunMode participantRunMode = participantConfig.mode();
                            boolean bl = ParticipantRunMode.Combined$.MODULE$.equals(participantRunMode) ? true : ParticipantRunMode.LedgerApiServer$.MODULE$.equals(participantRunMode);
                            if (bl) {
                                Resource resource2 = DbSupport$.MODULE$.owner(apiServerConfig.jdbcUrl(), (ServerRole)ServerRole.ApiServer$.MODULE$, apiServerConfig.databaseConnectionPoolSize(), apiServerConfig.databaseConnectionTimeout(), metrics, loggingContext).acquire((Object)resourceContext).map((Function1 & Serializable)dbSupport -> {
                                    DbSupport x$1 = dbSupport;
                                    Metrics x$2 = metrics;
                                    int x$3 = config.userManagementConfig().cacheExpiryAfterWriteInSeconds();
                                    int x$4 = config.userManagementConfig().maxCacheSize();
                                    int x$5 = UserManagementConfig$.MODULE$.MaxRightsPerUser();
                                    TimeProvider.UTC$ x$6 = TimeProvider.UTC$.MODULE$;
                                    ExecutionContextExecutorService x$7 = servicesExecutionContext;
                                    LoggingContext x$8 = loggingContext;
                                    UserManagementStore userManagementStore = PersistentUserManagementStore$.MODULE$.cached(x$1, x$2, (TimeProvider)x$6, x$3, x$4, x$5, (ExecutionContext)x$7, x$8);
                                    return new Tuple2(dbSupport, (Object)userManagementStore);
                                }, (Object)resourceContext);
                                resource = resource2.flatMap((Function1 & Serializable)x$7 -> {
                                    Tuple2 tuple2 = x$7;
                                    if (tuple2 == null) {
                                        throw new MatchError((Object)tuple2);
                                    }
                                    DbSupport dbSupport = (DbSupport)tuple2._1();
                                    UserManagementStore userManagementStore = (UserManagementStore)tuple2._2();
                                    Resource resource = StandaloneIndexService$.MODULE$.apply(dbSupport, config.ledgerId(), apiServerConfig, metrics, sharedEngine, (ExecutionContextExecutor)servicesExecutionContext, lfValueTranslationCache, materializer, loggingContext).acquire((Object)resourceContext).map((Function1 & Serializable)indexService -> {
                                        KeyValueDeduplicationSupportFactory factory = new KeyValueDeduplicationSupportFactory((ReadWriteServiceFactory)ledgerFactory, (IndexCompletionsService)indexService, (Materializer)Predef$.MODULE$.implicitly((Object)materializer), (ExecutionContext)servicesExecutionContext);
                                        TimedWriteService writeService = new TimedWriteService(factory.writeService(), metrics);
                                        Option timeServiceBackend = $this.com$daml$ledger$participant$state$kvutils$app$Runner$$configProvider.timeServiceBackend(config);
                                        return new Tuple4(indexService, (Object)factory, (Object)writeService, (Object)timeServiceBackend);
                                    }, (Object)resourceContext);
                                    Resource resource2 = resource.flatMap((Function1 & Serializable)x$6 -> {
                                        Tuple4 tuple4 = x$6;
                                        if (tuple4 == null) {
                                            throw new MatchError((Object)tuple4);
                                        }
                                        IndexService indexService = (IndexService)tuple4._1();
                                        TimedWriteService writeService = (TimedWriteService)tuple4._3();
                                        Option timeServiceBackend = (Option)tuple4._4();
                                        IndexService x$9 = indexService;
                                        UserManagementStore x$10 = userManagementStore;
                                        String x$11 = config.ledgerId();
                                        ApiServerConfig x$12 = apiServerConfig;
                                        CommandConfiguration x$13 = config.commandConfig();
                                        PartyConfiguration x$14 = $this.com$daml$ledger$participant$state$kvutils$app$Runner$$configProvider.partyConfig(config);
                                        Some x$15 = new Some((Object)writeService);
                                        AuthService x$16 = $this.com$daml$ledger$participant$state$kvutils$app$Runner$$configProvider.authService(config);
                                        HealthChecks x$17 = healthChecksWithIndexer.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"write"), (Object)writeService));
                                        Metrics x$18 = metrics;
                                        Option x$19 = timeServiceBackend;
                                        List x$20 = $this.com$daml$ledger$participant$state$kvutils$app$Runner$$configProvider.interceptors(config);
                                        Engine x$21 = sharedEngine;
                                        ExecutionContextExecutorService x$22 = servicesExecutionContext;
                                        LedgerFeatures x$23 = ledgerFeatures;
                                        UserManagementConfig x$24 = config.userManagementConfig();
                                        scala.collection.immutable.Seq x$25 = StandaloneApiServer$.MODULE$.apply$default$12();
                                        Function1 x$26 = StandaloneApiServer$.MODULE$.apply$default$16();
                                        Resource resource = StandaloneApiServer$.MODULE$.apply(x$9, x$10, x$11, x$12, x$13, x$14, (Option)x$15, x$16, x$17, x$18, x$19, x$25, x$20, x$21, (ExecutionContextExecutor)x$22, x$26, x$23, x$24, actorSystem, materializer, loggingContext).acquire((Object)resourceContext).map((Function1 & Serializable)apiServer -> new Some((Object)new Port(apiServer.port())), (Object)resourceContext);
                                        return resource;
                                    }, (Object)resourceContext);
                                    return resource2;
                                }, (Object)resourceContext);
                                return resource.map((Function1 & Serializable)port -> port, (Object)resourceContext);
                            } else {
                                if (!ParticipantRunMode.Indexer$.MODULE$.equals(participantRunMode)) throw new MatchError((Object)participantRunMode);
                                resource = package$.MODULE$.Resource().successful((Object)None$.MODULE$);
                            }
                            return resource.map((Function1 & Serializable)port -> port, (Object)resourceContext);
                        }, (Object)resourceContext);
                    }, (Object)resourceContext);
                }, (Object)resourceContext);
                return resource2;
            }, (Object)resourceContext);
        }, loggingContext2);
    }

    public static final /* synthetic */ void $anonfun$run$8(Runner $this, Config config$1, BoxedUnit x$2) {
        BoxedUnit boxedUnit = x$2;
        $this.logInitializationHeader(config$1);
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    public Runner(String name, LedgerFactory<Extra> factory, ConfigProvider<Extra> configProvider, LedgerFeatures ledgerFeatures) {
        this.com$daml$ledger$participant$state$kvutils$app$Runner$$name = name;
        this.factory = factory;
        this.com$daml$ledger$participant$state$kvutils$app$Runner$$configProvider = configProvider;
        this.com$daml$ledger$participant$state$kvutils$app$Runner$$ledgerFeatures = ledgerFeatures;
        this.cleanedName = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("[^A-Za-z0-9_\\-]")).replaceAllIn((CharSequence)name.toLowerCase(), "-");
        this.logger = ContextualizedLogger$.MODULE$.get(this.getClass());
    }
}

