/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.engine.trigger;

import com.daml.ledger.api.v1.value.Enum;
import com.daml.ledger.api.v1.value.GenMap;
import com.daml.ledger.api.v1.value.Identifier;
import com.daml.ledger.api.v1.value.Map;
import com.daml.ledger.api.v1.value.Optional;
import com.daml.ledger.api.v1.value.Record;
import com.daml.ledger.api.v1.value.RecordField;
import com.daml.ledger.api.v1.value.Value;
import com.daml.ledger.api.v1.value.Variant;
import com.daml.lf.data.FrontStack;
import com.daml.lf.data.Ref;
import com.daml.lf.data.Struct$;
import com.daml.lf.data.Time;
import com.daml.lf.language.Ast;
import com.daml.lf.speedy.Pretty$;
import com.daml.lf.speedy.SValue;
import com.daml.lf.value.Value;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.typelevel.paiges.Doc;
import org.typelevel.paiges.Doc$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Seq;
import scala.collection.immutable.TreeMap;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;

public final class PrettyPrint$ {
    public static final PrettyPrint$ MODULE$ = new PrettyPrint$();

    public Doc prettyApiIdentifier(Identifier id) {
        return Doc$.MODULE$.text(id.moduleName()).$plus(Doc$.MODULE$.char(':')).$plus(Doc$.MODULE$.text(id.entityName())).$plus(Doc$.MODULE$.char('@')).$plus(Doc$.MODULE$.text(id.packageId()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Doc prettyApiValue(boolean verbose, Option<Object> maxListWidth, Value v2) {
        Value.Sum$.Map map;
        Map map2;
        Option option;
        Optional optional;
        Value.Sum$.List list;
        com.daml.ledger.api.v1.value.List list2;
        Value.Sum$.Enum enum_;
        Enum enum_2;
        Value.Sum$.Variant variant;
        Variant variant2;
        Value.Sum$.Record record;
        Record record2;
        boolean bl = false;
        Value.Sum$.Optional optional2 = null;
        Value.Sum sum = v2.sum();
        if (Value.Sum$.Empty$.MODULE$.equals(sum)) {
            return Doc$.MODULE$.empty();
        }
        if (sum instanceof Value.Sum$.Int64) {
            Value.Sum$.Int64 int64 = (Value.Sum$.Int64)sum;
            long i = int64.value();
            return Doc$.MODULE$.str((Object)BoxesRunTime.boxToLong((long)i));
        }
        if (sum instanceof Value.Sum$.Numeric) {
            Value.Sum$.Numeric numeric = (Value.Sum$.Numeric)sum;
            String d = numeric.value();
            return Doc$.MODULE$.text(d);
        }
        if (sum instanceof Value.Sum$.Record && (record2 = (record = (Value.Sum$.Record)sum).value()) != null) {
            Doc doc;
            Option mbId = record2.recordId();
            Seq fs = record2.fields();
            Option option2 = mbId;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Identifier id = (Identifier)some.value();
                if (verbose) {
                    doc = this.prettyApiIdentifier(id);
                    return doc.$plus(Doc$.MODULE$.char('{')).$amp(Doc$.MODULE$.fill(Doc$.MODULE$.text(", "), (Iterable)fs.toList().map((Function1 & Serializable)x0$1 -> {
                        RecordField recordField = x0$1;
                        if (recordField != null) {
                            String k = recordField.label();
                            Option option = recordField.value();
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                Value v = (Value)some.value();
                                return Doc$.MODULE$.text(k).$amp(Doc$.MODULE$.char('=')).$amp(MODULE$.prettyApiValue(true, maxListWidth, v));
                            }
                        }
                        return Doc$.MODULE$.empty();
                    }))).$amp(Doc$.MODULE$.char('}'));
                }
            }
            doc = Doc$.MODULE$.empty();
            return doc.$plus(Doc$.MODULE$.char('{')).$amp(Doc$.MODULE$.fill(Doc$.MODULE$.text(", "), (Iterable)fs.toList().map((Function1 & Serializable)x0$1 -> {
                RecordField recordField = x0$1;
                if (recordField != null) {
                    String k = recordField.label();
                    Option option = recordField.value();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Value v = (Value)some.value();
                        return Doc$.MODULE$.text(k).$amp(Doc$.MODULE$.char('=')).$amp(MODULE$.prettyApiValue(true, maxListWidth, v));
                    }
                }
                return Doc$.MODULE$.empty();
            }))).$amp(Doc$.MODULE$.char('}'));
        }
        if (sum instanceof Value.Sum$.Variant && (variant2 = (variant = (Value.Sum$.Variant)sum).value()) != null) {
            Doc doc;
            Option mbId = variant2.variantId();
            String variant3 = variant2.constructor();
            Option value = variant2.value();
            Option option3 = mbId;
            if (option3 instanceof Some) {
                Some some = (Some)option3;
                Identifier id = (Identifier)some.value();
                if (verbose) {
                    doc = this.prettyApiIdentifier(id).$plus(Doc$.MODULE$.char(':'));
                    return doc.$plus(Doc$.MODULE$.text(variant3)).$plus(Doc$.MODULE$.char('(')).$plus((Doc)value.fold((Function0 & Serializable)() -> Doc$.MODULE$.empty(), (Function1 & Serializable)v -> MODULE$.prettyApiValue(true, maxListWidth, (Value)v))).$plus(Doc$.MODULE$.char(')'));
                }
            }
            doc = Doc$.MODULE$.empty();
            return doc.$plus(Doc$.MODULE$.text(variant3)).$plus(Doc$.MODULE$.char('(')).$plus((Doc)value.fold((Function0 & Serializable)() -> Doc$.MODULE$.empty(), (Function1 & Serializable)v -> MODULE$.prettyApiValue(true, maxListWidth, (Value)v))).$plus(Doc$.MODULE$.char(')'));
        }
        if (sum instanceof Value.Sum$.Enum && (enum_2 = (enum_ = (Value.Sum$.Enum)sum).value()) != null) {
            Doc doc;
            Option mbId = enum_2.enumId();
            String constructor = enum_2.constructor();
            Option option4 = mbId;
            if (option4 instanceof Some) {
                Some some = (Some)option4;
                Identifier id = (Identifier)some.value();
                if (verbose) {
                    doc = this.prettyApiIdentifier(id).$plus(Doc$.MODULE$.char(':'));
                    return doc.$plus(Doc$.MODULE$.text(constructor));
                }
            }
            doc = Doc$.MODULE$.empty();
            return doc.$plus(Doc$.MODULE$.text(constructor));
        }
        if (sum instanceof Value.Sum$.Text) {
            Value.Sum$.Text text = (Value.Sum$.Text)sum;
            String t = text.value();
            return Doc$.MODULE$.char('\"').$plus(Doc$.MODULE$.text(t)).$plus(Doc$.MODULE$.char('\"'));
        }
        if (sum instanceof Value.Sum$.ContractId) {
            Value.Sum$.ContractId contractId = (Value.Sum$.ContractId)sum;
            String acoid = contractId.value();
            return Doc$.MODULE$.text(acoid);
        }
        if (sum instanceof Value.Sum$.Unit) {
            return Doc$.MODULE$.text("<unit>");
        }
        if (sum instanceof Value.Sum$.Bool) {
            Value.Sum$.Bool bool = (Value.Sum$.Bool)sum;
            boolean b = bool.value();
            return Doc$.MODULE$.str((Object)BoxesRunTime.boxToBoolean((boolean)b));
        }
        if (sum instanceof Value.Sum$.List && (list2 = (list = (Value.Sum$.List)sum).value()) != null) {
            Seq lst = list2.elements();
            Option<Object> option5 = maxListWidth;
            if (!(option5 instanceof Some)) return Doc$.MODULE$.char('[').$plus(Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), (Iterable)lst.map((Function1 & Serializable)x$2 -> MODULE$.prettyApiValue(true, maxListWidth, (Value)x$2)))).$plus(Doc$.MODULE$.char(']'));
            Some some = (Some)option5;
            int maxWidth = BoxesRunTime.unboxToInt((Object)some.value());
            if (lst.size() <= maxWidth) return Doc$.MODULE$.char('[').$plus(Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), (Iterable)lst.map((Function1 & Serializable)x$2 -> MODULE$.prettyApiValue(true, maxListWidth, (Value)x$2)))).$plus(Doc$.MODULE$.char(']'));
            return Doc$.MODULE$.char('[').$plus(Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), (Iterable)((IterableOps)lst.take(maxWidth)).map((Function1 & Serializable)x$1 -> MODULE$.prettyApiValue(true, maxListWidth, (Value)x$1)))).$plus(Doc$.MODULE$.text(new StringBuilder(27).append(", ...").append(lst.size() - maxWidth).append(" elements truncated...").toString())).$plus(Doc$.MODULE$.char(']'));
        }
        if (sum instanceof Value.Sum$.Timestamp) {
            Value.Sum$.Timestamp timestamp = (Value.Sum$.Timestamp)sum;
            long t = timestamp.value();
            return Doc$.MODULE$.str((Object)BoxesRunTime.boxToLong((long)t));
        }
        if (sum instanceof Value.Sum$.Date) {
            Value.Sum$.Date date = (Value.Sum$.Date)sum;
            int days = date.value();
            return Doc$.MODULE$.str((Object)BoxesRunTime.boxToInteger((int)days));
        }
        if (sum instanceof Value.Sum$.Party) {
            Value.Sum$.Party party = (Value.Sum$.Party)sum;
            String p = party.value();
            return Doc$.MODULE$.char('\'').$plus(Doc$.MODULE$.str((Object)p)).$plus(Doc$.MODULE$.char('\''));
        }
        if (sum instanceof Value.Sum$.Optional) {
            Option option6;
            bl = true;
            optional2 = (Value.Sum$.Optional)sum;
            Optional optional3 = optional2.value();
            if (optional3 != null && (option6 = optional3.value()) instanceof Some) {
                Some some = (Some)option6;
                Value v1 = (Value)some.value();
                return Doc$.MODULE$.text("Option(").$plus(this.prettyApiValue(verbose, maxListWidth, v1)).$plus(Doc$.MODULE$.char(')'));
            }
        }
        if (bl && (optional = optional2.value()) != null && None$.MODULE$.equals(option = optional.value())) {
            return Doc$.MODULE$.text("None");
        }
        if (sum instanceof Value.Sum$.Map && (map2 = (map = (Value.Sum$.Map)sum).value()) != null) {
            Seq entries = map2.entries();
            Seq list3 = (Seq)entries.map((Function1 & Serializable)x0$2 -> {
                Map.Entry entry = x0$2;
                if (entry != null) {
                    String k = entry.key();
                    Option option = entry.value();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Value v = (Value)some.value();
                        return Doc$.MODULE$.text(k).$plus(Doc$.MODULE$.text(" -> ")).$plus(MODULE$.prettyApiValue(verbose, maxListWidth, v));
                    }
                }
                return Doc$.MODULE$.empty();
            });
            return Doc$.MODULE$.text("TextMap(").$plus(Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), (Iterable)list3)).$plus(Doc$.MODULE$.text(")"));
        }
        if (!(sum instanceof Value.Sum$.GenMap)) throw new MatchError((Object)sum);
        Value.Sum$.GenMap genMap = (Value.Sum$.GenMap)sum;
        GenMap genMap2 = genMap.value();
        if (genMap2 == null) throw new MatchError((Object)sum);
        Seq entries = genMap2.entries();
        Seq list4 = (Seq)entries.map((Function1 & Serializable)x0$3 -> {
            GenMap.Entry entry = x0$3;
            if (entry != null) {
                Option option = entry.key();
                Option option2 = entry.value();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Value k = (Value)some.value();
                    if (option2 instanceof Some) {
                        Some some2 = (Some)option2;
                        Value v = (Value)some2.value();
                        return MODULE$.prettyApiValue(verbose, maxListWidth, k).$plus(Doc$.MODULE$.text(" -> ")).$plus(MODULE$.prettyApiValue(verbose, maxListWidth, v));
                    }
                }
            }
            return Doc$.MODULE$.empty();
        });
        return Doc$.MODULE$.text("GenMap(").$plus(Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), (Iterable)list4)).$plus(Doc$.MODULE$.text(")"));
    }

    public Option<Object> prettyApiValue$default$2() {
        return None$.MODULE$;
    }

    public Doc prettySValue(SValue v2) {
        SValue.SBigNumeric sBigNumeric;
        Some some;
        Option option;
        boolean bl = false;
        SValue.SOptional sOptional = null;
        SValue sValue = v2;
        if (sValue instanceof SValue.SPAP) {
            return Doc$.MODULE$.text("...");
        }
        if (sValue instanceof SValue.SRecord) {
            SValue.SRecord sRecord = (SValue.SRecord)sValue;
            return Pretty$.MODULE$.prettyIdentifier(sRecord.id()).$plus(Doc$.MODULE$.char('{')).$amp(Doc$.MODULE$.fill(Doc$.MODULE$.text(", "), (Iterable)((StrictOptimizedIterableOps)sRecord.fields().toSeq().zip((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala((List)sRecord.values()).asScala())).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    SValue v = (SValue)tuple2._2();
                    return Doc$.MODULE$.text(k).$amp(Doc$.MODULE$.char('=')).$amp(MODULE$.prettySValue(v));
                }
                throw new MatchError((Object)tuple2);
            }))).$amp(Doc$.MODULE$.char('}'));
        }
        if (sValue instanceof SValue.SStruct) {
            SValue.SStruct sStruct = (SValue.SStruct)sValue;
            ArraySeq fieldNames = sStruct.fieldNames();
            ArrayList values = sStruct.values();
            return Doc$.MODULE$.char('<').$plus(Doc$.MODULE$.fill(Doc$.MODULE$.text(", "), (Iterable)Struct$.MODULE$.names$extension(fieldNames).zip((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala((List)values).asScala()).toSeq().map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    SValue v = (SValue)tuple2._2();
                    return Doc$.MODULE$.text(k).$plus(Doc$.MODULE$.char('=')).$plus(MODULE$.prettySValue(v));
                }
                throw new MatchError((Object)tuple2);
            }))).$plus(Doc$.MODULE$.char('>'));
        }
        if (sValue instanceof SValue.SVariant) {
            SValue.SVariant sVariant = (SValue.SVariant)sValue;
            Ref.Identifier id = sVariant.id();
            String variant = sVariant.variant();
            SValue value = sVariant.value();
            return Pretty$.MODULE$.prettyIdentifier(id).$plus(Doc$.MODULE$.char(':')).$plus(Doc$.MODULE$.text(variant)).$plus(Doc$.MODULE$.char('(')).$plus(this.prettySValue(value)).$plus(Doc$.MODULE$.char(')'));
        }
        if (sValue instanceof SValue.SEnum) {
            SValue.SEnum sEnum = (SValue.SEnum)sValue;
            Ref.Identifier id = sEnum.id();
            String constructor = sEnum.constructor();
            return Pretty$.MODULE$.prettyIdentifier(id).$plus(Doc$.MODULE$.char(':')).$plus(Doc$.MODULE$.text(constructor));
        }
        if (sValue instanceof SValue.SOptional) {
            bl = true;
            sOptional = (SValue.SOptional)sValue;
            Option option2 = sOptional.value();
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                SValue value = (SValue)some2.value();
                return Doc$.MODULE$.text("Option(").$plus(this.prettySValue(value)).$plus(Doc$.MODULE$.char(')'));
            }
        }
        if (bl && None$.MODULE$.equals(option = sOptional.value())) {
            return Doc$.MODULE$.text("None");
        }
        if (sValue instanceof SValue.SList) {
            SValue.SList sList = (SValue.SList)sValue;
            FrontStack list = sList.list();
            return Doc$.MODULE$.char('[').$plus(Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), (Iterable)list.map((Function1 & Serializable)v -> MODULE$.prettySValue((SValue)v)).toImmArray().toSeq())).$plus(Doc$.MODULE$.char(']'));
        }
        if (sValue instanceof SValue.SMap) {
            SValue.SMap sMap = (SValue.SMap)sValue;
            boolean isTextMap = sMap.isTextMap();
            TreeMap entries = sMap.entries();
            scala.collection.immutable.Iterable list = (scala.collection.immutable.Iterable)entries.map((Function1 & Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    SValue k = (SValue)tuple2._1();
                    SValue v = (SValue)tuple2._2();
                    return MODULE$.prettySValue(k).$plus(Doc$.MODULE$.text(" -> ")).$plus(MODULE$.prettySValue(v));
                }
                throw new MatchError((Object)tuple2);
            });
            return Doc$.MODULE$.text(isTextMap ? "TextMap(" : "GenMap(").$plus(Doc$.MODULE$.intercalate(Doc$.MODULE$.text(", "), (Iterable)list)).$plus(Doc$.MODULE$.text(")"));
        }
        if (sValue instanceof SValue.SAny) {
            SValue.SAny sAny = (SValue.SAny)sValue;
            Ast.Type ty = sAny.ty();
            SValue value = sAny.value();
            return Doc$.MODULE$.text("to_any").$plus(Doc$.MODULE$.char('@')).$plus(Doc$.MODULE$.text(ty.pretty())).$plus(this.prettySValue(value));
        }
        if (sValue instanceof SValue.SInt64) {
            SValue.SInt64 sInt64 = (SValue.SInt64)sValue;
            long value = sInt64.value();
            return Doc$.MODULE$.str((Object)BoxesRunTime.boxToLong((long)value));
        }
        if (sValue instanceof SValue.SNumeric) {
            SValue.SNumeric sNumeric = (SValue.SNumeric)sValue;
            BigDecimal value = sNumeric.value();
            return Doc$.MODULE$.str((Object)value);
        }
        if (sValue instanceof SValue.SBigNumeric && !(some = SValue.SBigNumeric$.MODULE$.unapply(sBigNumeric = (SValue.SBigNumeric)sValue)).isEmpty()) {
            BigDecimal value = (BigDecimal)some.get();
            return Doc$.MODULE$.str((Object)value);
        }
        if (sValue instanceof SValue.SText) {
            SValue.SText sText = (SValue.SText)sValue;
            String value = sText.value();
            return Doc$.MODULE$.text(String.valueOf(value));
        }
        if (sValue instanceof SValue.STimestamp) {
            SValue.STimestamp sTimestamp = (SValue.STimestamp)sValue;
            Time.Timestamp value = sTimestamp.value();
            return Doc$.MODULE$.str((Object)value);
        }
        if (sValue instanceof SValue.SParty) {
            SValue.SParty sParty = (SValue.SParty)sValue;
            String value = sParty.value();
            return Doc$.MODULE$.char('\'').$plus(Doc$.MODULE$.str((Object)value)).$plus(Doc$.MODULE$.char('\''));
        }
        if (sValue instanceof SValue.SBool) {
            SValue.SBool sBool = (SValue.SBool)sValue;
            boolean value = sBool.value();
            return Doc$.MODULE$.str((Object)BoxesRunTime.boxToBoolean((boolean)value));
        }
        if (SValue.SUnit$.MODULE$.equals(sValue)) {
            return Doc$.MODULE$.text("<unit>");
        }
        if (sValue instanceof SValue.SDate) {
            SValue.SDate sDate = (SValue.SDate)sValue;
            Time.Date value = sDate.value();
            return Doc$.MODULE$.str((Object)value);
        }
        if (sValue instanceof SValue.SContractId) {
            SValue.SContractId sContractId = (SValue.SContractId)sValue;
            Value.ContractId value = sContractId.value();
            return Doc$.MODULE$.text(value.coid());
        }
        if (sValue instanceof SValue.STypeRep) {
            SValue.STypeRep sTypeRep = (SValue.STypeRep)sValue;
            Ast.Type ty = sTypeRep.ty();
            return Doc$.MODULE$.text(ty.pretty());
        }
        if (SValue.SToken$.MODULE$.equals(sValue)) {
            return Doc$.MODULE$.text("Token");
        }
        throw new MatchError((Object)sValue);
    }

    private PrettyPrint$() {
    }
}

