/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.engine.trigger;

import com.daml.api.util.TimeProvider;
import com.daml.ledger.api.v1.event.CreatedEvent;
import com.daml.ledger.api.v1.ledger_offset.LedgerOffset;
import com.daml.ledger.client.LedgerClient;
import com.daml.lf.CompiledPackages;
import com.daml.lf.PureCompiledPackages;
import com.daml.lf.PureCompiledPackages$;
import com.daml.lf.archive.Dar;
import com.daml.lf.data.FrontStack;
import com.daml.lf.data.ImmArray;
import com.daml.lf.data.Ref;
import com.daml.lf.engine.trigger.Runner;
import com.daml.lf.engine.trigger.Runner$Implicits$;
import com.daml.lf.engine.trigger.Trigger;
import com.daml.lf.engine.trigger.Trigger$;
import com.daml.lf.engine.trigger.Trigger$Level$High$;
import com.daml.lf.engine.trigger.Trigger$Level$Low$;
import com.daml.lf.engine.trigger.Trigger$Version$;
import com.daml.lf.engine.trigger.TriggerLogContext;
import com.daml.lf.engine.trigger.TriggerParties;
import com.daml.lf.engine.trigger.TriggerRunnerConfig;
import com.daml.lf.language.Ast;
import com.daml.lf.speedy.Compiler;
import com.daml.lf.speedy.SValue;
import com.daml.logging.ContextualizedLogger;
import com.daml.logging.ContextualizedLogger$;
import com.daml.logging.entries.LoggingValue;
import com.daml.logging.entries.LoggingValue$;
import com.daml.logging.entries.ToLoggingValue$;
import com.daml.platform.services.time.TimeProviderType;
import com.daml.script.converter.Converter;
import com.daml.tracing.TelemetryContext;
import com.daml.util.Ctx;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import org.apache.pekko.NotUsed;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeMap$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scalaz.syntax.std.package;

public final class Runner$ {
    public static final Runner$ MODULE$ = new Runner$();
    private static final ContextualizedLogger logger = ContextualizedLogger$.MODULE$.get(MODULE$.getClass());

    public ContextualizedLogger logger() {
        return logger;
    }

    public <In> Flow<Ctx<TriggerLogContext, In>, Ctx<TriggerLogContext, In>, NotUsed> TriggerContextualFlow() {
        return Flow$.MODULE$.apply();
    }

    public Runner apply(CompiledPackages compiledPackages, Trigger trigger, TriggerRunnerConfig triggerConfig, LedgerClient client, TimeProviderType timeProviderType, Object applicationId, TriggerParties parties, TriggerLogContext triggerContext2) {
        return (Runner)triggerContext2.enrichTriggerContext((Seq<Tuple2<String, LoggingValue>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"level"), (Object)LoggingValue$.MODULE$.from((Object)trigger.defn().level().toString(), ToLoggingValue$.MODULE$.String$u0020to$u0020LoggingValue())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)LoggingValue$.MODULE$.from((Object)trigger.defn().version().toString(), ToLoggingValue$.MODULE$.String$u0020to$u0020LoggingValue()))}), (Function1 & Serializable)triggerContext -> new Runner(compiledPackages, trigger, triggerConfig, client, timeProviderType, applicationId, parties, (TriggerLogContext)triggerContext));
    }

    private int mapSize(SValue smap) {
        return BoxesRunTime.unboxToInt((Object)Converter.Implicits$.ErrorOr$u0020ops$.MODULE$.orConverterException$extension(Converter.Implicits$.MODULE$.ErrorOr$u0020ops(Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect((Object)smap), "SMap", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof SValue.SMap) {
                    SValue.SMap sMap = (SValue.SMap)A1;
                    TreeMap values = sMap.entries();
                    return (B1)BoxesRunTime.boxToInteger((int)values.size());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SValue x1) {
                SValue sValue = x1;
                return sValue instanceof SValue.SMap;
            }
        }))));
    }

    private Either<String, SValue> mapLookup(SValue key, SValue smap) {
        return Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect((Object)smap), "SMap", (PartialFunction)new Serializable(key){
            private static final long serialVersionUID = 0L;
            private final SValue key$1;

            public final <A1 extends SValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                SValue.SMap sMap;
                TreeMap entries;
                A1 A1 = x1;
                if (A1 instanceof SValue.SMap && (entries = (sMap = (SValue.SMap)A1).entries()).contains((Object)this.key$1)) {
                    return (B1)entries.apply((Object)this.key$1);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SValue x1) {
                SValue.SMap sMap;
                TreeMap entries;
                SValue sValue = x1;
                return sValue instanceof SValue.SMap && (entries = (sMap = (SValue.SMap)sValue).entries()).contains((Object)this.key$1);
            }
            {
                this.key$1 = key$1;
            }
        });
    }

    public Option<TreeMap<SValue, TreeMap<SValue, SValue>>> getActiveContracts(SValue svalue, Trigger.Level level, Trigger.Version version) {
        boolean bl = false;
        Trigger.Level level2 = null;
        Trigger.Level level3 = level;
        if (Trigger$Level$High$.MODULE$.equals(level3)) {
            bl = true;
            level2 = level3;
            if (version.$less$eq(Trigger$Version$.MODULE$.2$u002E0$u002E0())) {
                return None$.MODULE$;
            }
        }
        if (bl) {
            Either result = Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect((Object)svalue), "SRecord", (PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    SValue.SRecord sRecord;
                    Option option;
                    A1 A1 = x1;
                    if (A1 instanceof SValue.SRecord && !(option = SValue.SRecord$.MODULE$.unapply(sRecord = (SValue.SRecord)A1)).isEmpty()) {
                        ArrayList values = (ArrayList)((Tuple3)option.get())._3();
                        return (B1)values.get(0);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(SValue x1) {
                    SValue.SRecord sRecord;
                    Option option;
                    SValue sValue = x1;
                    return sValue instanceof SValue.SRecord && !(option = SValue.SRecord$.MODULE$.unapply(sRecord = (SValue.SRecord)sValue)).isEmpty();
                }
            }).flatMap((Function1 & Serializable)acs -> Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect(acs), "SRecord", (PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SValue, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    SValue.SRecord sRecord;
                    Option option;
                    A1 A1 = x2;
                    if (A1 instanceof SValue.SRecord && !(option = SValue.SRecord$.MODULE$.unapply(sRecord = (SValue.SRecord)A1)).isEmpty()) {
                        ArrayList values = (ArrayList)((Tuple3)option.get())._3();
                        return (B1)values.get(0);
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(SValue x2) {
                    SValue.SRecord sRecord;
                    Option option;
                    SValue sValue = x2;
                    return sValue instanceof SValue.SRecord && !(option = SValue.SRecord$.MODULE$.unapply(sRecord = (SValue.SRecord)sValue)).isEmpty();
                }
            }).flatMap((Function1 & Serializable)activeContracts -> Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect(activeContracts), "SMap", (PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SValue, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    if (A1 instanceof SValue.SMap) {
                        SValue.SMap sMap = (SValue.SMap)A1;
                        TreeMap values = sMap.entries();
                        return (B1)values;
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(SValue x3) {
                    SValue sValue = x3;
                    return sValue instanceof SValue.SMap;
                }
            }).map((Function1 & Serializable)templateMap -> {
                Iterable contractMap = (Iterable)templateMap.map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        SValue templateId = (SValue)tuple2._1();
                        SValue smap = (SValue)tuple2._2();
                        return Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect((Object)smap), "SMap", (PartialFunction)new Serializable(templateId){
                            private static final long serialVersionUID = 0L;
                            private final SValue templateId$1;

                            public final <A1 extends SValue, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                                A1 A1 = x4;
                                if (A1 instanceof SValue.SMap) {
                                    SValue.SMap sMap = (SValue.SMap)A1;
                                    TreeMap values = sMap.entries();
                                    return (B1)new Tuple2((Object)this.templateId$1, (Object)values);
                                }
                                return (B1)function1.apply(x4);
                            }

                            public final boolean isDefinedAt(SValue x4) {
                                SValue sValue = x4;
                                return sValue instanceof SValue.SMap;
                            }
                            {
                                this.templateId$1 = templateId$1;
                            }
                        });
                    }
                    throw new MatchError((Object)tuple2);
                });
                return new Tuple2(templateMap, (Object)contractMap);
            }).flatMap((Function1 & Serializable)x$19 -> {
                Tuple2 tuple2 = x$19;
                if (tuple2 != null) {
                    Iterable contractMap = (Iterable)tuple2._2();
                    return ((Either)contractMap.foldRight((Object)scala.package$.MODULE$.Right().apply((Object)TreeMap$.MODULE$.empty(SValue.SMap$.MODULE$.SMap$u0020Ordering())), (Function2 & Serializable)(x0$2, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
                        if (tuple2 != null) {
                            Either value = (Either)tuple2._1();
                            Either result = (Either)tuple2._2();
                            return value.flatMap((Function1 & Serializable)entry -> result.map((Function1 & Serializable)res -> {
                                Tuple2 tuple2 = entry;
                                if (tuple2 == null) {
                                    throw new MatchError((Object)tuple2);
                                }
                                SValue tid = (SValue)tuple2._1();
                                TreeMap tmap = (TreeMap)tuple2._2();
                                Tuple3 tuple3 = new Tuple3((Object)tuple2, (Object)tid, (Object)tmap);
                                Tuple2 x$16 = (Tuple2)tuple3._1();
                                SValue tid2 = (SValue)tuple3._2();
                                TreeMap tmap2 = (TreeMap)tuple3._3();
                                return new Tuple2(res, (Object)x$16);
                            }).map((Function1 & Serializable)x$18 -> {
                                Tuple2 tuple2 = x$18;
                                if (tuple2 != null) {
                                    TreeMap res = (TreeMap)tuple2._1();
                                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                                    if (tuple22 != null) {
                                        SValue tid = (SValue)tuple22._1();
                                        TreeMap tmap = (TreeMap)tuple22._2();
                                        return (TreeMap)res.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tid), (Object)tmap));
                                    }
                                }
                                throw new MatchError((Object)tuple2);
                            }));
                        }
                        throw new MatchError((Object)tuple2);
                    })).map((Function1 & Serializable)resultMap -> resultMap);
                }
                throw new MatchError((Object)tuple2);
            })));
            return new Some(Converter.Implicits$.ErrorOr$u0020ops$.MODULE$.orConverterException$extension(Converter.Implicits$.MODULE$.ErrorOr$u0020ops(result)));
        }
        if (Trigger$Level$Low$.MODULE$.equals(level3)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)level3);
    }

    public Option<Object> numberOfActiveContracts(SValue svalue, Trigger.Level level, Trigger.Version version) {
        return this.getActiveContracts(svalue, level, version).map((Function1 & Serializable)x$20 -> BoxesRunTime.boxToInteger((int)Runner$.$anonfun$numberOfActiveContracts$1(x$20)));
    }

    public Option<Object> numberOfPendingContracts(SValue svalue, Trigger.Level level, Trigger.Version version) {
        boolean bl = false;
        Trigger.Level level2 = null;
        Trigger.Level level3 = level;
        if (Trigger$Level$High$.MODULE$.equals(level3)) {
            bl = true;
            level2 = level3;
            if (version.$less$eq(Trigger$Version$.MODULE$.2$u002E0$u002E0())) {
                return None$.MODULE$;
            }
        }
        if (bl) {
            Either result = Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect((Object)svalue), "SRecord", (PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    SValue.SRecord sRecord;
                    Option option;
                    A1 A1 = x1;
                    if (A1 instanceof SValue.SRecord && !(option = SValue.SRecord$.MODULE$.unapply(sRecord = (SValue.SRecord)A1)).isEmpty()) {
                        ArrayList values = (ArrayList)((Tuple3)option.get())._3();
                        return (B1)values.get(0);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(SValue x1) {
                    SValue.SRecord sRecord;
                    Option option;
                    SValue sValue = x1;
                    return sValue instanceof SValue.SRecord && !(option = SValue.SRecord$.MODULE$.unapply(sRecord = (SValue.SRecord)sValue)).isEmpty();
                }
            }).flatMap((Function1 & Serializable)acs -> Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect(acs), "SRecord", (PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SValue, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    ArrayList values;
                    SValue.SRecord sRecord;
                    Option option;
                    A1 A1 = x2;
                    if (A1 instanceof SValue.SRecord && !(option = SValue.SRecord$.MODULE$.unapply(sRecord = (SValue.SRecord)A1)).isEmpty() && (values = (ArrayList)((Tuple3)option.get())._3()).size() >= 1) {
                        return (B1)values.get(1);
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(SValue x2) {
                    ArrayList values;
                    SValue.SRecord sRecord;
                    Option option;
                    SValue sValue = x2;
                    return sValue instanceof SValue.SRecord && !(option = SValue.SRecord$.MODULE$.unapply(sRecord = (SValue.SRecord)sValue)).isEmpty() && (values = (ArrayList)((Tuple3)option.get())._3()).size() >= 1;
                }
            }).flatMap((Function1 & Serializable)pendingContracts -> Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect(pendingContracts), "SMap", (PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SValue, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    if (A1 instanceof SValue.SMap) {
                        SValue.SMap sMap = (SValue.SMap)A1;
                        TreeMap values = sMap.entries();
                        return (B1)BoxesRunTime.boxToInteger((int)values.size());
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(SValue x3) {
                    SValue sValue = x3;
                    return sValue instanceof SValue.SMap;
                }
            }).map((Function1)(JFunction1.mcII.sp & Serializable)size -> size)));
            return new Some(Converter.Implicits$.ErrorOr$u0020ops$.MODULE$.orConverterException$extension(Converter.Implicits$.MODULE$.ErrorOr$u0020ops(result)));
        }
        if (Trigger$Level$Low$.MODULE$.equals(level3)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)level3);
    }

    public Either<String, SValue> getInFlightCommands(SValue svalue) {
        return Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect((Object)svalue), "SRecord", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ArrayList values;
                SValue.SRecord sRecord;
                Option option;
                A1 A1 = x1;
                if (A1 instanceof SValue.SRecord && !(option = SValue.SRecord$.MODULE$.unapply(sRecord = (SValue.SRecord)A1)).isEmpty() && (values = (ArrayList)((Tuple3)option.get())._3()).size() >= 4) {
                    return (B1)values.get(4);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SValue x1) {
                ArrayList values;
                SValue.SRecord sRecord;
                Option option;
                SValue sValue = x1;
                return sValue instanceof SValue.SRecord && !(option = SValue.SRecord$.MODULE$.unapply(sRecord = (SValue.SRecord)sValue)).isEmpty() && (values = (ArrayList)((Tuple3)option.get())._3()).size() >= 4;
            }
        }).map((Function1 & Serializable)inFlightCommands -> inFlightCommands);
    }

    public Option<Object> numberOfInFlightCommands(SValue svalue, Trigger.Level level, Trigger.Version version) {
        boolean bl = false;
        Trigger.Level level2 = null;
        Trigger.Level level3 = level;
        if (Trigger$Level$High$.MODULE$.equals(level3)) {
            bl = true;
            level2 = level3;
            if (version.$less$eq(Trigger$Version$.MODULE$.2$u002E0$u002E0())) {
                return None$.MODULE$;
            }
        }
        if (bl) {
            Either result = this.getInFlightCommands(svalue).map((Function1 & Serializable)inFlightCommands -> BoxesRunTime.boxToInteger((int)Runner$.MODULE$.mapSize(inFlightCommands)));
            return new Some(Converter.Implicits$.ErrorOr$u0020ops$.MODULE$.orConverterException$extension(Converter.Implicits$.MODULE$.ErrorOr$u0020ops(result)));
        }
        if (Trigger$Level$Low$.MODULE$.equals(level3)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)level3);
    }

    private boolean isCreateCommand(SValue svalue) {
        return BoxesRunTime.unboxToBoolean((Object)Converter.Implicits$.ErrorOr$u0020ops$.MODULE$.orConverterException$extension(Converter.Implicits$.MODULE$.ErrorOr$u0020ops(Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect((Object)svalue), "SVariant", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                boolean bl = false;
                SValue.SVariant sVariant = null;
                A1 A1 = x1;
                if (A1 instanceof SValue.SVariant) {
                    bl = true;
                    sVariant = (SValue.SVariant)A1;
                    String string = sVariant.variant();
                    if ("CreateCommand".equals(string)) {
                        return (B1)BoxesRunTime.boxToBoolean((boolean)true);
                    }
                }
                if (bl) {
                    return (B1)BoxesRunTime.boxToBoolean((boolean)false);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SValue x1) {
                boolean bl = false;
                SValue.SVariant sVariant = null;
                SValue sValue = x1;
                if (sValue instanceof SValue.SVariant) {
                    bl = true;
                    sVariant = (SValue.SVariant)sValue;
                    String string = sVariant.variant();
                    if ("CreateCommand".equals(string)) {
                        return true;
                    }
                }
                return bl;
            }
        }))));
    }

    private boolean isCreateAndExerciseCommand(SValue svalue) {
        return BoxesRunTime.unboxToBoolean((Object)Converter.Implicits$.ErrorOr$u0020ops$.MODULE$.orConverterException$extension(Converter.Implicits$.MODULE$.ErrorOr$u0020ops(Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect((Object)svalue), "SVariant", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                boolean bl = false;
                SValue.SVariant sVariant = null;
                A1 A1 = x1;
                if (A1 instanceof SValue.SVariant) {
                    bl = true;
                    sVariant = (SValue.SVariant)A1;
                    String string = sVariant.variant();
                    if ("CreateAndExerciseCommand".equals(string)) {
                        return (B1)BoxesRunTime.boxToBoolean((boolean)true);
                    }
                }
                if (bl) {
                    return (B1)BoxesRunTime.boxToBoolean((boolean)false);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SValue x1) {
                boolean bl = false;
                SValue.SVariant sVariant = null;
                SValue sValue = x1;
                if (sValue instanceof SValue.SVariant) {
                    bl = true;
                    sVariant = (SValue.SVariant)sValue;
                    String string = sVariant.variant();
                    if ("CreateAndExerciseCommand".equals(string)) {
                        return true;
                    }
                }
                return bl;
            }
        }))));
    }

    public Option<Object> numberOfInFlightCreateCommands(SValue commandId, SValue svalue, Trigger.Level level, Trigger.Version version) {
        boolean bl = false;
        Trigger.Level level2 = null;
        Trigger.Level level3 = level;
        if (Trigger$Level$High$.MODULE$.equals(level3)) {
            bl = true;
            level2 = level3;
            if (version.$less$eq(Trigger$Version$.MODULE$.2$u002E0$u002E0())) {
                return None$.MODULE$;
            }
        }
        if (bl) {
            Either result = this.getInFlightCommands(svalue).flatMap((Function1 & Serializable)inFlightCommands -> MODULE$.mapLookup(commandId, (SValue)inFlightCommands).flatMap((Function1 & Serializable)commands -> Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect(commands), "SList", (PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof SValue.SList) {
                        SValue.SList sList = (SValue.SList)A1;
                        FrontStack entries = sList.list();
                        return (B1)entries;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(SValue x1) {
                    SValue sValue = x1;
                    return sValue instanceof SValue.SList;
                }
            }).map((Function1 & Serializable)entries -> BoxesRunTime.boxToInteger((int)Runner$.$anonfun$numberOfInFlightCreateCommands$3(entries)))));
            return new Some(result.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        }
        if (Trigger$Level$Low$.MODULE$.equals(level3)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)level3);
    }

    public SValue com$daml$lf$engine$trigger$Runner$$triggerUserState(SValue state, Trigger.Level level, Trigger.Version version) {
        boolean bl = false;
        Trigger.Level level2 = null;
        Trigger.Level level3 = level;
        if (Trigger$Level$High$.MODULE$.equals(level3)) {
            bl = true;
            level2 = level3;
            if (version.$less$eq(Trigger$Version$.MODULE$.2$u002E0$u002E0())) {
                return state;
            }
        }
        if (bl) {
            return (SValue)Converter.Implicits$.ErrorOr$u0020ops$.MODULE$.orConverterException$extension(Converter.Implicits$.MODULE$.ErrorOr$u0020ops(Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect((Object)state), "SRecord", (PartialFunction)new Serializable(){
                private static final long serialVersionUID = 0L;

                public final <A1 extends SValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    SValue.SRecord sRecord;
                    Option option;
                    A1 A1 = x1;
                    if (A1 instanceof SValue.SRecord && !(option = SValue.SRecord$.MODULE$.unapply(sRecord = (SValue.SRecord)A1)).isEmpty()) {
                        ArrayList values = (ArrayList)((Tuple3)option.get())._3();
                        return (B1)values.get(3);
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(SValue x1) {
                    SValue.SRecord sRecord;
                    Option option;
                    SValue sValue = x1;
                    return sValue instanceof SValue.SRecord && !(option = SValue.SRecord$.MODULE$.unapply(sRecord = (SValue.SRecord)sValue)).isEmpty();
                }
            })));
        }
        if (Trigger$Level$Low$.MODULE$.equals(level3)) {
            return state;
        }
        throw new MatchError((Object)level3);
    }

    public boolean com$daml$lf$engine$trigger$Runner$$isSubmissionFailure(SValue svalue) {
        Either result = Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect((Object)svalue), "SVariant", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof SValue.SVariant) {
                    ArrayList values;
                    SValue.SRecord sRecord;
                    Option option;
                    SValue.SVariant sVariant = (SValue.SVariant)A1;
                    String string = sVariant.variant();
                    SValue sValue = sVariant.value();
                    if ("MCompletion".equals(string) && sValue instanceof SValue.SRecord && !(option = SValue.SRecord$.MODULE$.unapply(sRecord = (SValue.SRecord)sValue)).isEmpty() && (values = (ArrayList)((Tuple3)option.get())._3()).size() >= 1) {
                        return (B1)values.get(1);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SValue x1) {
                SValue sValue = x1;
                if (sValue instanceof SValue.SVariant) {
                    ArrayList values;
                    SValue.SRecord sRecord;
                    Option option;
                    SValue.SVariant sVariant = (SValue.SVariant)sValue;
                    String string = sVariant.variant();
                    SValue sValue2 = sVariant.value();
                    if ("MCompletion".equals(string) && sValue2 instanceof SValue.SRecord && !(option = SValue.SRecord$.MODULE$.unapply(sRecord = (SValue.SRecord)sValue2)).isEmpty() && (values = (ArrayList)((Tuple3)option.get())._3()).size() >= 1) {
                        return true;
                    }
                }
                return false;
            }
        }).flatMap((Function1 & Serializable)values -> Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect(values), "SVariant", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SValue, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                SValue.SVariant sVariant;
                String string;
                A1 A1 = x2;
                if (A1 instanceof SValue.SVariant && "Failed".equals(string = (sVariant = (SValue.SVariant)A1).variant())) {
                    return (B1)BoxesRunTime.boxToBoolean((boolean)true);
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(SValue x2) {
                SValue.SVariant sVariant;
                String string;
                SValue sValue = x2;
                return sValue instanceof SValue.SVariant && "Failed".equals(string = (sVariant = (SValue.SVariant)sValue).variant());
            }
        }).map((Function1 & Serializable)x$22 -> {
            bl = BoxesRunTime.unboxToBoolean((Object)x$22);
            return BoxedUnit.UNIT;
        }));
        return result.isRight();
    }

    public boolean com$daml$lf$engine$trigger$Runner$$isSubmissionSuccess(SValue svalue) {
        Either result = Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect((Object)svalue), "SVariant", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof SValue.SVariant) {
                    ArrayList values;
                    SValue.SRecord sRecord;
                    Option option;
                    SValue.SVariant sVariant = (SValue.SVariant)A1;
                    String string = sVariant.variant();
                    SValue sValue = sVariant.value();
                    if ("MCompletion".equals(string) && sValue instanceof SValue.SRecord && !(option = SValue.SRecord$.MODULE$.unapply(sRecord = (SValue.SRecord)sValue)).isEmpty() && (values = (ArrayList)((Tuple3)option.get())._3()).size() >= 1) {
                        return (B1)values.get(1);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SValue x1) {
                SValue sValue = x1;
                if (sValue instanceof SValue.SVariant) {
                    ArrayList values;
                    SValue.SRecord sRecord;
                    Option option;
                    SValue.SVariant sVariant = (SValue.SVariant)sValue;
                    String string = sVariant.variant();
                    SValue sValue2 = sVariant.value();
                    if ("MCompletion".equals(string) && sValue2 instanceof SValue.SRecord && !(option = SValue.SRecord$.MODULE$.unapply(sRecord = (SValue.SRecord)sValue2)).isEmpty() && (values = (ArrayList)((Tuple3)option.get())._3()).size() >= 1) {
                        return true;
                    }
                }
                return false;
            }
        }).flatMap((Function1 & Serializable)values -> Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect(values), "SVariant", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SValue, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                SValue.SVariant sVariant;
                String string;
                A1 A1 = x2;
                if (A1 instanceof SValue.SVariant && "Succeeded".equals(string = (sVariant = (SValue.SVariant)A1).variant())) {
                    return (B1)BoxesRunTime.boxToBoolean((boolean)true);
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(SValue x2) {
                SValue.SVariant sVariant;
                String string;
                SValue sValue = x2;
                return sValue instanceof SValue.SVariant && "Succeeded".equals(string = (sVariant = (SValue.SVariant)sValue).variant());
            }
        }).map((Function1 & Serializable)x$23 -> {
            bl = BoxesRunTime.unboxToBoolean((Object)x$23);
            return BoxedUnit.UNIT;
        }));
        return result.isRight();
    }

    private boolean isMessage(SValue svalue) {
        return this.com$daml$lf$engine$trigger$Runner$$isTransaction(svalue) || this.isCompletion(svalue) || this.com$daml$lf$engine$trigger$Runner$$isHeartbeat(svalue);
    }

    private boolean isCompletion(SValue svalue) {
        return Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect((Object)svalue), "SVariant", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                SValue.SVariant sVariant;
                String string;
                A1 A1 = x1;
                if (A1 instanceof SValue.SVariant && "MCompletion".equals(string = (sVariant = (SValue.SVariant)A1).variant())) {
                    return (B1)BoxesRunTime.boxToBoolean((boolean)true);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SValue x1) {
                SValue.SVariant sVariant;
                String string;
                SValue sValue = x1;
                return sValue instanceof SValue.SVariant && "MCompletion".equals(string = (sVariant = (SValue.SVariant)sValue).variant());
            }
        }).isRight();
    }

    public boolean com$daml$lf$engine$trigger$Runner$$isTransaction(SValue svalue) {
        return Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect((Object)svalue), "SVariant", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                SValue.SVariant sVariant;
                String string;
                A1 A1 = x1;
                if (A1 instanceof SValue.SVariant && "MTransaction".equals(string = (sVariant = (SValue.SVariant)A1).variant())) {
                    return (B1)BoxesRunTime.boxToBoolean((boolean)true);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SValue x1) {
                SValue.SVariant sVariant;
                String string;
                SValue sValue = x1;
                return sValue instanceof SValue.SVariant && "MTransaction".equals(string = (sVariant = (SValue.SVariant)sValue).variant());
            }
        }).isRight();
    }

    private boolean isCreateEvent(SValue svalue) {
        return Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect((Object)svalue), "SVariant", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                SValue.SVariant sVariant;
                String string;
                A1 A1 = x1;
                if (A1 instanceof SValue.SVariant && "CreatedEvent".equals(string = (sVariant = (SValue.SVariant)A1).variant())) {
                    return (B1)BoxesRunTime.boxToBoolean((boolean)true);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SValue x1) {
                SValue.SVariant sVariant;
                String string;
                SValue sValue = x1;
                return sValue instanceof SValue.SVariant && "CreatedEvent".equals(string = (sVariant = (SValue.SVariant)sValue).variant());
            }
        }).isRight();
    }

    public int com$daml$lf$engine$trigger$Runner$$numberOfCreateEvents(SValue svalue) {
        Either result = Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect((Object)svalue), "SVariant", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof SValue.SVariant) {
                    ArrayList values;
                    SValue.SRecord sRecord;
                    Option option;
                    SValue.SVariant sVariant = (SValue.SVariant)A1;
                    String string = sVariant.variant();
                    SValue sValue = sVariant.value();
                    if ("MTransaction".equals(string) && sValue instanceof SValue.SRecord && !(option = SValue.SRecord$.MODULE$.unapply(sRecord = (SValue.SRecord)sValue)).isEmpty() && (values = (ArrayList)((Tuple3)option.get())._3()).size() >= 2) {
                        return (B1)values.get(2);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SValue x1) {
                SValue sValue = x1;
                if (sValue instanceof SValue.SVariant) {
                    ArrayList values;
                    SValue.SRecord sRecord;
                    Option option;
                    SValue.SVariant sVariant = (SValue.SVariant)sValue;
                    String string = sVariant.variant();
                    SValue sValue2 = sVariant.value();
                    if ("MTransaction".equals(string) && sValue2 instanceof SValue.SRecord && !(option = SValue.SRecord$.MODULE$.unapply(sRecord = (SValue.SRecord)sValue2)).isEmpty() && (values = (ArrayList)((Tuple3)option.get())._3()).size() >= 2) {
                        return true;
                    }
                }
                return false;
            }
        }).flatMap((Function1 & Serializable)values -> Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect(values), "SList", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SValue, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof SValue.SList) {
                    SValue.SList sList = (SValue.SList)A1;
                    FrontStack events = sList.list();
                    return (B1)events.toImmArray();
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(SValue x2) {
                SValue sValue = x2;
                return sValue instanceof SValue.SList;
            }
        }).map((Function1 & Serializable)events -> BoxesRunTime.boxToInteger((int)Runner$.$anonfun$numberOfCreateEvents$2(events))));
        if (this.isMessage(svalue)) {
            return BoxesRunTime.unboxToInt((Object)result.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        }
        return BoxesRunTime.unboxToInt((Object)Converter.Implicits$.ErrorOr$u0020ops$.MODULE$.orConverterException$extension(Converter.Implicits$.MODULE$.ErrorOr$u0020ops(result)));
    }

    private boolean isArchiveEvent(SValue svalue) {
        return Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect((Object)svalue), "SVariant", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                SValue.SVariant sVariant;
                String string;
                A1 A1 = x1;
                if (A1 instanceof SValue.SVariant && "ArchivedEvent".equals(string = (sVariant = (SValue.SVariant)A1).variant())) {
                    return (B1)BoxesRunTime.boxToBoolean((boolean)true);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SValue x1) {
                SValue.SVariant sVariant;
                String string;
                SValue sValue = x1;
                return sValue instanceof SValue.SVariant && "ArchivedEvent".equals(string = (sVariant = (SValue.SVariant)sValue).variant());
            }
        }).isRight();
    }

    public int com$daml$lf$engine$trigger$Runner$$numberOfArchiveEvents(SValue svalue) {
        Either result = Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect((Object)svalue), "SVariant", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof SValue.SVariant) {
                    ArrayList values;
                    SValue.SRecord sRecord;
                    Option option;
                    SValue.SVariant sVariant = (SValue.SVariant)A1;
                    String string = sVariant.variant();
                    SValue sValue = sVariant.value();
                    if ("MTransaction".equals(string) && sValue instanceof SValue.SRecord && !(option = SValue.SRecord$.MODULE$.unapply(sRecord = (SValue.SRecord)sValue)).isEmpty() && (values = (ArrayList)((Tuple3)option.get())._3()).size() >= 2) {
                        return (B1)values.get(2);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SValue x1) {
                SValue sValue = x1;
                if (sValue instanceof SValue.SVariant) {
                    ArrayList values;
                    SValue.SRecord sRecord;
                    Option option;
                    SValue.SVariant sVariant = (SValue.SVariant)sValue;
                    String string = sVariant.variant();
                    SValue sValue2 = sVariant.value();
                    if ("MTransaction".equals(string) && sValue2 instanceof SValue.SRecord && !(option = SValue.SRecord$.MODULE$.unapply(sRecord = (SValue.SRecord)sValue2)).isEmpty() && (values = (ArrayList)((Tuple3)option.get())._3()).size() >= 2) {
                        return true;
                    }
                }
                return false;
            }
        }).flatMap((Function1 & Serializable)values -> Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect(values), "SList", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SValue, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 instanceof SValue.SList) {
                    SValue.SList sList = (SValue.SList)A1;
                    FrontStack events = sList.list();
                    return (B1)events.toImmArray();
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(SValue x2) {
                SValue sValue = x2;
                return sValue instanceof SValue.SList;
            }
        }).map((Function1 & Serializable)events -> BoxesRunTime.boxToInteger((int)Runner$.$anonfun$numberOfArchiveEvents$2(events))));
        if (this.isMessage(svalue)) {
            return BoxesRunTime.unboxToInt((Object)result.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        }
        return BoxesRunTime.unboxToInt((Object)Converter.Implicits$.ErrorOr$u0020ops$.MODULE$.orConverterException$extension(Converter.Implicits$.MODULE$.ErrorOr$u0020ops(result)));
    }

    public boolean com$daml$lf$engine$trigger$Runner$$isHeartbeat(SValue svalue) {
        return Converter.Implicits$.intoOr$u0020and$u0020expect$.MODULE$.expect$extension(Converter.Implicits$.MODULE$.intoOr$u0020and$u0020expect((Object)svalue), "SVariant", (PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends SValue, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                SValue.SVariant sVariant;
                String string;
                A1 A1 = x1;
                if (A1 instanceof SValue.SVariant && "MHeartbeat".equals(string = (sVariant = (SValue.SVariant)A1).variant())) {
                    return (B1)BoxesRunTime.boxToBoolean((boolean)true);
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SValue x1) {
                SValue.SVariant sVariant;
                String string;
                SValue sValue = x1;
                return sValue instanceof SValue.SVariant && "MHeartbeat".equals(string = (sVariant = (SValue.SVariant)sValue).variant());
            }
        }).isRight();
    }

    public FiniteDuration com$daml$lf$engine$trigger$Runner$$overloadedRetryDelay(int afterTries) {
        return new package.DurationInt(package$.MODULE$.DurationInt(250 * (1 << afterTries - 1))).milliseconds();
    }

    public TimeProvider getTimeProvider(TimeProviderType ty) {
        TimeProviderType timeProviderType = ty;
        if (TimeProviderType.Static$.MODULE$.equals(timeProviderType)) {
            return new TimeProvider.Constant(Instant.EPOCH);
        }
        if (TimeProviderType.WallClock$.MODULE$.equals(timeProviderType)) {
            return TimeProvider.UTC$.MODULE$;
        }
        throw new RuntimeException(new StringBuilder(29).append("Unexpected TimeProviderType: ").append(ty).toString());
    }

    public <A, B> Flow<Ctx<TriggerLogContext, A>, Ctx<TriggerLogContext, B>, NotUsed> retrying(int initialTries, Function1<Object, FiniteDuration> backoff, int parallelism, Function1<Ctx<TriggerLogContext, A>, Future<Option<B>>> retryable, Function1<Ctx<TriggerLogContext, A>, Future<B>> notRetryable, ExecutionContext ec) {
        return (Flow)Flow$.MODULE$.apply().mapAsync(parallelism, (Function1 & Serializable)ctx -> (Future)((TriggerLogContext)ctx.context()).childSpan("submission", (Seq<Tuple2<String, LoggingValue>>)Nil$.MODULE$, (Function1 & Serializable)triggerContext -> {
            triggerContext.logDebug("Submitting request to ledger API", (Seq<Tuple2<String, LoggingValue>>)Nil$.MODULE$, MODULE$.logger());
            return Runner$.trial$1(initialTries, ctx.copy(triggerContext, ctx.copy$default$2(), ctx.copy$default$3()), initialTries, notRetryable, ec, retryable, backoff).map((Function1 & Serializable)b -> {
                Object x$1 = b;
                TriggerLogContext x$2 = (TriggerLogContext)ctx.copy$default$1();
                TelemetryContext x$3 = ctx.copy$default$3();
                return ctx.copy((Object)x$2, x$1, x$3);
            }, ec);
        }, MODULE$.logger()));
    }

    public Future<SValue> run(Dar<Tuple2<String, Ast.GenPackage<Ast.Expr>>> dar, Ref.Identifier triggerId, LedgerClient client, TimeProviderType timeProviderType, Object applicationId, TriggerParties parties, Compiler.Config config, TriggerRunnerConfig triggerConfig, Materializer materializer, ExecutionContext executionContext) {
        return (Future)Trigger$.MODULE$.newTriggerLogContext(triggerId, parties.actAs(), parties.readAs(), triggerId.toString(), applicationId, (Function1 & Serializable)triggerContext -> {
            Map darMap = dar.all().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Either either = PureCompiledPackages$.MODULE$.build(darMap, config);
            if (either instanceof Left) {
                Left left = (Left)either;
                String err = (String)left.value();
                throw new RuntimeException(new StringBuilder(28).append("Failed to compile packages: ").append(err).toString());
            }
            if (!(either instanceof Right)) {
                throw new MatchError((Object)either);
            }
            Right right = (Right)either;
            PureCompiledPackages pkgs = (PureCompiledPackages)right.value();
            PureCompiledPackages compiledPackages = pkgs;
            Either<String, Trigger> either2 = Trigger$.MODULE$.fromIdentifier((CompiledPackages)compiledPackages, triggerId, (TriggerLogContext)triggerContext);
            if (either2 instanceof Left) {
                Left left = (Left)either2;
                String err = (String)left.value();
                throw new RuntimeException(new StringBuilder(17).append("Invalid trigger: ").append(err).toString());
            }
            if (!(either2 instanceof Right)) {
                throw new MatchError(either2);
            }
            Right right2 = (Right)either2;
            Trigger trigger = (Trigger)right2.value();
            Trigger trigger2 = trigger;
            Runner runner = MODULE$.apply((CompiledPackages)compiledPackages, trigger2, triggerConfig, client, timeProviderType, applicationId, parties, (TriggerLogContext)triggerContext);
            return runner.queryACS(materializer, executionContext).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)Runner$.$anonfun$run$2(check$ifrefutable$1)), executionContext).flatMap((Function1 & Serializable)x$26 -> {
                Tuple2 tuple2 = x$26;
                if (tuple2 != null) {
                    Seq acs = (Seq)tuple2._1();
                    LedgerOffset offset = (LedgerOffset)tuple2._2();
                    return ((Future)runner.runWithACS((Seq<CreatedEvent>)acs, offset, runner.runWithACS$default$3(), materializer, executionContext)._2()).map((Function1 & Serializable)finalState -> finalState, executionContext);
                }
                throw new MatchError((Object)tuple2);
            }, executionContext);
        });
    }

    public static final /* synthetic */ int $anonfun$numberOfActiveContracts$2(TreeMap x$21) {
        return x$21.values().size();
    }

    public static final /* synthetic */ int $anonfun$numberOfActiveContracts$1(TreeMap x$20) {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)x$20.values().map((Function1 & Serializable)x$21 -> BoxesRunTime.boxToInteger((int)Runner$.$anonfun$numberOfActiveContracts$2(x$21)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$numberOfInFlightCreateCommands$4(SValue cmd) {
        return MODULE$.isCreateCommand(cmd) || MODULE$.isCreateAndExerciseCommand(cmd);
    }

    public static final /* synthetic */ int $anonfun$numberOfInFlightCreateCommands$3(FrontStack entries) {
        return entries.toImmArray().toSeq().count((Function1 & Serializable)cmd -> BoxesRunTime.boxToBoolean((boolean)Runner$.$anonfun$numberOfInFlightCreateCommands$4(cmd)));
    }

    public static final /* synthetic */ int $anonfun$numberOfCreateEvents$2(ImmArray events) {
        return events.filter((Function1 & Serializable)svalue -> BoxesRunTime.boxToBoolean((boolean)Runner$.MODULE$.isCreateEvent(svalue))).length();
    }

    public static final /* synthetic */ int $anonfun$numberOfArchiveEvents$2(ImmArray events) {
        return events.filter((Function1 & Serializable)svalue -> BoxesRunTime.boxToBoolean((boolean)Runner$.MODULE$.isArchiveEvent(svalue))).length();
    }

    private static final Future trial$1(int tries, Ctx value, int initialTries$1, Function1 notRetryable$1, ExecutionContext ec$2, Function1 retryable$1, Function1 backoff$1) {
        return (Future)((TriggerLogContext)value.context()).enrichTriggerContext((Seq<Tuple2<String, LoggingValue>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"max-retries"), (Object)LoggingValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)initialTries$1), ToLoggingValue$.MODULE$.Int$u0020to$u0020LoggingValue()))}), (Function1 & Serializable)triggerContext -> {
            if (tries <= 1) {
                return ((Future)notRetryable$1.apply((Object)value)).recoverWith((PartialFunction)new Serializable((TriggerLogContext)triggerContext, initialTries$1){
                    private static final long serialVersionUID = 0L;
                    private final TriggerLogContext triggerContext$9;
                    private final int initialTries$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 != null) {
                            A1 A12 = A1;
                            this.triggerContext$9.logError("Failing permanently after exhausting submission retries", (Seq<Tuple2<String, LoggingValue>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"attempt"), (Object)LoggingValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)this.initialTries$1), ToLoggingValue$.MODULE$.Int$u0020to$u0020LoggingValue()))}), Runner$.MODULE$.logger());
                            return (B1)Future$.MODULE$.failed(A12);
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        return throwable != null;
                    }
                    {
                        this.triggerContext$9 = triggerContext$9;
                        this.initialTries$1 = initialTries$1;
                    }
                }, ec$2);
            }
            return ((Future)retryable$1.apply((Object)value)).flatMap((Function1 & Serializable)x$24 -> (Future)package.option$.MODULE$.ToOptionOpsFromOption(x$24).cata((Function1 & Serializable)result -> Future$.MODULE$.successful(result), (Function0 & Serializable)() -> Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                int attempt = initialTries$1 - tries + 1;
                FiniteDuration backoffPeriod = (FiniteDuration)backoff$1.apply((Object)BoxesRunTime.boxToInteger((int)attempt));
                triggerContext.logWarning("Submission failed, will retry again after backoff period expires", (Seq<Tuple2<String, LoggingValue>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"attempt"), (Object)LoggingValue$.MODULE$.from((Object)BoxesRunTime.boxToInteger((int)attempt), ToLoggingValue$.MODULE$.Int$u0020to$u0020LoggingValue())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"backoff-period"), (Object)LoggingValue$.MODULE$.from((Object)backoffPeriod, Runner$Implicits$.MODULE$.FiniteDuration$u0020to$u0020LoggingValue()))}), MODULE$.logger());
                Thread.sleep(backoffPeriod.toMillis());
            }, ec$2).flatMap((Function1 & Serializable)x$25 -> Runner$.trial$1(tries - 1, value, initialTries$1, notRetryable$1, ec$2, retryable$1, backoff$1), ec$2)), ec$2);
        });
    }

    public static final /* synthetic */ boolean $anonfun$run$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    private Runner$() {
    }
}

