/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.engine.trigger;

import ch.qos.logback.classic.Level;
import com.daml.auth.TokenHolder;
import com.daml.grpc.adapter.ExecutionSequencerFactory;
import com.daml.grpc.adapter.PekkoExecutionSequencerPool;
import com.daml.grpc.adapter.PekkoExecutionSequencerPool$;
import com.daml.ledger.api.refinements.ApiTypes$;
import com.daml.ledger.client.LedgerClient;
import com.daml.ledger.client.LedgerClient$;
import com.daml.ledger.client.configuration.CommandClientConfiguration;
import com.daml.ledger.client.configuration.CommandClientConfiguration$;
import com.daml.ledger.client.configuration.LedgerClientChannelConfiguration;
import com.daml.ledger.client.configuration.LedgerClientChannelConfiguration$;
import com.daml.ledger.client.configuration.LedgerClientConfiguration;
import com.daml.ledger.client.configuration.LedgerIdRequirement$;
import com.daml.lf.archive.Dar;
import com.daml.lf.archive.package$;
import com.daml.lf.data.Ref;
import com.daml.lf.engine.trigger.LogEncoder;
import com.daml.lf.engine.trigger.LogEncoder$Json$;
import com.daml.lf.engine.trigger.LogEncoder$Plain$;
import com.daml.lf.engine.trigger.Runner$;
import com.daml.lf.engine.trigger.RunnerConfig;
import com.daml.lf.engine.trigger.RunnerConfig$;
import com.daml.lf.engine.trigger.Trigger;
import com.daml.lf.engine.trigger.Trigger$;
import com.daml.lf.engine.trigger.TriggerDefinition;
import com.daml.lf.engine.trigger.TriggerParties;
import com.daml.lf.language.Ast;
import com.daml.lf.language.PackageInterface;
import com.daml.lf.language.PackageInterface$;
import com.daml.platform.services.time.TimeProviderType;
import com.daml.scalautil.Statement$;
import java.io.File;
import java.io.Serializable;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ActorSystem$;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Materializer$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnceOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class RunnerMain$ {
    public static final RunnerMain$ MODULE$ = new RunnerMain$();

    private void listTriggers(File darPath, Dar<Tuple2<String, Ast.GenPackage<Ast.Expr>>> dar, boolean verbose) {
        Predef$.MODULE$.println((Object)new StringBuilder(21).append("Listing triggers in ").append(darPath).append(":").toString());
        PackageInterface pkgInterface = PackageInterface$.MODULE$.apply(dar.all().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Tuple2 tuple2 = (Tuple2)dar.main();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String mainPkgId = (String)tuple2._1();
        Ast.GenPackage mainPkg = (Ast.GenPackage)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)mainPkgId, (Object)mainPkg);
        String mainPkgId2 = (String)tuple22._1();
        Ast.GenPackage mainPkg2 = (Ast.GenPackage)tuple22._2();
        mainPkg2.modules().values().foreach((Function1 & Serializable)mod -> {
            RunnerMain$.$anonfun$listTriggers$1(mainPkgId2, pkgInterface, verbose, mod);
            return BoxedUnit.UNIT;
        });
    }

    public void main(String[] args) {
        Option<RunnerConfig> option = RunnerConfig$.MODULE$.parse(args);
        if (None$.MODULE$.equals(option)) {
            throw scala.sys.package$.MODULE$.exit(1);
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            RunnerConfig config = (RunnerConfig)some.value();
            config.rootLoggingLevel().foreach((Function1 & Serializable)level -> {
                RunnerMain$.MODULE$.setLoggingLevel(level);
                return BoxedUnit.UNIT;
            });
            LogEncoder logEncoder = config.logEncoder();
            if (LogEncoder$Plain$.MODULE$.equals(logEncoder)) {
            } else if (LogEncoder$Json$.MODULE$.equals(logEncoder)) {
                Statement$.MODULE$.discard((Object)System.setProperty("LOG_FORMAT_JSON", "true"));
            } else {
                throw new MatchError((Object)logEncoder);
            }
            Dar dar = package$.MODULE$.DarDecoder().assertReadArchiveFromFile(config.darPath().toFile());
            config.listTriggers().foreach((Function1 & Serializable)verbose -> RunnerMain$.$anonfun$main$2(config, dar, BoxesRunTime.unboxToBoolean((Object)verbose)));
            Ref.Identifier triggerId = new Ref.Identifier((String)((Tuple2)dar.main())._1(), Ref.QualifiedName$.MODULE$.assertFromString(config.triggerIdentifier()));
            ActorSystem system = ActorSystem$.MODULE$.apply("TriggerRunner");
            Materializer materializer = Materializer$.MODULE$.apply((ClassicActorSystemProvider)system);
            PekkoExecutionSequencerPool sequencer = new PekkoExecutionSequencerPool("TriggerRunnerPool", PekkoExecutionSequencerPool$.MODULE$.$lessinit$greater$default$2(), PekkoExecutionSequencerPool$.MODULE$.$lessinit$greater$default$3(), system);
            ExecutionContextExecutor ec = system.dispatcher();
            Option tokenHolder = config.accessTokenFile().map((Function1 & Serializable)x$3 -> new TokenHolder(x$3));
            CommandClientConfiguration qual$1 = CommandClientConfiguration$.MODULE$.default();
            java.time.Duration x$1 = config.commandTtl();
            int x$2 = qual$1.copy$default$1();
            int x$32 = qual$1.copy$default$2();
            LedgerClientConfiguration clientConfig = new LedgerClientConfiguration((String)ApiTypes$.MODULE$.ApplicationId().unwrap(config.applicationId()), LedgerIdRequirement$.MODULE$.none(), qual$1.copy(x$2, x$32, x$1), tokenHolder.flatMap((Function1 & Serializable)x$4 -> x$4.token()));
            Option x$42 = config.tlsConfig().client(config.tlsConfig().client$default$1());
            int x$5 = config.maxInboundMessageSize();
            int x$62 = LedgerClientChannelConfiguration$.MODULE$.apply$default$2();
            LedgerClientChannelConfiguration channelConfig = new LedgerClientChannelConfiguration(x$42, x$62, x$5);
            Future flow = LedgerClient$.MODULE$.singleHost(config.ledgerHost(), config.ledgerPort(), clientConfig, channelConfig, (ExecutionContext)ec, (ExecutionSequencerFactory)sequencer).flatMap(arg_0 -> RunnerMain$.$anonfun$main$5(config, (ExecutionContext)ec, dar, triggerId, materializer, arg_0), (ExecutionContext)ec);
            flow.onComplete((Function1 & Serializable)x$6 -> system.terminate(), (ExecutionContext)ec);
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Await$.MODULE$.result((Awaitable)flow, (Duration)Duration$.MODULE$.Inf());
            return;
        }
        throw new MatchError(option);
    }

    private void setLoggingLevel(Level level) {
        Statement$.MODULE$.discard((Object)System.setProperty("LOG_LEVEL_ROOT", level.levelStr));
    }

    public static final /* synthetic */ void $anonfun$listTriggers$4(boolean verbose$1, Ref.QualifiedName qualifiedName$1, TriggerDefinition x0$1) {
        TriggerDefinition triggerDefinition = x0$1;
        if (triggerDefinition != null) {
            Ast.TypeConApp ty = triggerDefinition.ty();
            Trigger.Version version = triggerDefinition.version();
            Trigger.Level level = triggerDefinition.level();
            if (verbose$1) {
                Predef$.MODULE$.println((Object)new StringBuilder(34).append("  ").append(qualifiedName$1).append("\t(type = ").append(ty.pretty()).append(", level = ").append(level).append(", version = ").append(version).append(")").toString());
                return;
            }
            Predef$.MODULE$.println((Object)new StringBuilder(2).append("  ").append(qualifiedName$1).toString());
            return;
        }
        throw new MatchError((Object)triggerDefinition);
    }

    public static final /* synthetic */ void $anonfun$listTriggers$3(PackageInterface pkgInterface$1, boolean verbose$1, Tuple3 x$2) {
        Tuple3 tuple3 = x$2;
        if (tuple3 != null) {
            Ref.QualifiedName qualifiedName = (Ref.QualifiedName)tuple3._2();
            Ref.Identifier triggerId = (Ref.Identifier)tuple3._3();
            Trigger$.MODULE$.detectTriggerDefinition(pkgInterface$1, triggerId).foreach((Function1 & Serializable)x0$1 -> {
                RunnerMain$.$anonfun$listTriggers$4(verbose$1, qualifiedName, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public static final /* synthetic */ void $anonfun$listTriggers$1(String mainPkgId$1, PackageInterface pkgInterface$1, boolean verbose$1, Ast.GenModule mod) {
        ((IterableOnceOps)mod.definitions().keys().map((Function1 & Serializable)defName -> {
            Ref.QualifiedName qualifiedName = Ref.QualifiedName$.MODULE$.apply(mod.name(), defName);
            Ref.Identifier triggerId = new Ref.Identifier(mainPkgId$1, qualifiedName);
            return new Tuple3(defName, (Object)qualifiedName, (Object)triggerId);
        })).foreach((Function1 & Serializable)x$2 -> {
            RunnerMain$.$anonfun$listTriggers$3(pkgInterface$1, verbose$1, x$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Nothing$ $anonfun$main$2(RunnerConfig config$1, Dar dar$1, boolean verbose) {
        MODULE$.listTriggers(config$1.darPath().toFile(), (Dar<Tuple2<String, Ast.GenPackage<Ast.Expr>>>)dar$1, verbose);
        return scala.sys.package$.MODULE$.exit(0);
    }

    public static final /* synthetic */ Future $anonfun$main$5(RunnerConfig config$1, ExecutionContext ec$1, Dar dar$1, Ref.Identifier triggerId$1, Materializer materializer$1, LedgerClient client) {
        return config$1.ledgerClaims().resolveClaims(client, ec$1).flatMap((Function1 & Serializable)parties -> Runner$.MODULE$.run((Dar<Tuple2<String, Ast.GenPackage<Ast.Expr>>>)dar$1, triggerId$1, client, (TimeProviderType)config$1.timeProviderType().getOrElse((Function0 & Serializable)() -> RunnerConfig$.MODULE$.DefaultTimeProviderType()), config$1.applicationId(), (TriggerParties)parties, config$1.compilerConfigBuilder().build(config$1.majorLanguageVersion()), config$1.triggerConfig(), materializer$1, ec$1).map((Function1 & Serializable)x$5 -> {
            sValue = x$5;
            return BoxedUnit.UNIT;
        }, ec$1), ec$1);
    }

    private RunnerMain$() {
    }
}

