/*
 * Decompiled with CFR 0.152.
 */
package com.daml.lf.engine.trigger;

import com.daml.ledger.api.v1.transaction_filter.Filters;
import com.daml.ledger.api.v1.transaction_filter.InclusiveFilters;
import com.daml.ledger.api.v1.transaction_filter.InclusiveFilters$;
import com.daml.ledger.api.v1.transaction_filter.InterfaceFilter;
import com.daml.lf.CompiledPackages;
import com.daml.lf.data.ImmArray;
import com.daml.lf.data.ImmArray$;
import com.daml.lf.data.Ref;
import com.daml.lf.data.Ref$;
import com.daml.lf.engine.trigger.Converter$;
import com.daml.lf.engine.trigger.Machine$;
import com.daml.lf.engine.trigger.Runner$;
import com.daml.lf.engine.trigger.Runner$Implicits$;
import com.daml.lf.engine.trigger.Trigger;
import com.daml.lf.engine.trigger.Trigger$Level$High$;
import com.daml.lf.engine.trigger.Trigger$Level$Low$;
import com.daml.lf.engine.trigger.Trigger$Version$;
import com.daml.lf.engine.trigger.TriggerDefinition;
import com.daml.lf.engine.trigger.TriggerIds;
import com.daml.lf.engine.trigger.TriggerLogContext;
import com.daml.lf.engine.trigger.TriggerLogContext$;
import com.daml.lf.language.Ast;
import com.daml.lf.language.Ast$;
import com.daml.lf.language.LookupError;
import com.daml.lf.language.PackageInterface;
import com.daml.lf.language.Util;
import com.daml.lf.language.Util$;
import com.daml.lf.speedy.Compiler;
import com.daml.lf.speedy.SExpr;
import com.daml.lf.speedy.SValue;
import com.daml.logging.LoggingContext;
import com.daml.logging.LoggingContextOf$;
import com.daml.logging.entries.LoggingValue;
import com.daml.logging.entries.LoggingValue$;
import com.daml.logging.entries.ToLoggingValue$;
import com.daml.platform.participant.util.LfEngineToApi$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scalaz.Tag$;
import scalaz.syntax.TagOps$;

public final class Trigger$
implements Serializable {
    public static final Trigger$ MODULE$ = new Trigger$();

    public <P, T> T newTriggerLogContext(Ref.Identifier triggerDefinition, Object actAs, Set<Object> readAs, String triggerId, Object applicationId, Function1<TriggerLogContext, T> f) {
        return (T)LoggingContextOf$.MODULE$.newLoggingContext(LoggingContextOf$.MODULE$.label(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"applicationId"), (Object)LoggingValue$.MODULE$.from(TagOps$.MODULE$.unwrap$extension(scalaz.syntax.package$.MODULE$.tag().ToTagOps(applicationId)), ToLoggingValue$.MODULE$.String$u0020to$u0020LoggingValue()))}), (Function1 & Serializable)loggingContext -> TriggerLogContext$.MODULE$.newRootSpan("setup", (Seq<Tuple2<String, LoggingValue>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)LoggingValue$.MODULE$.from((Object)triggerId, ToLoggingValue$.MODULE$.String$u0020to$u0020LoggingValue())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"definition"), (Object)LoggingValue$.MODULE$.from((Object)triggerDefinition, Runner$Implicits$.MODULE$.Identifier$u0020to$u0020LoggingValue())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actAs"), (Object)LoggingValue$.MODULE$.from(Tag$.MODULE$.unwrap(actAs), ToLoggingValue$.MODULE$.String$u0020to$u0020LoggingValue())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"readAs"), (Object)LoggingValue$.MODULE$.from(Tag$.MODULE$.unsubst((Object)readAs), ToLoggingValue$.MODULE$.Iterable$u005BT$u005D$u0020to$u0020LoggingValue(ToLoggingValue$.MODULE$.String$u0020to$u0020LoggingValue())))}), (Function1 & Serializable)triggerContext -> f.apply(triggerContext), (LoggingContext)loggingContext));
    }

    private Either<String, Object> detectHasReadAs(PackageInterface pkgInterface, TriggerIds triggerIds) {
        return pkgInterface.lookupRecordFieldInfo(triggerIds.damlTriggerLowLevel("Trigger"), (String)Ref$.MODULE$.Name().assertFromString("initialState")).left().map((Function1 & Serializable)x$1 -> x$1.pretty()).flatMap((Function1 & Serializable)fieldInfo -> {
            Option option;
            Left left;
            Option option2;
            Ast.Type type = fieldInfo.typDef();
            if (type != null && !(option2 = Util.TFun$.MODULE$.unapply(type)).isEmpty()) {
                Ast.Type type2 = (Ast.Type)((Tuple2)option2.get())._1();
                Ast.Type type3 = (Ast.Type)((Tuple2)option2.get())._2();
                Ast.TBuiltin tBuiltin = Util$.MODULE$.TParty();
                Ast.Type type4 = type2;
                if (!(tBuiltin != null ? !tBuiltin.equals(type4) : type4 != null)) {
                    Option option3;
                    if (type3 != null && !(option3 = Util.TFun$.MODULE$.unapply(type3)).isEmpty()) {
                        Ast.Type type5 = (Ast.Type)((Tuple2)option3.get())._1();
                        Ast.Type type6 = (Ast.Type)((Tuple2)option3.get())._2();
                        if (type5 instanceof Ast.TApp) {
                            Ast.TApp tApp = (Ast.TApp)type5;
                            Option option4 = Util$.MODULE$.TList().unapply(tApp);
                            if (!option4.isEmpty()) {
                                Ast.Type type7 = (Ast.Type)option4.get();
                                Ast.TBuiltin tBuiltin2 = Util$.MODULE$.TParty();
                                Ast.Type type8 = type7;
                                if (!(tBuiltin2 != null ? !tBuiltin2.equals(type8) : type8 != null)) {
                                    Option option5;
                                    if (type6 != null && !(option5 = Util.TFun$.MODULE$.unapply(type6)).isEmpty()) {
                                        left = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                                        return left.map((Function1 & Serializable)hasReadAs -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)hasReadAs)));
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (type != null && !(option = Util.TFun$.MODULE$.unapply(type)).isEmpty()) {
                Ast.Type type9 = (Ast.Type)((Tuple2)option.get())._1();
                Ast.Type type10 = (Ast.Type)((Tuple2)option.get())._2();
                Ast.TBuiltin tBuiltin = Util$.MODULE$.TParty();
                Ast.Type type11 = type9;
                if (!(tBuiltin != null ? !tBuiltin.equals(type11) : type11 != null)) {
                    Option option6;
                    if (type10 != null && !(option6 = Util.TFun$.MODULE$.unapply(type10)).isEmpty()) {
                        left = package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
                        return left.map((Function1 & Serializable)hasReadAs -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)hasReadAs)));
                    }
                }
            }
            left = package$.MODULE$.Left().apply((Object)new StringBuilder(59).append("Internal error: Unexpected type for initialState function: ").append(type).toString());
            return left.map((Function1 & Serializable)hasReadAs -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)hasReadAs)));
        });
    }

    public Either<String, Trigger.Version> detectVersion(PackageInterface pkgInterface, TriggerIds triggerIds) {
        Ref.Identifier versionTypeCon = triggerIds.damlTriggerInternal("Version");
        Either either = pkgInterface.lookupDataEnum(versionTypeCon);
        if (either instanceof Left) {
            return Trigger$Version$.MODULE$.fromString((Option<String>)None$.MODULE$);
        }
        if (either instanceof Right) {
            Option option;
            Right right = (Right)either;
            PackageInterface.DataEnumInfo dataEnumInfo = (PackageInterface.DataEnumInfo)right.value();
            ImmArray immArray = dataEnumInfo.dataEnum().constructors();
            if (immArray != null && !(option = ImmArray$.MODULE$.unapplySeq(immArray)).isEmpty() && option.get() != null && ((IndexedSeqOps)option.get()).lengthCompare(1) == 0) {
                String versionCons = (String)((SeqOps)option.get()).apply(0);
                return Trigger$Version$.MODULE$.fromString((Option<String>)new Some((Object)versionCons));
            }
            return package$.MODULE$.Left().apply((Object)"can not infer trigger version");
        }
        throw new MatchError((Object)either);
    }

    public Either<String, TriggerDefinition> detectTriggerDefinition(PackageInterface pkgInterface, Ref.Identifier triggerId) {
        Some some;
        Ast.GenDValue genDValue;
        boolean bl = false;
        Right right = null;
        Either either = pkgInterface.lookupValue(triggerId);
        if (either instanceof Right) {
            Ast.Type type;
            Some some2;
            bl = true;
            right = (Right)either;
            Ast.GenDValue genDValue2 = (Ast.GenDValue)right.value();
            if (genDValue2 != null && !(some2 = Ast$.MODULE$.DValueSignature().unapply(genDValue2)).isEmpty() && (type = (Ast.Type)((Tuple3)some2.get())._1()) instanceof Ast.TApp) {
                Ast.TApp tApp = (Ast.TApp)type;
                Ast.Type ty = tApp.tyfun();
                Ast.Type tyArg = tApp.arg();
                if (ty instanceof Ast.TTyCon) {
                    Ast.TTyCon tTyCon = (Ast.TTyCon)ty;
                    Ref.Identifier tyCon = tTyCon.tycon();
                    TriggerIds triggerIds = new TriggerIds(tyCon.packageId());
                    return this.detectVersion(pkgInterface, triggerIds).flatMap((Function1 & Serializable)version -> {
                        if (version.$less(Trigger$Version$.MODULE$.2$u002E5$u002E1())) {
                            return Trigger$.fromV20ExtractTriggerDefinition$1(tTyCon, tyArg, triggerIds, version, triggerId);
                        }
                        return Trigger$.fromV251ExtractTriggerDefinition$1(tTyCon, tyArg, triggerIds, version, triggerId);
                    });
                }
            }
        }
        if (bl && (genDValue = (Ast.GenDValue)right.value()) != null && !(some = Ast$.MODULE$.DValueSignature().unapply(genDValue)).isEmpty()) {
            Ast.Type ty = (Ast.Type)((Tuple3)some.get())._1();
            return Trigger$.error$1(triggerId, ty);
        }
        if (either instanceof Left) {
            Left left = (Left)either;
            LookupError err = (LookupError)left.value();
            return package$.MODULE$.Left().apply((Object)err.pretty());
        }
        throw new MatchError((Object)either);
    }

    public Either<String, Trigger> fromIdentifier(CompiledPackages compiledPackages, Ref.Identifier triggerId, TriggerLogContext triggerContext) {
        Compiler compiler = compiledPackages.compiler();
        return this.detectTriggerDefinition(compiledPackages.pkgInterface(), triggerId).flatMap((Function1 & Serializable)triggerDef -> MODULE$.detectHasReadAs(compiledPackages.pkgInterface(), triggerDef.triggerIds()).flatMap((Function1 & Serializable)hasReadAs -> Trigger$.$anonfun$fromIdentifier$2(compiledPackages, compiler, triggerDef, triggerContext, BoxesRunTime.unboxToBoolean((Object)hasReadAs))));
    }

    private Either<String, Option<FiniteDuration>> getTriggerHeartbeat(CompiledPackages compiledPackages, Compiler compiler, TriggerDefinition triggerDef, TriggerLogContext triggerContext) {
        Option option;
        SExpr.SExpr heartbeat = compiler.unsafeCompile((Ast.Expr)new Ast.ERecProj(triggerDef.ty(), (String)Ref$.MODULE$.Name().assertFromString("heartbeat"), triggerDef.expr()));
        boolean bl = false;
        SValue.SOptional sOptional = null;
        SValue sValue = Machine$.MODULE$.stepToValue(compiledPackages, heartbeat, triggerContext);
        if (sValue instanceof SValue.SOptional) {
            bl = true;
            sOptional = (SValue.SOptional)sValue;
            Option option2 = sOptional.value();
            if (None$.MODULE$.equals(option2)) {
                return package$.MODULE$.Right().apply((Object)None$.MODULE$);
            }
        }
        if (bl && (option = sOptional.value()) instanceof Some) {
            Some some = (Some)option;
            SValue relTime = (SValue)some.value();
            return Converter$.MODULE$.toFiniteDuration(relTime).map((Function1 & Serializable)x$2 -> new Some(x$2));
        }
        return package$.MODULE$.Left().apply((Object)new StringBuilder(27).append("Expected Optional but got ").append(sValue).append(".").toString());
    }

    public Either<String, Filters> getTriggerFilter(CompiledPackages compiledPackages, Compiler compiler, TriggerDefinition triggerDef, TriggerLogContext triggerContext) {
        SExpr.SExpr registeredTemplates = compiler.unsafeCompile((Ast.Expr)new Ast.ERecProj(triggerDef.ty(), (String)Ref$.MODULE$.Name().assertFromString("registeredTemplates"), triggerDef.expr()));
        Seq packages = ((IterableOnceOps)compiledPackages.packageIds().map((Function1 & Serializable)pkgId -> new Tuple2(pkgId, compiledPackages.pkgInterface().lookupPackage(pkgId).toOption().get()))).toSeq();
        boolean bl = false;
        SValue.SVariant sVariant = null;
        SValue sValue = Machine$.MODULE$.stepToValue(compiledPackages, registeredTemplates, triggerContext);
        if (sValue instanceof SValue.SVariant) {
            bl = true;
            sVariant = (SValue.SVariant)sValue;
            String allTemplates = sVariant.variant();
            if ("AllInDar".equals(allTemplates) ? true : "AllTemplates".equals(allTemplates)) {
                triggerContext.logWarning(new StringBuilder(177).append("Please avoid the use of ").append(allTemplates).append(" and register against specific templates using RegisteredTemplate - AllInDar and AllTemplates should only be used when developing or testing trigger code").toString(), (Seq<Tuple2<String, LoggingValue>>)Nil$.MODULE$, Runner$.MODULE$.logger());
                return package$.MODULE$.Right().apply((Object)new Filters((Option)new Some((Object)new InclusiveFilters(Trigger$.templateFilter$1((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Trigger$.$anonfun$getTriggerFilter$6(x$3)), packages), Trigger$.interfaceFilter$1((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Trigger$.$anonfun$getTriggerFilter$7(x$4)), packages), InclusiveFilters$.MODULE$.apply$default$3()))));
            }
        }
        if (bl) {
            String string = sVariant.variant();
            SValue v = sVariant.value();
            if ("RegisteredTemplates".equals(string)) {
                Either<String, Seq<Ref.Identifier>> either = Converter$.MODULE$.toRegisteredTemplates(v);
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Seq identifiers = (Seq)right.value();
                    Set set = identifiers.toSet();
                    Function1 & Serializable isRegistered = (Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)set.contains(elem));
                    return package$.MODULE$.Right().apply((Object)new Filters((Option)new Some((Object)new InclusiveFilters(Trigger$.templateFilter$1(isRegistered, packages), Trigger$.interfaceFilter$1(isRegistered, packages), InclusiveFilters$.MODULE$.apply$default$3()))));
                }
                if (either instanceof Left) {
                    Left left = (Left)either;
                    String err = (String)left.value();
                    return package$.MODULE$.Left().apply((Object)err);
                }
                throw new MatchError(either);
            }
        }
        return package$.MODULE$.Left().apply((Object)new StringBuilder(65).append("Expected AllInDar or AllTemplates or RegisteredTemplates but got ").append(sValue).toString());
    }

    public Trigger apply(TriggerDefinition defn, Filters filters, Option<FiniteDuration> heartbeat, boolean hasReadAs) {
        return new Trigger(defn, filters, heartbeat, hasReadAs);
    }

    public Option<Tuple4<TriggerDefinition, Filters, Option<FiniteDuration>, Object>> unapply(Trigger x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple4((Object)x$0.defn(), (Object)x$0.filters(), x$0.heartbeat(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.hasReadAs())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Trigger$.class);
    }

    private static final Left error$1(Ref.Identifier triggerId, Ast.Type ty) {
        TriggerIds triggerIds = new TriggerIds((String)Ref$.MODULE$.PackageId().assertFromString("-"));
        Ast.TTyCon highLevelTrigger = new Ast.TTyCon(triggerIds.damlTrigger("Trigger"));
        Ast.TTyCon lowLevelTrigger = new Ast.TTyCon(triggerIds.damlTriggerLowLevel("Trigger"));
        Ast.TVar a = new Ast.TVar((String)Ref$.MODULE$.Name().assertFromString("a"));
        return package$.MODULE$.Left().apply((Object)new StringBuilder(97).append("the definition ").append(triggerId).append(" does not have valid trigger type: ").append("expected a type of the form ").append("(").append(new Ast.TApp((Ast.Type)highLevelTrigger, (Ast.Type)a).pretty()).append(") or (").append(new Ast.TApp((Ast.Type)lowLevelTrigger, (Ast.Type)a).pretty()).append(") ").append("but got (").append(ty.pretty()).append(")").toString());
    }

    private static final Either fromV20ExtractTriggerDefinition$1(Ast.TTyCon ty, Ast.Type tyArg, TriggerIds triggerIds, Trigger.Version version, Ref.Identifier triggerId$2) {
        Ref.Identifier tyCon;
        Ref.Identifier identifier = tyCon = ty.tycon();
        Ref.Identifier identifier2 = triggerIds.damlTriggerLowLevel("Trigger");
        if (!(identifier != null ? !identifier.equals(identifier2) : identifier2 != null)) {
            Ast.EVal expr = new Ast.EVal(triggerId$2);
            Ast.TypeConApp ty2 = new Ast.TypeConApp(tyCon, (ImmArray)ImmArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{tyArg})));
            return package$.MODULE$.Right().apply((Object)new TriggerDefinition(triggerId$2, ty2, version, Trigger$Level$Low$.MODULE$, (Ast.Expr)expr));
        }
        Ref.Identifier identifier3 = tyCon;
        Ref.Identifier identifier4 = triggerIds.damlTrigger("Trigger");
        if (!(identifier3 != null ? !identifier3.equals(identifier4) : identifier4 != null)) {
            Ast.EVal runTrigger = new Ast.EVal(triggerIds.damlTrigger("runTrigger"));
            Ast.EApp expr = new Ast.EApp((Ast.Expr)runTrigger, (Ast.Expr)new Ast.EVal(triggerId$2));
            Ast.TTyCon triggerState = new Ast.TTyCon(triggerIds.damlTriggerInternal("TriggerState"));
            Ast.TApp stateTy = new Ast.TApp((Ast.Type)triggerState, tyArg);
            Ref.Identifier lowLevelTriggerTy = triggerIds.damlTriggerLowLevel("Trigger");
            Ast.TypeConApp ty3 = new Ast.TypeConApp(lowLevelTriggerTy, (ImmArray)ImmArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TApp[]{stateTy})));
            return package$.MODULE$.Right().apply((Object)new TriggerDefinition(triggerId$2, ty3, version, Trigger$Level$High$.MODULE$, (Ast.Expr)expr));
        }
        return Trigger$.error$1(triggerId$2, (Ast.Type)ty);
    }

    private static final Either fromV251ExtractTriggerDefinition$1(Ast.TTyCon ty, Ast.Type tyArg, TriggerIds triggerIds, Trigger.Version version, Ref.Identifier triggerId$2) {
        Ref.Identifier tyCon;
        Ref.Identifier identifier = tyCon = ty.tycon();
        Ref.Identifier identifier2 = triggerIds.damlTriggerLowLevel("BatchTrigger");
        if (!(identifier != null ? !identifier.equals(identifier2) : identifier2 != null)) {
            Ast.EVal expr = new Ast.EVal(triggerId$2);
            Ast.TypeConApp ty2 = new Ast.TypeConApp(tyCon, (ImmArray)ImmArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.Type[]{tyArg})));
            return package$.MODULE$.Right().apply((Object)new TriggerDefinition(triggerId$2, ty2, version, Trigger$Level$Low$.MODULE$, (Ast.Expr)expr));
        }
        Ref.Identifier identifier3 = tyCon;
        Ref.Identifier identifier4 = triggerIds.damlTriggerLowLevel("Trigger");
        if (!(identifier3 != null ? !identifier3.equals(identifier4) : identifier4 != null)) {
            Ast.EVal runTrigger = new Ast.EVal(triggerIds.damlTriggerInternal("runLegacyTrigger"));
            Ast.EApp expr = new Ast.EApp((Ast.Expr)runTrigger, (Ast.Expr)new Ast.EVal(triggerId$2));
            Ast.TTyCon triggerState = new Ast.TTyCon(triggerIds.damlTriggerInternal("TriggerState"));
            Ast.TApp stateTy = new Ast.TApp((Ast.Type)triggerState, tyArg);
            Ref.Identifier lowLevelTriggerTy = triggerIds.damlTriggerLowLevel("Trigger");
            Ast.TypeConApp ty3 = new Ast.TypeConApp(lowLevelTriggerTy, (ImmArray)ImmArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TApp[]{stateTy})));
            return package$.MODULE$.Right().apply((Object)new TriggerDefinition(triggerId$2, ty3, version, Trigger$Level$Low$.MODULE$, (Ast.Expr)expr));
        }
        Ref.Identifier identifier5 = tyCon;
        Ref.Identifier identifier6 = triggerIds.damlTrigger("Trigger");
        if (!(identifier5 != null ? !identifier5.equals(identifier6) : identifier6 != null)) {
            Ast.EVal runTrigger = new Ast.EVal(triggerIds.damlTrigger("runTrigger"));
            Ast.EApp expr = new Ast.EApp((Ast.Expr)runTrigger, (Ast.Expr)new Ast.EVal(triggerId$2));
            Ast.TTyCon triggerState = new Ast.TTyCon(triggerIds.damlTriggerInternal("TriggerState"));
            Ast.TApp stateTy = new Ast.TApp((Ast.Type)triggerState, tyArg);
            Ref.Identifier lowLevelTriggerTy = triggerIds.damlTriggerLowLevel("Trigger");
            Ast.TypeConApp ty4 = new Ast.TypeConApp(lowLevelTriggerTy, (ImmArray)ImmArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast.TApp[]{stateTy})));
            return package$.MODULE$.Right().apply((Object)new TriggerDefinition(triggerId$2, ty4, version, Trigger$Level$High$.MODULE$, (Ast.Expr)expr));
        }
        return Trigger$.error$1(triggerId$2, (Ast.Type)ty);
    }

    public static final /* synthetic */ Either $anonfun$fromIdentifier$2(CompiledPackages compiledPackages$1, Compiler compiler$1, TriggerDefinition triggerDef$1, TriggerLogContext triggerContext$1, boolean hasReadAs) {
        return MODULE$.getTriggerFilter(compiledPackages$1, compiler$1, triggerDef$1, triggerContext$1).flatMap((Function1 & Serializable)filter -> MODULE$.getTriggerHeartbeat(compiledPackages$1, compiler$1, triggerDef$1, triggerContext$1).map((Function1 & Serializable)heartbeat -> new Trigger(triggerDef$1, (Filters)filter, (Option<FiniteDuration>)heartbeat, hasReadAs)));
    }

    private static final Seq templateFilter$1(Function1 isRegistered, Seq packages$1) {
        return (Seq)packages$1.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String pkgId = (String)tuple2._1();
                Ast.GenPackage pkg = (Ast.GenPackage)tuple2._2();
                return pkg.modules().toList().flatMap((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        Ref.DottedName modName = (Ref.DottedName)tuple2._1();
                        Ast.GenModule module = (Ast.GenModule)tuple2._2();
                        return (Iterable)module.templates().keys().collect((PartialFunction)new Serializable(isRegistered, pkgId, modName){
                            private static final long serialVersionUID = 0L;
                            private final Function1 isRegistered$1;
                            private final String pkgId$1;
                            private final Ref.DottedName modName$1;

                            public final <A1 extends Ref.DottedName, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                if (BoxesRunTime.unboxToBoolean((Object)this.isRegistered$1.apply((Object)new Ref.Identifier(this.pkgId$1, Ref.QualifiedName$.MODULE$.apply(this.modName$1, A1))))) {
                                    return (B1)LfEngineToApi$.MODULE$.toApiIdentifier(new Ref.Identifier(this.pkgId$1, Ref.QualifiedName$.MODULE$.apply(this.modName$1, A1)));
                                }
                                return (B1)function1.apply(x1);
                            }

                            public final boolean isDefinedAt(Ref.DottedName x1) {
                                Ref.DottedName dottedName = x1;
                                return BoxesRunTime.unboxToBoolean((Object)this.isRegistered$1.apply((Object)new Ref.Identifier(this.pkgId$1, Ref.QualifiedName$.MODULE$.apply(this.modName$1, dottedName))));
                            }
                            {
                                this.isRegistered$1 = isRegistered$1;
                                this.pkgId$1 = pkgId$1;
                                this.modName$1 = modName$1;
                            }
                        });
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private static final Seq interfaceFilter$1(Function1 isRegistered, Seq packages$1) {
        return (Seq)packages$1.flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String pkgId = (String)tuple2._1();
                Ast.GenPackage pkg = (Ast.GenPackage)tuple2._2();
                return pkg.modules().toList().flatMap((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        Ref.DottedName modName = (Ref.DottedName)tuple2._1();
                        Ast.GenModule module = (Ast.GenModule)tuple2._2();
                        return (Iterable)module.interfaces().keys().collect((PartialFunction)new Serializable(isRegistered, pkgId, modName){
                            private static final long serialVersionUID = 0L;
                            private final Function1 isRegistered$2;
                            private final String pkgId$2;
                            private final Ref.DottedName modName$2;

                            public final <A1 extends Ref.DottedName, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                A1 A1 = x1;
                                if (BoxesRunTime.unboxToBoolean((Object)this.isRegistered$2.apply((Object)new Ref.Identifier(this.pkgId$2, Ref.QualifiedName$.MODULE$.apply(this.modName$2, A1))))) {
                                    return (B1)new InterfaceFilter((Option)new Some((Object)LfEngineToApi$.MODULE$.toApiIdentifier(new Ref.Identifier(this.pkgId$2, Ref.QualifiedName$.MODULE$.apply(this.modName$2, A1)))), true, false);
                                }
                                return (B1)function1.apply(x1);
                            }

                            public final boolean isDefinedAt(Ref.DottedName x1) {
                                Ref.DottedName dottedName = x1;
                                return BoxesRunTime.unboxToBoolean((Object)this.isRegistered$2.apply((Object)new Ref.Identifier(this.pkgId$2, Ref.QualifiedName$.MODULE$.apply(this.modName$2, dottedName))));
                            }
                            {
                                this.isRegistered$2 = isRegistered$2;
                                this.pkgId$2 = pkgId$2;
                                this.modName$2 = modName$2;
                            }
                        });
                    }
                    throw new MatchError((Object)tuple2);
                });
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public static final /* synthetic */ boolean $anonfun$getTriggerFilter$6(Ref.Identifier x$3) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$getTriggerFilter$7(Ref.Identifier x$4) {
        return true;
    }

    private Trigger$() {
    }
}

