/*
 * Decompiled with CFR 0.152.
 */
package com.danielasfregola.twitter4s.http.clients.rest.friendships;

import com.danielasfregola.twitter4s.entities.LookupRelationship;
import com.danielasfregola.twitter4s.entities.Relationship;
import com.danielasfregola.twitter4s.entities.User;
import com.danielasfregola.twitter4s.entities.UserIds;
import com.danielasfregola.twitter4s.entities.UserStringifiedIds;
import com.danielasfregola.twitter4s.http.clients.rest.friendships.TwitterFriendshipClient;
import com.danielasfregola.twitter4s.http.clients.rest.friendships.parameters.BlockedParameters;
import com.danielasfregola.twitter4s.http.clients.rest.friendships.parameters.DeviceNotificationParameters;
import com.danielasfregola.twitter4s.http.clients.rest.friendships.parameters.FollowParameters;
import com.danielasfregola.twitter4s.http.clients.rest.friendships.parameters.FriendshipParameters;
import com.danielasfregola.twitter4s.http.clients.rest.friendships.parameters.NotificationParameters;
import com.danielasfregola.twitter4s.http.clients.rest.friendships.parameters.RelationshipParameters;
import com.danielasfregola.twitter4s.http.clients.rest.friendships.parameters.RelationshipParametersByIds;
import com.danielasfregola.twitter4s.http.clients.rest.friendships.parameters.RelationshipParametersByNames;
import com.danielasfregola.twitter4s.http.clients.rest.friendships.parameters.RelationshipsParameters;
import com.danielasfregola.twitter4s.http.clients.rest.friendships.parameters.RetweetNotificationParameters;
import com.danielasfregola.twitter4s.http.clients.rest.friendships.parameters.UnfollowParameters;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public abstract class TwitterFriendshipClient$class {
    public static Future getNoRetweetsUserIds(TwitterFriendshipClient $this) {
        BlockedParameters parameters = new BlockedParameters(false);
        return TwitterFriendshipClient$class.genericGetNoRetweetsUserIds($this, parameters, ManifestFactory$.MODULE$.classType(Seq.class, (Manifest)ManifestFactory$.MODULE$.Long(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
    }

    public static Future getNoRetweetsUserStringifiedIds(TwitterFriendshipClient $this) {
        BlockedParameters parameters = new BlockedParameters(true);
        return TwitterFriendshipClient$class.genericGetNoRetweetsUserIds($this, parameters, ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
    }

    private static Future genericGetNoRetweetsUserIds(TwitterFriendshipClient $this, BlockedParameters parameters, Manifest evidence$1) {
        return $this.RichHttpRequest($this.Get().apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/no_retweets/ids.json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.com$danielasfregola$twitter4s$http$clients$rest$friendships$TwitterFriendshipClient$$friendshipsUrl()})), parameters)).respondAs(evidence$1);
    }

    public static Future getIncomingFriendshipIds(TwitterFriendshipClient $this, long cursor) {
        FriendshipParameters parameters = new FriendshipParameters(cursor, false);
        return TwitterFriendshipClient$class.genericGetIncomingFriendships($this, parameters, ManifestFactory$.MODULE$.classType(UserIds.class));
    }

    public static long getIncomingFriendshipIds$default$1(TwitterFriendshipClient $this) {
        return -1L;
    }

    public static Future getIncomingFriendshipStringifiedIds(TwitterFriendshipClient $this, long cursor) {
        FriendshipParameters parameters = new FriendshipParameters(cursor, true);
        return TwitterFriendshipClient$class.genericGetIncomingFriendships($this, parameters, ManifestFactory$.MODULE$.classType(UserStringifiedIds.class));
    }

    public static long getIncomingFriendshipStringifiedIds$default$1(TwitterFriendshipClient $this) {
        return -1L;
    }

    private static Future genericGetIncomingFriendships(TwitterFriendshipClient $this, FriendshipParameters parameters, Manifest evidence$2) {
        return $this.RichHttpRequest($this.Get().apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/incoming.json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.com$danielasfregola$twitter4s$http$clients$rest$friendships$TwitterFriendshipClient$$friendshipsUrl()})), parameters)).respondAs(evidence$2);
    }

    public static Future getOutgoingFriendshipIds(TwitterFriendshipClient $this, long cursor) {
        FriendshipParameters parameters = new FriendshipParameters(cursor, false);
        return TwitterFriendshipClient$class.getGenericOutgoingFriendships($this, parameters, ManifestFactory$.MODULE$.classType(UserIds.class));
    }

    public static long getOutgoingFriendshipIds$default$1(TwitterFriendshipClient $this) {
        return -1L;
    }

    public static Future getOutgoingFriendshipStringifiedIds(TwitterFriendshipClient $this, long cursor) {
        FriendshipParameters parameters = new FriendshipParameters(cursor, true);
        return TwitterFriendshipClient$class.getGenericOutgoingFriendships($this, parameters, ManifestFactory$.MODULE$.classType(UserStringifiedIds.class));
    }

    public static long getOutgoingFriendshipStringifiedIds$default$1(TwitterFriendshipClient $this) {
        return -1L;
    }

    private static Future getGenericOutgoingFriendships(TwitterFriendshipClient $this, FriendshipParameters parameters, Manifest evidence$3) {
        return $this.RichHttpRequest($this.Get().apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/outgoing.json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.com$danielasfregola$twitter4s$http$clients$rest$friendships$TwitterFriendshipClient$$friendshipsUrl()})), parameters)).respondAs(evidence$3);
    }

    public static Future followUserId(TwitterFriendshipClient $this, long user_id, boolean notify) {
        FollowParameters parameters = new FollowParameters((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)user_id)), (Option<String>)None$.MODULE$, notify);
        return TwitterFriendshipClient$class.genericFollow($this, parameters);
    }

    public static Future followUser(TwitterFriendshipClient $this, String screen_name, boolean notify) {
        FollowParameters parameters = new FollowParameters((Option<Object>)None$.MODULE$, (Option<String>)new Some((Object)screen_name), notify);
        return TwitterFriendshipClient$class.genericFollow($this, parameters);
    }

    public static boolean followUserId$default$2(TwitterFriendshipClient $this) {
        return true;
    }

    public static boolean followUser$default$2(TwitterFriendshipClient $this) {
        return true;
    }

    private static Future genericFollow(TwitterFriendshipClient $this, FollowParameters parameters) {
        return $this.RichHttpRequest($this.Post().apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/create.json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.com$danielasfregola$twitter4s$http$clients$rest$friendships$TwitterFriendshipClient$$friendshipsUrl()})), parameters)).respondAs(ManifestFactory$.MODULE$.classType(User.class));
    }

    public static Future unfollowUserId(TwitterFriendshipClient $this, long user_id) {
        UnfollowParameters parameters = new UnfollowParameters((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)user_id)), (Option<String>)None$.MODULE$);
        return TwitterFriendshipClient$class.genericUnfollow($this, parameters);
    }

    public static Future unfollowUser(TwitterFriendshipClient $this, String screen_name) {
        UnfollowParameters parameters = new UnfollowParameters((Option<Object>)None$.MODULE$, (Option<String>)new Some((Object)screen_name));
        return TwitterFriendshipClient$class.genericUnfollow($this, parameters);
    }

    private static Future genericUnfollow(TwitterFriendshipClient $this, UnfollowParameters parameters) {
        return $this.RichHttpRequest($this.Post().apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/destroy.json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.com$danielasfregola$twitter4s$http$clients$rest$friendships$TwitterFriendshipClient$$friendshipsUrl()})), parameters)).respondAs(ManifestFactory$.MODULE$.classType(User.class));
    }

    public static Future enableRetweetsNotificationsForUser(TwitterFriendshipClient $this, String screen_name) {
        RetweetNotificationParameters parameters = new RetweetNotificationParameters((Option<Object>)None$.MODULE$, (Option<String>)new Some((Object)screen_name), true);
        return TwitterFriendshipClient$class.genericNotifications($this, parameters);
    }

    public static Future enableRetweetsNotificationsForUserId(TwitterFriendshipClient $this, long user_id) {
        RetweetNotificationParameters parameters = new RetweetNotificationParameters((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)user_id)), (Option<String>)None$.MODULE$, true);
        return TwitterFriendshipClient$class.genericNotifications($this, parameters);
    }

    public static Future disableRetweetsNotificationsForUser(TwitterFriendshipClient $this, String screen_name) {
        RetweetNotificationParameters parameters = new RetweetNotificationParameters((Option<Object>)None$.MODULE$, (Option<String>)new Some((Object)screen_name), false);
        return TwitterFriendshipClient$class.genericNotifications($this, parameters);
    }

    public static Future disableRetweetsNotificationsForUserId(TwitterFriendshipClient $this, long user_id) {
        RetweetNotificationParameters parameters = new RetweetNotificationParameters((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)user_id)), (Option<String>)None$.MODULE$, false);
        return TwitterFriendshipClient$class.genericNotifications($this, parameters);
    }

    public static Future enableDeviceNotificationsForUser(TwitterFriendshipClient $this, String screen_name) {
        DeviceNotificationParameters parameters = new DeviceNotificationParameters((Option<Object>)None$.MODULE$, (Option<String>)new Some((Object)screen_name), true);
        return TwitterFriendshipClient$class.genericNotifications($this, parameters);
    }

    public static Future enableDeviceNotificationsForUserId(TwitterFriendshipClient $this, long user_id) {
        DeviceNotificationParameters parameters = new DeviceNotificationParameters((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)user_id)), (Option<String>)None$.MODULE$, true);
        return TwitterFriendshipClient$class.genericNotifications($this, parameters);
    }

    public static Future disableDeviceNotificationsForUser(TwitterFriendshipClient $this, String screen_name) {
        DeviceNotificationParameters parameters = new DeviceNotificationParameters((Option<Object>)None$.MODULE$, (Option<String>)new Some((Object)screen_name), false);
        return TwitterFriendshipClient$class.genericNotifications($this, parameters);
    }

    public static Future disableDeviceNotificationsForUserId(TwitterFriendshipClient $this, long user_id) {
        DeviceNotificationParameters parameters = new DeviceNotificationParameters((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)user_id)), (Option<String>)None$.MODULE$, false);
        return TwitterFriendshipClient$class.genericNotifications($this, parameters);
    }

    private static Future genericNotifications(TwitterFriendshipClient $this, NotificationParameters parameters) {
        return $this.RichHttpRequest($this.Post().apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/update.json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.com$danielasfregola$twitter4s$http$clients$rest$friendships$TwitterFriendshipClient$$friendshipsUrl()})), parameters)).respondAs(ManifestFactory$.MODULE$.classType(Relationship.class));
    }

    public static Future getRelationshipBetweenUserIds(TwitterFriendshipClient $this, long source_id, long target_id) {
        RelationshipParametersByIds parameters = new RelationshipParametersByIds(source_id, target_id);
        return TwitterFriendshipClient$class.genericGetRelationship($this, parameters);
    }

    public static Future getRelationshipBetweenUsers(TwitterFriendshipClient $this, String source_screen_name, String target_screen_name) {
        RelationshipParametersByNames parameters = new RelationshipParametersByNames(source_screen_name, target_screen_name);
        return TwitterFriendshipClient$class.genericGetRelationship($this, parameters);
    }

    private static Future genericGetRelationship(TwitterFriendshipClient $this, RelationshipParameters parameters) {
        return $this.RichHttpRequest($this.Get().apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/show.json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.com$danielasfregola$twitter4s$http$clients$rest$friendships$TwitterFriendshipClient$$friendshipsUrl()})), parameters)).respondAs(ManifestFactory$.MODULE$.classType(Relationship.class));
    }

    public static Future getRelationshipsWithUsers(TwitterFriendshipClient $this, Seq screen_names) {
        Predef$.MODULE$.require(!screen_names.isEmpty(), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "please, provide at least one screen name";
            }
        });
        RelationshipsParameters parameters = new RelationshipsParameters((Option<String>)None$.MODULE$, (Option<String>)new Some((Object)screen_names.mkString(",")));
        return TwitterFriendshipClient$class.genericGetRelationships($this, parameters);
    }

    public static Future getRelationshipsWithUserIds(TwitterFriendshipClient $this, Seq user_ids) {
        Predef$.MODULE$.require(!user_ids.isEmpty(), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "please, provide at least one user id";
            }
        });
        RelationshipsParameters parameters = new RelationshipsParameters((Option<String>)new Some((Object)user_ids.mkString(",")), (Option<String>)None$.MODULE$);
        return TwitterFriendshipClient$class.genericGetRelationships($this, parameters);
    }

    private static Future genericGetRelationships(TwitterFriendshipClient $this, RelationshipsParameters parameters) {
        return $this.RichHttpRequest($this.Get().apply(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/lookup.json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.com$danielasfregola$twitter4s$http$clients$rest$friendships$TwitterFriendshipClient$$friendshipsUrl()})), parameters)).respondAs(ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(LookupRelationship.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
    }

    public static void $init$(TwitterFriendshipClient $this) {
        $this.com$danielasfregola$twitter4s$http$clients$rest$friendships$TwitterFriendshipClient$_setter_$com$danielasfregola$twitter4s$http$clients$rest$friendships$TwitterFriendshipClient$$friendshipsUrl_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/friendships"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.apiTwitterUrl(), $this.twitterVersion()})));
    }
}

