/*
 * Decompiled with CFR 0.152.
 */
package com.danielasfregola.twitter4s.http.oauth;

import com.danielasfregola.twitter4s.entities.AccessToken;
import com.danielasfregola.twitter4s.entities.ConsumerToken;
import com.danielasfregola.twitter4s.http.package$;
import com.danielasfregola.twitter4s.util.Encoder;
import com.danielasfregola.twitter4s.util.Encoder$class;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;
import spray.http.HttpHeader;
import spray.http.HttpHeaders;
import spray.http.HttpRequest;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u00015\u0011QbT!vi\"\u0004&o\u001c<jI\u0016\u0014(BA\u0002\u0005\u0003\u0015y\u0017-\u001e;i\u0015\t)a!\u0001\u0003iiR\u0004(BA\u0004\t\u0003%!x/\u001b;uKJ$4O\u0003\u0002\n\u0015\u0005yA-\u00198jK2\f7O\u001a:fO>d\u0017MC\u0001\f\u0003\r\u0019w.\\\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UAR\"\u0001\f\u000b\u0005]1\u0011\u0001B;uS2L!!\u0007\f\u0003\u000f\u0015s7m\u001c3fe\"A1\u0004\u0001B\u0001B\u0003%A$A\u0007d_:\u001cX/\\3s)>\\WM\u001c\t\u0003;\u0001j\u0011A\b\u0006\u0003?\u0019\t\u0001\"\u001a8uSRLWm]\u0005\u0003Cy\u0011QbQ8ogVlWM\u001d+pW\u0016t\u0007\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\u0017\u0005\u001c7-Z:t)>\\WM\u001c\t\u0003;\u0015J!A\n\u0010\u0003\u0017\u0005\u001b7-Z:t)>\\WM\u001c\u0005\u0006Q\u0001!\t!K\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007)bS\u0006\u0005\u0002,\u00015\t!\u0001C\u0003\u001cO\u0001\u0007A\u0004C\u0003$O\u0001\u0007A\u0005C\u00030\u0001\u0011\u0005\u0001'A\u0006pCV$\b\u000eS3bI\u0016\u0014HCA\u00199!\t\u0011d'D\u00014\u0015\t)AGC\u00016\u0003\u0015\u0019\bO]1z\u0013\t94G\u0001\u0006IiR\u0004\b*Z1eKJDQ!\u000f\u0018A\u0004i\nqA]3rk\u0016\u001cH\u000f\u0005\u00023w%\u0011Ah\r\u0002\f\u0011R$\bOU3rk\u0016\u001cH\u000fC\u0003?\u0001\u0011\u0005q(A\u0006pCV$\b\u000eU1sC6\u001cHC\u0001!K!\u0011\tEiR$\u000f\u0005=\u0011\u0015BA\"\u0011\u0003\u0019\u0001&/\u001a3fM&\u0011QI\u0012\u0002\u0004\u001b\u0006\u0004(BA\"\u0011!\t\t\u0005*\u0003\u0002J\r\n11\u000b\u001e:j]\u001eDQ!O\u001fA\u0004iBQ\u0001\u0014\u0001\u0005\u00025\u000bab\\1vi\"\u001c\u0016n\u001a8biV\u0014X\r\u0006\u0002O5R\u0011q*\u0017\t\u0005\u001fA\u0013v)\u0003\u0002R!\t1A+\u001e9mKJ\u0002\"a\u0015-\u000e\u0003QS!!\u0016,\u0002\t1\fgn\u001a\u0006\u0002/\u0006!!.\u0019<b\u0013\tIE\u000bC\u0003:\u0017\u0002\u000f!\bC\u0003?\u0017\u0002\u0007\u0001\tC\u0004]\u0001\t\u0007I\u0011A/\u0002\u0015MLwM\\5oO.+\u00170F\u0001H\u0011\u0019y\u0006\u0001)A\u0005\u000f\u0006Y1/[4oS:<7*Z=!\u0011\u0015\t\u0007\u0001\"\u0005c\u0003Y\u0019WO\u001d:f]R\u001cVmY8oIN4%o\\7Fa>\u001cW#A2\u0011\u0005=!\u0017BA3\u0011\u0005\u0011auN\\4\t\u000b\u001d\u0004A\u0011C/\u0002\u001b\u001d,g.\u001a:bi\u0016tuN\\2f\u0011\u0015I\u0007\u0001\"\u0003k\u0003A\u0011\u0017m]5d\u001f\u0006+H\u000f\u001b)be\u0006l7/F\u0001A\u0011\u0015a\u0007\u0001\"\u0001n\u0003A9W\r^*jO:\fG/\u001e:f\u0005\u0006\u001cX\r\u0006\u0002oaR\u0011qi\u001c\u0005\u0006s-\u0004\u001dA\u000f\u0005\u0006}-\u0004\r\u0001\u0011\u0005\u0006e\u0002!\ta]\u0001\u000bE>$\u0017\u0010U1sC6\u001cHC\u0001!u\u0011\u0015I\u0014\u000fq\u0001;\u0011\u00151\b\u0001\"\u0001x\u0003-\tX/\u001a:z!\u0006\u0014\u0018-\\:\u0015\u0005a|\b\u0003B=\u007f\u000fJk\u0011A\u001f\u0006\u0003wr\f\u0011\"[7nkR\f'\r\\3\u000b\u0005u\u0004\u0012AC2pY2,7\r^5p]&\u0011QI\u001f\u0005\u0006sU\u0004\u001dA\u000f\u0005\b\u0003\u0007\u0001A\u0011BA\u0003\u00031)gnY8eKB\u000b'/Y7t)\r9\u0015q\u0001\u0005\b\u0003\u0013\t\t\u00011\u0001A\u0003\u0019\u0001\u0018M]1ng\u0002")
public class OAuthProvider
implements Encoder {
    private final ConsumerToken consumerToken;
    private final AccessToken accessToken;
    private final String signingKey;

    @Override
    public String toHmacSha1(String base, String secret) {
        return Encoder$class.toHmacSha1(this, base, secret);
    }

    @Override
    public String toBase64(byte[] data) {
        return Encoder$class.toBase64(this, data);
    }

    @Override
    public String toSha1(String base) {
        return Encoder$class.toSha1(this, base);
    }

    public HttpHeader oauthHeader(HttpRequest request) {
        String authorizationValue = ((TraversableOnce)((TraversableOnce)this.oauthParams(request).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=\"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList().sorted((Ordering)Ordering.String$.MODULE$)).mkString(", ");
        return new HttpHeaders.RawHeader("Authorization", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"OAuth ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{authorizationValue})));
    }

    public Map<String, String> oauthParams(HttpRequest request) {
        Map<String, String> oauthParams2 = this.basicOAuthParams();
        return oauthParams2.$plus(this.oauthSignature(oauthParams2, request)).mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$1) {
                return package$.MODULE$.RichString(x$1).toAscii();
            }
        });
    }

    public Tuple2<String, String> oauthSignature(Map<String, String> oauthParams2, HttpRequest request) {
        String signatureBase = this.getSignatureBase(oauthParams2, request);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_signature"), (Object)this.toHmacSha1(signatureBase, this.signingKey()));
    }

    public String signingKey() {
        return this.signingKey;
    }

    public long currentSecondsFromEpoc() {
        return System.currentTimeMillis() / 1000L;
    }

    public String generateNonce() {
        return Random$.MODULE$.alphanumeric().take(42).mkString();
    }

    private Map<String, String> basicOAuthParams() {
        Tuple2 consumerKey = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_consumer_key"), (Object)this.consumerToken.key());
        Tuple2 signatureMethod = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_signature_method"), (Object)"HMAC-SHA1");
        Tuple2 version = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_version"), (Object)"1.0");
        Tuple2 token = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_token"), (Object)this.accessToken.key());
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{consumerKey, this.nonce$1(), signatureMethod, this.timestamp$1(), token, version}));
    }

    public String getSignatureBase(Map<String, String> oauthParams2, HttpRequest request) {
        String method = package$.MODULE$.RichString(request.method().toString()).toAscii();
        String baseUrl = package$.MODULE$.RichString(package$.MODULE$.RichUri(request.uri()).endpoint()).toAscii();
        String encodedParams = package$.MODULE$.RichString(this.encodeParams((Map<String, String>)this.queryParams(request).$plus$plus(oauthParams2).$plus$plus(this.bodyParams(request)))).toAscii();
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "&", "&", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{method, baseUrl, encodedParams}));
    }

    public Map<String, String> bodyParams(HttpRequest request) {
        Map map;
        String body = request.entity().asString().replace("+", "%20");
        if (body.isEmpty()) {
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        } else {
            String[] entities = body.split("&");
            List bodyTokens = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])entities).flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ArrayOps<String> apply(String x$2) {
                    return Predef$.MODULE$.refArrayOps((Object[])x$2.split("=", 2));
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toList();
            map = bodyTokens.grouped(2).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(List<String> x0$2) {
                    List<String> list = x0$2;
                    Some some = List$.MODULE$.unapplySeq(list);
                    if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                        String k = (String)((LinearSeqOptimized)some.get()).apply(0);
                        String v = (String)((LinearSeqOptimized)some.get()).apply(1);
                        Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
                        return tuple2;
                    }
                    throw new MatchError(list);
                }
            }).toMap(Predef$.MODULE$.$conforms());
        }
        return map;
    }

    public Map<String, String> queryParams(HttpRequest request) {
        return request.uri().query().toMap().mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$3) {
                return package$.MODULE$.RichString(x$3).toAscii();
            }
        });
    }

    private String encodeParams(Map<String, String> params) {
        return ((TraversableOnce)((List)params.keySet().toList().sorted((Ordering)Ordering.String$.MODULE$)).map((Function1)new Serializable(this, params){
            public static final long serialVersionUID = 0L;
            private final Map params$1;

            public final String apply(String key) {
                String value = (String)this.params$1.apply((Object)key);
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, value}));
            }
            {
                this.params$1 = params$1;
            }
        }, List$.MODULE$.canBuildFrom())).mkString("&");
    }

    private final Tuple2 nonce$1() {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_nonce"), (Object)this.generateNonce());
    }

    private final Tuple2 timestamp$1() {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"oauth_timestamp"), (Object)((Object)BoxesRunTime.boxToLong((long)this.currentSecondsFromEpoc())).toString());
    }

    public OAuthProvider(ConsumerToken consumerToken, AccessToken accessToken) {
        this.consumerToken = consumerToken;
        this.accessToken = accessToken;
        Encoder$class.$init$(this);
        String encodedConsumerSecret = package$.MODULE$.RichString(consumerToken.secret()).toAscii();
        String encodedAccessTokenSecret = package$.MODULE$.RichString(accessToken.secret()).toAscii();
        this.signingKey = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "&", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{encodedConsumerSecret, encodedAccessTokenSecret}));
    }
}

