/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.billing;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.billing.BudgetList;
import com.databricks.sdk.service.billing.BudgetsService;
import com.databricks.sdk.service.billing.DeleteBudgetRequest;
import com.databricks.sdk.service.billing.GetBudgetRequest;
import com.databricks.sdk.service.billing.WrappedBudget;
import com.databricks.sdk.service.billing.WrappedBudgetWithStatus;
import com.databricks.sdk.support.Generated;
import java.util.HashMap;

@Generated
class BudgetsImpl
implements BudgetsService {
    private final ApiClient apiClient;

    public BudgetsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public WrappedBudgetWithStatus create(WrappedBudget request) {
        String path = String.format("/api/2.0/accounts/%s/budget", this.apiClient.configuredAccountID());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        return this.apiClient.POST(path, request, WrappedBudgetWithStatus.class, headers);
    }

    @Override
    public void delete(DeleteBudgetRequest request) {
        String path = String.format("/api/2.0/accounts/%s/budget/%s", this.apiClient.configuredAccountID(), request.getBudgetId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        this.apiClient.DELETE(path, request, Void.class, headers);
    }

    @Override
    public WrappedBudgetWithStatus get(GetBudgetRequest request) {
        String path = String.format("/api/2.0/accounts/%s/budget/%s", this.apiClient.configuredAccountID(), request.getBudgetId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, request, WrappedBudgetWithStatus.class, headers);
    }

    @Override
    public BudgetList list() {
        String path = String.format("/api/2.0/accounts/%s/budget", this.apiClient.configuredAccountID());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        return this.apiClient.GET(path, BudgetList.class, headers);
    }

    @Override
    public void update(WrappedBudget request) {
        String path = String.format("/api/2.0/accounts/%s/budget/%s", this.apiClient.configuredAccountID(), request.getBudgetId());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Content-Type", "application/json");
        this.apiClient.PATCH(path, request, Void.class, headers);
    }
}

