/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.CredentialsProvider;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.HeaderFactory;
import com.databricks.sdk.core.oauth.RefreshableTokenSource;
import com.databricks.sdk.core.utils.AzureUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;

public class AzureServicePrincipalCredentialsProvider
implements CredentialsProvider,
AzureUtils {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public String authType() {
        return "azure-client-secret";
    }

    @Override
    public HeaderFactory configure(DatabricksConfig config) {
        if (!config.isAzure() || config.getAzureClientId() == null || config.getAzureClientSecret() == null || config.getAzureTenantId() == null) {
            return null;
        }
        this.ensureHostPresent(config, this.mapper);
        RefreshableTokenSource inner = this.tokenSourceFor(config, config.getEffectiveAzureLoginAppId());
        RefreshableTokenSource cloud = this.tokenSourceFor(config, config.getAzureEnvironment().getServiceManagementEndpoint());
        return () -> {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Bearer " + inner.getToken().getAccessToken());
            headers.put("X-Databricks-Azure-SP-Management-Token", cloud.getToken().getAccessToken());
            if (config.getAzureWorkspaceResourceId() != null) {
                headers.put("X-Databricks-Azure-Workspace-Resource-Id", config.getAzureWorkspaceResourceId());
            }
            return headers;
        };
    }
}

