/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.oauth2;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.oauth2.CreateCustomAppIntegration;
import com.databricks.sdk.service.oauth2.CreateCustomAppIntegrationOutput;
import com.databricks.sdk.service.oauth2.CustomAppIntegrationService;
import com.databricks.sdk.service.oauth2.DeleteCustomAppIntegrationRequest;
import com.databricks.sdk.service.oauth2.GetCustomAppIntegrationOutput;
import com.databricks.sdk.service.oauth2.GetCustomAppIntegrationRequest;
import com.databricks.sdk.service.oauth2.GetCustomAppIntegrationsOutput;
import com.databricks.sdk.service.oauth2.UpdateCustomAppIntegration;
import com.databricks.sdk.support.Generated;

@Generated
class CustomAppIntegrationImpl
implements CustomAppIntegrationService {
    private final ApiClient apiClient;

    public CustomAppIntegrationImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateCustomAppIntegrationOutput create(CreateCustomAppIntegration request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/custom-app-integrations", this.apiClient.configuredAccountID());
        return this.apiClient.POST(path, request, CreateCustomAppIntegrationOutput.class);
    }

    @Override
    public void delete(DeleteCustomAppIntegrationRequest request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/custom-app-integrations/%s", this.apiClient.configuredAccountID(), request.getIntegrationId());
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public GetCustomAppIntegrationOutput get(GetCustomAppIntegrationRequest request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/custom-app-integrations/%s", this.apiClient.configuredAccountID(), request.getIntegrationId());
        return this.apiClient.GET(path, request, GetCustomAppIntegrationOutput.class);
    }

    @Override
    public GetCustomAppIntegrationsOutput list() {
        String path = String.format("/api/2.0/accounts/%s/oauth2/custom-app-integrations", this.apiClient.configuredAccountID());
        return this.apiClient.GET(path, GetCustomAppIntegrationsOutput.class);
    }

    @Override
    public void update(UpdateCustomAppIntegration request) {
        String path = String.format("/api/2.0/accounts/%s/oauth2/custom-app-integrations/%s", this.apiClient.configuredAccountID(), request.getIntegrationId());
        this.apiClient.PATCH(path, request, Void.class);
    }
}

