/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.sharing;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.sharing.CreateRecipient;
import com.databricks.sdk.service.sharing.DeleteRecipientRequest;
import com.databricks.sdk.service.sharing.GetRecipientRequest;
import com.databricks.sdk.service.sharing.GetRecipientSharePermissionsResponse;
import com.databricks.sdk.service.sharing.ListRecipientsRequest;
import com.databricks.sdk.service.sharing.ListRecipientsResponse;
import com.databricks.sdk.service.sharing.RecipientInfo;
import com.databricks.sdk.service.sharing.RecipientsService;
import com.databricks.sdk.service.sharing.RotateRecipientToken;
import com.databricks.sdk.service.sharing.SharePermissionsRequest;
import com.databricks.sdk.service.sharing.UpdateRecipient;
import com.databricks.sdk.support.Generated;

@Generated
class RecipientsImpl
implements RecipientsService {
    private final ApiClient apiClient;

    public RecipientsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public RecipientInfo create(CreateRecipient request) {
        String path = "/api/2.1/unity-catalog/recipients";
        return this.apiClient.POST(path, request, RecipientInfo.class);
    }

    @Override
    public void delete(DeleteRecipientRequest request) {
        String path = String.format("/api/2.1/unity-catalog/recipients/%s", request.getName());
        this.apiClient.DELETE(path, request, Void.class);
    }

    @Override
    public RecipientInfo get(GetRecipientRequest request) {
        String path = String.format("/api/2.1/unity-catalog/recipients/%s", request.getName());
        return this.apiClient.GET(path, request, RecipientInfo.class);
    }

    @Override
    public ListRecipientsResponse list(ListRecipientsRequest request) {
        String path = "/api/2.1/unity-catalog/recipients";
        return this.apiClient.GET(path, request, ListRecipientsResponse.class);
    }

    @Override
    public RecipientInfo rotateToken(RotateRecipientToken request) {
        String path = String.format("/api/2.1/unity-catalog/recipients/%s/rotate-token", request.getName());
        return this.apiClient.POST(path, request, RecipientInfo.class);
    }

    @Override
    public GetRecipientSharePermissionsResponse sharePermissions(SharePermissionsRequest request) {
        String path = String.format("/api/2.1/unity-catalog/recipients/%s/share-permissions", request.getName());
        return this.apiClient.GET(path, request, GetRecipientSharePermissionsResponse.class);
    }

    @Override
    public void update(UpdateRecipient request) {
        String path = String.format("/api/2.1/unity-catalog/recipients/%s", request.getName());
        this.apiClient.PATCH(path, request, Void.class);
    }
}

